' $segment
' $linesize:132
' $title: 'RBBSSUB6.BAS 17.4/CDor, Copyright 1993 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'
'  Name ...............: RBBSSUB6.BAS
'  First Released .....: February 1993
'  Subsequent Releases.: 
'  Copyright ..........: 1993
'  Purpose.............: Subroutines for RBBS-PC/CDor
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
100   SUB DoorSys
      CALL TimeRemain (MinsRemaining)
      Close 2
      OPEN "O", 2, ZNodeWorkDrvPath$ + "DOOR.SYS"
      IF ZLocalUser THEN _
         PRINT #2, "COM0:" _
      ELSE PRINT #2, ZComPort$ + CHR$(58)                       '(1)
      PRINT #2, ZCBaud$                                         '(2)
      ZPosition% = INSTR(ZBaudParity$, "N,")
      PRINT #2, MID$(ZBaudParity$, ZPosition% + 2, 1)           '(3)
      PRINT #2, ZNodeFileID$                                    '(4)
      PRINT #2, ZTalkToModemAt$                                 '(5)
      IF ZSnoop = -1 THEN _                                     '(6)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      IF ZPrinter = -1 THEN _                                   '(7)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      IF ZSysopAvail = -1 OR ZSysopAnnoy = -1 THEN _            '(8)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      IF ZSysopAvail = -1 OR ZSysopAnnoy = -1 THEN _            '(9)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      IF ZGlobalSysop THEN                                     '(10)
         PRINT #2, ZSysopFirstName$ + SPACE$(1) + _
         LEFT$(ZSysopLastName$,LEN(ZSysopLastName$)-1)
      ELSE
         PRINT #2, OrigFirstName$ + SPACE$(1) + ZLastName$
      END IF
      PRINT #2, ZCityState$                                    '(11)
      PRINT #2, ""    'Home Phone                              '(12)
      PRINT #2, ""    'Data Phone                              '(13)
      PRINT #2, ZPswdSave$                                     '(14)
      ZZ$ = STR$(ZUserSecLevel)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(15)
      ZZ$ = STR$(ZTimesLoggedOn)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(16)
      PRINT #2, MID$(ZLastDateTimeOn$, 1, 2) + CHR$(47) + _
                MID$(ZLastDateTimeOn$, 4 ,2) + CHR$(47) + _
                MID$(ZLastDateTimeOn$, 7 ,2)
      CALL TimeRemain (MinsRemaining)
      CALL CheckInt (ZDoorTime$)
      IF ZErrCode = 0 AND ZTestedIntValue > 0 THEN _
         IF MinsRemaining > ZTestedIntValue THEN _
            MinsRemaining = ZTestedIntValue
      ZZ$ = STR$(INT(MinsRemaining) * 60)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(18)
      PRINT #2,INT(MinsRemaining)                              '(19)
      IF ZWasGR = 4 THEN
         PRINT #2, "RIP"                                       '(20)
      ELSEIF ZWasGR = 2 OR ZCanANSIChat THEN
         PRINT #2, "GR"
      ELSE
         PRINT #2, "NG"
      END IF
      ZZ$ = STR$(ZPageLength)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(21)
      IF ZExpertUser THEN _                                    '(22)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      PRINT #2, ""       'Conferences registered in            '(23)
      ZZ$ = ZConfName$
      CALL Trim (ZZ$)
      PRINT #2, ZZ$                                            '(24)
      PRINT #2, ZExpirationDate$                               '(25)
      ZZ$ = STR$(ZUserFileIndex)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(26)
      PRINT #2, ZUserXferDefault$                              '(27)
      IF ZUplds = 0 THEN _
         PRINT #2, CHR$(49) _
      ELSE _
         ZZ$ = STR$(ZUplds) : _
         CALL Trim(ZZ$) : _
         PRINT #2, ZZ$                                         '(28)
      ZZ$ = STR$(ZDnlds)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(29)
      ZZ$ = STR$(ZBytesToday!/1000)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(30)
      IF ZByteMethod = 3 THEN _
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes! : _
         ZZ$ = STR$(Today#/1000) : _
         CALL Trim(ZZ$) : _
         PRINT #2, ZZ$ _
      ELSE PRINT #2, ""
      PRINT #2, ""         'Callers birthday mm/dd/yy          '(32)
      CALL BreakFileName (ZMainUserFile$,Drive$,filename$,extension$,ZFalse)
      PRINT #2, Drive$                                         '(33)
      PRINT #2, ""   'Path to GEN Directory                    '(34)
      PRINT #2, ZSysopFirstName$                               '(35)
      PRINT #2, ZActiveUserName$                               '(36)
      PRINT #2, ""   'Event Time        (hh:mm)                '(37)
      IF ZReliableMode = -1 THEN _                             '(38)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      PRINT #2, ""       'ANSI Supported but caller is NG (Y,N)'(39)
      IF ZShareIt THEN _                                       '(40)
         PRINT #2, CHR$(89) _
      ELSE PRINT #2, CHR$(78)
      PRINT #2, ""       'BBS Default color     (1-15)         '(41)
      ZZ$ = STR$(ASC(ZBankTime$))
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(42)
      CALL UnPackDIRDate (ZListNewDate$, ZZ$,CHR$(47))
      PRINT #2, ZZ$
      PRINT #2, LEFT$(ZTimeLoggedOn$, 5)                       '(44)
      PRINT #2, RIGHT$(ZLastDateTimeOnSave$, 5)                '(45)
      IF ZByteMethod = 2 THEN
         Today# = ZRatioRestrict# - ZDLToday!
         ZZ$ = STR$(Today#)
         CALL Trim(ZZ$)
         PRINT #2, ZZ$
      ELSE
         PRINT #2, ""       'Max daily files limit             '(46)
      END IF
      ZZ$ = STR$(ZDLToday!)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(47)
      ZZ$ = STR$(ZULBytes!/1000)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(48)
      ZZ$ = STR$(ZDLBytes!/1000)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(49)
      '* "RBBS-PC is the Best!"
      CALL FormatString (1083,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      PRINT #2, Strng$                                         '(50)
      PRINT #2, ""      'Total Doors opened                    '(51)
      PRINT #2, ""      'Total Messages left                   '(52)
      CLOSE 2
      END SUB
'
101   SUB PCBoardSys
'
      CALL TimeRemain (MinsRemaining)
      CLOSE 2
      OPEN ZNodeWorkDrvPath$ + "PCBOARD.SYS" FOR RANDOM AS #2 LEN = 128
      FIELD #2, 128 AS CONTENTS$
      Template$ = STRING$(128,32)
      IF ZSnoop THEN _
         MID$(Template$,1,2) = "-1" _
      ELSE MID$(Template$,1,2) = " 0"
      IF ZPrinter THEN _
         MID$(Template$,3,2) = "-1" _
      ELSE MID$(Template$,3,2) = " 0"
      IF ZSysopAvail THEN _
         MID$(Template$,5,2) = "-1" _
      ELSE MID$(Template$,5,2) = " 0"
      MID$(Template$,7,2) = " 0"
      IF ZSysop THEN _
         MID$(Template$,9,1) = CHR$(88) _
      ELSE MID$(Template$,9,1) = CHR$(78)
      IF ZReliableMode THEN _
         MID$(Template$,10,2) = "-1" _
      ELSE MID$(Template$,10,2) = " 0"
      ZZ$ = CHR$(78)
      IF ZWasGR > 1 OR ZCanANSIChat OR ZRIPGraphics THEN _
         ZZ$ = CHR$(89)
      IF INSTR(ZBaudParity$, ",7") THEN _
         ZZ$ = CHR$(55)
      MID$(Template$,12,1) = ZZ$
      IF ZAvailableForChat THEN _
         MID$(Template$,13,1) = CHR$(65) _
      ELSE MID$(Template$,13,1) = CHR$(85)
      MID$(Template$,14,5) = RIGHT$(ZTalkToModemAt$,5)
      IF ZLocalUser THEN _
         MID$(Template$,19,5) = "local" _
      ELSE MID$(Template$,19,5) = RIGHT$(ZCBaud$,5)
      LSET temp$ = MKI$(VAL(ZUserRecord$))
      MID$(Template$,24,2) = temp$
      MID$(Template$,26,15) = LEFT$(OrigFirstName$,15)
      MID$(Template$,41,12) = LEFT$(ZPswdSave$,12)
      MID$(Template$,53,2) = MKI$(ZStartTime)
      MID$(Template$,55,2) = MKI$(ZElapsedTime)
      MID$(Template$,57,5) = LEFT$(ZTimeLoggedOn$,5)
      MID$(Template$,62,2) = MKI$(ZTempTimeAllowed)
      IF ZGlobalSysop THEN
         UserName$ =  ZSysopFirstName$ + SPACE$(1) + _
         LEFT$(ZSysopLastName$,LEN(ZSysopLastName$)-1)
      ELSE
         UserName$ =  OrigFirstName$ + SPACE$(1) + ZLastName$
      END IF
      MID$(Template$,85,25) = LEFT$(UserName$,25)
      CALL TimeRemain (MinsRemaining)
      CALL CheckInt (ZDoorTime$)
      IF ZErrCode = 0 AND ZTestedIntValue > 0 THEN _
         IF MinsRemaining > ZTestedIntValue THEN _
            MinsRemaining = ZTestedIntValue
      pcboardtime = INT(MinsRemaining)
      IF pcboardtime > 99 THEN _
         pcboardtime = 99
      minutes$ = SPACE$(2)
      LSET minutes$ = MKI$(pcboardtime)
      MID$(Template$,110,2) = minutes$
      ZZ$ = ZNodeID$
      CALL Trim (ZNodeID$)
      MID$(Template$,112,1) = LEFT$(ZNodeID$,1)
      MID$(Template$,126,1) = MID$(ZComPort$,4,1)
      LSET CONTENTS$ = Template$
      PUT 2,1
      CLOSE #2
      END SUB
'
108 SUB BBSFileSetup
'
    CALL BreakFileName (ZCallersFile$,Drive$,WasX$,ZWasY$,ZTrue)
    ZCallersFilePrefix$ = WasX$
    ZLocalBkSp$ = ZBackSpace$
    ZSysopFullName$ = LEFT$(ZSysopFirstName$ + SPACE$(1) + _
                      LEFT$(ZSysopLastName$,LEN(ZSysopLastName$)-1) _
                       + SPACE$(2),22)
    ZFastFileSearch = ZFalse
    CALL FindIt (ZFastFileList$)
    IF ZOK THEN _
       CALL FindIt (ZFastFileLocator$) : _
       IF ZOK THEN _
          ZFastFileSearch = ZTrue : _
          CALL BreakFileName (ZFastFileList$, Drive$,WasX$,ZWasY$,ZTrue) : _
          ZFileName$ = Drive$ + WasX$ + CHR$(84) + ZWasY$ : _   'T
          CALL FindIt (ZFileName$) : _
          IF ZOK THEN _
             CALL OpenRSeq (2,ZFileName$, WasX, WasY, 72) : _
             FIELD 2, 72 AS IndexRec$ : _
             GET 2, 1 : _
             ZFastTabs$ = IndexRec$ : _
             CLOSE 2 _
          ELSE ZFastTabs$ = ""
    END SUB
'
112 SUB BBSTimeSetup
    IF NOT ZSubBoard THEN
       ZLocalUser = ZTrue
       ZOutTxt$ = ZColorReset$
       ZSubParm = 1
       CALL TPut
       ZLocalUser = ZFalse
    END IF
    ZUpldDriveFile$ = RIGHT$(ZDnldDrives$,1)+":FREESPAC.UPL"
    ZMinsPerSessionDef = ZMinsPerSession - ZElapsedTime
    ZMaxPerDayDef = ZMaxPerDay
    ZMaxBankTimeDef = ZMaxBank
    END SUB
'
175 SUB BBSFMSSetup
'
    CALL CountLines (MaxEntries)
    REDIM ZCategoryName$(MaxEntries),ZCategoryCode$(MaxEntries),_
          ZCategoryDesc$(MaxEntries)
    CALL InitFMS (ZNumCategories)
    ZMaxMsgLines = ZMaxMsgLinesDef
    IF (NOT ZLocalUser) AND (NOT ZSubBoard) THEN _
       CALL OpenCom (ZModemInitBaud$,",N,8,1")
    IF NOT ZSubBoard THEN
       CALL SetEcho (ZDefaultEchoer$)
    END IF
    ZNodeWorkFile$ = ZNodeWorkDrvPath$ + _
                      "NWRK" + _
                      ZNodeFileID$
    ZBatchWorkFile$ = ZNodeWorkDrvPath$ + _
                      "NBCH" + _
                      ZNodeFileID$
    END SUB
'
' CallerID Checks for CALLER ID Info in Modem Response String
'
270 SUB CallerID (ModemResponse$)
    ZCallerIDBlockActive = ZFalse
    IF ZCallerIDNumStr$ = "NONE" OR ZCallerIDNumStr$ = "" THEN
       EXIT SUB
    END IF
    Found = INSTR(ModemResponse$,ZCallerIDNumStr$)
    IF Found THEN
       ZCallerID$ = MID$(ModemResponse$,Found+LEN(ZCallerIDNumStr$)+1)
       CALL Trim (ZCallerID$)
    ELSEIF INSTR(ModemResponse$,ZCallerIDBlockStr$) THEN
       ZCallerIDBlockActive = ZTrue
    END IF
    END SUB
'
' CheckRIPIcons
'
345 SUB CheckRIPIcons
    CALL FindIt (ZRIPICONFile$)
    IF NOT ZOK THEN
       EXIT SUB
    END IF
    CALL FindIt ("RBBSICON.DEF")
    IF ZOK THEN
       FileName$ = ZFileName$
       HoldName$ = ZFileNameHold$
       TempSec = ZUserSecLevel
       '* "Checking ICONS, please wait!"
       LineNum = 963
       GOSUB 357
       '* "!|1F010000"
       LineNum = 964
       GOSUB 355
       RIPStr$ = Strng$
       DO
          CALL ReadDir (2,1)
          ZOutTxt$ = RIPStr$ + ZOutTxt$
          CALL FlushCom (WasX$)
          CALL PutCom (ZOutTxt$)
          CALL SkipLine (1)
          CALL DelayTime (1)
          CALL FlushCom (WasX$)
          IF LEFT$(WasX$,1) = "0" THEN
             CALL FlushCom (WasX$)
             CALL SkipLine (1)
             '* "{RIYou do not have ALL the RIP ICONS used at the {BN!"
             LineNum = 965
             GOSUB 357
             '* "Would you like to DOWNLOAD the {BN ICONS now ([Y],N)"
             LineNum = 966
             GOSUB 355
             ZOutTxt$ = Strng$
             ZSubParm = 1
             CALL TGet
             IF ZSubParm = -1 THEN
                EXIT SUB
             END IF
             IF ZWasQ = 0 OR UCASE$(ZUserIn$) = "Y" THEN
                CALL SkipLine (1)
                ZErrCode = 0
                ZFileName$ = ZRIPICONFile$
                CALL BreakFileName (ZRIPICONFile$,Drive$,Body$,Ext$,ZTrue)
                ZFileNameHold$ = Body$ + Ext$
                ZUserSecLevel = ZOptSec(19)
                CALL XFerType (1,ZTrue)
                IF ZWasQ = 0 OR UCASE$(ZUserIn$) = "N" THEN
                   CALL SkipLine (1)
                   GOTO 350
                END IF
                CALL CheckCarrier
                IF ZSubParm = -1 THEN
                   GOTO 350
                END IF
                ZTransferFunction = 1
                CALL Transfer
                CALL KillWork ("XFER-" + ZNodeID$ + ".DEF")
                CALL CheckCarrier
                IF ZSubParm = -1 THEN
                   GOTO 350
                END IF
                CALL GraphicDisplayFile (ZHelpPath$ + "RIPICON" + ZHelpExtension$)
                CALL SmartPause (ZTrue)
             END IF
             EXIT DO
          END IF
       LOOP WHILE NOT EOF(2)
    END IF
350 ZFileName$ = FileName$
    ZFileNameHold$ = HoldName$
    ZOutTxt$ = ""
    CALL FlushCom (WasX$)
    ZUserSecLevel = TempSec
    EXIT SUB
355 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
    RETURN
357 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,1,"")
    RETURN
    END SUB
'
' RegistrationCheck
'
462 SUB RegistrationCheck (TodayComputeDate!)
    IF ZRestrictByDate AND ZDaysInRegPeriod > 0 THEN _
       CALL CompDate (ZUserRegYY,ZUserRegMM,ZUserRegDD,UserComputeDate!) : _
       ZRegDaysRemaining = UserComputeDate! + _
                            ZDaysInRegPeriod - _
                            TodayComputeDate! : _
       CALL ExpireDate (UserComputeDate!,ZDaysInRegPeriod,ZExpirationDate$) _
    ELSE ZDaysInRegPeriod = 0
    TempStr$ = STR$(ZUserSecLevel)
    CALL Trim (TempStr$)
    ExpFile$ = ZHelpPath$ + "RGXD" + TempStr$ + ZHelpExtension$
    CALL FindIt (ExpFile$)
    IF NOT ZOK THEN _
       ExpFile$ = ZHelpPath$ + "RGXPIRD" + ZHelpExtension$
    IF NOT ZPrivateDoor THEN
       IF ZRegDaysRemaining < 0 AND ZDaysInRegPeriod > 0 THEN
          IF ZUserSecLevel > ZTempExpiredSec THEN
             '* "{CBExpired Registration - security level set to{SP"
             CALL FormatString (703,ZFalse,ZFalse,0,ZFalse,0,Strng$)
             CALL QuickTPut (Strng$ + STR$(ZTempExpiredSec) + ZEmphasizeOff$,2)
             CALL SmartPause (ZFalse)
             CALL GraphicDisplayFile (ExpFile$)
             ZLogonErrorIndex = 9
             ZUserSecLevel = ZTempExpiredSec
             LSET ZSecLevel$ = MKI$(ZUserSecLevel)
             IF ZRegReset THEN
                WorkDate$ = DATE$
                WorkDate$ = LEFT$(WorkDate$,6) + RIGHT$(WorkDate$,2)
                CALL ResetRegDate (WorkDate$)
                LSET ZUserOption$ = LEFT$(ZUserOption$,10) + _
                                    ZRegDate$ + _
                                    MID$(ZUserOption$,13)
             END IF
             CALL SetPrivileges
          END IF
       END IF
    END IF
    END SUB
'
' * UnPackDIRDate - takes ZListNewDate$ and converts to readable text
'
600 SUB UnPackDIRDate (SourceStr$, OutStr$, DateSeparator$)
    OutStr$ = RIGHT$(STR$(ASC(MID$(SourceStr$,2))),2) + _    ' MM
           DateSeparator$ + _
           RIGHT$(STR$(ASC(MID$(SourceStr$,3))),2) + _       ' DD
           DateSeparator$ + _
           RIGHT$(STR$(ASC(SourceStr$)),2)                   ' YY
    IF MID$(OutStr$,1,1) = SPACE$(1) THEN
       MID$(OutStr$,1,1) = CHR$(48)
    END IF
    IF MID$(OutStr$,4,1) = SPACE$(1) THEN
       MID$(OutStr$,4,1) = CHR$(48)
    END IF
    IF MID$(OutStr$,7,1) = SPACE$(1) THEN
       MID$(OutStr$,7,1) = CHR$(48)
    END IF
    END SUB
'
' * ConfigError - Reports error with RBBS-PC config file
'
610 SUB ConfigError
    ZSnoop = ZTrue
    CALL PScrn ("Configuration "+ZConfigFileName$+" missing/improper format")
    CALL DelayTime(5)
    END SUB
'
' * Check Names against TrashCan File
'
670 SUB CheckTrashCan (Found)
    Found = ZFalse
    CALL OpenWork (2,ZTrashcanFile$)
    IF ZErrCode <> 0 THEN
       ZErrCode = 0
       EXIT SUB
    END IF
    WHILE NOT EOF(2)
       INPUT #2, TrashName$
       IF ZWasZ$ = TrashName$ THEN
          Found = ZTrue
          '* "Name not allowed here!"
          CALL FormatString (704,ZFalse,ZFalse,0,ZTrue,1,"")
          '* "Name violation: {AN"
          CALL FormatString (705,ZFalse,ZTrue,1,ZFalse,0,"")
          EXIT SUB
       END IF
    WEND
    END SUB
'
' * set default graphics for all new users
'
700 SUB SetNewGR
    WasX = ZDefaultNewUserGraphics
    IF WasX < 30 OR WasX > 99 THEN
       WasX = 60
    END IF
    ZWasGR = (WasX MOD 5)
    ZWasGRHold = ZWasGR
    IF ZWasGR = 3 THEN
       IF ZRIPGraphics THEN
          WasX = 99
          ZWasGR = 4
       ELSEIF ZCanANSIChat THEN
          WasX = 97
          ZWasGR = 2
       ELSE
          WasX = 60
          ZWasGR = 0
       END IF
    END IF
    ZBoldText$ = CHR$(48 - (WasX > 64))
    ZBoldTextHold$ = ZBoldText$
    IF WasX > 64 THEN
       ZUserTextColor = INT((WasX - ZWasGR)/5 + 18)
    ELSE
       ZUserTextColor = INT((WasX - ZWasGR)/5 + 25)
    END IF
    IF ZUserTextColor > 37 THEN
       ZUserTextColor = 37
    END IF
    END SUB
'
' * set default toggle options for all new users
'
759 SUB SetToggles
    ZFullScreenEditor = (ZDefaultNewUserOpts AND 1) > 0
    ZReadNewMail      = (ZDefaultNewUserOpts AND 2) > 0
    ZCheckBulletLogon = (ZDefaultNewUserOpts AND 4) > 0
    ZSkipFilesLogon   = (ZDefaultNewUserOpts AND 8) = 0
    ZExtendedOff      = (ZDefaultNewUserOpts AND 16) = 0
    ZUpperCase        = (ZDefaultNewUserOpts AND 32) > 0
    ZPromptBell       = (ZDefaultNewUserOpts AND 64) > 0
    ZANSIMusic        = (ZDefaultNewUserOpts AND 128) > 0
    ZMorePromptLF     = (ZDefaultNewUserOpts AND 256) = 0
    ZAvailableForChat = (ZDefaultNewUserOpts AND 512) > 0
    ZTurboKeyUser     = (ZDefaultNewUserOpts AND 1024) > 0
    ZTurboKeyUserHold = ZTurboKeyUser
    ZPageLength  = ZPageLengthDef
    ZRightMargin = 74
    ZReselectAll = ZFalse
    ZReselectGraphics = ZFalse
    ZNulls = ZFalse
    END SUB
'
' * NewUserToggles - select various toggle options for new users
'
760 SUB NewUserToggles
'
    IF ZNewUserSelect > 0 THEN
       '* "{CR{CB{G1Please select your preferences for the following options{C0"
       LineNum = 706
       GOSUB 770
       '* "{CB{G1(Recommended settings can be selected by pressing ENTER){C0"
       LineNum = 707
       GOSUB 770
    END IF
'
'   Selection of ANSIEd
'
    IF (ZNewUserSelect AND 1) > 0 THEN
       Help$ = "A"
       GOSUB 769
       '* "{C2Use the {CEFULL SCREEN {C2Editor for entering messages"
       LineNum = 708
       GOSUB 772
       GOSUB 765
       ZFullScreenEditor = NOT ZNo
       CALL Toggle (-1)
    END IF
'
' * Read All New Mail
'
    IF (ZNewUserSelect AND 2) > 0 AND NOT ZSkipMailCheck THEN
       Help$ = "M"
       GOSUB 769
       '* "{C2Read All {CENEW MAIL {C2at logon"
       LineNum = 709
       GOSUB 772
       GOSUB 765
       ZReadNewMail = NOT ZNo
       CALL Toggle (-14)
    END IF
'
'
' * Review New Bulletins
'
    IF (ZNewUserSelect AND 4) > 0 THEN
       Help$ = "B"
       GOSUB 769
       '* "{C2Review All {CEBULLETINS {C2at logon"
       LineNum = 710
       GOSUB 772
       GOSUB 765
       ZCheckBulletLogon = NOT ZNo
       CALL Toggle (-2)
    END IF
'
' * Check new files
'
    IF (ZNewUSerSelect AND 8) > 0 AND ZNewFilesCheck THEN
       Help$ = "F"
       GOSUB 769
       '* "{C2Always check for {CENEW FILES {C2at logon"
       LineNum = 711
       GOSUB 772
       GOSUB 765
       ZSkipFilesLogon = ZNo
       CALL Toggle (-4)
    END IF
'
' * Extended DIR Listing
'
    IF (ZNewUserSelect AND 16) > 0 THEN
       Help$ = "E"
       GOSUB 769
       '* "{C2Do you want {CEEXTENDED {C2directory listings when listing files"
       LineNum = 712
       GOSUB 772
       GOSUB 765
       ZExtendedOff = ZNo
       CALL Toggle (-12)
    END IF
'
' * Case Change
'
    IF (ZNewUserSelect AND 32) > 0 AND ZWasGR < 1 AND ZHiLiteOff THEN
       Help$ = "C"
       GOSUB 769
       '* "{C2Do you want {CEUPPER CASE {C2only{C0 (Y,[N])"
       LineNum = 713
       GOSUB 772
       GOSUB 768
       ZUpperCase = ZYes
       CALL Toggle (-3)
    END IF
'
' * ANSI Music
'
    IF (ZNewUserSelect AND 128) > 0 AND ZWasGR > 1 THEN
       Help$ = "S"
       GOSUB 769
       '* "{C2Do you want {CEANSI Music{C0 (Y,[N])"
       LineNum = 714
       GOSUB 772
       GOSUB 768
       ZANSIMusic = ZYes
       CALL Toggle (-15)
    END IF
'
' * Prompt Bell
'
    IF (ZNewUserSelect AND 64) > 0 THEN
       Help$ = "!"
       GOSUB 769
       '* {RI{C2Do you want the {CEPROMPT BELL {C2at every Prompt{C0 (Y,[N])"
       LineNum = 715
       GOSUB 772
       GOSUB 768
       ZPromptBell = ZYes
       CALL Toggle (-10)
    END IF
'
' * Lines Per Page
'
    IF (ZNewUserSelect AND 256) > 0 AND ZWasGR <> 4 THEN
       Help$ = "L"
       GOSUB 769
       CALL LinesPerPage
    END IF
'
' * More Prompt LF
'
    IF (ZNewUserSelect AND 512) > 0 THEN
       Help$ = "K"
       GOSUB 769
       '* "{C2Do you want {CEMORE PROMPTS {C2erased"
       LineNum = 716
       GOSUB 772
       GOSUB 765
       ZMorePromptLF = ZNo
       CALL Toggle (-13)
    END IF
'
' * Internode Chat Availability
'
    IF (ZNewUserSelect AND 1024) > 0 THEN
       Help$ = "I"
       GOSUB 769
       '* "{C2Do you want to be {CEAVAILABLE {C2for InterNode Chat"
       LineNum = 717
       GOSUB 772
       GOSUB 765
       ZAvailableForChat = NOT ZNo
       CALL Toggle (-11)
    END IF
'
' * Select TurboKeys
'
    IF (ZNewUserSelect AND 2048) > 0 AND ZWasGR <> 4 THEN
       Help$ = "T"
       GOSUB 769
       '* "{C2Do you want {CETURBOKEYS"
       LineNum = 718
       GOSUB 772
       GOSUB 765
       IF ZWasQ = 0 OR ZYes THEN
          ZTurboKeyUser = ZFalse
       ELSE
          ZTurboKeyUser = ZTrue
       END IF
       CALL Toggle (8)
    END IF
'
    EXIT SUB
'
765 ZOutTxt$ = ZOutTxt$ + ZEmphasizeOff$ + ZYesPrompt$
768 ZTurboKey = -ZTurboKeyUser
    CALL SkipLine (1)
    ZSubparm = 1
    CALL TGet
    IF ZSubParm < 0 THEN
       EXIT SUB
    END IF
    RETURN
'
' * display help for option
'
769 FileName$ = ZHelpPath$ + "T" + Help$ + ZHelpExtension$
    CALL GraphicDisplayFile (FileName$)
    RETURN
770 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,1,"")
    RETURN
772 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
    RETURN
    END SUB
'
780 SUB LinesPerPage
    '* "{CR{C2Please Select {CELines Per Page {C2for Display{C0"
    CALL FormatString (719,ZFalse,ZFalse,0,ZTrue,1,"")
    '* "Lines Per Page"
    CALL FormatString (720,ZFalse,ZFalse,0,ZFalse,0,Strng$)
    CALL ChangeInt (ZTrue,Strng$,ZPageLength,23,255)
    IF ZWasQ <> 0 THEN
       ZPageLength = ZTestedIntValue
       ZPageLengthHold = ZPageLength
    END IF
    END SUB
'
815 SUB DisplayWelcome
    ZStopInterrupts = NOT ZWelcomeInterruptable
    ZBypassTimeCheck = ZTrue
    ZFileName$ = ZWelcomeFile$ + CHR$(46) + MID$(TIME$,1,2)
    CALL FindItX (ZFileName$,18)
    IF NOT ZOK THEN
       ZFileName$ = ZWelcomeFile$ + ".LST"
       CALL FindItX (ZFileName$,18)
    END IF
    IF ZOK THEN
       CLOSE 18
       CALL OpenWork (18, ZFileName$)
       WHILE NOT EOF(18)
          CALL ReadDir (18,1)
          ZFileName$ = ZOutTxt$
          ZStopInterrupts = NOT ZWelcomeInterruptable
          ZBypassTimeCheck = ZTrue
          ZDisplayAsUnit = ZTrue
          GOSUB 816
       WEND
       CLOSE 18
    ELSE
       ZFileName$ = ZWelcomeFile$
       ZDisplayAsUnit = ZTrue
       GOSUB 816
    END IF
    ZDisplayAsUnit = ZFalse
    EXIT SUB
816 CALL GraphicDisplayFile (ZFileName$)
    CALL CheckCarrier
    IF ZSubParm = -1 THEN _
       EXIT SUB
    RETURN
    END SUB
'
820 SUB SayGoodby
'
    CALL BreakFileName (ZEpilog$,Pre$,Body$,Ext$,ZFalse)
    ZFileName$ = Pre$ + Body$ + CHR$(46) + MID$(TIME$,1,2)
    CALL FindFile (ZFileName$,ZOK)
    IF NOT ZOK THEN
       ZFileName$ = Pre$ + Body$ + ".LST"
       CALL FindFile (ZFileName$,ZOK)
    END IF
    IF ZOK THEN
       CALL OpenWork (7, ZFileName$)
       WHILE NOT EOF(7)
          CALL ReadDir (7,1)
          ZFileName$ = ZOutTxt$
          ZStopInterrupts = NOT ZWelcomeInterruptable
          ZBypassTimeCheck = ZTrue
          ZDisplayAsUnit = ZTrue
          CALL GraphicDisplayFile (ZFileName$)
          CALL CheckCarrier
          IF ZSubParm = -1 THEN _
             EXIT SUB
       WEND
       IF NOT ZLocalUser THEN
          CALL DelayTime (9 + ZBPS)
       END IF
       CLOSE 7
    END IF
    END SUB
'
832 SUB RegistrationExpires
'
    TempStr$ = STR$(ZUserSecLevel)
    CALL Trim (TempStr$)
    ExpFile$ = ZHelpPath$ + "RGXP" + TempStr$ + ZHelpExtension$
       CALL FindIt (ExpFile$)
       IF NOT ZOK THEN
          GOSUB 836
       END IF
       IF ZRestrictByDate AND ZDaysInRegPeriod > 0 THEN
          IF ZRegDaysRemaining <= ZDaysToWarn AND _
             ZRegDaysRemaining > 0 AND ZUserSecLevel > ZTempExpiredSec THEN
             '* "{CR{CF{G4 Registration EXPIRES in {CE{RR {CFdays! {C0"
             CALL FormatString (721,ZFalse,ZFalse,0,Ztrue,1,"")
             GOTO 834
          ELSEIF ZRegDaysRemaining = 0 AND _
                 ZUserSecLevel > ZTempExpiredSec AND _
                 NOT ZNewUser THEN
             '* "{CR{CF{G4 Registration EXPIRES today! {C0"
             CALL FormatString (722,ZFalse,ZFalse,0,ZTrue,1,"")
             ExpFile$ = ZHelpPath$ + "RGXTD" + TempStr$ + ZHelpExtension$
             CALL FindIt (ExpFile$)
             IF NOT ZOK THEN
                GOSUB 836
             END IF
834          CALL PutCom(ZBellRinger$)
             CALL SmartPause (ZTrue)
             CALL GraphicDisplayFile(ExpFile$)
          END IF
      END IF
      EXIT SUB
836   ExpFile$ = ZHelpPath$ + "RGXPIRE" + ZHelpExtension$
      RETURN
      END SUB
'
' ****  S - COMMAND FROM UTILITY MENU (STATISTICS)  ***
'
     SUB ShowStatistics
1000 CALL SkipLine (1)
     ZFileName$ = ZWelcomeFileDrvPath$ + "LGSTATS"
     CALL GraphicDisplayFile (ZFileName$)
     CALL SmartPause (ZFalse)
     IF ZUserSecLevel < ZSysopSecLevel THEN
        EXIT SUB
     END IF
     ZFileName$ = ZWelcomeFileDrvPath$ + "SSTATS"
     CALL GraphicDisplayFile (ZFileName$)
     CALL SmartPause (ZFalse)
     END SUB
'
1235 SUB SysopNextMsg
     IF ZUserSecLevel >= ZSysopSecLevel THEN
        ZSysopNext = ZFalse
        EXIT SUB
     END IF
     ZFileName$ = ZWelcomeFileDrvPath$ + "SYSNEXT"
     CALL GraphicDisplayFile (ZFileName$)
     END SUB
'
1240 SUB LogOffPlease
     ZFileName$ = ZWelcomeFileDrvPath$ + "LOGOFF"
     CALL GraphicDisplayFile (ZFileName$)
     END SUB
'
' * News Scan
'
     SUB NewsScan (NewsParm,BoardCheckDate$,SameUser,WasZ)
     ON NewsParm GOTO 1241,1242,1241
1241 NewsDate# = VAL(MID$(BoardCheckDate$,4,2)) + _
        (100 * VAL(MID$(BoardCheckDate$,1,2))) + _
        (10000# * (1900 + VAL(MID$(BoardCheckDate$,7,2))))
     GOTO 1243
1242 NewsDate# = 0
     SameUser = ZFalse
     GOSUB 1245
     GOTO 1244
1243 GOSUB 1245
     FDate# = WasD + (100 * ZMsgPtr) + (10000# * (WasY + 1980))
     IF NewsDate# > FDate# THEN _
        EXIT SUB
     IF ZTurboLogon THEN
        '* "{CR{CBNEWS {C3file updated since last call{C0"
        CALL FormatString (724,ZFalse,ZFalse,0,ZTrue,1,"")
        EXIT SUB
     END IF
1244 IF NOT SameUser THEN _
        ZStopInterrupts = NOT ZNewsInterruptable : _
        ZBypassTimeCheck = ZTrue : _
        ZDisplayAsUnit = ZTrue : _
        CALL GraphicDisplayFile (ZFileName$) : _
        ZDisplayAsUnit = ZFalse : _
        ZBypassTimeCheck = ZFalse
     ZStopInterrupts = ZFalse
     WasZ = 0
     EXIT SUB
1245 ZFileName$ = ZNewsFileName$
     CALL RBBSFind (ZFileName$,WasZ,WasY,ZMsgPtr,WasD)
     IF WasZ <> 0 THEN
        IF (NOT ZTurboLogon) AND  (NOT ZSubBoard) AND NewsParm <> 3 THEN
           '* "{C4No {CBNEWS {C3available{C0"
           CALL FormatString (725,ZFalse,ZFalse,0,ZTrue,1,"")
           END IF
        EXIT SUB
     END IF
     RETURN
     END SUB
'
1750 SUB InitialMenus
'
1751 IF ZExpertUser THEN
        CALL SkipLine (1)
        GOTO 1756
     END IF
1755 ZFileName$ = ZWelcomeFileDrvPath$ + "INFOSCR"
     CALL GraphicDisplayFile (ZFileName$)
1756 '* "{CE{CN{C2:{C0"
     LineNum = 38
     GOSUB 1795
     ZOutTxt$ = Strng$
     ZSubParm = 4
     CALL TPut
     CALL DispTimeRemain (MinsRemaining)
     '* "{CFSCREEN {C2command{C0"
     LineNum = 726
     GOSUB 1795
     ZOutTxt$ = Strng$
     IF ZCmndsInPrompt THEN
        IF ZExpertUser THEN
           '* "{SP(?,P,W,O,Y,N,H,[Q])"
           LineNum = 727
           GOSUB 1795
           ZOutTxt$ = ZOutTxt$ + Strng$
        ELSE
           '* "{SP(?,P)relog,W)elcome,O)nline,Y)ours,N)ewUser,H)elp,[Q]uit)"
           LineNum = 728
           GOSUB 1795
           ZOutTxt$ = ZOutTxt$ + Strng$
        END IF
     END IF
     '* "?PWOYNHQ"
     LineNum = 729
     GOSUB 1795
     DO
        ZTurboKey = -ZTurboKeyUser
        ZSubParm = 1
        CALL TGet
        IF ZSubParm < 0 THEN _
           EXIT SUB
        CALL AllCaps (ZUserIn$)
     LOOP UNTIL ZWasQ = 0 OR INSTR(Strng$,ZUserIn$) <> 0
     WasMplX = INSTR(Strng$,ZUserIn$)
     IF ZUserIn$ = "" THEN _
        GOTO 1767
     SELECT CASE WasMplX
        CASE 1
           GOTO 1755
        CASE 2
           ZFileName$ = ZPreLog$
           GOTO 1766
        CASE 3
           Hold = ZWelcomeInterruptable
           ZWelcomeInterruptable = ZTrue
           CALL DisplayWelcome
           ZWelcomeInterruptable = Hold
           GOTO 1751
        CASE 4
           ZFileName$ = ZNewsFileName$
           GOTO 1766
        CASE 5
           ZFileName$ = ZWelcomeFileDrvPath$ + _
                        ZNodeId$ + _
                        "LG" + _
                        STR$(ZUserSecLevel) + _
                        ".DEF"
           CALL Remove (ZFileName$,SPACE$(1))
           CALL FindIt (ZFileName$)
           IF NOT ZOK THEN
              ZFileName$ = ZWelcomeFileDrvPath$ + _
                           "LG" + _
                           STR$(ZUserSecLevel) + _
                           ".DEF"
              CALL Remove (ZFileName$,SPACE$(1))
           END IF
           GOTO 1766
        CASE 6
           ZFileName$ = ZNewUserFile$
           GOTO 1766
        CASE 7
           GOTO 1755
        CASE 8
           GOTO 1767
        CASE ELSE
           GOTO 1751
     END SELECT

1766 GOSUB 1790
     CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
     GOTO 1751
1767 ZFileSysParm = 1
      EXIT SUB
1790 CALL FindIt (ZFileName$)
     IF NOT ZOK THEN
        '* "{CR{CF{C5 Review Screen Not Found {C0"
        CALL FormatString (730,ZFalse,ZFalse,0,ZTrue,2,"")
        RETURN
     END IF
     CALL GraphicDisplayFile (ZFileName$)
     CALL CheckCarrier
     IF ZSubParm = -1 THEN _
        EXIT SUB
     RETURN
1795 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
'
     SUB SmartPause (ForceIt)
'
1800 IF ForceIt OR NOT ZExpertUser THEN
        CALL SKipLine (1)
        IF ZNonStop THEN
           ZOneStop = ZTrue
           ZNonStop = ZFalse
        END IF
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
     END IF
     END SUB
'
     SUB GetLastCaller (Opened)
'
2000  IF Opened THEN
         GOTO 2010
      END IF
      ZLastCaller$ = SPACE$(1)
      ZActiveMessageFile$ = ZOrigMsgFile$
      CALL OpenMsg
2010  FIELD 1, 128 AS ZMsgRec$
      GET 1,ZNodeRecIndex
      IF MID$(ZMsgRec$,55,2) = "-1" THEN
         '* "SYSOP"
         CALL FormatString (131,ZFalse,ZFalse,0,ZFalse,0,ZLastCaller$)
      ELSE
         ZLastCaller$ = MID$(ZMsgRec$,1,26)
      END IF
      CALL Trim (ZLastCaller$)
      END SUB
'
3000 SUB SetupTransferInfo
'
     Temp$ = STR$(ZUserSecLevel)
     CALL Trim (Temp$)
     '* "{C${CE{SL {C2{NO {CB{CT {C2At {CE{BP{C0{CR"
     LineNum = 731
     GOSUB 3010
     ZOutTxt$ = Strng$
     IF ZTransferFunction = 1 THEN
        '* "{CADownloading{CE"
        LineNum = 732
        GOSUB 3010
        ZOutTxt$ = ZOutTxt$ + Strng$
        IF ZBlockSize > 0 THEN
           '* "{C2 blocks {CE"
           LineNum = 733
           GOSUB 3010
           ZOutTxt$ = ZOutTxt$ + _
                ZFGE$ + STR$(CINT(ZBytesInFile#/ZBlockSize)) + Strng$
        END IF
        '* "{C2 bytes{CR"
        LineNum = 734
        GOSUB 3010
        ZOutTxt$ = ZOutTxt$ + _
             STR$(ZBytesInFile#) + Strng$
        '* "{CBEstimated Transfer Time:{CD"
        LineNum = 735
        GOSUB 3010
        ZOutTxt$ = ZOutTxt$ + Strng$ + STR$(INT(ZBlocksInFile# / 60))
        '* "{C3 min,{CD"
        LineNum = 736
        GOSUB 3010
        Strng1$ = Strng$
        '* "{C3 sec{C7{C0"
        LineNum = 737
        GOSUB 3010
        Strng2$ = Strng$
        ZoutTxt$ = ZOutTxt$ + Strng1$ + _
             STR$(INT(ZBlocksInFile# - _
             (INT(ZBlocksInFile# / 60) * 60))) + Strng2$
     ELSE
        '* "{CAUploading file At {CE{BP{C0{CR"
        LineNum = 738
        GOSUB 3010
        ZOutTxt$ = ZOutTxt$ + Strng$
     END IF
     EXIT SUB
3010 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
'
' Create a TOSS log file for MsgToss to Scan Echo Conferences
'
3400 SUB TossLog
     IF ZRBBSName$ = ZOrigRBBSName$ THEN _
        EXIT SUB
     TossFile$ = "TOSS" + ZNodeFileID$ + ".LOG"
     CALL FindIt (TossFile$)
     IF NOT ZOK THEN _
        GOTO 3407
     CALL OpenWork (2,TossFile$)
     Found = ZFalse
     GOSUB 3408
     IF Found THEN _
        EXIT SUB
     GOTO 3409
3407 CALL OpenOutW (TossFile$)
     PRINT #2, ZRBBSName$
     CLOSE 2
     EXIT SUB
3408 IF EOF(2) THEN _
        RETURN
     INPUT #2,TossList$
     IF ZRBBSName$ <> TossList$ THEN _
        GOTO 3408
     Found = ZTrue
     RETURN
3409 CALL OpenWorkA (2,TossFile$)
     CALL PrintWorkA (2,ZRBBSName$)
     CLOSE 2
     END SUB
'
' * Check for conferences allowing "Soft" Alias Names
'
3410 SUB SoftAlias (MsgFromAlias$)
     MsgFromAlias$ = ""
     CALL BreakFileName (ZActiveMessageFile$, _
                         Pre$,Body$,Ext$,ZTrue)
     CALL WordInFile ("SOFTALIA.DEF",Body$+Ext$,Found,ZTrue)
     IF Found THEN
        '* "{CRFROM (Enter WHO this message is FROM) [ENTER] = {AN"
        CALL FormatString (739,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
        WHILE MsgFromAlias$ = ""
           ZSubParm = 1
           CALL TGet
           IF ZSubParm < 0 THEN
              EXIT SUB
           END IF
           IF ZWasQ = 0 THEN
              MsgFromAlias$ = ZActiveUserName$
           ELSE
              MsgFromAlias$ = LEFT$(ZUserIn$,30)
           END IF
        WEND
     END IF
     END SUB
'
' ***** SYSOP Remote Toggles from key 6
'
4130 SUB SysopToggles
4131 Sysop6File$ = ZWelcomeFileDrvPath$ + "SYSOP6.MNU"
     CALL GraphicDisplayFile (Sysop6File$)
4142 CALL Line25
     IF ZCmndsInPrompt THEN
        '* "{CFSYSOP TOGGLE {C2command{C0 (1,2,3,4,5,[Q]uit)"
        LineNum = 740
     ELSE
        '* "{CFSYSOP TOGGLE (C2command{C0"
        LineNum = 741
     END IF
     CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
     DO
        ZTurboKey = -ZTurboKeyUser
        CALL PopCmdStack
        IF ZSubParm < 0 THEN
           EXIT SUB
        END IF
        ZWasZ$ = UCASE$(ZUserIn$(ZAnsIndex))
     LOOP UNTIL ZWasQ = 0 OR INSTR("12345Q",ZWasZ$) <> 0
     IF ZWasQ = 0 OR ZWasZ$ = "Q" THEN
        ZSubParm = 0
        EXIT SUB
     END IF
     WasX = INSTR("12345",ZWasZ$)
     SELECT CASE WasX
        CASE 1
           ZSubParm = -8
           '* "Sysop Available:{SP"
           LineNum = 742
           GOSUB 4145
           Strng$ = Strng$ + FNYESNO$(-(NOT ZSysopAvail))
        CASE 2
           IF NOT ZPrinter AND ZPrinterNumber < 1 THEN
              DO
                 '* "No printer selected!  Which Printer to use (1,2,3,[Q]uit)"
                 LineNum = 743
                 GOSUB 4145
                 ZOutTxt$ = Strng$
                 ZTurboKey = -ZTurboKeyUser
                 CALL PopCmdStack
                 IF ZSubParm < 0 THEN
                    EXIT SUB
                 END IF
                 ZWasZ$ = UCASE$(ZUserIn$(ZAnsIndex))
              LOOP UNTIL ZWasQ = 0 OR INSTR("123Q",ZWasZ$) <> 0
              IF ZWasQ = 0 OR ZWasZ$ = "Q" THEN
                 GOTO 4131
              ELSE
                 ZPrinterNumber = VAL(ZWasZ$)
                 '* "{CBChecking LPT{ZZ{C0"
                 CALL FormatString (744,ZFalse,ZFalse,0,ZTrue,1,"")
                 CALL CheckPrinter (ZPrinterNumber)
                 IF NOT ZOK THEN
                    '* "{CE{G4ERROR!  Unable to print to LPT{ZZ{C0"
                    CALL FormatString (745,ZFalse,ZFalse,0,ZTrue,1,"")
                    ZPrinterNumber = 0
                    GOTO 4131
                 ELSE
                    '* "{CF{C2LPT{ZZ Active{C0"
                    CALL FormatString (746,ZFalse,ZFalse,0,ZTrue,1,"")
                 END IF
              END IF
           END IF
           ZSubParm = -11
           '* "Printer Logging:{SP"
           LineNum = 747
           GOSUB 4145
           Strng$ = Strng$ + FNYESNO$(-(NOT ZPrinter))
        CASE 3
           ZSubParm = -12
           '* "Snoop:{SP"
           LineNum = 748
           GOSUB 4145
           Strng$ = Strng$ + FNYESNO$(-(NOT ZSnoop))
        CASE 4
           ZSubParm = -13
           '* "Sysop Annoy:{SP"
           LineNum = 749
           GOSUB 4145
           Strng$ = Strng$ + FNYESNO$(-(NOT ZSysopAnnoy))
        CASE 5
           ZSubParm = -14
           '* "Sysop Next:{SP"
           LineNum = 750
           GOSUB 4145
           Strng$ = Strng$ + FNYESNO$(-(NOT ZSysopNext))
        CASE ELSE
     END SELECT
     CALL FindFKey
     CALL QuickTPut1 (ZFGB$ + Strng$ + ZEmphasizeOff$)
     CALL SmartPause (ZTrue)
     GOTO 4131
4145 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
'
     SUB InitSysopChat
'
4700 IF NOT ZSysopAvail OR ZNeverCanPage THEN
        '* "Sorry, {FS is not available now"
        LineNum = 755
        GOSUB 4770
        GOTO 4755
     END IF
     '* "{CF{G1Chat with SysOp{C0"
     LineNum = 756
     GOSUB 4770
     WasJJ = VAL(MID$(TIME$,1,2))*100 + VAL(MID$(TIME$,4,2))
     IF (WasJJ > ZStartOfficeHours AND WasJJ < ZEndOfficeHours) OR ZSysopAnnoy THEN _
        GOTO 4710
     GOTO 4750
     '* "Sysop in from {SH to {EH"
     LineNum = 757
     GOSUB 4770
     GOTO 4755
4710 '* "{C0Page {FS? (Y,[N])"
     CALL FormatString (758,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
     CALL SkipLine (1)
     ZTurboKey = -ZTurboKeyUser
     ZSubParm = 1
     CALL TGet
     IF NOT ZYes OR ZSubParm = -1 THEN
        EXIT SUB
     END IF
     '* "{C0Reason for Page"
     CALL FormatString (1096,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     IF LEN(Strng$) THEN
        DO
           ZOutTxt$ = Strng$
           CALL TGet
           IF ZSubParm = -1 THEN
              EXIT SUB
           END IF
        LOOP UNTIL ZWasQ
     END IF
     ZMenuSysopPages = ZMenuSysopPages + 1
     PageCount = 0
     '* "O3T200MBMLA64L32C64D64E64"
     CALL FormatString (759,ZFalse,ZFalse,0,ZFalse,0,SoundStr$)
     '* "Paging {FS"
     CALL FormatString (760,ZFalse,ZFalse,0,ZTrue,0,"")
     PageTimeStart! = TIMER
     TempSnoop = ZSnoop
     ZSnoop = ZTrue
     CALL Line25
4730 CALL DelayTime (1)
     PageCount = PageCount + 1
     IF INKEY$ = ZEscape$ THEN _
        GOTO 4765
     ZSubParm = 4
     CALL QuickTPut (SPACE$(2) + CHR$(46),0)
     IF ZANSIMusic THEN
        FOR TelephoneRing = 1 TO 15 STEP 1
           CALL PutCom ("[MB" + SoundStr$ + CHR$(14))
        NEXT TelephoneRing
     ELSE
        CALL PutCom(ZBellRinger$)
     END IF
     IF INSTR(ZPagingPtrSupport$,CHR$(7)) AND ZPrinter THEN
        LPRINT CHR$(7);
     ELSE
        FOR TelephoneRing = 1 TO 15 STEP 1
           CALL RBBSPlay (SoundStr$)
        NEXT TelephoneRing
     END IF
     CALL CheckCarrier
     IF ZSubParm = -1 THEN
        EXIT SUB
     END IF
     CALL DelayTime (2)
     CALL CheckTime (PageTimeStart!, PageTimeNow!, 2)
     IF PageTimeNow! < 15 THEN GOTO 4730
     ZSnoop = TempSnoop
     ZOutTxt$ = ""
4750 IF (WasJJ > ZStartOfficeHours AND WasJJ < ZEndOfficeHours) OR _
        ZSysopAnnoy THEN
        '* "{CR{CB{FS {CDnot responding!{C0"
        LineNum = 761
        GOSUB 4770
     END IF
4755 '* "{C3Leave a message or comment{C0{CR"
     LineNum = 762
     GOSUB 4770
     CALL SmartPause (ZTrue)
     PagedFileName$ = ZWelcomeFileDrvPath$ + "PAGED.MNU"
     CALL GraphicDisplayFile (PagedFileName$)
     ZPageStatus$ = "PG!"
     '* "Operator paged {TM"
     CALL FormatString (763,ZFalse,ZTrue,2,ZFalse,0,"")
     EXIT SUB
4765 '* "Paged & chatted with Sysop"
     CALL FormatString (764,ZFalse,ZTrue,1,ZFalse,0,"")
         ZPageStatus$ = ""
     '* "{CESysop in!  {FN, this is {FS, go ahead!{C0"
     CALL FormatString (765,ZFalse,ZFalse,0,ZFalse,0,ZSysopGreeting$)
     IF ZCanANSIChat = ZTrue THEN
        CALL ResetGraphics
        CALL ANSIChat
     ELSE
        CALL SkipLine (1)
        CALL QuickTPut1 (ZSysopGreeting$)
        CALL SysopChat
     END IF
     EXIT SUB
4770 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,1,"")
     RETURN
     END SUB
'
5350 SUB SetGlobals
'
     ZUplds = ZGlobalUplds
     ZDnlds = ZGlobalDnlds
     ZDLToday! = ZGlobalDLToday!
     ZBytesToday! = ZGlobalBytesToday!
     ZDLBytes! = ZGlobalDLBytes!
     ZULBytes! = ZGlobalULBytes!
     ZDropTimes = ZGlobalDropTimes
     ZBankTime = ZGlobalBankTime
     END SUB
'
' *****  R - COMMAND FROM UTILITY MENU (REVIEW PROFILE)  ****
'
     SUB ReviewProfile
5400 CALL SkipLine (1)
     ZFileName$ = ZWelcomeFileDrvPath$ + "PROFILE"
     CALL GraphicDisplayFile (ZFileName$)
     CALL SmartPause (ZFalse)
     END SUB
'
6000  SUB GetMenu0Info
'
6001  CALL OpenWork (2,"MENU0-" + ZNodeFileID$ + ".DEF")
      IF ZErrCode = 52 THEN _
         CALL MakeMenu0Info : _
         GOTO 6001
      CALL ReadDir (2,1)
      CALL Trim (ZOutTxt$)
      ZMenuTimer! = VAL(ZOutTxt$)
      IF ZMenuTimer! > TIMER THEN _
         CALL MakeMenu0Info : _
         EXIT SUB
      ZMenuTimer! = TIMER
      CALL ReadDir (2,1)
      ZMenuNewUpld = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewUsers = VAL(ZOutTxt$)
      CALL ReadDIr (2,1)
      ZMenuNewCalls = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewSysop = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuDownloads = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuSysopPages = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuCarriers = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuDoors = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewMsgs = VAL(ZOutTxt$)
      CLOSE 2
      END SUB
'
6100  SUB PutMenu0Info
'
      CALL OpenOutW ("MENU0-" + ZNodeFileID$ + ".DEF")
      CALL PrintWorkA (2,STR$(ZMenuTimer!))
      CALL PrintWorkA (2,STR$(ZMenuNewUpld))
      CALL PrintWorkA (2,STR$(ZMenuNewUsers))
      CALL PrintWorkA (2,STR$(ZMenuNewCalls))
      CALL PrintWorkA (2,STR$(ZMenuNewSysop))
      CALL PrintWorkA (2,STR$(ZMenuDownloads))
      CALL PrintWorkA (2,STR$(ZMenuSysopPages))
      CALL PrintWorkA (2,STR$(ZMenuCarriers))
      CALL PrintWorkA (2,STR$(ZMenuDoors))
      CALL PrintWorkA (2,STR$(ZMenuNewMsgs))
      CLOSE 2
      END SUB
'
6200  SUB MakeMenu0Info
'
      ZMenuTimer! = 0
      ZMenuNewUpld = 0
      ZMenuNewUsers = 0
      ZMenuNewCalls = 0
      ZMenuNewSysop = 0
      ZMenuDownloads = 0
      ZMenuSysopPages = 0
      ZMenuCarriers = 0
      ZMenuDoors = 0
      ZMenuNewMsgs = 0
      CALL OpenOutW ("MENU0-" + ZNodeFileID$ + ".DEF")
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CALL PrintWorkA (2,CHR$(48))
      CLOSE 2
      END SUB
'
' $SUBTITLE: 'ReadDoorSys - Reads a DOOR.SYS drop file'
' $PAGE
'
'  SUBPROGRAM NAME    -- ReadDoorSys
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'
'
'  OUTPUT PARAMETERS  --     ZUserSecLevel
'                            ZUplds
'                            ZDnlds
'                            ZBytesToday!
'                            ZBankTime$
'                            ZDLToday!
'                            ZULBytes!
'                            ZDLBytes!
'
'  SUBPROGRAM PURPOSE --  Reads a DOOR.SYS drop file
'
' SecurityLevel (15), Total Uploads (28), Total Downloads (29),
' Daily Download "K" Total (30) Time Credits (42), Files DL today (47),
' Total "K" Uploaded (48), and Total "K" DL (49) can be modified by a
' Door, so let RBBS read back in the values!
'
9000 SUB ReadDoorSys
'
     FIELD 5,128 AS ZUserRecord$

     CALL OpenWork (2,ZNodeWorkDrvPath$+"DOOR.SYS")
     IF ZErrCode = 52 THEN _
        EXIT SUB
     FOR I = 1 TO 15
        CALL ReadDir (2,1)
     NEXT I
     OldVal = CVI(ZSecLevel$)
     ZUserSecLevel = VAL (ZOutTxt$)
     IF OldVal <> ZUserSecLevel THEN
        ZAdjustedSecurity = ZTrue
        ZUserSecSave = ZUserSecLevel
        IF (NOT ZConfMode) AND (NOT ZSubBoard) THEN
           ZOrigSec = ZUserSecLevel
           '* "Security level set to {SL via DOOR.SYS"
           CALL FormatString (766,ZFalse,ZTrue,2,ZFalse,0,"")
        END IF
     END IF
     MID$(ZUserRecord$,47,2) = MKI$(VAL(ZOutTxt$)) ' sec. level      (15)
     FOR I = 16 TO 28
        CALL ReadDir (2,1)
     NEXT I
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,125,2) = MKI$(VAL(ZZ$))     'total uploads    (28)
     CALL ReadDir (2,1)
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,123,2) = MKI$(VAL(ZZ$))     'total downloads  (29)
     CALL ReadDir (2,1)
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,94,4) = MKS$(VAL(ZZ$)*1000) 'bytes dnld today (30)
     FOR I = 31 TO 42
        CALL ReadDir (2,1)
     NEXT I
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,89,1) = CHR$(VAL(ZZ$))      ' banked time     (42)
     FOR I = 43 TO 47
        CALL ReadDir (2,1)
     NEXT I
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,90,4) = MKS$(VAL(ZZ$))      ' files dl today  (47)
     CALL ReadDir (2,1)
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,102,4) = MKS$(VAL(ZZ$)*1000)' total kbytes uploaded (48)
     CALL ReadDir (2,1)
     ZZ$ = ZOutTxt$
     CALL Trim (ZZ$)
     MID$(ZUserRecord$,98,4) = MKS$(VAL(ZZ$)*1000) ' total kbytes downloaded (49)
     CLOSE 2
     END SUB
'
SUB ColorInitials (Strng$)
    IF ZWasGR < 2 THEN
       EXIT SUB
    END IF
    IF INSTR(Strng$,">") = 3 THEN
       Strng$ = ZEscape$ + "[1;" + _
                LTRIM$(STR$(ZUserTextColor)) + "m" + _
                Strng$ + _
                ZEmphasizeOff$
       IF ZBoldText$ = "1" THEN
          MID$(Strng$,3,1) = "0"
       END IF
    ELSE
       Strng$ = ZEmphasizeOff$ + Strng$
    END IF
    END SUB
'
'
SUB UserEd (EditFromRead,TempHashValue$,UserRecordHold$,RegDateHold$,UserSecLevelSave,WasTu) STATIC
'
10000 ZStopInterrupts = ZTrue
      WasI = 1
      ScanUsers = ZFalse
      IF EditFromRead = 1 THEN GOTO 11341
      '* "A)dd, L)ist, P)rint, M)odify, S)can users"
      LineNum = 767
      GOSUB 26210
      GOSUB 12930
      IF ZWasQ = 0 THEN _
      IF EditFromRead > 0 THEN _
         GOTO 11325 _
      ELSE _
         ZUserFileIndex = WasTU : _
         GOTO 20093
      WasQQ = 0
      ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
      CALL AllCaps (ZWasZ$)
      IF ZWasZ$ = CHR$(65) THEN _                               'A
         GOTO 12300 _
      ELSE IF ZWasZ$ = CHR$(77) THEN _                          'M
         ZStopInterrupts = ZTrue _
      ELSE IF ZWasZ$ = CHR$(80) THEN _                          'P
         WasQQ = ZTrue _
      ELSE IF ZWasZ$ = CHR$(83) THEN _                          'S
         ScanUsers = ZTrue : _
         ZStopInterrupts = ZTrue _
      ELSE IF ZWasZ$ <> CHR$(76) THEN _                         'L
         GOTO 10000
      CALL OpenUser (ZHighestUserRecord)
      GOSUB 26100
      IF UCASE$(LEFT$(ZUserLocation$,1)) = "C" THEN _
         TempCity$ = "C)" + RIGHT$(ZUserLocation$,LEN(ZUserLocation$)-1) _
      ELSE TempCity$ = "C)" + ZUserLocation$
      WasZ = 1
      IF ScanUsers THEN
         '* "Scan for N)ame, P)assword, C)ity/State, L)evel"
         LineNum = 768
         GOSUB 26210
         '* ", H)ash id"
         LineNum = 1084
         GOSUB 26220
         ZOutTxt$ = ZOutTxt$ + _
              LEFT$(Strng$,-9*(ZStartHash > 1 AND ZLenHash > 0))
         GOSUB 12930
         ZOutTxt$ = ""
         ScanFunction$ = LEFT$(ZUserIn$(1),1)
         CALL AllCaps (ScanFunction$)
         ZCR = 0
         GOSUB 12979
         GOSUB 12966
         GOTO 12962
      END IF
10010 FOR WasJ = WasZ TO ZHighestUserRecord
         GET 5,WasJ
10015    CALL DispUserRec (WasQQ)
         IF NOT ZOK THEN _
            GOTO 11310
         IF ZRet <> 0 THEN _
           GOTO 11330
        IF NOT ZStopInterrupts THEN _
           GOTO 11310
11110   '* "[Letter/Char], {CO[1]{C0Delete, {CO[2]{C0Find, {CO[3]{C0Menu, {CO[4]{C0Print, {CO[5]{C0Quit, {CO[6]{C0User #"
        LineNum = 769
        GOSUB 26210
        GOSUB 12930
        IF NOT ScanUsers AND ZWasQ = 0 THEN _
           GOTO 11310
11115   ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
        CALL AllCaps (ZWasZ$)
        '* "123456ABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%&*()<>[]"
        LineNum = 770
        GOSUB 26220
        WasX = INSTR(Strng$,ZWasZ$)
        IF ZWasZ$ = "" AND ScanUsers THEN _
           GOTO 12965
        ON WasX GOTO 11130, 11340, 11330, 11220, 11320, 11127, _
                     11190, 11390, 11160, 11470, 11437, 11425, _
                     11426, 11420, 11423, 11490, 11435, 11446, _
                     11448, 11452, 11424, 11400, 11431, 11427, _
                     11432, 11433, 11445, 11436, 11434, 11428, _
                     11429, 11444, 11430, 11438, 11439, 11440, _
                     11441, 11442, 11443, 11449, 11447, 11450, _
                     11451, 11453, 11454
        GOTO 11110
11125   WasZ = VAL(ZUserIn$)
        IF WasZ < 1 OR WasZ > ZHighestUserRecord THEN _
           GOTO 11127
        GOTO 10010
11127   '* "What record #"
        LineNum = 771
        GOSUB 26210
        GOSUB 12932
        GOTO 11125
'
' *  D - COMMAND FROM 5- USER MAINTENANCE OPTIONS (DELETE USER)
'
11130   '* "{C0Delete user (Y,[N])"
        LineNum = 1085
        GOSUB 26210
        GOSUB 12995
        IF ZYes THEN
           '* "deleted user"
           LineNum = 772
           GOSUB 26220
           LSET ZUserName$ = CHR$(0) + Strng$
           LSET ZSecLevel$ = MKI$(ZMinLogonSec - 1)
           LSET ZLastDateTimeOn$ = "01-01-80" + _
                                     SPACE$(1) + _
                                     ZTimeLoggedOn$
        END IF
        GOTO 11290
'
' *  N - COMMAND FROM 5- USER MAINTENANCE OPTIONS (CHANGE USER PASSWORD)
'
11160   GOSUB 12800
        GOTO 11290
'
' *  P - COMMAND FROM 5- USER MAINTENANCE OPTIONS (PRINT USER FILE)
'
11185   '* "City/State now {CT"
        LineNum = 773
        GOSUB 26230
        '* "Enter new{SP"
        LineNum = 774
        GOSUB 26220
        WasA1$ = Strng$
        RETURN
11190 ' *** C - COMMAND FROM 5 - CHANGE CITY/STATE ***
        CityStateSave$ = ZWasCI$
        ZWasCI$ = ZCityState$
        CALL Trim (ZWasCI$)
        GOSUB 11185
        GOSUB 12960
        ZWasCI$ = CityStateSave$
        GOTO 11290
11220   WasQQ = NOT WasQQ
        GOTO 10015
11290   ZUserFileIndex = LOC(5)
        GOSUB 12989
        GOSUB 26000
        GOSUB 12991
        ZUserFileIndex = 0
        GOTO 10015
11310   IF ScanUsers THEN _
           GOTO 12965
11311 NEXT
'
' *  Q - COMMAND FROM 5- USER MAINTENANCE OPTIONS (QUIT TO MAIN MENU)
'
11320 ZUserFileIndex = WasTU
      LSET ZUserRecord$ = UserRecordHold$
      ZRegDate$ = RegDateHold$
      IF EditFromRead > 0 THEN _
         GOTO 11325
      EXIT SUB
11325 ZReply = ZFalse
      JustReplied = ZTrue
      QuotedReply = ZTrue
      EditFromRead = 0
      CALL GetMsgAttr
      DontPrint = ZTrue
      ZUserIn$ = CHR$(61)                                       '=
      EditFromRead = 3
      EXIT SUB
'
' *  M - COMMAND FROM 5- USER MAINTENANCE OPTIONS (MAIN USER MAINT. MENU)
'
11330 CLOSE 2
      IF EditFromRead > 0 THEN _
         EditFromRead = 2
      GOTO 10000
'
' *  F - COMMAND FROM 5- USER MAINTENANCE OPTIONS (FIND USER)
'
11340 '* "{SPto find"
      LineNum = 775
      GOSUB 26220
      ZOutTxt$ = ZPromptHash$ + Strng$
      CALL SkipLine (1)
      ZParseOff = ZTrue
      GOSUB 12932
      IF ZWasQ = 0 THEN _
        GOTO 11340
      TempHashValue$ = ZUserIn$
11341 IF LEN(TempHashValue$) < 3 OR LEN(TempHashValue$) > ZLenHash THEN _
         GOTO 11340
      CALL AllCaps (TempHashValue$)
      IF ZStartIndiv < 1 THEN _
         GOTO 11345
11342 '* "{SP to find"
      LineNum = 775
      GOSUB 26220
      ZOutTxt$ = ZPromptIndiv$ + Strng$
      GOSUB 12995
      IF ZWasQ = 0 THEN _
         GOTO 11342
      TempIndivValue$ = ZUserIn$
      IF LEN(TempIndivValue$) > ZLenIndiv THEN _
         GOTO 11342
      CALL AllCaps (TempIndivValue$)
11345 GOSUB 12600
      GOSUB 12990
      GOSUB 12987
      IF NOT Found THEN
         CALL QuickPeek (TempHashValue$,MsgTo$,Found,ZTrue)
         IF Found THEN
            GOSUB 12600
         END IF
      END IF
      GOSUB 12990
      GOSUB 12987
      ZUserFileIndex = 0
      IF Found THEN _
         GOTO 10015
11380 '* "{SPnot found"
      LineNum = 776
      GOSUB 26220
      ZOutTxt$ = ZEmphasizeOff$ + TempHashValue$ + _
           SPACE$(1) + TempIndivValue$ + Strng$
      GOSUB 12977
      GOTO 11310
'
' *  S - COMMAND FROM 5- USER MAINTENANCE OPTIONS (CHANGE USER SECURITY)
'
11390 GOSUB 11395
      LSET ZSecLevel$ = MKI$(WasOF)
      GOTO 11290
11395 '* "New sec level{EX"
      LineNum = 777
      GOSUB 26210
      GOSUB 12932
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      WasOF = VAL(ZWasZ$)
      IF WasOF > ZUserSecLevel THEN _
         WasOF = ZUserSecLevel
      RETURN
'
' *  R - COMMAND FROM 5- USER MAINTENANCE OPTIONS (SET USER GRAPHICS)
'
11400 Temp = ASC(MID$(ZUserOption$,6,1))
      '* "Graphics Color"
      LineNum = 1086
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,30,99)
      IF ZWasQ <> 0 THEN
         LSET ZUserOption$ = LEFT$(ZUserOption$,5) + _
                             CHR$(ZTestedIntValue) + _
                             MID$(ZUserOption$,7)
      END IF
      GOTO 11290
11420        ' * T - COMMAND FROM 5 - TIME USED
      Temp = CVI (ZElapsedTime$)
      '* "Time Used"
      LineNum = 778
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,-21900,2000)
      IF ZWasQ <> 0 THEN _
         LSET ZElapsedTime$ = MKI$(ZTestedIntValue)
      GOTO 11290
11423        ' * B - COMMAND FROM 5 - BANKED TIME
      Temp = ASC(ZBankTime$)
      '* "Banked Time"
      LineNum = 779
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,0,255)
      IF ZWasQ <> 0 THEN _
         LSET ZBankTime$ = CHR$(ZTestedIntValue)
      GOTO 11290
11424        ' * ! - COMMAND FROM 5 - DROPPED CARRIERS
      Temp = ASC(ZDropTimes$)
      '* "Dropped Carriers"
      LineNum = 780
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,0,255)
      IF ZWasQ <> 0 THEN _
         LSET ZDropTimes$ = CHR$(ZTestedIntValue)
      GOTO 11290
'
' * Date/Time last on
'
11425 '* "Enter Last Date/Time on (DD-MM-YY HH:MM)"
      LineNum = 781
      GOSUB 26210
      GOSUB 12932
      IF ZWasQ = 0 THEN
         GOTO 10015
      END IF
      LSET ZLastDateTimeOn$ = ZUserIn$(ZAnsIndex) + _
                              SPACE$(1) + ZUserIn$(ZLastIndex)
      ZLastIndex = 1
      GOTO 11290
'
' * Times On
'
11426 Temp = CVI(MID$(ZUserOption$,1,2))
      '* "Times Logged On"
      LineNum = 782
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,1,32767)
      IF ZWasQ <> 0 THEN
         LSET ZUserOption$ = MKI$(ZTestedIntValue) + MID$(ZUserOption$,3)
      END IF
      GOTO 11290
'
' * ANSIEd
'
11427 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 128
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$ (ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Protocol
'
11428 '* "Enter Protocol"
      LineNum = 783
      GOSUB 26210
      GOSUB 12932
      IF ZWasQ <> 0 THEN
         LSET ZUserOption$ = LEFT$(ZUserOption$,4) + _
                             UCASE$(LEFT$(ZUserIn$(ZAnsIndex),1)) + _
                             MID$(ZUserOption$,6)
      END IF
      GOTO 11290
'
' * Skip New Files
'
11429 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 64
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Check New Bulletins
'
11430 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 32
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * HighLighting
'
11431 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 1024
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Page Length
'
11432 Temp = ASC(MID$(ZUserOption$,13,1))
      '* "Page Length"
      LineNum = 784
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,0,255)
      IF ZWasQ <> 0 THEN
         LSET ZUserOption$ = LEFT$(ZUserOption$,12) + _
                 CHR$(ZTestedIntValue) + _
                 MID$(ZUserOption$,14)
      END IF
      GOTO 11290
'
' * Right Margin
'
11433 Temp = ASC(MID$(ZUserOption$,7,1))
      '* "Right Margin"
      LineNum = 785
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,1,74)
      IF ZWasQ <> 0 THEN
         LSET ZUserOption$ = LEFT$(ZUserOption$,6) + _
                 CHR$(ZTestedIntValue) + _
                 MID$(ZUserOption$,8)
      END IF
      GOTO 11290
'
' * Mail Waiting
'
11434 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 512
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Answered Questionaire
'
11435 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 256
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Last Message Read
'
11436 Temp = CVI(MID$(ZUserOption$,3,2))
      '* "Last Message Read"
      LineNum = 786
      GOSUB 26220
      CALL ChangeInt (ZTrue,Strng$,Temp,0,ZHighMsgNumber)
      IF ZWasQ <> 0 THEN
         LSET ZUserOption$ = LEFT$(ZUserOption$,2) + _
                 MKI$(ZTestedIntValue) + _
                 MID$(ZUserOption$,5)
      END IF
      GOTO 11290
'
' * Last DIR Date
'
11437 '* "Enter Last DIR Date (MM-DD-YY)"
      LineNum = 787
      GOSUB 26210
      GOSUB 12932
      IF ZWasQ = 0 THEN
         GOTO 10015
      END IF
      IF LEN(ZUserIn$(ZAnsIndex)) < 8 THEN
         GOTO 11437
      END IF
      LSET ZListNewDate$ = CHR$(VAL(MID$(ZUserIn$(ZAnsIndex),7,2))) + _
                           CHR$(VAL(MID$(ZUserIn$(ZAnsIndex),1,2))) + _
                           CHR$(VAL(MID$(ZUserIn$(ZAnsIndex),4,2)))
      GOTO 11290
'
' * Expert User
'
11438 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 2
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Prompt Bell
'
11439 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 1
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Nulls
'
11440 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 4
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Upper Case
'
11441 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 8
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Line Feeds
'
11442 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 16
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * TurboKeys
'
11443 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 2048
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Personal Upload Waiting
'
11444 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 4096
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Read All New Mail
'
11445 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 1
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * Reselect All
'
11446 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 2
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * More Prompt LF
'
11447 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 4
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * Reselect Graphics
'
11448 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 8
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * ANSI Music
'
11449 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 16
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * Echoer
'
11450 '* "Change ECHO to R)BBS, C)aller's software"
      LineNum = 788
      GOSUB 26220
      Strng1$ = Strng$
      '* ", I)ntermediate host"
      LineNum = 794
      GOSUB 26220
      Strng2$ = Strng$
      ZOutTxt$ = Strng1$ + _
           MID$(Strng2$,1,-20 * (ZHostEchoOn$ <> "")) + _
           ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZWasQ = 0 THEN _
         GOTO 11290
      ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
      CALL AllCaps (ZWasZ$)
      IF INSTR("ICR",ZWasZ$) <> 0 THEN _
         LSET ZUserOption$ = LEFT$(ZUserOption$,13) + _
         ZWasZ$
      GOTO 11290
'
' * Never Can Page
'
11451 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 32
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * Reselect Protocol
'
11452 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 64
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' * Extended Files
'
11453 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA XOR 16384
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + _
              MKI$(ZWasA) + _
              MID$(ZUserOption$,11)
      GOTO 11290
'
' * Global Twit
'
11454 ZWasA = ASC(MID$(ZUserOption$,8,1))
      ZWasA = ZWasA XOR 128
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + _
              CHR$(ZWasA) + _
              MID$(ZUserOption$,9)
      GOTO 11290
'
' *  $ - COMMAND FROM 5 - USER MAINTENANCE (CHANGE REGISTRATION DATE)
'
11470 '* "Enter new registration date (MM-DD-YY)"
      LineNum = 789
      GOSUB 26210
      GOSUB 12932
      IF ZWasQ = 0 THEN _
         GOTO 10015
11475 WorkDate$ = ZUserIn$(ZAnsIndex)
      IF LEN(WorkDate$) < 8 THEN _
         GOTO 11470
      CALL ResetRegDate (WorkDate$)
      IF NOT ZOK THEN _
         GOTO 11470
      LSET ZUserOption$ = LEFT$(ZUserOption$,10) + _
                           ZRegDate$ + _
                           MID$(ZUserOption$,13)
      CALL SetRegDisplay
      ZRegDate$ = RegDateHold$
      GOTO 11290
'
' *  X - COMMAND FROM 5 - USER MAINTENANCE (CHANGE XFER COUNTERS) *
'
11490 CALL CmndSysOpXfer
      GOTO 11290
'
' *  A - COMMAND FROM 5- USER MAINTENANCE OPTIONS (ADD USER)
'
12300 WasA1$ = ""
      Attempts = 0
      FirstNameSave$ = ZFirstName$
      LastNameSave$ = ZLastName$
      ActiveUserNameSave$ = ZActiveUserName$
      CityStateSave$ = ZWasCI$
      HashValueSave$ = HashValue$
      IndivValueSave$ = ZIndivValue$
      GOSUB 12500
      GOSUB 12840
      GOSUB 12850
      GOSUB 12598
      IF ZUserFileIndex = 0 THEN _
         GOSUB 12984 : _
         GOTO 12330
      IF Found THEN
         '* "User already exists"
         LineNum = 790
         GOSUB 26220
         WasD$ = Strng$
         CALL LPrnt(WasD$,1)
         GOSUB 12984
         GOTO 12330
      END IF
12310 GOSUB 12630
      GOSUB 12800
      GOSUB 11395
      ZTempSecLevel = WasOF
      CALL SetNewUserDef
      LSET ZLastDateTimeOn$ = ZCurDate$ + _
                                SPACE$(1) + _
                                ZTimeLoggedOn$
      LSET ZListNewDate$ = CHR$(91) + CHR$(1) + CHR$(1)
      TempDate$ = DATE$
      WorkDate$ = LEFT$(TempDate$,6) + RIGHT$(TempDate$,2)
      CALL ResetRegDate (WorkDate$)
      LSET ZUserOption$ = LEFT$(ZUserOption$,10) + _
                           ZRegDate$ + _
                           MID$(ZUserOption$,13)
      LSET ZUserOption$ = LEFT$(ZUserOption$,13) + ZDefaultEchoer$
      LSET ZUserOption$ = LEFT$(ZUserOption$,12) + _
              CHR$(23) + _
              MID$(ZUserOption$,14)
      LSET ZUserOption$ = LEFT$(ZUserOption$,6) + _
              CHR$(72) + _
              MID$(ZUserOption$,8)
      LSET ZUserOption$ = LEFT$(ZUserOption$,7) + CHR$(1) + _
              MID$(ZUserOption$,9)
      LSET ZUserOption$ = LEFT$(ZUserOption$,8) + MKI$(9264) + _
              MID$(ZUserOption$,11)
      GOSUB 12960
      CALL AllCaps (ZUserIn$)
      LSET ZCityState$ = ZUserIn$
      LSET ZElapsedTime$ = MKI$(0)
      IF ZStartHash > 1 THEN _
         MID$(ZUserRecord$,ZStartHash,ZLenHash) = HashValue$
      IF ZStartIndiv > 1 THEN _
         MID$(ZUserRecord$,ZStartIndiv,ZLenIndiv) = ZIndivValue$
      GOSUB 26000
12320 GOSUB 12991
12330 ZUserSecLevel = UserSecLevelSave
      ZFirstName$ = FirstNameSave$
      ZLastName$ = LastNameSave$
      ZActiveUserName$ = ActiveUserNameSave$
      ZWasCI$ = CityStateSave$
      HashValue$ = HashValueSave$
      ZIndivValue$ = IndivValueSave$
      ZUserFileIndex = WasTU
      LSET ZUserRecord$ = UserRecordHold$
      GOTO 10000
'
' *  GET USER First AND Last NAMES
'
12500 IF Attempts > 5 THEN _
         ZFF = ZTrue : _
         RETURN
12510 Attempts = Attempts + 1
      ZOutTxt$ = WasA1$ + _
           ZFirstNamePrompt$
      CALL SkipLine (1)
      ZLogonActive = ZTrue
      GOSUB 12555
      IF ZWasQ = 0 THEN _
          GOTO 12500
      ZLogonActive = ZFalse
      CALL Trim (ZWasZ$)
      ZFirstName$ = ZWasZ$
12530 ZOutTxt$ = WasA1$ + _
           ZLastNamePrompt$
      ZParseOff = ZTrue
      GOSUB 12555
      IF ZWasQ = 0 THEN
         ZLastName$ = ""
         ZWasZ$ = ""
         GOTO 12542
      END IF
12540 CALL Trim (ZWasZ$)
      ZLastName$ = ZWasZ$
      IF LEN(ZLastName$) < 2 THEN _
         IF LEN(ZFirstName$) > 2 THEN _
            GOTO 12500
12542 IF (LEN(ZFirstName$) + LEN(ZLastName$)) > 30 THEN _
         GOTO 12500
      IF UserSecLevelSave < ZSysopSecLevel THEN _
         IF (LEN(ZFirstName$) < 2 OR LEN(ZLastName$) < 2) THEN _
            GOTO 12500 _
         ELSE IF LEFT$(ZFirstName$,1)=SPACE$(1) OR LEFT$(ZLastName$,1)=SPACE$(1) THEN _
                 GOTO 12500
12550 ZActiveUserName$ = MID$(ZFirstName$ + SPACE$(1) + ZLastName$,1,31)
      ZWasZ$ = ZFirstName$
      RETURN
'
' *  CHECK FOR NAMES NOT ALLOWED
'
12555 GOSUB 12932
      IF ZWasQ = 0 THEN _
         RETURN
12556 ZWasZ$ = ZUserIn$(ZAnsIndex)
12557 CALL AllCaps (ZWasZ$)
      CALL RemNonAlf (ZWasZ$,31,91)
      RETURN
'
' *  COMMON SEARCH USER FILE ROUTINE
'
12598 TempHashValue$ = HashValue$
      TempIndivValue$ = ZIndivValue$
12600 GOSUB 25000
      GOSUB 12988
12605 CALL OpenUser (ZHighestUserRecord)
      GOSUB 26100
      CALL FindUser (TempHashValue$,TempIndivValue$,ZStartHash,ZLenHash,_
                     ZStartIndiv,ZLenIndiv,ZHighestUserRecord,Found,_
                     ZUserFileIndex,ZWasSL)
     IF Found THEN _
        RETURN
     IF ZCurUserCount < (ZHighestUserRecord-1)*.95 THEN _
        RETURN
     '* "No room for new users in {CN"
     LineNum = 212
     GOSUB 26210
     CALL UpdtCalr (ZOutTxt$,2)
     IF ZActiveUserFile$ <> ZMainUserFile$ THEN _
        ZUserFileIndex = 0 : _
        RETURN
      IF ZRememberNewUsers AND NOT ZSurviveNoUserRoom THEN _
              GOTO 12975
      ZUserFileIndex = 0
      IF ZSurviveNoUserRoom THEN _
         ZRememberNewUsers = ZFalse
      RETURN
'
' *  AUGMENT USER COUNT, LOCK 4 REC BLOCK IN USER, UNLOCK FILES
'
12630 GOSUB 23000
      ZCurUserCount = ZCurUserCount + (ZWasSL = 0) * ZRememberNewUsers
12632 GOSUB 24000
      GOSUB 12985
      IF ZRememberNewUsers THEN _
         GOSUB 12989
      GOSUB 12990
      RETURN
'
' *  GET PASSWORD FROM NEWUSER
'
12800 '* "{C0Password"
      LineNum = 791
      GOSUB 26220
      CALL NewPassword (Strng$,ZFalse)
      IF ZSubParm < 0 THEN _
         exit sub
      IF UserSecLevelSave < ZSysopSecLevel THEN _
         IF ZUserIn$ = SPACE$(LEN(ZUserIn$)) THEN _
            GOTO 12800
      LSET ZPswd$ = ZWasZ$
      RETURN
'
' *  GET HASH VALUE FOR CURRENT USER TO LOOK UP IN THE USER'S FILE
'
12840 IF ZStartHash = 1 THEN _
         HashValue$ = ZActiveUserName$ : _
         RETURN
      WasX$ = WasA1$ + _
           ZPromptHash$
      CALL UntilRight (WasX$,HashValue$,2,ZLenHash)
      RETURN
'
' *  GET FIELD TO INDIVIDUATE ONE USER FROM ANOTHER (NAME FIELD IS DEFAULT)
'
12850 IF ZStartIndiv < 1 OR ZLenIndiv < 1 THEN _
         RETURN
      IF ZStartIndiv = 1 THEN _
         ZIndivValue$ = ZActiveUserName$ : _
         RETURN
      IF ZExitToDoors THEN _
         RETURN
      WasX$ = WasA1$ + _
           ZPromptIndiv$
      CALL UntilRight (WasX$,ZIndivValue$,2,ZLenIndiv)
      RETURN
12930 ZTurboKey = -ZTurboKeyUser
12932 CALL PopCmdStack
      GOTO 12997
'
' *  GET CITY AND STATE
'
12960 ZOutTxt$ = WasA1$ + ZUserLocation$ + ZPressEnterExpert$
      ZParseOff = ZTrue
      GOSUB 12932
      IF ZWasQ = 0 THEN _
         RETURN
      CALL AllCaps (ZUserIn$)
      LSET ZCityState$ = ZUserIn$
      ZWasCI$ = ZUserIn$
      RETURN
'
' *  S - COMMAND FROM 5 - USER MAINTENANCE OPTIONS (SCAN USERS)
'
12962 WasX = 0
      ZFF = ZFalse
      ZMacroMin = 99
      '* "String to search"
      LineNum = 792
      GOSUB 26210
      GOSUB 12998
      IF ZWasQ = 0 THEN _
         GOTO 10000
      CALL AllCaps (ZUserIn$)
      WasWK$ = ZUserIn$
      IF ScanFunction$ = CHR$(76) THEN _                        'L
         WasWK$ = CHR$(44) + _
               STR$(VAL(WasWK$)) + _
               CHR$(44)
12963 GET 5,WasI
      GOSUB 12966
      WasX = INSTR(ScanField$,WasWK$)
      IF WasX > 0 THEN _
         GOTO 10015
12965 WasI = WasI + 1
      IF WasI > ZHighestUserRecord THEN _
         LSET ZUserRecord$ = UserRecordHold$ : _
         GOTO 10000
      WasX = 0
      GOTO 12963
12966 ZFF = INSTR("NCPLH",ScanFunction$)
12967 ON ZFF GOTO 12968,12969,12970,12972,12971
      GOTO 10000
'
' *  N - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR NAME)
'
12968 ScanField$ = ZUserName$
      RETURN
'
' *  C - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR CITY/ST)
'
12969 ScanField$ = ZCityState$
      RETURN
'
' *  P - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR PASSWORD)
'
12970 ScanField$ = ZPswd$
      RETURN
'
' *  H - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR HASH ID)
'
12971 IF ZStartHash > 0 AND ZLenHash > 0 THEN _
         ScanField$ = MID$(ZUserRecord$,ZStartHash,ZLenHash)
      RETURN
'
' *  L - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR LEVEL)
'
12972 ScanField$ = CHR$(44) + _
                    STR$(CVI(ZSecLevel$)) + _
                    CHR$(44)
      RETURN
'
' * CALLS INTO SEPARATELY COMPILED SUBROUTINES (RBBS-SUB)
'
'
' * STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL OUTPUT ROUTINE
'
12975 ZSubParm = 1
      GOTO 12981
12976 ZSubParm = 2
      GOTO 12981
12977 ZSubParm = 3
      GOTO 12981
12978 ZSubParm = 4     ' no cr/lf
      GOTO 12981
12979 ZSubParm = 5     ' cr/lf
      GOTO 12981
12980 ZSubParm = 6
12981 CALL TPut
12983 IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZSubParm = 8 THEN _
         GOSUB 12995
      RETURN
'
' * STANDARD ENTRY FOR RBBS-PC'S FILE LOCKING WHEN RUNNING MULTIPLE RBBS-PC'S
'
12984 ZSubParm = 1  ' LOCK USERS & MESSAGES
      GOTO 12994
12985 ZSubParm = 2  ' UNLOCK MESSAGES AND FLUSH
      Flushed = ZTrue
      GOTO 12994
12986 ZSubParm = 3  ' LOCK MESSAGES
      GOTO 12994
12987 ZSubParm = 4  ' UNLOCK MESSAGES
      GOTO 12994
12988 ZSubParm = 5  ' LOCK USERS
      GOTO 12994
12989 ZSubParm = 6  ' LOCK USER BLOCK
      GOTO 12994
12990 ZSubParm = 7  ' UNLOCK USERS
      GOTO 12994
12991 ZSubParm = 8  ' UNLOCK USER BLOCK
      GOTO 12994
12994 CALL FileLock
      IF Flushed THEN _
         FIELD 1,128 AS ZMsgRec$ : _
         Flushed = ZFalse
      IF ZSubParm = -1 THEN _
         ZSubParm = -9 : _
         CALL FindFKey : _
         EXIT SUB
      RETURN
'
' * STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL INPUT ROUTINE
'
12995 GOSUB 12997
      ZSubParm = 1
12996 CALL TGet
12997 IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
12998 ZOutTxt$ = ZOutTxt$ + _
           ZPressEnterExpert$
      GOTO 12995
12999 ZTurboKey = -ZTurboKeyUser
      GOTO 12995
'
' *  C/R - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (QUIT TO MAIN MENU)
'
20093 LSET ZUserRecord$ = UserRecordHold$
      GOSUB 26200
      EXIT SUB
'
' *  GET MESSAGE HEADER RECORD DATA
'
23000 GET 1,1
      ZHighMsgNumber = VAL(LEFT$(ZMsgRec$,8))
      AutoAddSec   = CVI(MID$(ZMsgRec$,9,2))
      ZCallsToDate! = VAL(MID$(ZMsgRec$,11,10))
      ZMsgSecCats$ = LEFT$(CHR$(85),-(MID$(ZMsgRec$,21,1) <> CHR$(47))) + _
                     LEFT$(CHR$(82),-(MID$(ZMsgRec$,22,1) <> CHR$(47))) + _
                     LEFT$(CHR$(80),-(MID$(ZMsgRec$,23,1) <> CHR$(47))) + CHR$(69)
      IF ZUserSecLevel >= ZSecKillAny THEN _
          ZMsgSecCats$ = "URPE"
      IF ZMsgSecCats$ = CHR$(69) THEN _
         ZMsgSecCats$ = "UE"
      ZCurUserCount = VAL(MID$(ZMsgRec$,57,5))
      FirstMsgRecord = VAL(MID$(ZMsgRec$,68,7))
      ZNextMsgRec = VAL(MID$(ZMsgRec$,75,7))
      HighestMsgRecord = VAL(MID$(ZMsgRec$,82,7))
      Temp = VAL(MID$(ZMsgRec$,127))
      IF ZActiveMessageFile$ = ZOrigMsgFile$ THEN _
         ZMaxNodes = Temp
      IF ZNextMsgRec <= Temp THEN _
         ZNextMsgRec = Temp + 1
      RETURN
'
' *  UPDATE MESSAGE HEADER RECORD DATA
'
24000 MID$(ZMsgRec$,1,8) = STR$(ZHighMsgNumber)
      MID$(ZMsgRec$,11,10) = STR$(ZCallsToDate!)
      MID$(ZMsgRec$,57,5) = STR$(ZCurUserCount)
      MID$(ZMsgRec$,68,7) = STR$(FirstMsgRecord)
      MID$(ZMsgRec$,75,7) = STR$(ZNextMsgRec)
      MID$(ZMsgRec$,82,7) = STR$(HighestMsgRecord)
      PUT 1,1
      RETURN
'
25000 GOSUB 12986
      GOSUB 25200
      GOSUB 23000
      RETURN
'
' ****  RESTORE A MESSAGE BASE   ***
'
25100 GOSUB 25200
      GOSUB 23000
      RETURN
'
' *****  OPEN AND SETUP MESSAGE BASE  *****
'
25200 CALL OpenMsg
      IF ZErrCode = 64 THEN _
         ZErrCode = 0 : _
         GOTO 25300
      FIELD 1, 128 AS ZMsgRec$
      RETURN
'
' ****  JOIN M)AIN   ***
'
25300 '* "MAIN"
      LineNum = 166
      GOSUB 26220
      IF ZConfName$ <> Strng$ THEN
         '* "{CR{C2Rejoining {CBMAIN{C0"
         LineNum = 176
         GOSUB 26230
      END IF
      ZActiveUserName$ = ZOrigUserNameDgs$
      ZFirstName$ = OrigFirstName$
      CALL DeLink (ZConfName$)
      ConfFileName$ = OrigMsgName$
      ZNewsFileName$ = OrigNewsFileName$
      ZTurboLogon = ZTrue
      ZMarkedMsgs$ = ""
      ZMarkedFiles$ = ""
      ZWasQ = 0
      ZNewUser = ZFalse
      ZInConfMenu = ZTrue
      '* "SYSOP"
      LineNum = 131
      GOSUB 26220
      IF ZActiveUserName$ = Strng$ THEN _
         ZActiveUserName$ = ZSecretName$ : _
         CALL Trim (ZActiveUserName$)
      ZConfigFileName$ = ZOrigCnfg$
      CALL ReadDef (ZConfigFileName$)
      IF ZOrigMsgFile$ <> ZActiveMessageFile$ THEN _
         ZActiveMessageFile$ = ZOrigMsgFile$ : _
         GOSUB 25100
      IF ZOrigUserFile$ <> ZActiveUserFile$ THEN _
         GOSUB 25600 : _
         ZActiveUserFile$ = ZOrigUserFile$ : _
         ZActiveUserName$ = ZOrigUserName$ : _
         GOSUB 12598 : _
         GOSUB 12990 : _
         IF Found THEN _
            GOSUB 26200 : _
            ZMainUserFileIndex = ZUserFileIndex : _
            CALL SetPrompt : _
            CALL XferType (2,ZTrue) _
         ELSE ZUserFileIndex = 0 : _
              ZMainUserFileIndex = 0
      '* "{AN Exited {CN"
      LineNum = 793
      GOSUB 26220
      CALL UpdtCalr (Strng$,3)
      '* "MAIN"
      LineNum = 166
      GOSUB 26220
      ZConfName$ = Strng$
      ConfNameSave$ = ZConfName$
      IF ZCurPUI$ = "" OR ZSubBoard THEN _
         ZCurPUI$ = ZMainPUI$
      CALL FindIt (ZCurPUI$)
      ZCustomPUI = ZOK
      IF NOT ZOK THEN _
         ZCurPUI$ = ""
      ZPrevPUI$ = ""
      ZUplds = ZGlobalUplds
      ZDnlds = ZGlobalDnlds
      ZDLToday! = ZGlobalDLToday!
      ZBytesToday! = ZGlobalBytesToday!
      ZDLBytes! = ZGlobalDLBytes!
      ZULBytes! = ZGlobalULBytes!
      ZBankTime = ZGlobalBankTime
      ZConfMode = ZFalse
      BoardCheckDate$ = ZLastDateTimeOn$
      ZSubBoard = ZTrue
      GOSUB 12987
      IF ((ZUserSecLevel < ZAutoUpgradeSec) AND ZSubBoard) OR _
         ((ZUserSecLevel < OrigUpgradeSec) AND NOT ZSubBoard) THEN _
            IF ZUserSecLevel <> ZOrigSec THEN _
               ZUserSecLevel = ZOrigSec : _
               LSET ZSecLevel$ = MKI$(ZUserSecLevel)
      RETURN
'
' *****  UPDATE CURRENT USERS RECORD  ****
'
25600 IF ZUserFileIndex < 1 THEN _
         RETURN
      IF ZAdjustedSecurity AND NOT ZSysop THEN _
         LSET ZSecLevel$ = MKI$(ZUserSecLevel) : _
         ZUserSecSave = ZUserSecLevel
      IF ZSubBoard THEN _
         ZActiveUserName$ = ZOrigUserNameDgs$ : _
         ZFirstName$ = OrigFirstName$
      CALL UpdateU (ZFalse)
      RETURN
'
' * WRITE A RECORD TO THE RBBS-PC "USER" FILE
'
26000 IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
         PUT 5,ZUserFileIndex
      RETURN
'
' * DEFINE USER FILE RECORD VARIABLES TO COMPENSATE FOR THE BUG IN QUICKBASIC
' * THAT REQUIRES A FIELD STATMENT TO BE EXECUTED WITHIN EACH SEPARATELY
' * COMPILED PROGRAM -- EVEN THOUGH A FIELD STATEMENT WAS EXECUTED WHEN THE
' * FILE WAS OPENED IN ANOTHER SEPERATELY COMPILED SUBROUTINE
'
' * SO WHY ARE WE USING MICROSOFT!?
'
26100 FIELD 5,31 AS ZUserName$, _
              15 AS ZPswd$, _
               2 AS ZSecLevel$, _
              14 AS ZUserOption$,  _
              24 AS ZCityState$, _
               1 AS MachineType$, _
               1 AS ZDropTimes$, _
               1 AS ZBankTime$,_
               4 AS ZTodayDl$, _
               4 AS ZTodayBytes$, _
               4 AS ZDlBytes$, _
               4 AS ZULBytes$, _
              14 AS ZLastDateTimeOn$, _
               3 AS ZListNewDate$, _
               2 AS ZUserDnlds$, _
               2 AS ZUserUplds$, _
               2 AS ZElapsedTime$
      FIELD 5,128 AS ZUserRecord$
      RETURN
'
' * GET USER DEFAULTS
'
26200 GOSUB 26100
      CALL SetSysOp
      CALL SetUserPref
      RETURN
26210 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      RETURN
26220 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
26230 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,1,"")
      RETURN
      END SUB
'
42850 SUB ChangeEchoToggle
      CALL ReportEcho
42851 '* "Change ECHO to R)BBS, C)aller's software"
      CALL FormatString (788,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      '* ", I)ntermediate host"
      CALL FormatString (794,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      ZOutTxt$ = ZOutTxt$ + _
           MID$(Strng$,1,-20 * (ZHostEchoOn$ <> "")) + _
           ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         EXIT SUB
42852 ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
      CALL AllCaps (ZWasZ$)
      IF INSTR("ICR",ZWasZ$) = 0 THEN _
         GOTO 42851
      ZEchoer$ = ZWasZ$
      CALL SetEcho (ZEchoer$)
      CALL ReportEcho
      END SUB
'
43000 SUB SetGraphicsWanted
'
      ZPrevPUI$ = ""
      GOSUB 43005
      GOTO 43022
43005 CALL AskGraphics
      IF ZSubParm = -1 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         RETURN
43020 '* "Text Graphics:{SP"
      LineNum = 795
      GOSUB 43030
      ZOutTxt$ = Strng$
      ZSubParm = 5
      CALL TPut
      RETURN
43022 ZPrevPUI$ = ""
      IF ZEmphasizeOnDef$ = "" THEN _
         RETURN
      IF ZNewUser THEN _
         ZEmphasizeOn$ = ZEmphasizeOnDef$ : _
         ZEmphasizeOff$ = ZEmphasizeOffDef$
      IF ZWasGR < 2 AND ZWasGRHold <> 3 THEN
         '* "Do you want colorized prompts"
         LineNum = 801
         GOSUB 43030
         IF ZWasGR > 1 THEN
            ZOutTxt$ = Strng$ + ZYesPrompt$
         ELSE
            ZOutTxt$ = Strng$ + ZNoPrompt$
         END IF
         ZSubParm = 1
         CALL TGet
         ZHiLiteOff = ZYes
      ELSE
         ZHiLiteOff = ZTrue
      END IF
      IF ZWasGRHold = 3 THEN
         IF ZRIPGraphics OR ZCanANSIChat THEN
            ZHiLiteOff = ZTrue
         ELSE
            ZHiLiteOff = ZFalse
         END IF
      END IF
      CALL Toggle(5)
      CALL SetGraphic (ZWasGR)
      IF NOT ZNewUser THEN
         CALL DefaultU
      END IF
      EXIT SUB
43030 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
      END SUB
'
' * make all users reselect graphics if set in CONFIG
'
45500 SUB ReselectGraphics
      UserMode = ZExpertUser
      ZExpertUser = ZFalse
      CALL SetGraphicsDefaults
      CALL ResetGraphics
      '* "{CR{C2You must re-select your {CBGRAPHICS {C2preferences!{C0"
      CALL FormatString (802,ZFalse,ZFalse,0,ZTrue,2,"")
      CALL SetGraphicsWanted
      ZExpertUser = UserMode
      IF ZSubParm < 0 THEN
         EXIT SUB
      END IF
      IF ZWasQ = 0 THEN
         CALL SetGraphic (ZWasGR)
      END IF
      ZReselectGraphics = ZFalse
      CALL DefaultU
      END SUB
'
45510 SUB SetGraphicsDefaults
      IF ZCanANSIChat THEN
         ZWasGR = 2
         ZUserTextColor = 37
         ZBoldText$ = "1"
         ZHiLiteOff = ZFalse
      ELSE
         ZWasGR = 0
         ZUserTextColor = 37
         ZBoldText$ = "0"
         ZHiLiteOff = ZTrue
      END IF
      IF ZRIPGraphics THEN
         ZWasGR = 4
      END IF
      ZHiLiteOffHold = ZHiLiteOff
      ZBoldTextHold$ = ZBoldText$
      END SUB
'
45600 SUB ReselectAll
      '* "{CR{C2You must re-select {CBALL {C2preferences!{C0"
      CALL FormatString (803,ZFalse,ZFalse,0,ZTrue,2,"")
      CALL SetToggles
      GOSUB 45610
      CALL SetGraphicsDefaults
      GOSUB 45610
      CALL SetGraphicsWanted
      GOSUB 45610
      CALL SetGraphic (ZWasGR)
      GOSUB 45610
      '* "{CEDefault{SP"
      CALL FormatString (804,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      CALL XferType (3,ZExpertUser)
      GOSUB 45610
      ZUserXferDefault$ = ZWasFT$
      CALL NewUserToggles
      GOSUB 45610
      ZReselectAll = ZFalse
      ZReselectGraphics = ZFalse
      ZReselectProto = ZFalse
      GOSUB 45610
      CALL DefaultU
      EXIT SUB
45610 IF ZSubParm < 0 THEN
         EXIT SUB
      ELSE
         RETURN
      END IF
      END SUB
'
59934 SUB SetANSIColors
'
      REDIM FG$(15)
      REDIM BG$(8)

      ZDR1$ = ZDR1Def$                       'filename
      ZDR2$ = ZDR2Def$                       'filesize
      ZDR3$ = ZDR3Def$                       'filedate
      ZDR4$ = ZDR4Def$                       'main description
      ZDR5$ = ZDR5Def$                       'extended desc.
      FileName$ = "RBBS" + ZNodeID$ + ".CLR"
      CALL FindIt (FileName$)
      IF NOT ZOK THEN
         FileName$ = "RBBS-PC.CLR"
         CALL FindIt (FileName$)
      END IF
      IF ZOK THEN
         CALL OpenWork (2,FileName$)
         FOR ColorCount = 1 TO 15
            CALL ReadDir (2,1)
            FG$(ColorCount) = ZEscape$ + ZOutTxt$
         NEXT ColorCount
         FOR ColorCount = 1 TO 8
            CALL ReadDir (2,1)
            BG$(ColorCount) = ZEscape$ + ZOutTxt$
         NEXT ColorCount
         ZOutTxt$ = ""
         CLOSE 2
         ZFG1$ = FG$(1)
         ZFG2$ = FG$(2)
         ZFG3$ = FG$(3)
         ZFG4$ = FG$(4)
         ZFG5$ = FG$(5)
         ZFG6$ = FG$(6)
         ZFG7$ = FG$(7)
         ZFG8$ = FG$(8)
         ZFG9$ = FG$(9)
         ZFGA$ = FG$(10)
         ZFGB$ = FG$(11)
         ZFGC$ = FG$(12)
         ZFGD$ = FG$(13)
         ZFGE$ = FG$(14)
         ZFGF$ = FG$(15)
         ZBG0$ = BG$(1)
         ZBG1$ = BG$(2)
         ZBG2$ = BG$(3)
         ZBG3$ = BG$(4)
         ZBG4$ = BG$(5)
         ZBG5$ = BG$(6)
         ZBG6$ = BG$(7)
         ZBG7$ = BG$(8)
      ELSE
         ZFG1$ = ZEscape$ + "[0;34m"            'Blue
         ZFG2$ = ZEscape$ + "[0;32m"            'Green
         ZFG3$ = ZEscape$ + "[0;36m"            'Cyan
         ZFG4$ = ZEscape$ + "[0;31m"            'Red
         ZFG5$ = ZEscape$ + "[0;35m"            'Magenta
         ZFG6$ = ZEscape$ + "[0;33m"            'Brown
         ZFG7$ = ZEscape$ + "[0;37m"            'White
         ZFG8$ = ZEscape$ + "[1;30m"            'Grey
         ZFG9$ = ZEscape$ + "[1;34m"            'Brt Blue
         ZFGA$ = ZEscape$ + "[1;32m"            'Brt Green
         ZFGB$ = ZEscape$ + "[1;36m"            'Brt Cyan
         ZFGC$ = ZEscape$ + "[1;31m"            'Brt Red
         ZFGD$ = ZEscape$ + "[1;35m"            'Brt Magenta
         ZFGE$ = ZEscape$ + "[1;33m"            'Yellow
         ZFGF$ = ZEscape$ + "[1;37m"            'Brt White
         ZBG0$ = ZEscape$ + "[40m"              'Blk BackGround
         ZBG1$ = ZEscape$ + "[44m"              'Blue BackGround
         ZBG2$ = ZEscape$ + "[42m"              'Grn BackGround
         ZBG3$ = ZEscape$ + "[46m"              'Cyan BackGround
         ZBG4$ = ZEscape$ + "[41m"              'Red BackGround
         ZBG5$ = ZEscape$ + "[45m"              'Mag BackGround
         ZBG6$ = ZEscape$ + "[43m"              'Brn BackGround
         ZBG7$ = ZEscape$ + "[47m"              'Wht BackGround
      END IF
      END SUB
'
60000 SUB ExpiredPswd
'
      IF ZPswdChngReqTime = 0 THEN _
         EXIT SUB
      IF ZTimesLoggedOn MOD ZPswdChngReqTime <> 0 THEN _
         EXIT SUB
60010 CALL SkipLine (1)
      ZFileName$ = ZHelpPath$ + "PASSWORD" + ZHelpExtension$
      CALL BufFile (ZFileName$,WasX)
      '* "Password has expired!"
      LineNum = 805
      CRCount = 1
      GOSUB 60022
      '* "Enter a new Password"
      LineNum = 806
      GOSUB 60020
      Prompt$ = Strng$
      CALL NewPassword (Prompt$,ZTrue)
      CALL AllCaps (ZOldPassword$)
      IF ZWasZ$ = ZOldPassword$ THEN
         '* "{CRYou cannot reuse your OLD Password!"
         LineNum = 807
         CRCount = 2
         GOSUB 60022
         GOTO 60010
      END IF
      '* "Re-enter your New Password"
      LineNum = 808
      GOSUB 60020
      ZOutTxt$ = Strng$
      ZHidden = ZTrue
      ZSubParm = 1
      CALL TGet
      CALL AllCaps (ZUserIn$)
      IF ZWasZ$ <> ZUserIn$ THEN
         '* "Passwords do not match"
         LineNum = 809
         GOSUB 60020
         ZOutTxt$ = Strng$
         ZSubParm = 1
         CALL TPut
         GOTO 60010
      END IF
      '* "Expired Password! {LT"
      LineNum = 810
      CRCount = 2
      GOSUB 60024
      ZSubParm = 6
      CALL FileLock
      CALL OpenUser (HighestUserRecord)
      GET 5,ZUserFileIndex
      CALL AllCaps (ZUserIn$)
      LSET ZPswd$ = ZUserIn$
      IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
         PUT 5,ZUserFileIndex
      ZSubParm = 8
      CALL FileLock
      '* "Password Changed."
      LineNum = 811
      GOSUB 60020
      ZOutTxt$ = Strng$
      ZStopInterrupts = ZTrue
      ZSubParm = 1
      CALL TPut
      CALL SkipLine (1)
      '* "New Password {Z1"
      LineNum = 812
      CRCount = 2
      GOSUB 60024
      CALL SmartPause (ZFalse)
      EXIT SUB
60020 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
60022 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,CRCount,"")
      RETURN
60024 CALL FormatString (LineNum,ZFalse,ZTrue,CRCount,ZFalse,0,"")
      RETURN
      END SUB
'
' * ANSIMusic
'
63630 SUB SetANSIMusic
      IF ZANSIMusic AND NOT ZLocalUser THEN
         '* "[MBO3T200MBMLA64L32C64D64E64"
         CALL FormatString (813,ZFalse,ZFalse,0,ZFalse,0,ZBellRinger$)
         ZBellRinger$ = ZBellRinger$ + CHR$(14)
      ELSE
         ZBellRinger$ = CHR$(7)
      END IF
      END SUB
'
      SUB DropCarrier
'
63700 IF ZDropCarSecChng = 0 THEN _
         EXIT SUB
      IF ZDropTimes > ZDropCarSecChng THEN _
         ZDropTimes = ZDropCarSecChng - 1
      IF ZDropChange = ZFalse THEN
         ZDropTimes = ZDropTimes + 1
         '* "Dropped Carriers set to {DC"
         LineNum = 814
         CRCount = 1
         GOSUB 63710
         IF ZDropTimes MOD ZDropCarSecChng <> 0 THEN
            ZGlobalDropTimes = ZDropTimes
            ZDropChange = ZTrue
            EXIT SUB
         END IF
         ZUserSecLevel = ZUserSecLevel - ZDropIncrement
         ZSubParm = 6
         CALL FileLock
         CALL OpenUser (HighestUserRecord)
         GET 5,ZUserFileIndex
         LSET ZSecLevel$ = MKI$(ZUserSecLevel)
         IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
            PUT 5,ZUserFileIndex
         ZSubParm = 8
         CALL FileLock
         ZDropChange = ZTrue
         '* "Security reset for Dropped Carriers!"
         LineNum = 815
         CRCount = 2
         GOSUB 63710
         ZDropTimes = 0
         ZGlobalDropTimes = ZDropTimes
         ZSubParm = -1
      END IF
      EXIT SUB
63710 CALL FormatString (LineNum,ZFalse,ZTrue,CRCount,ZFalse,0,"")
      RETURN
      END SUB
'
' $SUBTITLE: 'ANSISysop5 --- ANSI driven sysop's key 5'
'
' $PAGE
'
63720 SUB ANSISysop5
'
      ZOk = ZFalse
      WasX$ = MID$(ZUserRecord$,ZStartHash,ZLenHash)
      IF ASC(WasX$) = 0 OR LEFT$(WasX$,3) = SPACE$(3) THEN _
         EXIT SUB
      WasOF = CVI(ZSecLevel$)
      IF WasOF > ZUserSecLevel THEN _
         IF NOT ZGlobalSysop THEN _
            EXIT SUB
      Sysop5Menu$ = ZWelcomeFileDrvPath$ + "SYSOP5.MNU"
      ZLinesPrinted = 0
      ZNonStop = ZTrue
      CALL GraphicDisplayFile (Sysop5Menu$)
      ZStopInterrupts = ZTrue
      TempUserOptions = CVI(MID$(ZUserOption$,9,2))
      TempExtendedUserOptions = ASC(MID$(ZUserOption$,8,1))
      ZOutTxt$ = ZSysopColor$
      IF WasOF < ZMinLogonSec THEN _
         ZOutTxt$ = ZFGE$ + ZBG4$ _
      ELSE IF WasOF >= ZSysopSecLevel THEN _
         ZOutTxt$ = ZFGF$ + ZBG1$
      Temp$ = LEFT$(ZUserName$,24)
      CALL Trim (Temp$)
      CALL ANSIPut (2,20)
      CALL QuickTPut (ZOutTxt$ + Temp$ + ZSysopColor$,0) 'name
      Temp$ = RIGHT$(SPACE$(5) + STR$(LOC(5)),4)
      CALL Trim (Temp$)
      CALL ANSIPut (2,71)
      CALL QuickTPut (Temp$,0)                             ' Record #
      CALL ANSIPut (3,20)
      CALL QuickTPut (ZCityState$,0)                       ' City/State
      Temp$ = RIGHT$(SPACE$(6) + STR$(WasOF),6)
      CALL Trim (Temp$)
      CALL ANSIPut (4,20)
      CALL QuickTPut (Temp$,0)                             ' Security Level
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 1) > 0))
      CALL ANSIPut (4,71)
      CALL QuickTPut (Temp$,0)        'ZReadNewMail
      CALL ANSIPut (5,20)
      CALL QuickTPut (ZPswd$,0)                            ' Password
      Temp$ = STR$(CVI(MID$(ZUserOption$,3,2)))
      CALL Trim (Temp$)
      CALL ANSIPut (5,71)
      CALL QuickTPut (Temp$,0)        ' Highest Msg #
      IF ZRestrictByDate THEN _
         CALL SetRegDisplay : _
         CALL ANSIPut (6,20) : _
         CALL QuickTPut (ZRegDisplayDate$,0)               ' Subscription date
      Temp$ = FNYesNo$(-((TempUserOptions AND 512) > 0))
      CALL ANSIPut (6,71)
      CALL QuickTPut (Temp$,0)        ' Mail Waiting
      CALL UnPackDIRDate (ZListNewDate$, Temp$, CHR$(45))
      CALL ANSIPut (7,20)
      CALL QuickTPut (Temp$,0)        ' Last DIR Date
      Temp$ = MID$(ZUserOption$,5,1)
      IF Temp$ = SPACE$(1) THEN Temp$ = CHR$(78)
      CALL ANSIPut (7,71)
      CALL QuickTPut (Temp$,0)        'ZUserXferDefault$ -  Protocol
      CALL ANSIPut (8,20)
      CALL QuickTPut (ZLastDateTimeOn$,0)                  ' Last date on
      Temp$ = FNYesNo$(-((TempUserOptions AND 64) > 0))
      CALL ANSIPut (8,71)
      CALL QuickTPut (Temp$,0)                ' Skip New Files
      Temp$ = RIGHT$(SPACE$(5) + STR$(CVI(MID$(ZUserOption$,1,2))),5)
      CALL Trim (Temp$)
      CALL ANSIPut (9,20)
      CALL QuickTPut (Temp$,0)                             ' Times on
      Temp$ = FNYesNo$(-((TempUserOptions AND 4096) > 0))
      CALL ANSIPut (9,71)
      CALL QuickTPut (Temp$,0)        'ZFileWaiting - Per. Upld
      Temp$ = STR$(CVI(ZElapsedTime$))
      CALL Trim (Temp$)
      CALL ANSIPut (10,20)
      CALL QuickTPut (Temp$,0)                            ' Time used
      Temp$ = FNYesNo$(-((TempUserOptions AND 32) > 0))
      CALL ANSIPut (10,71)
      CALL QuickTPut (Temp$,0)                  ' Check New Bulls
      Temp$ = RIGHT$(SPACE$(5) + STR$(ASC(ZBankTime$)),5)
      CALL Trim (Temp$)
      CALL ANSIPut (11,20)
      CALL QuickTPut (Temp$,0)                          ' Banked Time
      Temp$ = FNYesNo$(-((TempUserOptions AND 2) > 0))
      CALL ANSIPut (11,71)
      CALL QuickTPut (Temp$,0)        'ZExpertUser - Expert
      Temp$ = RIGHT$(SPACE$(5) + STR$(CVI(ZUserDnlds$)),5)
      CALL Trim (Temp$)
      CALL ANSIPut (12,20)
      CALL QuickTPut (Temp$,0)                       ' Total Files DL
      Temp$ = FNYesNo$(-((TempUserOptions AND 1) > 0))
      CALL ANSIPut (12,71)
      CALL QuickTPut (Temp$,0)        'ZPromptBell - Prompt Bell
      Temp$ = RIGHT$(SPACE$(5) + STR$(CVI(ZUserUplds$)),5)
      CALL Trim (Temp$)
      CALL ANSIPut (13,20)
      CALL QuickTPut (Temp$,0)                       ' Total Files UL
      Temp$ = FNYesNo$(-((TempUserOptions AND 4) > 0))
      CALL ANSIPut (13,71)
      CALL QuickTPut (Temp$,0)        'ZNulls - Nulls
      Temp$ = STR$(CVS(ZDlBytes$))
      CALL Trim (Temp$)
      CALL ANSIPut (14,20)
      CALL QuickTPut (Temp$,0)                             ' Total Bytes DL
      Temp$ = FNYesNo$(-((TempUserOptions AND 8) > 0))
      CALL ANSIPut (14,71)
      CALL QuickTPut (Temp$,0)        'ZUpperCase - Upper Case
      Temp$ = STR$(CVS(ZULBytes$))
      CALL Trim (Temp$)
      CALL ANSIPut (15,20)
      CALL QuickTPut (Temp$,0)                       ' Total Bytes UL
      Temp$ = FNYesNo$(-((TempUserOptions AND 16) > 0))
      CALL ANSIPut (15,71)
      CALL QuickTPut (Temp$,0)        'ZLineFeeds Line Feeds
      Temp$ = STR$(CVS(ZTodayDl$))
      CALL Trim (Temp$)
      CALL ANSIPut (16,20)
      CALL QuickTPut (Temp$,0)                      ' Todays DL Files
      Temp$ = FNYesNo$(-((TempUserOptions AND 2048) > 0))
      CALL ANSIPut (16,71)
      CALL QuickTPut (Temp$,0)        'ZTurboKeyUser - TurboKey
      Temp$ = STR$(CVS(ZTodayBytes$))
      CALL Trim (Temp$)
      CALL ANSIPut (17,20)
      CALL QuickTPut (Temp$,0)                      ' Todays DL Bytes
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 16) > 0))
      CALL AnsiPut (17,71)
      CALL QuickTPut (Temp$,0)        'ZANSIMusic
      Temp$ = FNYesNo$(-((TempUserOptions AND 256) > 0))
      CALL ANSIPut (18,20)
      CALL QuickTPut (Temp$,0)  'ZReqQuesAnswered - Ans. Questionaire
      WasX = ASC(MID$(ZUserOption$,6,1))
      TempZBoldText$ = FNYesNo$(VAL(CHR$(48 - (WasX > 64))))
      Temp$ = STR$(WasX)
      CALL Trim (Temp$)
      CALL ANSIPut (18,45)
      CALL QuickTPut (Temp$,0)        'color number
      Temp$ = FNYesNo$(-(((NOT TempExtendedUserOptions) AND 4) > 0))
      CALL ANSIPut (18,71)
      CALL QuickTPut (Temp$,0)        'ZMorePromptLF
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 2) > 0))
      CALL ANSIPut (19,20)
      CALL QuickTPut (Temp$,0)        'ZReselectAll
      Temp$ = FNYesNo$(-((TempUserOptions AND 1024) > 0))
      CALL ANSIPut (19,45)
      CALL QuickTPut (Temp$,0)        'Highlighting
      CALL ANSIPut (19,71)
      CALL QuickTPut (MID$(ZUserOption$,14),0) 'Echo Preference
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 8) > 0))
      CALL AnsiPut (20,20)
      CALL QuickTPut (Temp$,0)        'ZReselectGraphics
      Temp$ = FNYesNo$(-((TempUserOptions AND 128) > 0))
      CALL ANSIPut (20,45)
      CALL QuickTPut (Temp$,0)        'FullScreenEditor - ANSIEd
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 32) > 0))
      CALL AnsiPut (20,71)
      CALL QuickTPut (Temp$,0)        'ZNeverCanPage
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 64) > 0))
      CALL ANSIPut (21,20)
      CALL QuickTPut (temp$,0)        'ZReselectProto
      Temp$ = STR$(ASC(MID$(ZUserOption$,13,1)))
      CALL Trim (Temp$)
      CALL ANSIPut (21,45)
      CALL QuickTPut (Temp$,0)        ' Page Length
      Temp$ = FNYesNo$(-((TempUserOptions AND 16384) > 0))
      CALL ANSIPut (21,71)
      CALL QuickTPut (Temp$,0)        ' Extended Off
      Temp$ = STR$(ASC(ZDropTimes$))
      CALL Trim (Temp$)
      CALL ANSIPut(22,20)
      CALL QuickTPut (Temp$,0)        ' Carrier Drops
      Temp$ = STR$(ASC(MID$(ZUserOption$,7,1)))
      CALL Trim (Temp$)
      CALL ANSIPut (22,45)
      CALL QuickTPut (Temp$,0)        ' Right Margin
      Temp$ = FNYesNo$(-((TempExtendedUserOptions AND 128) > 0))
      CALL ANSIPut (22,71)
      CALL QuickTPut (Temp$,0)        'Twit
      CALL ANSIPut (24,1)
      CALL QuickTPut (ZEmphasizeOff$,0)
      ZOk = ZTrue
      END SUB
'
63730 SUB ANSIPut (ANSIRow,ANSICol)
'
      CALL QuickTPut (CHR$(27) + CHR$(91) + MID$(STR$(ANSIRow),2) + CHR$(59) + _
           MID$(STR$(ANSICol),2) + CHR$(72),0)
      END SUB
'
63740 SUB UploadMessage
'
      IF ZSysop THEN _
         EXIT SUB
      CALL BreakFileName (ZMainMsgFile$,Drive$,FileName$,ZWasY$,ZFalse)
      IF RIGHT$(FileName$,1) = CHR$(77) THEN _
         FileName$ = LEFT$(FileName$,LEN(FileName$)-1)
      ZFileName$ = ZHelpPath$ + FileName$ + "U" + ZHelpExtension$
      CALL Findit(ZFileName$)
      IF ZOK THEN _
         GOTO 63742
      ZFileName$ = ZHelpPath$ + "UPMSG" + ZHelpExtension$
63742 CALL GraphicDisplayFile (ZFileName$)
      END SUB
'
' * Reset Graphics if RIP active
'
63750 SUB ResetGraphics
      IF ZWasGR = 4 THEN
         CALL PutCom (ZRIPGraphicsReset$)
      END IF
      END SUB
'
' * New Mail Waiting
'
63760 SUB MailWait
      IF ZMailWaiting THEN
         ZFileName$ = ZHelpPath$ + "MAIL" + ZHelpExtension$
         CALL GraphicDisplayFile (ZFileName$)
         IF NOT ZOK THEN
            '* "{CR{CF{G1You have new Mail!{C0"
            CALL FormatString (816,ZFalse,ZFalse,0,ZTrue,2+ZTurboLogon,"")
         END IF
      END IF
      END SUB
'
' * SingleNodeDoorCheck - checks to see if single node door is in
' * use by another node
'
' * Returns ZOK = ZTrue if door not in use
'
63770 SUB SingleNodeDoorCheck (DoorName$)
      DoorNodeFile$ = "RBBSDOOR.DEF"
      CALL FindFile (DoorNodeFile$,ZOK)
      IF NOT ZOK THEN
         CALL MakeDoorNodeFile (DoorNodeFile$)
      END IF
      CALL OpenRSeq (19,DoorNodeFile$,HighRec,WasX,16)
      FIELD 19, 16 AS DoorInUse$
      FOR Index = 1 TO ZMaxNodes
         GET 19, Index
         IF DoorInUse$ = DoorName$ + SPACE$(16-LEN(DoorName$)) THEN
            ZOK = ZFalse
            CLOSE 19
            EXIT SUB
         END IF
      NEXT Index
      LSET DoorInUse$ = DoorName$
      PUT 19, ZNodeRecIndex - 1
      CLOSE 19
      ZOK = ZTrue
      END SUB
'
' * SingleNodeDoorClear - clears a single node door for use
'
63780 SUB SingleNodeDoorClear
      DoorNodeFile$ = "RBBSDOOR.DEF"
      CALL FindFile (DoorNodeFile$,ZOK)
      IF NOT ZOK THEN
         CALL MakeDoorNodeFile (DoorNodeFile$)
      END IF
      CALL OpenRSeq (19,DoorNodeFile$,HighRec,WasX,16)
      FIELD 19, 16 AS DoorInUse$
      LSET DoorInUse$ = SPACE$(16)
      PUT 19, ZNodeRecIndex - 1
      CLOSE 19
      END SUB
'
' * MakeDoorNodeFile - creates RBBSDOOR.DEF
'
63790 SUB MakeDoorNodeFile (DoorNodeFile$)
      CALL OpenRSeq (19,DoorNodeFile$,HighRec,WasX,16)
      FIELD 19, 16 AS Blank$
      LSET Blank$ = SPACE$(16)
      FOR Index = 1 TO ZMaxNodes
         PUT 19, Index
      NEXT Index
      CLOSE 19
      END SUB
'
' * GraphicDisplayFile - sets graphic file and displays
'
63800 SUB GraphicDisplayFile (FileName$)
      CALL Graphic (FileName$)
      CALL BufFile (FileName$,WasX)
      END SUB

'
' * FormatString - reads RBBS-PC.LNG file and formats/displays text
'
63810 SUB FormatString (LineNumber,ToPrint,ToCallers, _
                        CallersIdx,ToRemote,Returns,ReadBack$)
      CALL OpenRSeq (21,ZLanguageFile$,HighRec,WasX,130)
      IF LineNumber > HighRec THEN
         PRINT "Line <";LineNumber;"> exceeds <";HighRec;"> lines"
         PRINT "In RBBS language file ";ZLanguageFile$
         CALL DelayTime (1)
         GOTO 63812
      END IF
      FIELD 21, 128 AS ReadBack$, _
                  2 AS CRLf$
      GET 21, LineNumber
      IF LEN(ReadBack$) <> 128 THEN
         PRINT "Line <";LineNumber;"> not within width per line of 128 characters!"
         PRINT "In RBBS Language file ";ZLanguageFile$
         CALL DelayTime (1)
         GOTO 63812
      END IF
      IF LEFT$(ReadBack$,3)="{*F" THEN
         ReadBack$ = MID$(ReadBack$,4)
         CALL GraphicDisplayFile (LEFT$(ReadBack$,INSTR(ReadBack$+" "," ")-1))
         ReadBack$ = MID$(ReadBack$+"  ",INSTR(ReadBack$+" "," ")+1)
      END IF
      CALL Trim (ReadBack$)
      CALL SmartText (ReadBack$,ZTrue,ZFalse,ZFalse)
      IF ToPrint THEN
         CALL PScrn (ReadBack$)
      END IF
      IF ToCallers THEN
         CALL UpdtCalr (ReadBack$,CallersIdx)
      END IF
      IF ToRemote THEN
         CALL QuickTPut (ReadBack$,Returns)
      END IF
63812 CLOSE 21
      END SUB
