'  $INCLUDE: 'RBBS-VAR.MOD'
'  $segment
'  $linesize:132
'  $title: 'SYSOP8.BAS 17.4'
'
'  Copyright (c) 1993 Daniel T. Drinnon
'
'  $SUBTITLE: 'Sysop8 -- PERSONAL/FMS/FFS/RFM OnLine File Maintenance'
'
'  SUBROUTINE NAME    -- SYSOP8
'
'  INPUT PARAMETERS   -- None
'
'  OUTPUT PARAMETERS  -- None
'
'  SUBROUTINE PURPOSE -- Manipulation of the FMS/FFS/Personal Files Systems
'
100 SUB Sysop8 STATIC
'
' =============================================================================
' * Error Handling
' =============================================================================
'
    ON ERROR GOTO 12000
'
' =============================================================================
' * Return from Extended Description on ADD Action
' =============================================================================
'
    IF ZGetExtDesc THEN
       ZMaxMsgLines = ZMaxMsgLinesDef
       ZRightMargin = WasLL
       CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZMaxExtendedLines,3)
       ZGetExtDesc = ZFalse
    END IF
'
' =============================================================================
' * Main entry prompt
' =============================================================================
'
    IF ZExpertUser THEN _
       GOTO 110
101 CALL GraphicDisplayFile (ZWelcomeFileDrvPath$ + "SYSOP8.MNU")
110 CALL Line25
    '* "{CRA)dd, D)elete, E)dit, F)ind, L)ist, M)ove, V)iew, H)elp, [Q]uit"
    LineNum = 893
    GOSUB 11210
    '* "ADEFLVMHQ"
    LineNum = 894
    GOSUB 11200
    DO
       GOSUB 11100
    LOOP UNTIL ZWasQ = 0 OR INSTR(Strng$,ZWasZ$) <> 0
    IF ZWasQ = 0 OR ZWasZ$ = "Q" THEN
       ZFileSysParm = 0
       EXIT SUB
    END IF
    WasX = INSTR(Strng$,ZWasZ$)
    ON WasX GOSUB 200,300,400,500,550,800,600,101
    GOTO 110
'
' * ===========================================================================
' * Add a file to the FMS, Upload, or Personal Areas
' * ===========================================================================
'
200 '* "ADD"
    LineNum = 1087
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700
205 '* "{CBEnter {CASOURCE {CBPath/Filename of new file to ADD{C0{EX"
    LineNum = 895
    GOSUB 11210
'
' * Get Source File Name
'
    GOSUB 11000
    IF ZWasQ = 0 THEN
       RETURN
    END IF
'
' * Check for wildcards
'
206 IF INSTR(ZUserIn$(ZAnsIndex),"*") > 0 THEN
       CALL CmdStackPushPop (1)
       GOSUB 555
       CALL CmdStackPushPop (2)
       REDIM WildList$(100)
       MatchCount = 1
       MatchFile$ = ""
       FILESPEC$ = UCASE$(ZUserIn$(ZAnsIndex))
       CALL BreakFileName (FILESPEC$,WildDrive$, _
                         WildBody$,WildExt$,ZTrue)
       MatchFile$ = GetFirstMatchingFile$(FILESPEC$)
       IF MatchFile$ <> "" THEN
          WildList$(MatchCount) = WildDrive$ + MatchFile$
          MatchFile$ = GetNextMatchingFile$
          DO WHILE MatchFile$ <> ""
             MatchCount = MatchCount + 1
             IF MatchCount > 100 THEN
                '* "{CE{G4Too Many Matches!{C0"
                LineNum = 896
                CRCount = 1
                GOSUB 11220
                EXIT DO
             END IF
             WildList$(MatchCount) = WildDrive$ + MatchFile$
             MatchFile$ = GetNextMatchingFile$
          LOOP
       ELSE
          GOTO 205
       END IF
       FOR wildcount = 1 TO MatchCount
          SourceFileName$ = WildList$(wildcount)
          GOSUB 8002
          GOSUB 210
          IF ZAbort THEN
             ZWasQ = 0
             ZAnsIndex = 0
             REDIM WildList$(0)
             RETURN
          END IF
       NEXT wildcount
       REDIM WildList$(0)
       GOTO 220
    ELSE
       GOSUB 8001
    END IF
'
' * nothing to do check
'
    IF NOT ZOK THEN _
       GOTO 205
    IF ZWasQ = 0 THEN _
       RETURN
'
' * option to change target filename
'
210 TargetFileName$ = SourceBody$ + SourceExt$
    '* "{CBEnter {CATARGET {CBfilename: {C0["
    LineNum = 897
    GOSUB 11200
    Strng1$ = Strng$
    '* "]{C0"
    LineNum = 898
    GOSUB 11200
    Strng2$ = Strng$
    ZOutTxt$ = Strng1$ + TargetFileName$ + Strng$
    GOSUB 11000
    IF ZWasQ <> 0 THEN
       TargetFileName$ = UCASE$(ZUserIn$(ZAnsIndex))
    END IF
'
' * Allow for Personal Uploads
'
    '* "ALL"
    LineNum = 450
    GOSUB 11200
    ALLStr$ = Strng$
    IF ZUserSecLevel >= ZMinSecPersUpld THEN
       WhoTo$ = ""
       ZFileSysParm = 7
       CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue)
    ELSE
       WhoTo$ = ALLStr$
    END IF
    TargetDir$ = ""
'
' * Setup to select target subdirectory
'
    IF WhoTo$ = ALLStr$ THEN
       InPers = ZFalse
       GOSUB 2000
    ELSE
        InPers = ZTrue
        InFMS = ZFalse
        TargetDir$ = ZPersonalDrvPath$
        GOSUB 5000
    END IF
    IF ZAnsIndex = 0 THEN
       ZWasQ = 0
       ZWasZ$ = ""
       RETURN
    END IF
'
' * Make sure copy was successful
'
    CALL FindIt (TargetDir$ + TargetFileName$)
    IF NOT ZOK THEN
       '* "{CF{C4ERROR! "
       LineNum = 899
       GOSUB 11200
       Strng1$ = Strng$
       '* "{SPnot found after COPY!{C0"
       LineNum = 900
       GOSUB 11200
       Strng2$ = Strng$
       CALL QuickTPut1 (Strng1$ + TargetFileName$ + Strng2$)
       GOTO 205
    END IF
'
' * option to delete original file
'
    GOSUB 3000
'
' * get description for directory listing
'
    GOSUB 4000
'
' * if aborted, then delete the copied file
'
    IF ZAbort THEN
       CALL KillWork (TargetDir$ + TargetFileName$)
       GOTO 205
    END IF
'
' * log it to the Caller's Log
'
    '* "Added{SP"
    LineNum = 901
    GOSUB 11200
    Strng1$ = Strng$
    '* "{SPto File System"
    LineNum = 902
    GOSUB 11200
    Strng2$ = Strng$
    CALL UpdtCalr (Strng1$ + TargetFileName$ + Strng2$,2)
'
' * set filename for FIDX
'
    ZFileName$ = TargetFileName$
'
' * if file was in FIDX/LIDX, then update the FIDX file
'
215 GOSUB 6000
' *
' * All Done
' *
220 RETURN
'
' * ===========================================================================
' * Delete an entry from the Upload, FMS, or Personal Areas
' * ===========================================================================
'
300 '* "DELETE"
    LineNum = 1088
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700
    WasA1$ = ZActiveMessageFile$
    ZActiveMessageFile$ = ZOrigMsgFile$
    CALL OpenMsg
    FIELD 1, 128 AS ZMsgRec$
    GET 1,1
    NumNodes = VAL(MID$(ZMsgRec$,127))
    FOR NodeIndex = 2 TO NumNodes + 1
       GET 1,NodeIndex
       IF MID$(ZMsgRec$,55,2) <> "-1" THEN
          CALL SaveUserActivity(WhatTheyDoin$,Nodeindex,ZTrue)
          IF WhatTheyDoin$ = CHR$(70) AND _
             MID$(ZMsgRec$,57,1) = CHR$(65) AND _
             VAL(ZNodeID$) <> NodeIndex - 1 THEN
             '* "{CR{CF{G4WARNING! Node"
             LineNum = 903
             GOSUB 11200
             Strng1$ = Strng$
             '* "{SPis using the File System!{C0"
             LineNum = 904
             GOSUB 11200
             Strng2$ = Strng$
             CALL QuickTPut (Strng1$ + STR$(NodeIndex-1) + Strng2$,2)
             EXIT FOR
          END IF
       END IF
    NEXT NodeIndex
    ZActiveMessageFile$ = WasA1$
305 '* "{CBEnter Filename to {CADELETE{C0{EX"
    LineNum = 905
    GOSUB 11210
'
' * Get SourceFileName$
'
    GOSUB 8000

    IF ZWasQ = 0 THEN _
       RETURN
'
' *  if couldn't find file to delete, ask to remove it from file list
'
    CALL FindIt (SourceFileName$)
    IF NOT ZOK THEN
       DO
          '* "{CBRemove Entry from File List?{C0 (Y,[N])"
          LineNum = 906
          GOSUB 11210
          GOSUB 11100
       LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
       IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
          GOTO 305
       ELSE
          GOSUB 1000
          GOTO 310
       END IF
    END IF

    IF ZWasQ = 0 THEN
       RETURN
    END IF
'
' * find out if file to delete is in the Personal Files
'
    GOSUB 1000
'
' * delete it
'
    GOSUB 3000
'
' * if the file was not deleted then go no further
'
    CALL FindIt (SourceFileName$)
    IF ZOK OR ZWasQ = 0 OR ZWasZ$ = "N" THEN
       GOTO 305
    END IF
'
' * remove the entry from the respective file system (private/FMS)
'
310 IF InPers THEN
       GOSUB 7000
       GOTO 320
    END IF
    IF ZFastFileSearch THEN
       InFMS = ZTrue
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)
       ZFileName$ = SourceBody$ + SourceExt$
       GOSUB 6000
       GOSUB 7000
    END IF
'
' * option to add entry to offline file list
'
320 CALL BreakFileName (SourceFileName$, Drive$, Body$, Ext$, ZTrue)
    DelFileName$ = Body$ + Ext$
    '* "{CBAdd {C2"
    LineNum = 907
    GOSUB 11200
    Strng1$ = Strng$
    '* "{CB to {C2OFFLINE {CBlist?{C0 (Y,[N])"
    LineNum = 908
    GOSUB 11200
    Strng2$ = Strng$
    DO
       ZOutTxt$ = Strng1$ + DelFileName$ + Strng2$
       GOSUB 11100
    LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
    IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
       GOTO 330
    ELSE
       CALL FindFile (ZDirPath$ + "OFFLINE.DEF",ZOK)
       IF ZOK THEN
          '* "{CBAdd {C2"
          LineNum = 907
          GOSUB 11200
          Strng1$ = Strng$
          '* "{CB to {C2"
          LineNum = 927
          GOSUB 11200
          Strng2$ = Strng$
          '* "OFFLINE.DEF{C0 ([Y],N)"
          LineNum = 959
          GOSUB 11200
          Strng3$ = Strng$
          DO
             ZOutTxt$ = Strng1$ + DelFileName$ + Strng2$ + ZDirPath$ + Strng3$
             GOSUB 11100
          LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
          IF ZWasQ = 0 OR ZWasZ$ = "Y" THEN
             OfflineFileName$ = ZDirPath$ + "OFFLINE.DEF"
             GOTO 322
          END IF
       END IF
       '* "{CBEnter Filename of {CAOFFLINE List{C0{EX"
       LineNum = 909
       GOSUB 11210
       GOSUB 11000
       IF ZWasQ = 0 THEN
          GOTO 330
       END IF
       OfflineFileName$ = UCASE$(ZUserIn$(ZAnsIndex))
       CALL FindIt (OfflineFileName$)
       IF NOT ZOK THEN
          '* "{CE{Z1 does not exist! Create?{C0 (Y,[N])"
          LineNum = 910
          GOSUB 11210
          GOSUB 11100
          IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
             GOTO 320
          END IF
       END IF
322    CALL OpenWorkA (2,OfflineFileName$)
       CALL PrintWorkA (2, DelFileName$)
       CLOSE 2
    END IF
'
' * log it to the Caller's Log
'
330 '* "Deleted{SP"
    LineNum = 911
    GOSUB 11200
    Strng1$ = Strng$
    '* "{SPfrom File System"
    LineNum = 912
    GOSUB 11200
    Strng2$ = Strng$
    CALL UpdtCalr (Strng1$ + SourceFileName$ + Strng2$,2)
'
' All done
'
    RETURN
'
' * ===========================================================================
' * Edit an entry in the Upload, FMS, or Personal Areas
' * ===========================================================================
'
400 '* "EDIT"
    LineNum = 1089
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700
    RETURN
'
' * ===========================================================================
' * Find an entry in the Upload, FMS, or Personal Areas
' * ===========================================================================
'
500 '* "FIND"
    LineNum = 1090
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

    '* "{CBEnter Filename to {CAFIND{C0{EX"
    LineNum = 913
    GOSUB 11210
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN
'
' * give location
'
    IF ZOK THEN
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)
       '* "{CB"
       LineNum = 914
       GOSUB 11200
       Strng1$ = Strng$
       '* "{C2 is located in {CB"
       LineNum = 915
       GOSUB 11200
       Strng2$ = Strng$
       CALL QuickTPut1 (Strng1$ + SourceBody$ + SourceExt$ + _
                        Strng2$ + SourceDrive$ + ZEmphasizeOff$)
       RETURN
    END IF
'
' All done
'
    RETURN
'
' * ===========================================================================
' * List a filespec
' * ===========================================================================
'
550 '* "LIST"
    LineNum = 1091
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

    '* "{CBEnter Filespec to {CALIST{C0{EX"
    LineNum = 916
    GOSUB 11210
'
' * get filespec to list
'
    GOSUB 11000
    IF ZWasQ = 0 THEN
       RETURN
    END IF

555 FILESPEC$ = UCASE$(ZUserIn$(ZAnsIndex))
    MatchFile$ = GetFirstMatchingFile$(FILESPEC$)
    IF MatchFile$ <> "" THEN
       filecount = 0
       '* "{CEDirectory of {CA"
       LineNum = 917
       GOSUB 11200
       CALL QuickTPut1 (Strng$ + FILESPEC$ + ZEmphasizeOff$)
       CALL QuickTPut (MatchFile$ + SPACE$(15 - LEN(MatchFile$)),0)
       MatchFile$ = GetNextMatchingFile$
       DO WHILE MatchFile$ <> ""
          filecount = filecount + 1
          IF filecount MOD 5 = 0 THEN
             CALL SkipLine (1)
             CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
             filecount = 0
          END IF
          CALL QuickTPut (MatchFile$ + SPACE$(15 - LEN(MatchFile$)),0)
          MatchFile$ = GetNextMatchingFile$
       LOOP
       CALL SkipLine (2)
    ELSE
       '* "{CF{G4ERROR! Could not find any matches to{SP"
       LineNum = 918
       GOSUB 11200
       CALL QuickTPut1 (Strng$ + FILESPEC$ + ZEmphasizeOff$)
    END IF
'
'
' All done
'
    RETURN
'
' * ===========================================================================
' * Move an entry from/to the Upload, FMS, or Personal Areas
' * ===========================================================================
'
600 '* "MOVE"
    LineNum = 1092
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

605 '* "{CBEnter Filename to MOVE{C0{EX"
    LineNum = 919
    GOSUB 11210
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN

    IF ZOK THEN
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)

       TargetFileName$ = SourceFileName$
       CALL BreakFileName (TargetFileName$,TargetDir$, _
                           TargetBody$,TargetExt$,ZTrue)
       TargetFileName$ = TargetBody$ + TargetExt$
    END IF
'
' * Allow for Personal Uploads
'
    '* "ALL"
    LineNum = 450
    GOSUB 11200
    ALLStr$ = Strng$
    IF ZUserSecLevel >= ZMinSecPersUpld THEN
       WhoTo$ = ""
       CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue)
    ELSE
       WhoTo$ = ALLStr$
    END IF
    TargetDir$ = ""
'
' * Setup to select target subdirectory
'
    IF WhoTo$ = ALLStr$ THEN
       InPers = ZFalse
       GOSUB 2000
    ELSE
        InPers = ZTrue
        InFMS = ZFalse
        TargetDir$ = ZPersonalDrvPath$
        GOSUB 5000
    END IF
    IF ZAnsIndex = 0 THEN
       ZWasQ = 0
       ZWasZ$ = ""
       RETURN
    END IF
'
' * Make sure copy was successful
'
    CALL FindIt (TargetDir$ + TargetFileName$)
    IF NOT ZOK THEN
       '* "{CF{G4ERROR!{SP"
       LineNum = 920
       GOSUB 11200
       Strng1$ = Strng$
       '* "{SPnot found after COPY!{C0"
       LineNum = 921
       GOSUB 11200
       Strng2$ = Strng$
       CALL QuickTPut1 (Strng1$ + TargetFileName$ + Strng2$)
       GOTO 605
    END IF
'
' * delete the original
'

GOSUB 3000
'    CALL KillWork (SourceFileName$)

'
' * set filename for FIDX
'
    ZFileName$ = TargetFileName$
'
' * if file was in FIDX/LIDX, then update the FIDX file
'
    GOSUB 6000
' *
' * All Done
' *
    RETURN
'
' * ===========================================================================
' * Build and display an Action prompt
' * ===========================================================================
'
700 '* "{CR{CE"
    LineNum = 922
    GOSUB 11200
    Strng1$ = Strng$
    '* "{SPan FMS Entry{C0"
    LineNum = 923
    GOSUB 11200
    Strng2$ = Strng$
    CALL QuickTPut1 (Strng1$ + Action$ + Strng2$)
    RETURN
'
' * ===========================================================================
' * View any file
' * ===========================================================================
'
800 '* "VIEW"
    LineNum = 1093
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

    '* "{CBEnter Filename to {CAVIEW{C0{EX"
    LineNum = 924
    GOSUB 11210
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN
'
' * view file
'
    ZFileName$ = SourceFileName$
    CALL FindFIle (ZFileName$,ZOK)
    IF ZOK THEN
       CALL GetArc (ZTrue)
    END IF
'
' All done
'
    RETURN
'
' =============================================================================
' * determine if the file is in Personals or FMS
' =============================================================================
'
1000 CALL WordInFile (ZPersonalDir$,SourceBody$ + SourceExt$,ZOK,ZFalse)
     IF ZOK THEN
        InFMS = ZFalse
        InPers = ZTrue
     ELSE
        InFMS = ZTrue
        InPers = ZFalse
     END IF
     RETURN
'
' =============================================================================
' * Pick Subdirectory to copy file to.  Look in subdirectories listed
' * in CONFIG first.  If FIDX/LIDX is used, use them too.
' *
' * Check the directories listed in CONFIG
' * The FIRST Subdirectory ZSubDir$(1) is always the UPLOAD sub
' * any other subdirectories listed in CONFIG should
' * not be in the FFS
' =============================================================================
'
2000 '* "{CB"
     LineNum = 925
     GOSUB 11200
     Strng1$ = Strng$
     '* "{SP{C2"
     LineNum = 926
     GOSUB 11200
     Strng2$ = Strng$
     '* "{CB to {C2"
     LineNum = 927
     GOSUB 11200
     Strng3$ = Strng$
     '* "{C0 (Y)es,[N]o,A)bort)"
     LineNum = 928
     GOSUB 11200
     Strng4$ = Strng$
     FOR WasX = 1 TO ZSubDirCount - 1
        DO
           ZOutTxt$ = Strng1$ + Action$ + Strng2$ + SourceFileName$ + _
                      Strng3$ + ZSubDir$(WasX) + Strng4$
           GOSUB 11100
        LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
        IF ZWasZ$ = "A" THEN
           ZAbort = ZTrue
           ZAnsIndex = 0
           RETURN
        END IF
        IF ZWasZ$ = "Y" THEN
           InPers = ZFalse
           InFMS = ZFalse
           TargetDir$ = ZSubDir$(WasX)
           CALL BreakFileName (ZFMSDirectory$,TDirPath$, _
                               TMainFMSDir$,TMainDirExtension$,ZFalse)
           GOSUB 5000
           RETURN
        END IF
     NEXT WasX
' *
' * Search through the FIDX
' * Look for the FIDX.LST first
' *
     IF ZFastFileSearch THEN
        TFastFileLocator$ = ZFastFileLocator$
        CALL BreakFileName (ZFastFileList$,Drive$,Body$,Ext$,ZTrue)
        CALL FindIt (Drive$ + "SYSOP8.CFG")
        IF ZOK THEN
           CALL OpenWork (7, Drive$ + "SYSOP8.CFG")
        END IF
        LineToRead = 1
        IF ZOK THEN
           IF ZErrCode <> 0 THEN
              GOSUB 2010
              CLOSE 7
              GOTO 2020
           END IF
2005       CALL ReadParmsX (7,ZOutTxt$(),4,LineToRead)
           IF ZErrCode <> 0 AND ZOutTxt$(2) = "" THEN
              CLOSE 7
              GOTO 2020
           END IF
           TFastFileList$ = UCASE$(ZOutTxt$(1))
           TFastFileLocator$ = UCASE$(ZOutTxt$(2))
           CALL BreakFileName (UCASE$(ZOutTxt$(3)),TDirPath$,TMainFMSDir$, _
                              TMainDirExtension$,ZFalse)
           TMaxDescLen = VAL(ZOutTxt$(4))
           GOSUB 2010
           IF ZWasZ$ = "Y" THEN
              InPers = ZFalse
              InFMS = ZTrue
              CLOSE 7
              GOTO 2020
           END IF
           LineToRead = LineToRead + 1
           ZOutTxt$(2) = ""
           GOTO 2005
        ELSE
           GOSUB 2010
           CLOSE 7
           GOTO 2020
        END IF
2010    CALL OpenRSeq (2,TFastFileLocator$,HighRec,WasX,66)
        FIELD 2, 66 AS Location$
        FOR WasX = 1 TO HighRec
           GET 2, WasX
           SelectLocation$ = LEFT$(Location$,63)
           CALL Trim (SelectLocation$)
           FOR WasL = 1 TO ZSubDirCount - 1
              Found = ZFalse
              CALL BreakFileName (SelectLocation$,SDrive$,Body$,Ext$,ZFalse)
              CALL BreakFileName (ZSubDir$(WasL),RDrive$,Body$,Ext$,ZFalse)
              IF SDrive$ = RDrive$ THEN
                 Found = ZTrue
                 EXIT FOR
              END IF
           NEXT WasL
           IF LEFT$(SelectLocation$,2) <> "M!" AND NOT Found THEN
              '* "{CB"
              LineNum = 925
              GOSUB 11200
              Strng1$ = Strng$
              '* "{SP{C2"
              LineNum = 926
              GOSUB 11200
              Strng2$ = Strng$
              '* "{CB to {C2"
              LineNum = 927
              GOSUB 11200
              Strng3$ = Strng$
              '* "{C0 (Y)es,[N]o,A)bort)"
              LineNum = 928
              GOSUB 11200
              Strng4$ = Strng$
              DO
                 ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                            SourceFileName$ + _
                            Strng3$ + SelectLocation$ + Strng4$
                 GOSUB 11100
              LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
              IF ZWasZ$ = "A" THEN
                 ZAnsIndex = 0
                 RETURN
              END IF
              IF ZWasZ$ = "Y" THEN
                 InPers = ZFalse
                 InFMS = ZTrue
                 LidxPos = WasX
                 TargetDir$ = SelectLocation$
                 CLOSE 2
                 CLOSE 7
                 GOSUB 5000
                 RETURN
              END IF
           END IF
        NEXT WasX
        CLOSE 2
        RETURN
     END IF
2020 IF TargetDir$ = "" THEN _
        GOTO 2000
     RETURN
'
' =============================================================================
' * option to delete original file
' =============================================================================
'
3000 '* "{CCDelete {CE"
     LineNum = 929
     GOSUB 11200
     Strng1$ = Strng$
     '* "{CC?{C0 (Y,[N])"
     LineNum = 930
     GOSUB 11200
     Strng2$ = Strng$
     DO
        ZOutTxt$ = Strng1$ + SourceFileName$ + Strng2$
        GOSUB 11100
     LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
     IF ZWasQ > 0 AND ZWasZ$ = "Y" THEN
        CALL KillWork (SourceFileName$)
     END IF
     RETURN
'
' =============================================================================
' * get description for directory listing
' =============================================================================
'
4000 CALL BreakFileName (TargetFileName$,Pre$,Body$,Ext$,ZFalse)
     HoldUpldDir$ = ZUpldDir$
     HoldFMSDirectory$ = ZFMSDirectory$
     GOSUB 4010
     CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),0,1)
     GOSUB 4010
     CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),0,2)
     ZFMSDirectory$ = HoldFMSDirectory$
     GOSUB 4020
     CALL FindFile (ZFileName$,ZOK)
     IF NOT ZOK THEN
        CALL BreakFileName (ZFileName$,Drive$,Body$,Ext$,ZTrue)
        CALL FindFile (Drive$ + Body$ + CHR$(46) + ZDefaultExtension$,ZOK)
        IF NOT ZOK THEN
           '* "Upload Aborted"
           LineNum = 601
           GOSUB 11220
        END IF
     END IF
     IF ZGetExtDesc THEN
        '* "Extended Description of {FH"
        LineNum = 600
        GOSUB 11200
        ZMsgHeader$ = Strng$
        ZSysopComment = ZTrue
        ZMaxMsgLines = ZMaxExtendedLines
        WasLL = ZRightMargin
        ZRightMargin = 30 + ZMaxDescLen + (5 * ZShowTimesDownloaded)
        IF ZRightMargin > 74 THEN _
           ZRightMargin = 74
        EXIT SUB
     END IF
     RETURN
'==============================================================================
' * some rbbs configurations seem to leave off the trailing "\"
'==============================================================================
4010 IF RIGHT$(TDirPath$,1) <> "\" THEN
        ZFMSDirectory$ = TDirPath$ + "\" + TMainFMSDir$ + "." + TMainDirExtension$
     ELSE
        ZFMSDirectory$ = TDirPath$ + TMainFMSDir$ + "." + TMainDirExtension$
     END IF
     IF RIGHT$(ZFMSDirectory$,1) <> "\" THEN
        ZUpldDir$ = ZFMSDirectory$
     ELSE
        ZUpldDir$ = ZFMSDirectory$
     END IF
4020 ZFileName$ = TargetDir$ + TargetFileName$
     ZFileNameHold$ = TargetFileName$
     RETURN
'
' =============================================================================
' * copy file from source to target
' =============================================================================
'
5000 IF SourceFileName$ = TargetDir$ + TargetFileName$ THEN
        '* "{C9SOURCE and TARGET are the SAME!{C0"
        LineNum = 931
        GOSUB 11220
        RETURN
     END IF
     CopyCommand$ = "COPY " + SourceFileName$ + SPACE$(1) + _
                        TargetDir$ + TargetFileName$ + " > NUL"
     '* "{C9Copying {CB"
     LineNum = 932
     GOSUB 11200
     Strng1$ = Strng$
     '* "{C9 as {CB"
     LineNum = 933
     GOSUB 11200
     Strng2$ = Strng$
     '* "{C9 to {CB"
     LineNum = 934
     GOSUB 11200
     Strng3$ = Strng$
     CALL QuickTPut1 (Strng1$ + SourceFileName$ + _
                      Strng2$ + TargetFileName$ + _
                      Strng3$ + TargetDir$ + ZEmphasizeOff$)
     CALL ShellExit (CopyCommand$)
     RETURN
'
' =============================================================================
' * if file was in FIDX/LIDX, then update the FIDX file
' =============================================================================
'
6000 IF InFMS = ZFalse OR InPers = ZTrue OR NOT ZFastFileSearch THEN _
         RETURN
     '* "{C2Rebuilding {CB"
     LineNum = 935
     GOSUB 11200
     CALL QuickTPut1(Strng$ + TFastFileList$ + ZEmphasizeOff$)
     FSize = 21
     CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,21)
     FIELD #2, 12 AS SearchFile$, _
                4 AS SearchPath$, _
                3 AS SearchDate$, _
                2 AS SearchCrLf$
     GET 2,1
     IF SearchCrLf$ <> ZCRLf$ THEN _
        FSize = 18 : _
        CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,18) : _
        FIELD #2, 12 AS SearchFile$, _
                   4 AS SearchPath$, _
                   2 AS SearchCrLf$
     SearchFile$ = ZFileName$
     WasX$ = MID$(STR$(LidxPos),2)
     WasX$ = SPACE$(4 - LEN(WasX$)) + WasX$
     SearchPath$ = WasX$
     IF FSize > 18 THEN _
        WasDX$ = DATE$ : _
        SearchDate$ = CHR$ (VAL (MID$ (WasDX$, 9, 2)) - 48) + _
                      CHR$ (VAL (MID$ (WasDX$, 1, 2)) + 31) + _
                      CHR$ (VAL (MID$ (WasDX$, 4, 2)) + 31) : _
     SearchCrLf$ = ZCRLf$

     IF FSize > 18 THEN _
        Template$ = SPACE$(21) : _
        MID$(Template$,17,3) = SearchDate$ : _
        MID$(Template$,20,2) = SearchCrLf$ _
     ELSE _
        Template$ = SPACE$(18) : _
        MID$(Template$,17,2) = SearchCrLf$
     MID$(Template$,1,12) = SearchFile$
     MID$(Template$,13,4) = SearchPath$
'
' * Rebuild the FIDX file
'
6010 CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,FSize)
     FIELD #2, Fsize AS OldFidx$
     FIDXFileName$ = TDirPath$ + "FIDX.$$$"
     CALL OpenRSeq (7,FIDXFileName$,XX,XX,FSize)
     FIELD #7, FSize AS WorkFidx$
     NumRecs = LOF(2) / FSize
     Flag = ZFalse
     FOR Count = 1 TO NumRecs
        GET 2
        '* "ADD"
        LineNum = 1087
        GOSUB 11200
        IF Action$ = Strng$ THEN
           IF MID$(OldFidx$,1,12) > MID$(Template$,1,12) _
              AND Flag = ZFalse THEN
              LSET WorkFidx$ = Template$
              PUT 7
              Flag = ZTrue
           END IF
           LSET WorkFidx$ = OldFidx$
           PUT 7
        END IF
        '* "DELETE"
        LineNum = 1088
        GOSUB 11200
        IF Action$ = Strng$ THEN
           IF MID$(OldFidx$,1,12) < MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
           IF MID$(OldFidx$,1,12) > MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
        END IF
        '* "MOVE"
        LineNum = 1092
        GOSUB 11200
        IF Action$ = Strng$ THEN
           IF MID$(OldFidx$,1,12) < MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
           IF MID$(OldFidx$,1,12) = MID$(Template$,1,12) THEN
              LSET WorkFidx$ = Template$
              PUT 7
           END IF
           IF MID$(OldFidx$,1,12) > MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
        END IF
     NEXT Count
'    CLOSE 2
     CLOSE 7
     CALL KillWork (TFastFileList$)
     NAME FIDXFileName$ AS TFastFileList$
'
' * make a new FIDXT tab file
'
6020 IF TFastFileList$ = "" THEN
        TFastFileList$ = ZFastFileList$
     END IF
     DIM StartPos(36)
     '* "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
     LineNum = 632
     GOSUB 11200
     CharsCounted$ = Strng$
     CLOSE 2
     CALL OpenWork (2,TFastFileList$)
     FOR i = 1 TO 36
        StartPos(i) = 0
     NEXT
     IndexPos = 1
     LinesRead = 0
     WHILE NOT EOF(2)
        LINE INPUT #2, A$
        LinesRead = LinesRead + 1
        IndexChar$ = MID$(A$, IndexPos, 1)
        Position = INSTR(CharsCounted$, IndexChar$)
        IF Position > 0 THEN
           IF StartPos(Position) = 0 THEN
              StartPos(Position) = LinesRead
           END IF
        END IF
     WEND
     CLOSE 2
     CALL BreakFileName (TFastFileList$,Pre$,Body$,Ext$,ZTrue)
     FastTabFile$ = Pre$ + Body$ + "T" + Ext$
     CALL OpenRSeq (2,FastTabFile$,HighRec,WasX,72)
     '* "{C2Re-Indexing {CB"
     LineNum = 936
     GOSUB 11200
     CALL QuickTPut1(Strng$ + FastTabFile$ + ZEmphasizeOff$)
     FIELD #2, 72 AS OutRec$
     PrevValue = 0
     i = 1
     WHILE i < 37 AND StartPos (i) = 0
        StartPos (i) = 1
        i = i + 1
     WEND
     i = 36
     WHILE i > 0 AND StartPos(i) = 0
        i = i - 1
     WEND
     StartPos(36) = StartPos(i)
     FOR i = 36 TO 1 STEP -1
        IF StartPos(i) = 0 THEN
           CurrentValue = 1
           IF PrevValue > CurrentValue THEN
              CurrentValue = PrevValue
           END IF
        ELSE
           CurrentValue = StartPos(i)
        END IF
        StartPos(i) = CurrentValue
        PrevValue = CurrentValue
     NEXT
     FOR i = 1 TO 36
        MID$(OutRec$, 1 + 2 * (i - 1), 2) = MKI$(StartPos(i))
     NEXT
     PUT 2, 1
     CLOSE 2
     RETURN
'
' =============================================================================
' * Update the MASTER.DIR or PERSONAL DIR file
' =============================================================================
'
7000 CALL BreakFileName (SourceFileName$,SourceDrive$, _
                         SourceBody$,SourceExt$,ZTrue)
     CALL BreakFileName (ZPersonalDir$,PerPre$,PerBody$,PerExt$,ZFalse)
     DeleteFile$ = SourceBody$ + SourceExt$
     '* "{C2Rebuilding {CB"
     LineNum = 935
     GOSUB 11200
     IF InPers THEN
        CALL QuickTPut1(Strng$ + ZPersonalDir$ + ZEmphasizeOff$)
        FSize = 12 + 21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) + ZPersonalLen + 1 + 2
        CALL OpenRSeq (2,ZPersonalDir$,HighRec,WasX,FSize)
        FIELD #2, 12 AS FileName$, _
                  21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) AS FileDesc$, _
                  ZPersonalLen + 1 AS FilePers$, _
                   2 AS FileChar$
        CALL OpenRSeq (7,PerPre$ + "\" + PerBody$ + ".$$$",XX,XX,FSize)
        FIELD #7, 12 AS WorkFileName$, _
                  21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) AS WorkFileDesc$, _
                  ZPersonalLen + 1 AS WorkFilePers$, _
                   2 AS WorkFileChar$
     ELSE
        CALL QuickTPut1(Strng$ + TDirPath$ + TMainFMSDir$ + "." + _
                        TMainDirExtension$ + ZEmphasizeOff$)
        FSize = 12 + 10 + 11 + TMaxDescLen + 3 + 2
        CALL OpenRSeq (2,TDirPath$ + TMainFMSDir$ + "." + _
                       TMainDirExtension$,HighRec,WasX,Fsize)
        FIELD #2, 12 AS FileName$, _
                  10 AS FileSize$, _
                  11 AS FileDate$, _
                  TMaxDescLen + 1 AS FileDesc$, _
                   4 AS FileCat$
        CALL OpenRSeq (7,TDirPath$ + TMainFMSDir$ + ".$$$",XX,XX,FSize)
        FIELD #7, 12 AS WorkFileName$, _
                  10 AS WorkFileSize$, _
                  11 AS WorkFileDate$, _
                  TMaxDescLen + 1 AS WorkFileDesc$, _
                   4 AS WorkFileCat$
     END IF
     '*
     '* Parse the list to look for possible extended descriptions
     '*
     SourceCount = HighRec
     LastWasIt = ZFalse
     FOR InCount = HighRec TO 1 STEP -1
        GET 2, InCount
        IF DeleteFile$ + SPACE$(12-LEN(DeleteFile$)) <> FileName$ THEN
           IF LastWasIt = ZTrue THEN
              IF LEFT$(FileName$,1) = SPACE$(1) THEN
                 SourceCount = SourceCount - 1
              ELSE
                 LastWasIt = ZFalse
              END IF
           END IF
        ELSE
           LastWasIt = ZTrue
           SourceCount = SourceCount - 1
        END IF
     NEXT InCount
     '*
     '* rebuild the file list
     '*
     OutCount = SourceCount
     LastWasIt = ZFalse
     FOR InCount = HighRec TO 1 STEP -1
        GET 2, InCount
        '*
        '* check for extended on the deleted file
        '*
        IF LastWasIt = ZTrue THEN
           IF LEFT$(FileName$,1) = SPACE$(1) THEN
              LastWasIt = ZTrue
           ELSE
              LastWasIt = ZFalse
           END IF
        END IF
        IF DeleteFile$ + SPACE$(12-LEN(DeleteFile$)) <> FileName$ THEN
           IF LastWasIt = ZFalse THEN
              IF InPers THEN
                 LSET WorkFileName$ = FileName$
                 LSET WorkFileDesc$ = FileDesc$
                 LSET WorkFilePers$ = FilePers$
                 LSET WorkFileChar$ = FileChar$
              ELSE
                 LSET WorkFileName$ = FileName$
                 LSET WorkFileSize$ = FileSize$
                 LSET WorkFileDate$ = FileDate$
                 LSET WorkFileDesc$ = FileDesc$
                 LSET WorkFileCat$ = FileCat$
              END IF
              PUT 7, OutCount
              OutCount = OutCount - 1
           ELSE
              '* "{C2Removing Extended Description{C0{CR"
              LineNum = 937
              GOSUB 11220
           END IF
        ELSE
           LastWasIt = ZTrue
           '* "{C2Found {CB"
           LineNum = 938
           GOSUB 11200
           Strng1$ = Strng$
           '* "{C2 - Removing Entry{C0"
           LineNum = 939
           GOSUB 11200
           Strng2$ = Strng$
           CALL QuickTPut1 (Strng1$ + DeleteFile$ + Strng2$)
        END IF
     NEXT InCount
     CLOSE 2
     CLOSE 7
     '*
     '* kill the old listing and rename the new one
     '*
     IF InPers THEN
        CALL KillWork (ZPersonalDir$)
        NAME PerPre$ + "\" + PerBody$ + ".$$$" AS ZPersonalDir$
     END IF
     IF InFMS THEN
        CALL KillWork (TDirPath$ + TMainFMSDir$ + "." + _
                       TMainDirExtension$)
        NAME TDirPath$ + TMainFMSDir$ + ".$$$" AS TDirPath$ + _
             TMainFMSDir$ + "." + _
             TMainDirExtension$
     END IF
     RETURN
'
' =============================================================================
' * Input SourceFileName for Action
' =============================================================================
'
8000 GOSUB 11000
     IF ZWasQ = 0 THEN
        RETURN
     END IF
8001 SourceFileName$ = ZUserIn$(ZAnsIndex)
8002 CALL AllCaps (SourceFileName$)
     CALL BreakFileName (SourceFileName$,SourceDrive$, _
                         SourceBody$,SourceExt$,ZTrue)
     Found = ZFalse
     '* "ADD"
     LineNum = 1087
     GOSUB 11200
     Strng1$ = Strng$
     '* "VIEW"
     LineNum = 1093
     GOSUB 11200
     Strng2$ = Strng$
     IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
        CALL FindIt (SourceFileName$)
        IF ZOK THEN
           Found = ZTrue
           RETURN
        END IF
     ELSE
        SourceFileName$ = SourceBody$ + SourceExt$
        CALL FindIt (ZPersonalDrvPath$ + SourceBody$ + SourceExt$)
        IF ZOK THEN
           Found = ZTrue
           '* "FIND"
           LineNum = 1090
           GOSUB 11200
           Strng1$ = Strng$
           '* "MOVE"
           LineNum = 1092
           GOSUB 11200
           Strng2$ = Strng$
           IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
              SourceFileName$ = ZPersonalDrvPath$ + SourceBody$ + SourceExt$
              RETURN
           END IF
           '* "{CB"
           LineNum = 940
           GOSUB 11200
           Strng1$ = Strng$
           '* "{SP{C2"
           LineNum = 941
           GOSUB 11200
           Strng2$ = Strng$
           '* "{CB from {C2"
           LineNum = 942
           GOSUB 11200
           Strng3$ = Strng$
           '* "{C0 (Y)es,[N]o,A)bort)"
           LineNum = 943
           GOSUB 11200
           Strng4$ = Strng$
           DO
              ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                         SourceBody$ + SourceExt$ + _
                         Strng3$ + ZPersonalDrvPath$ + Strng4$
              GOSUB 11100
           LOOP Until ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
           IF ZWasZ$ = "A" THEN
              Found = ZFalse
              ZAnsIndex = 0
              RETURN
           END IF
           IF ZWasZ$ = "Y" THEN
              InPers = ZTrue
              InFMS = ZFalse
              SourceFileName$ = ZPersonalDrvPath$ + SourceBody$ + SourceExt$
              RETURN
           END IF
           Found = ZFalse
        END IF
        FOR WasX = 1 TO ZSubDirCount - 1
           CALL FindIt (ZSubDir$(WasX) + SourceBody$ + SourceExt$)
           IF ZOK THEN
              Found = ZTrue
              '* "FIND"
              LineNum = 1090
              GOSUB 11200
              Strng1$ = Strng$
              '* "MOVE"
              LineNum = 1092
              GOSUB 11200
              Strng2$ = Strng$
              IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
                 SourceFileName$ = ZSubDir$(WasX) + SourceBody$ + SourceExt$
                 RETURN
              END IF
              '* "{CB"
              LineNum = 940
              GOSUB 11200
              Strng1$ = Strng$
              '* "{SP{C2"
              LineNum = 941
              GOSUB 11200
              Strng2$ = Strng$
              '* "{CB from {C2"
              LineNum = 942
              GOSUB 11200
              Strng3$ = Strng$
              '* "{C0 (Y)es,[N]o,A)bort)"
              LineNum = 943
              GOSUB 11200
              Strng4$ = Strng$
              DO
                 ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                            SourceBody$ + SourceExt$ + _
                            Strng3$ + ZSubDir$(WasX) + Strng4$
                 GOSUB 11100
              LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
              IF ZWasZ$ = "A" THEN
                 Found = ZFalse
                 ZAnsIndex = 0
                 RETURN
              END IF
              IF ZWasZ$ = "Y" THEN
                 SourceFileName$ = ZSubDir$(WasX) + _
                                   SourceBody$ + SourceExt$
                 TDirPath$ = ZDirPath$
                 TMainFMSDir$ = ZMainFMSDir$
                 TMainDirExtension$ = ZMainDirExtension$
                 TMaxDescLen = ZMaxDescLen
                 TFastFileList$ = ZFastFileList$
                 TFastFileLocator$ = ZFastFileLocator$
                 RETURN
              END IF
              Found = ZFalse
           END IF
        NEXT WasX
        IF ZFastFileSearch THEN
           TFastFileLocator$ = ZFastFileLocator$
           CALL BreakFileName (ZFastFileList$,Drive$,Body$,Ext$,ZTrue)
           CALL FindIt (Drive$ + "SYSOP8.CFG")
           IF ZOK THEN
              CALL OpenWork (7, Drive$ + "SYSOP8.CFG")
           ELSE
              CALL FindIt (Drive$ + Body$ + ".LST")
              IF ZOK THEN
                 CALL OpenWork (7,Drive$ + Body$ + ".LST")
              END IF
           END IF
           LineToRead = 1
           IF ZOK THEN
              IF ZErrCode <> 0 THEN
                 GOSUB 8010
                 GOTO 8020
              END IF
8005          CALL ReadParmsX (7,ZOutTxt$(),4,LineToRead)
              IF ZErrCode <> 0 AND ZOutTxt$(1) = "" THEN
                 CLOSE 7
                 GOTO 8020
              END IF
              TFastFileList$ = UCASE$(ZOutTxt$(1))
              TFastFileLocator$ = UCASE$(ZOutTxt$(2))
              CALL BreakFileName (UCASE$(ZOutTxt$(3)),TDirPath$, _
                                  TMainFMSDir$,TMainDirExtension$,ZFalse)
              TMaxDescLen = VAL(ZOutTxt$(4))
              GOSUB 8010
              IF ZWasZ$ = "Y" THEN
                 GOTO 8020
              END IF
              LineToRead = LineToRead + 1
              ZOutTxt$(1) = ""
              GOTO 8005
           ELSE
              GOSUB 8010
              GOTO 8020
           END IF
8010       CALL OpenRSeq (14,TFastFileLocator$,HighRec,WasX,66)
           FIELD 14, 66 AS Location$
           FOR WasX = 1 TO HighRec
              GET 14, WasX
              SelectLocation$ = LEFT$(Location$,63)
              CALL Trim (SelectLocation$)
              FOR WasL = 1 TO ZSubDirCount - 1
                 Found = ZFalse
                 CALL BreakFileName (SelectLocation$,SDrive$,Body$,Ext$,ZFalse)
                 CALL BreakFileName (ZSubDir$(WasL),RDrive$,Body$,Ext$,ZFalse)
                 IF SDrive$ = RDrive$ THEN
                    Found = ZTrue
                    EXIT FOR
                 END IF
              NEXT WasL
              IF LEFT$(SelectLocation$,2) <> "M!" AND NOT Found THEN
                 CALL FindIt (SelectLocation$ + SourceBody$ + SourceExt$)
                 IF ZOK THEN
                    Found = ZTrue
                    '* "FIND"
                    LineNum = 1090
                    GOSUB 11200
                    Strng1$ = Strng$
                    '* "MOVE"
                    LineNum = 1092
                    GOSUB 11200
                    Strng2$ = Strng$
                    IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
                       SourceFileName$ = SelectLocation$ + SourceBody$ + SourceExt$
                       RETURN
                    END IF
                    '* "{CB"
                    LineNum = 940
                    GOSUB 11200
                    Strng1$ = Strng$
                    '* "{SP{C2"
                    LineNum = 941
                    GOSUB 11200
                    Strng2$ = Strng$
                    '* "{CB from {C2"
                    LineNum = 942
                    GOSUB 11200
                    Strng3$ = Strng$
                    '* "{C0 (Y)es,[N]o,A)bort)"
                    LineNum = 943
                    GOSUB 11200
                    Strng4$ = Strng$
                    DO
                       ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                                  SourceBody$ + SourceExt$ + _
                                  Strng3$ + SelectLocation$ + Strng4$
                       GOSUB 11100
                    LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
                    IF ZWasZ$ = "A" THEN
                       Found = ZFalse
                       ZAnsIndex = 0
                       RETURN
                    END IF
                    IF ZWasZ$ = "Y" THEN
                       InFMS = ZTrue
                       LidxPos = WasX
                       SourceFileName$ = SelectLocation$ + SourceBody$ + SourceExt$
                       CLOSE 14
                       RETURN
                    END IF
                    Found = ZFalse
                 END IF
              END IF
           NEXT WasX
           CLOSE 14
           RETURN
        END IF
     END IF
8020 IF NOT Found THEN
        '* "{CF{G4ERROR! Could not find{SP"
        LineNum = 944
        GOSUB 11200
        CALL QuickTPut1 (Strng$ + SourceBody$ + SourceExt$ + ZEmphasizeOff$)
     END IF
     RETURN
'
' =============================================================================
' * common input routine - single char
' =============================================================================
'
11000 ZSubParm = 1
      CALL TGet
      IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
'
' =============================================================================
' * common input routine - string
' =============================================================================
'
11100 ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZWasZ$ = UCASE$(ZUserIn$(ZAnsIndex))
      RETURN
'
' =============================================================================
' * External Text Display
' =============================================================================
'
11200 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
11210 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      RETURN
11220 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,CRCount,"")
      RETURN
'
' =============================================================================
' * End of SYSOP8
' =============================================================================
'
      END SUB
'
' =============================================================================
' * Error Handling
' =============================================================================
'
12000 ZOutTxt$ = "SYSOP8 Untrapped Error" + _
           STR$(ERR) + _
           " in line" + _
           STR$(ERL)
      IF ZPrinter THEN
         CALL Printit(ZOutTxt$)
      END IF
      CALL QuickTPut1 (ZOutTxt$)
      CALL UpdtCalr (ZOutTxt$,2)
      ZErrCode = ERR
      RESUME NEXT
