;
; Changes made by Scott McNay (1:395/11) July 26, 1992, to allow routine to be
; used with code compiled with BC's /Fs option.  (Most) changes marked with
; ;BCFS0726.  May have optimized some code also.  This is a plug-in replacement
; for the original code.

;BCFS0801: Standardized code format.  Made sure that DI, SI, BP, and DS are
;  saved to meet requirements of BC 7.x.
;  Why bother having a temp buffer??  Got rid of it.  Will save the 1K overhead
;  of the buffer and the time overhead of copying 1K of data.  Got rid of all
;  variables.

; Modified 8/24/85 for use with QuickBasic Compiler

; Heavy modifications 8/31/86 by Jim King
; Changed CRC_CALC from the awfulness it was to an algorithm suggested
; by Philip Burns.  In a test program, this algorithm is over 3 times as
; fast as the one previously used by RBBS-PC.
; Changed the loop that calculates checksum and calls the CRC to be more
; efficient (just about halved the number of instructions).
; Note that RBBS-PC.BAS was also modified so that it no longer tacks on
; two null bytes to the input string (they were necessary for the old CRC
; routine to work correctly).
; Once again, thanks to Philip Burns for suggesting the CRC algorithm.
; Many thanks also to John Souvestre, who helped me tweak the assembly
; routine to run even faster.

	Extrn	StringAddress:far					      ;BCFS0726

XM_CALC	SEGMENT PUBLIC 'CODE'
	ASSUME	CS:XM_CALC
	PUBLIC	XMODEM

XMODEM	PROC	FAR
	PUSH	BP
	MOV	BP,SP
;
	PUSH	DI							      ;BCFS0801
	PUSH	SI							      ;BCFS0801
	PUSH	DS						              ;BCFS0726
	PUSH	[BP+14]		;GET A$ STRING DESCRIPTOR ADDRESS	      ;BCFS0726
	CALL	StringAddress						      ;BCFS0726
	MOV	SI,AX							      ;BCFS0726
	MOV	DS,DX							      ;BCFS0726
	XOR	BP,BP		;INITIALIZE CHECKSUM			      ;BCFS0801
;
	XOR	DX,DX		;initialize CRC value to 0
LOOP1:
	LODSB			;get character into AL
	MOV	DI,CX		;SAVE CX
	ADD	BP,AX		;ADD AL TO CHECKSUM			      ;BCFS0801

; this used to be:
;CRC_CALC   PROC NEAR
; this is the CRC calculation routine.  It's placed here instead of in
; a separate procedure for additional speed.
; DX contains the CRC value, AL has the new character.  Other registers
; are used for temporary storage and scratch work.
	XCHG	DH,DL		; CRC := Swap(CRC) XOR Ord(Ch);
	XOR	DL,AL

	MOV	AL,DL		; CRC := CRC XOR ( Lo(CRC) SHR 4 );
	MOV	CL,4
	SHR	AL,CL
	XOR	DL,AL

				; CRC := CRC XOR ( Swap(Lo(CRC)) SHL 4 )
				;	XOR ( Lo(CRC) SHL 5 );
	MOV	BL,DL
	MOV	AH,DL
	SHL	AH,CL
	XOR	DH,AH
	XOR	BH,BH
	INC	CL
	SHL	BX,CL
	XOR	DX,BX
; end of the CRC calculation routine
	
	MOV	CX,DI		;RESTORE CX
	LOOP	LOOP1		;do it again


	POP	DS		;RESTORE DS
	POP	SI							      ;BCFS0801
	POP	DI							      ;BCFS0801
	MOV	CX,BP							      ;BCFS0801
	MOV	BP,SP							      ;BCFS0801
	MOV	AX,DX		;PASS BACK THE CRC VALUE		      ;BCFS0801
	MOV	BX,[BP+ 6]	;AND CRC HIGH AND LOW BYTES		      ;BCFS0801
	MOV	[BX],AL							      ;BCFS0801
	MOV	BX,[BP+ 8]						      ;BCFS0801
	MOV	[BX],AH							      ;BCFS0801
	MOV	BX,[BP+10]						      ;BCFS0801
	MOV	[BX],AX							      ;BCFS0801
	MOV	AL,CL		;PASS BACK THE CHECK SUM		      ;BCFS0801
	MOV	BX,[BP+12]						      ;BCFS0801
	MOV	[BX],AL							      ;BCFS0801
;
	POP	BP
	RET	10
XMODEM	ENDP
XM_CALC	ENDS
	END
