/****************************************************************************/
/* CLEANUSR module for RBBSMNT v2.01, a maintenance utility for RBBS-PC     */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */

  /**************************************************************************/
  /* clean a message file                                                   */
  /**************************************************************************/

void cleanusr(void)
{
   long usrpos,wrkpos;
   int maxrec,nlen;
   int year,month,day,age;
   int i,ucount,rcount,wcount,luser,xuser,kills,recs_read;
   int usr,wrk;
   int ch,hash_1,hash_2;
   char *p,name[32];

   sprintf(logbuf, "Processing %s.", usrfile);
   writelog(logbuf, 1, 3);

   if (use_wrk)
   {
      sprintf(wrkfile, "%s\\RBBSMNT.$$U", wkf);
   }

   else
   {
      strcpy(wrkfile, usrfile);

      if ((p = strrchr(wrkfile, '.')) != NULL)
      {
         sprintf(p, ".$$U");
      }

      else
      {
         strcat(wrkfile, ".$$U");
      }
   }

   /*************************************************************************/
   /* open usr file                                                         */
   /*************************************************************************/


   if ((usr = open(usrfile, O_RDONLY|O_BINARY)) == ERROR)
   {
      sprintf(logbuf, "Error opening %s.", usrfile);
      writelog(logbuf, 1, 0);
      return ;
   }

   /*************************************************************************/
   /* open tmp file                                                         */
   /*************************************************************************/


   if (!access(wrkfile, 0))
   {
      unlink(wrkfile);
   }

   if ((wrk = open(wrkfile, O_BINARY|O_WRONLY|O_CREAT, S_IREAD|S_IWRITE)) ==
   ERROR)
   {
      sprintf(logbuf, "Error opening temporary USERS file.");
      writelog(logbuf, 1, 0);
      return ;
   }
   usrpos = lseek(usr, 0L, SEEK_END);
   maxrec = (int)(usrpos/sizeof(RBBSUSER));

   /*************************************************************************/
   /* write temporary file                                                  */
   /*************************************************************************/

   printf("\r  Preparing");

   for (i = 0; i < maxrec/UBLOCK; i++)
   {
      write(wrk, (char *)ulist, UBLOCK *sizeof(RBBSUSER));
      printf(".");
   }

   for (i = 0; i < maxrec%UBLOCK; i++)
   {
      write(wrk, (char *)ulist, sizeof(RBBSUSER));
   }
   close(wrk);
   wrk = open(wrkfile, O_BINARY|O_RDWR, S_IREAD|S_IWRITE);
   lseek(usr, 0L, SEEK_SET);

   /*************************************************************************/
   /* read userfile                                                         */
   /*************************************************************************/

   recs_read = kills = luser = xuser = ucount = 0;

   while (recs_read < maxrec)
   {
      rcount = 0;

      if (quiet)
      {
         printf("\r\33[K\r  Reading ");
      }

      /**********************************************************************/
      /* read up to 256 user records                                        */
      /**********************************************************************/


      while (rcount < UBLOCK && recs_read < maxrec)
      {
         usrpos = lseek(usr, 0L, SEEK_CUR);
         read(usr, (char *)ulist[rcount].user_name, sizeof(RBBSUSER));
         recs_read++;

         if (ulist[rcount].user_name[0] != ' ' && ulist[rcount].user_name[0]
         != '\0' && strncmp(ulist[rcount].user_name, "NEWUSER", 7))
         {
            ch = FALSE;

            /****************************************************************/
            /* exempt user?                                                 */
            /****************************************************************/


            if (ulist[rcount].user_level >= exempt)
            {
               sprintf(logbuf, "%.31s exempt", ulist[rcount].user_name);
               ch = TRUE;
               xuser++;
            }

            /****************************************************************/
            /* locked user?                                                 */
            /****************************************************************/


            if (ulist[rcount].user_level <= 0)
            {
               sprintf(logbuf, "%.31s locked out", ulist[rcount].user_name);
               writelog(logbuf, 0, 3);
               ch = TRUE;
               luser++;
            }

            /****************************************************************/
            /* check age                                                    */
            /****************************************************************/


            if (!ch)
            {
               sscanf(ulist[rcount].last_on, "%2u-%2u-%2u", &month, &day,
               &year);
               age = (int) (now-(((year-80)*365)+to_month[month-1]+day));

               if (age > max_since)
               {
                  sprintf(logbuf, "%.31s deleted, last on at %.8s.", ulist
                  [rcount].user_name, ulist[rcount].last_on);
                  writelog(logbuf, 0, 3);
                  kills++;
               }

               else
               {
                  sprintf(logbuf, "%.31s copied", ulist[rcount].user_name);
                  ch = TRUE;
               }
            }

            /****************************************************************/
            /* adjust last msg read pointer                                 */
            /****************************************************************/


            if (ch)
            {

	       if (do_renum && ulist[rcount].lastread)
               {

		  i = lives-1;
		  while (i && mlist[i].old_num > ulist[rcount].lastread)
		  {
		     i--;
		  }
		  ulist[rcount].lastread = mlist[i].new_num;
               }

               if (quiet)
               {

                  if (rcount%32 == 0)
                  {
                     printf(".");
                  }
               }
               rcount++;
            }

            if (!quiet)
            {
               printf("\r\33[K\r  %s\n", logbuf);
            }
         }
      }

      /**********************************************************************/
      /* write a block of up to 256 user records                            */
      /**********************************************************************/


      if (!quiet)
      {
         printf("\r\33[K");
      }
      printf("\r  Writing ");

      for (wcount = 0; wcount < rcount; wcount++)
      {
         memset(name, 0, 32);
         strncpy(name, ulist[wcount].user_name, 31);/* username to workspace*/
         p = name+strlen(name);

         while (isspace(*(--p)))        /* strip trailing blanks            */
            ;
         *(++p) = '\0';

         if (ucount%32 == 0)
         {
            printf("o");
         }
         ucount++;
         nlen = strlen(name)-1;

         /*******************************************************************/
         /* calculate hash values                                           */
         /*******************************************************************/

         hash_1 = name[0];
         hash_2 = name[nlen/2];
         ch = name[nlen];
         hash_1 = (int)(((hash_1 *100)+(hash_2 *10)+ch)%maxrec)+1;
         ch = name[1];
         hash_2 = (int)((ch *10+7)%maxrec);

         /*******************************************************************/
         /* find free slot in usrfile                                       */
         /*******************************************************************/


         for (i = 0; i < maxrec; i++)
         {

            if (hash_1 > 0)
            {

               if (hlist[hash_1] == 'F')/* free slot?                       */
               {
                  wrkpos = (long)((hash_1-1)*(long)sizeof(RBBSUSER));
                  lseek(wrk, wrkpos, SEEK_SET);
                  write(wrk, (char *)ulist[wcount].user_name, sizeof
                  (RBBSUSER));
                  hlist[hash_1] = 'U';
                  break;
               }
            }
            hash_1 += hash_2;           /* get next hash value              */

            if (hash_1 > maxrec-1)      /* but not past EOF                 */
            {
               hash_1 -= maxrec;
            }
         }

         /*******************************************************************/
         /* user properly saved in free slot?                               */
         /*******************************************************************/


         if (i == maxrec)               /* couldn't find free slot!!        */
         {
            sprintf(logbuf, "Userfile too full.");
            writelog(logbuf, 1, 0);
            close(usr);
            close(wrk);
            unlink(wrkfile);
            return ;
         }
      }
   }
   close(wrk);
   close(usr);

   /*************************************************************************/
   /* adjust usercount in msg file header                                   */
   /*************************************************************************/


   if ((wrk = open(msgfile, O_RDWR|O_BINARY)) == ERROR)
   {
      sprintf(logbuf, "Error opening %s.", msgfile);
      writelog(logbuf, 1, 0);
      unlink(wrkfile);
      return ;
   }
   get_rbbs_hdr(wrk);
   num_users = ucount;
   put_rbbs_hdr(wrk);
   close(wrk);
   sprintf(logbuf,
   "Usrs: %05d deleted, %05d active (%04d exempt, %04d locked).", kills,
   ucount, xuser, luser);
   printf("\r\33[K\r  %s\n", logbuf);
   writelog(logbuf, 0, 4);

   /*************************************************************************/
   /* rename or copy workfile to org file                                   */
   /*************************************************************************/


   if (use_wrk)
   {
      sprintf(logbuf, "copy %s %s > nul", wrkfile, usrfile);
      system(logbuf);
      unlink(wrkfile);
   }

   else
   {
      unlink(usrfile);
      rename(wrkfile, usrfile);
   }
}


/*--------------------------------------------------------------------------*/

