/****************************************************************************/
/* DUMPOLD module for RBBSMNT v2.01, a maintenance utility for RBBS-PC      */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */

  /**************************************************************************/
  /* dump old messages to an archive file                                   */
  /**************************************************************************/

void dump_old(int msg)
{
   RBBSMSG far *m;
   char far *buf,*q,*r;
   int old,dcount,scount;
   size_t bufsize;
   char *p,oldfile[_MAX_PATH];
   char *ds;

   scount = 0;
   strcpy(oldfile, msgfile);

   if ((p = strrchr(oldfile, '.')) == NULL)
   {
      p = oldfile+strlen(oldfile);
   }
   sprintf(p, ".%03d", today->tm_yday);

   if ((old = open(oldfile, O_CREAT|O_APPEND|O_WRONLY|O_TEXT, S_IREAD|
   S_IWRITE)) == ERROR)
   {
      sprintf(logbuf, "Error opening %s.", oldfile);
      writelog(logbuf, 1, 0);
      return ;
   }
   printf("\r\33[K  Archiving old msgs");

   if (p = strstr(oldfile, "M."))
   {
      *p = '\0';
   }

   if (p = strrchr(oldfile, '\\'))
   {
      p++;
   }

   else
   {
      p = oldfile;
   }
   ds = asctime(today);
   sprintf(logbuf, PRGNAME VERSION
   " Message archive for %s conference, %.2s %.3s %.4s (#%03d)", p, ds+8, ds
   +4, ds+20, today->tm_yday);
   write(old, logbuf, strlen(logbuf));  /* write brag line                  */

   /*************************************************************************/
   /* write the messages to a file                                          */
   /*************************************************************************/


   for (dcount = 0; dcount < lives; dcount++)
   {

      if (mlist[dcount].old_num == -1)  /* msg to kill?                     */
      {

         if ((scount++%32) == 0)
         {
            printf(".");
         }
         bufsize = mlist[dcount].num_recs *128;/* size of buffer            */

         if ((buf = (char far *)malloc(bufsize *sizeof(char))) == NULL)
         {
            sprintf(logbuf, "%s messages buffer.", no_memory);
            writelog(logbuf, 1, 0);
            return ;
         }
         lseek(msg, mlist[dcount].msg_pos, SEEK_SET);/* seek to msg         */
         read(msg, buf, bufsize);       /* read msg                         */

         /*******************************************************************/
         /* trim padded spaces from msg text                                */
         /*******************************************************************/

         q = buf+bufsize-1;

         while ((*q&0x7F) <= ' ')
         {
            *(q--) = '\0';
         }

         /*******************************************************************/
         /* build & write separator line                                    */
         /*******************************************************************/

         m = (RBBSMSG *)buf;
         memset(logbuf, '\0', 128);
         memset(logbuf, '\n', 1);
         memset(logbuf+1, '-', 72);
         write(old, logbuf, strlen(logbuf));/* write                        */

         /*******************************************************************/
         /* build & write Date/To/From/Subj line                            */
         /*******************************************************************/

         sprintf(logbuf,
      "\nDate: %8.8s, %8.8s\nFrom: %31.31s\nTo:   %22.22s\nSubj: %25.25s\n\n"
         , m->enter_date, m->enter_time, m->msg_from, m->msg_to, m->msg_subj
         );
         write(old, logbuf, strlen(logbuf));/* write                        */

         /*******************************************************************/
         /* translate RBBSCR to regular LF                                  */
         /*******************************************************************/

         q = &buf[128];

         while (q = strchr(q, 227))
         {
            *q = '\n';
            q++;
         }

         /*******************************************************************/
         /* zap kludge lines                                                */
         /*******************************************************************/


         while (buf[128] == '\x001')
         {
            r = strchr(&buf[128], '\n');
            memmove(&buf[128], ++r, strlen(r)+1);
         }

         if ((q = strstr(&buf[128], "\nSEEN-BY:")) || (q = strstr(&buf[128],
         "\n\x001")))
         {

            do
            {
               r = strchr(++q, '\n');
               memmove(q, ++r, strlen(r)+1);
            }

            while ((q = strstr(&buf[128], "\nSEEN-BY:")) || (q = strstr(&buf
            [128], "\n\x001")));
         }

         /*******************************************************************/
         /* write the converted msg text                                    */
         /*******************************************************************/

         write(old, &buf[128], strlen(&buf[128]));
         free(buf);
      }
   }
   close(old);
   printf("\r\33[K");
}


/*--------------------------------------------------------------------------*/

