/****************************************************************************/
/* MAKELIST module for RBBSMNT v2.01, a maintenance utility for RBBS-PC     */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */

  /**************************************************************************/
  /* make a list of all messages                                            */
  /**************************************************************************/

int makelist(int fp)
{
   int cur_rec;                         /* current record pos in msg file   */
   int num_rec;                         /* # records in this messages       */
   int year,month,day;                  /* timestamp                        */
   long msgpos;
   int xnum,count = 0;

   lives = 0;
   deads = 0;
   bads = FALSE;

   if (quiet)
   {
      printf("\r  Scanning msg file");
   }
   get_rbbs_hdr(fp);                    /* get the file header              */

   if (next_rec > first_rec)            /* any messages?                    */
   {
      cur_rec = first_rec;

      do
      {
         msgpos = (long)(cur_rec-1)*128L;
         lseek(fp, msgpos, SEEK_SET);   /* move to start of message         */
         read(fp, (char *)&msg_hdr, (size_t)sizeof(RBBSMSG));
         cur_rec++;

         if (msg_hdr.enter_date[2] == '-' && msg_hdr.enter_date[5] == '-' &&
         msg_hdr.enter_time[2] == ':')  /* got a real message header?       */
         {
            count++;
            sscanf(msg_hdr.num_recs, "%4u", &num_rec);

            if (!strncmp(msg_hdr.msg_stat, ALIVE, 1))/* alive msg?          */
            {
               sscanf(msg_hdr.enter_date, "%2u-%2u-%2u", &month, &day, &year
               );
               mlist[lives].msg_age = (int)(now-(((year-80)*365)+to_month
               [month-1]+day));
               sscanf(msg_hdr.msg_number, "%4u", &xnum);
               mlist[lives].old_num = xnum;
               mlist[lives].new_num = mlist[lives].old_num;
               mlist[lives].num_recs = num_rec;
               mlist[lives].msg_pos = msgpos;
               lives++;
            }

            else
            {
               deads++;
            }
            cur_rec += num_rec-1;
         }

         else
         {

            /****************************************************************/
            /* next record read wasn't a msg header!!!!                     */
            /****************************************************************/

            bads = TRUE;

            while (cur_rec < last_rec)  /* search for a msg header          */
            {
               read(fp, (char *)&msg_hdr, (size_t)sizeof(RBBSMSG));

               if (msg_hdr.enter_date[2] == '-' && msg_hdr.enter_date[5] ==
               '-' && msg_hdr.enter_time[2] == ':')/* got a real message
                                           header?                          */
               {
                  sscanf(msg_hdr.msg_number, "%4u", &xnum);
                  sprintf(logbuf, "Fixed broken link at msg %05d.", xnum);
                  writelog(logbuf, 1, 1);
                  msgpos = (long)(cur_rec-1)*128L;
                  break;
               }
               cur_rec++;
            }

            if (cur_rec >= next_rec)
            {
               sprintf(logbuf, "Fixed msg file corruption.");
               writelog(logbuf, 1, 0);
            }
         }
      }

      while (cur_rec < next_rec);
   }
   printf("\r\33[K");
   sprintf(logbuf, "Found %05d active msgs.", lives);
   writelog(logbuf, 1, 4);
   return (count);
}

