/****************************************************************************/
/* DATA module for RBBSMNT v2.01, a maintenance utility for RBBS-PC         */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */

  /**************************************************************************/
  /* character data                                                         */
  /**************************************************************************/

char *msgfile;                          /* pointer to current MSG file      */
char *no_memory = "! Error allocating memory for";
char *usrfile;                          /* pointer to current USR file      */
char logbuf[TXTLEN];                    /* log scratch pad                  */
char wkf[_MAX_PATH] = "\0";             /* work directory                   */
char wrkfile[_MAX_PATH] = "\0";         /* work directory                   */

  /**************************************************************************/
  /* integer data                                                           */
  /**************************************************************************/

int bads = FALSE;                       /* bad records found                */
int deads;
int do_clean = FALSE;
int do_renum = FALSE;
int do_usr = FALSE;
int exempt = 32000;                     /* user level exempt from cleanup   */
int first_rec = 0;                      /* first msg rec in msg file        */
int high_msg = 1;                       /* highest msg numbe in msg file    */
int lives = 0;                          /* # msgs alive                     */
int kills = 0;                          /* # of msgs to kill                */
int last_rec = 0;                       /* last record in msg file          */
int max_age = 32000;                    /* max age of msgs                  */
int max_msgs = 999;                     /* max # msgs in msg file           */
int max_since = 32000;                  /* days after user deleted          */
int next_rec = 0;                       /* next free rec in msg file        */
int now;
int num_users = 0;                      /* # of usr record in usr file      */
int pip = FALSE;
int quiet = FALSE;
int use_wrk = FALSE;
int save_em = FALSE;
int fixhdr = FALSE;

  /**************************************************************************/
  /* some default C structures                                              */
  /**************************************************************************/

struct stat f;                          /* structure for FILE INFO          */
struct tm *today;                       /* structure for time info          */
time_t ltime;                           /* placeholder for time             */

  /**************************************************************************/
  /* custom data                                                            */
  /**************************************************************************/

MSGINFO *mlist;                         /* pointer to array of msg info     */
RBBSHDR hdr;                            /* message header record            */
RBBSMSG msg_hdr;                        /* message file header record       */
RBBSNODE noderec;                       /* node record within MESSAGES file */
RBBSUSER *ulist;                        /* pointer to in-core user array    */
RBBSUSER urec;                          /* user record                      */
char far *hlist;                        /* index of used records            */
long to_month[12] =
{
   0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L
} ;

/*--------------------------------------------------------------------------*/

