/****************************************************************************/
/* UTILITY module for RBBSMNT v2.01, a maintenance utility for RBBS-PC      */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */

  /**************************************************************************/
  /* get RBBS message file header                                           */
  /**************************************************************************/

void get_rbbs_hdr(int fp)
{
   int x;
   long oldpos = lseek(fp, 0L, SEEK_CUR);/* store current file position     */

   lseek(fp, 0L, SEEK_SET);             /* seek back to header              */
   read(fp, (char *)&hdr, (int)sizeof(RBBSHDR));/* read header              */
   sscanf(hdr.last_msg, "%7u", &high_msg);
   sscanf(hdr.user_count, "%5u", &num_users);
   sscanf(hdr.first_msg_rec, "%7u", &first_rec);
   sscanf(hdr.next_free_rec, "%7u", &next_rec);
   sscanf(hdr.num_nodes, "%7u", &x);
   if(first_rec != (x+2))
   {
      writelog("Inconsistent header info, repair with -FIX option",1,0);
      exit(1);
   }
   last_rec = (int)(lseek(fp, 0L, SEEK_END)/128L);/* get real filesize      */
   lseek(fp, oldpos, SEEK_SET);         /* restore file position            */
}


  /**************************************************************************/
  /* put RBBS message file header                                           */
  /**************************************************************************/

void put_rbbs_hdr(int fp)
{
   long oldpos = lseek(fp, 0L, SEEK_SET);/* store file position             */

   lseek(fp, 0L, SEEK_SET);             /* seek to header                   */
   read(fp, (char *)&hdr, (int)sizeof(RBBSHDR));/* read header              */
   itos(high_msg, hdr.last_msg, 8);
   itos(num_users, hdr.user_count, 5);
   itos(next_rec, hdr.next_free_rec, 7);
   itos(last_rec, hdr.last_msg_rec, 7);
   lseek(fp, 0L, SEEK_SET);             /* seek to header                   */
   write(fp, (char *)&hdr, (int)sizeof(RBBSHDR));
   lseek(fp, oldpos, SEEK_SET);         /* restore file position            */
}


  /**************************************************************************/
  /* copy integer to non-terminated string, left adjusted                   */
  /**************************************************************************/

void itos(int num,char *dest,int len)
{
   char temp[12];

   memset(dest, ' ', len);              /* set field to spaces              */
   itoa(num, temp, 10);
   memcpy(dest, temp, strlen(temp));
}


/*--------------------------------------------------------------------------*/

