/****************************************************************************/
/* RBBSMNT.H for RBBSMNT v2.01, a maintenance utility for RBBS-PC           */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include <stdlib.h>
#include <malloc.h>
#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <fcntl.h>

  /**************************************************************************/
  /* define data                                                            */
  /**************************************************************************/

#define  PRGNAME       "RBBSMNT "
#define  VERSION       "v2.01"
#define  RELDATE       " of Januari 5, 1992 "
#define  OK            0
#define  ERROR         -1
#define  TRUE          1
#define  FALSE         0
#define  ALIVE         "\xE1"           /* active RBBS message              */
#define  TXTLEN        256              /* size of text buffers             */
#define  UBLOCK        256              /* # of in-core user records        */

  /**************************************************************************/
  /* structure to save msg info                                             */
  /**************************************************************************/

typedef struct
{
   int old_num;                         /* msg number before renum          */
   int new_num;                         /* msg number after renum           */
   int num_recs;                        /* number of record in this message */
   int msg_age;                         /* age of this msg                  */
   long msg_pos;                        /* position of this MSG in the file */
   char far *buf;                       /* pointer to in-memory msg buffer  */
} MSGINFO,*MSGINFO_PTR;

  /**************************************************************************/
  /* RBBS-PC messagefile header record structure (1st record of msg file)   */
  /**************************************************************************/

typedef struct
{
   char last_msg[8];                    /* ASCII number of last msg         */
   int joinsec;                         /* min level to join this conference*/
   char cur_caller[10];                 /* ASCII number of current caller   */
   char rsvd1[36];                      /* reserved                         */
   char user_count[5];                  /* # of entries in USERS file       */
   char spare[6];                       /* unused                           */
   char first_msg_rec[7];               /* # of first actual message record */
   char next_free_rec[7];               /* # of first available free record */
   char last_msg_rec[7];                /* # of records in this file        */
   char max_message[7];                 /* # of max messages in this file   */
   char rsvd3[31];                      /* reserved                         */
   char num_nodes[2];                   /* # of nodes using this file       */
} RBBSHDR,*RBBSHDR_PTR;

  /**************************************************************************/
  /* structure of a "node" record in the messages file                      */
  /**************************************************************************/

typedef struct
{
   char last_user[31];                  /* name of last user on this node   */
   int sysop_avail;                     /* sysop available indicator        */
   int sysop_annoy;                     /* sysop pagable indicator          */
   int sysop_next;                      /* if sysop wants system nect       */
   int printer_on;                      /* this node logs to printer        */
   int door_avail;                      /* indicates if DOORS are open      */
   int eight_bit;                       /* user logged on N,8,1             */
   char baud_rate[2];                   /* baudrate indicator               */
   int upper_case;                      /* user wants all UPPER case        */
   long bytes_xferd;                    /* bytes xferd in last up/down load */
   char batch_xfer[1];                  /* user can do batch transfer       */
   int graphics;                        /* user wants graphics and/or color */
   int sysop;                           /* if current user is SYSOP         */
   char active[1];                      /* this node has a user on-line now */
   int snoop;                           /* snoop for this node is on        */
   char modem_baud[5];                  /* modem to computer baudrate       */
   char logon_time[3];                  /* time user logged on (packed)     */
   char rsvd1[4];                       /* reserved                         */
   int priv_door;                       /* returning from private door      */
   char door_type[1];                   /* what external program was called */
   char protocol[1];                    /* current protocol used            */
   char rsvd2[1];                       /* reserved                         */
   int last_exit;                       /* last date RBBS-PC exited (packed)*/
   char rsvd3[7];                       /* reserved                         */
   char exit_time[5];                   /* last time RBBS-PC exited         */
   int arq;                             /* MNP/ARQ indicator                */
   char pui[8];                         /* PUI name                         */
   int local;                           /* local indicator                  */
   int local_port;                      /* no com port indicator            */
   char confername[8];                  /* name of current conference       */
   int time_credit;                     /* UL time credit                   */
   int rsvd4;                           /* reserved                         */
   int lastmenu;                        /* last menu user was in            */
   char ext_date[6];                    /* date (MMDDYY) of exit to protocol*/
   char ext_time[4];                    /* time (HHMM) of exit to protocol  */
} RBBSNODE,*RBBSNODE_PTR;

  /**************************************************************************/
  /* structure of a RBBS-PC message header                                  */
  /**************************************************************************/

typedef struct
{
   char private[1];                     /* contains * for private msg       */
   char msg_number[4];                  /* ASCII msg number                 */
   char msg_from[31];                   /* msg from                         */
   char msg_to[22];                     /* msg to                           */
   char enter_time[8];                  /* time msg was written             */
   char rsvd1[1];                       /* reserved                         */
   char enter_date[8];                  /* date msg was written             */
   char msg_subj[25];                   /* msg subject                      */
   char msg_pswd[15];                   /* password to read msg             */
   char msg_stat[1];                    /* active/killed msg                */
   char num_recs[4];                    /* # of record in this msg          */
   int msg_secy;                        /* msg security                     */
   char last_date[3];                   /* last date msg was read (packed)  */
   char last_time[3];                   /* last time msg was read (packed)  */
} RBBSMSG,*RBBSMSG_PTR;

  /**************************************************************************/
  /* structure of the RBBS users file records                               */
  /**************************************************************************/

typedef struct
{
   char user_name[31];                  /* user name (first & last)         */
   char password[15];                   /* user password                    */
   int user_level;                      /* user security level              */
   int times_on;                        /* times user has logged on         */
   int lastread;                        /* last msg read                    */
   char user_proto[1];                  /* user preferred protocol          */
   char graphics[1];                    /* user graphic preferences         */
   int margin;                          /* user msg margin                  */
   int user_options;                    /* user options                     */
   int subscribe;                       /* user registration date (packed)  */
   char pagelength[1];                  /* user pagelength                  */
   char rsvd1[1];                       /* reserved                         */
   char user_city[24];                  /* user city/state                  */
   char rsvd2[3];                       /* reserved                         */
   long files_today;                    /* files downloaded today           */
   long bytes_today;                    /* bytes downloaded today           */
   long bytes_down;                     /* bytes downloaded TOTAL           */
   long bytes_up;                       /* bytes uploaded TOTAL             */
   char last_on[14];                    /* last dat/time user logged on     */
   char last_list[3];                   /* date last listed files (packed)  */
   int down_files;                      /* files downloaded TOTAL           */
   int up_files;                        /* files uploaded TOTAL             */
   int elapsed;                         /* elapsed time during last call    */
} RBBSUSER,*RBBSUSER_PTR;

#include "prototype.h"                  /* fuction prototypes               */

/*--------------------------------------------------------------------------*/

