#include <stdio.h>

main(argc, argv)
unsigned int argc;
char **argv;
{
FILE *source, *dest, *temp;
char line_buf[128];
int f_flag = 0;

  if (argc != 4) {
    printf("usage: mv_line <source_file> <dest_file> <key>.\n");
    printf("This will move all lines beginning with <key> from\n");
    printf("<source_file> to <dest_file>. Lines may have upto 127 chars.\n");
    exit(1);
  }
  source = fopen(argv[1], "r");
  dest   = fopen(argv[2], "a");
  temp   = fopen("MV_LINE.$$$", "w");
  if (source == NULL) {
    printf("Sorry: cannot open source file: %s.\n", argv[1]);
    exit(1);
  }
  if (dest == NULL) {
    printf("Sorry: cannot open destination file: %s.\n", argv[2]);
    exit(1);
  }
  if (temp == NULL) {
    printf("Sorry: cannot create temporary file.\n");
    exit(1);
  }
  while (! feof(source)) {
    fgets(line_buf, 128, source);	/* get a line */
    if (cmp_case(argv[3], line_buf) == 0) {
      fputs(line_buf, dest);		/* move it to output. */
      f_flag++;
      continue;				/* don't copy to temp */
    }
    fputs(line_buf, temp);		/* copy no match line to temp */
  }
  if (! f_flag)
    printf("Sorry: there are no lines in \"%s\" that match \"%s\".\n",
      argv[1], argv[3]);
  fclose(source);			/* close all i/o streams */
  fclose(dest);
  fclose(temp);
  unlink(argv[1]);			/* destroy original */
  rename("MV_LINE.$$$", argv[1]);	/* rename temp to original */
  printf("Done. I moved %d line(s)\n", f_flag);
}
