
/******************************************************
 NEWZ news files generator for RBBS-PC ver 2.0
 Creates plain and ansi color text files from user
 generated text files with stop/start dates.

 Compiled under TURBO C++ 3.0 Small memory model.
 Copyright (c) 1992 by James P. Storch
 all right reserved

 Electric Harbor BBS (703) 730-0542
 ******************************************************/

#include <dos.h>
#include <stdio.h>
#include <dir.h>
#include <string.h>
#define FALSE 0
#define TRUE !FALSE
#define MAXLINE 160
int main(void);
void no_news(void);

FILE *infile;
FILE *outfile;
FILE *outfilec;
FILE *outfileg;

struct nwzf {              /* structure for holding nwz file info */
	char name[81];
	long start;
	long stop;
	};

struct nwzf nwz[50],temp;
struct date date;     /* date structure, from DOS.H                  */
struct ffblk ffblk;   /* dos file control block structure,from DOS.H */

long today;
char line_in[161];
char line_out[161];
char line_outc[161];
char line_outg[161];
int done,count,hi,lo;
int odd,z,x;
long year,month,day;

/**********************
 Box drawing characters
 **********************/

char tl[]= " ";
char tla[]=" (@)";

char tr[]= "Ŀ\n";
char tra[]="(@)\n";

char le[]= " o";
char lea[]="  | ";

char re[]= "o\n";
char rea[]=" | \n";

char bl[]= " ";
char bla[]=" (@)";

char br[]= "\n";
char bra[]="(@)\n";

char hb[]= "                                                                 ";

char hl[]= "";
char hla[]="-------------------------------------------------------------------------";


char main_path[80];      /* holds path for plain text file to create */
char mainc_path[80];     /*                ansi color file to create */
char maing_path[80];     /*                IBM char file to create   */
char nwz_search[80];     /*                search path and wildcard  */
char nwz_path[80];       /*                search path only          */
char ltk[80];

char esc[]="\x1b[";       /* start of ansi control string       */
char border[30];          /* holds ansi string for border color */
char title[30];           /*                       title color  */
char text[30];            /*                       text color   */
char normal[30];          /* ansi string to normalize at end    */

int main(void){

/************************************************
 Find out what today is and convert to a long int
 ************************************************/

getdate(&date);
today=date.da_day+(31*(long)date.da_mon)+(372*(long)date.da_year);

/************************************
 Open config file and get config info
 ************************************/

printf("--> Reading NEWZ.CFG\n");
if ((infile=fopen("newz.cfg","rt"))==NULL){
	printf("FAILURE TRYING TO OPEN NEWZ.CFG!\n");
	exit(1);
	}
/*******************************************
 Read the paths for files to read and create
 *******************************************/
fscanf(infile,"%s",main_path);
fscanf(infile,"%s",mainc_path);
fscanf(infile,"%s",maing_path);
fscanf(infile,"%s",line_in);
strcpy(nwz_search,line_in);
strcpy(nwz_path,strtok(line_in,"*"));

/***************************
 Get License to Kill setting
 ***************************/
fscanf(infile,"%s",ltk);

/*******************************************
 Convert color codes to ansi control strings
 *******************************************/
fscanf(infile,"%s",line_in);
strcpy(border,esc);
strcat(border,line_in);
strcat(border,"m");

fscanf(infile,"%s",line_in);
strcpy(title,esc);
strcat(title,line_in);
strcat(title,"m");

fscanf(infile,"%s",line_in);
strcpy(text,esc);
strcat(text,line_in);
strcat(text,"m");

fscanf(infile,"%s",line_in);
strcpy(normal,esc);
strcat(normal,line_in);
strcat(normal,"m");

fclose(infile);

/*************************************
 Find all .NWZ files in this directory
 *************************************/

printf("--> Looking for files matching '%s'\n",nwz_search);

if (findfirst(nwz_search,&ffblk,0)) no_news();

do{
	strcpy(nwz[count].name,nwz_path);
	strcat(nwz[count].name,ffblk.ff_name);
	printf("    %s found.\n", nwz[count].name);
	count++;
	if (count==50) {
		printf("    Stopping at 50th file!\n");
		break;
		}
	done = findnext(&ffblk);
	}while(!done);

/******************************************************
 Now, open each one and get stop & start info from each
 ******************************************************/

printf("--> Getting start and stop dates for %d files.\n",count);

for(x=0;x<count;x++){
	printf("    Reading stop/start date from %s\n",nwz[x].name);
	if ((infile=fopen(nwz[x].name,"rt"))==NULL){
		printf("FAILURE TRYING TO OPEN %s!\n",nwz[x].name);
		exit(1);
		}
	fscanf(infile,"%s",line_in);
	month= atoi(strtok(line_in,"/"));
	day = atoi(strtok(NULL,"/"));
	year= atoi(strtok(NULL,"\n"));
	if(year<1900) year+=1900;	   //Now you can enter 1992 or just 92
	nwz[x].start=day+(31*month)+(372*year);

	fscanf(infile,"%s",line_in);
	month= atoi(strtok(line_in,"/"));
	day = atoi(strtok(NULL,"/"));
	year= atoi(strtok(NULL,"\n"));
	if(year<1900) year+=1900;
	nwz[x].stop=day+(31*month)+(372*year);

	if(nwz[x].start<=today && nwz[x].stop >=today) z=TRUE;
	fclose(infile);
}

/********************************************
 Perform a quick sort of files by start date,
 so the most recent NWZ text are shown first
 ********************************************/
printf("--> Sorting by most recent start dates.\n");
for(hi=0;hi<count-1;hi++)
	for(lo=hi+1;lo<count;lo++)
		if (nwz[hi].start<nwz[lo].start)
		{	temp=nwz[hi];
			nwz[hi]=nwz[lo];
			nwz[lo]=temp;
		}

/***************************************
 License to Kill old files, if ltk="yes"
 ***************************************/
if(strnicmp(ltk,"yes",3)==0){
	printf("--> Licensed To Kill! Looking for OLD files.\n");
	for(x=0;x<count;x++){
		if(nwz[x].stop<today){
			printf("    Deleting %s\n",nwz[x].name);
			remove(nwz[x].name);
			}
		}
	} else printf("--> Not licensed to Kill, OLD files left alone.\n");

/************************************
 If no files are current do "no news"
 ************************************/
if (z==FALSE) no_news();

/********************************
 Open Main.nws for plain text and
 Mainc.nws for ansi colored text
 ********************************/

printf("--> Generating files:\n");
printf("    %s\n",main_path);
printf("    %s\n",mainc_path);
printf("    %s\n",maing_path);

if((outfile=fopen(main_path,"wt"))==NULL){
	printf("FAILURE TRYING TO OPEN MAIN.NWS!\n");
	exit(1);
	}

if((outfilec=fopen(mainc_path,"wt"))==NULL){
	printf("FAILURE TRYING TO OPEN MAINC.NWS!\n");
	exit(1);
	}

if((outfileg=fopen(maing_path,"wt"))==NULL){
	printf("FAILURE TRYING TO OPEN MAING.NWS!\n");
	exit(1);
	}

/***************************************************************
 Now, open the sorted files that have start dates prior or equal
 to today and stop dates after or equal to today
 ***************************************************************/
for(x=0;x<count;x++){
if(nwz[x].start <= today && nwz[x].stop >= today){
	printf("    Reading news data from %s\n",nwz[x].name);
	if ((infile=fopen(nwz[x].name,"rt"))==NULL){
		printf("FAILURE TRYING TO RE-OPEN %s!\n",nwz[x].name);
		exit(1);
		}
	/********************************************
	 Two dummy reads to skip start and stop dates
	 ********************************************/
	fgets(line_in,MAXLINE,infile);
	fgets(line_in,MAXLINE,infile);

	/************************************
	 Get title and format with top border
	 ************************************/
	fgets(line_in,MAXLINE,infile);
	strcpy(line_in,strtok(line_in,"\n"));
	/******************************
	 odd=1 if length of line is odd
	 ******************************/
	z=strlen(line_in);
	odd=z-((z/2)*2);

	/*******************
	 make plain top line
	 *******************/
	strcpy(line_out,tla);
	strncat(line_out,hla,(72-strlen(line_in)-2)/2);
	strcat(line_out,"]");
	strncat(line_out,line_in,strlen(line_in));
	strcat(line_out,"[");
	strncat(line_out,hla,(72-strlen(line_in)-2)/2+odd);
	strcat(line_out,tra);
	fputs(line_out,outfile);

	/**********************
	 make IBM char top line
	 **********************/
	strcpy(line_outg,tl);
	strncat(line_outg,hl,(72-strlen(line_in)-2)/2);
	strcat(line_outg,"");
	strncat(line_outg,line_in,strlen(line_in));
	strcat(line_outg,"");
	strncat(line_outg,hl,(72-strlen(line_in)-2)/2+odd);
	strcat(line_outg,tr);
	fputs(line_outg,outfileg);
	printf("%s",line_outg);

	/************************
	 make ansi color top line
	 ************************/
	strcpy(line_outc,border);
	strcat(line_outc,tl);
	strncat(line_outc,hl,(72-strlen(line_in)-2)/2);
	strcat(line_outc,"");
	strcat(line_outc,title);
	strncat(line_outc,line_in,strlen(line_in));
	strcat(line_outc,border);
	strcat(line_outc,"");
	strncat(line_outc,hl,(72-strlen(line_in)-2)/2+odd);
	strcat(line_outc,tr);
	fputs(line_outc,outfilec);

	/**************************************
	 Read line of text until EOF and format
	 **************************************/
		while(fgets(line_in,MAXLINE,infile)!=NULL){
			strcpy(line_in,strtok(line_in,"\n"));
			z=strlen(line_in);
			odd=z-((z/2)*2);

			/********************************************
			 create centered plain text line with borders
			 ********************************************/
			strcpy(line_out,lea);
			strncat(line_out,hb,(72-strlen(line_in))/2);
			strncat(line_out,line_in,strlen(line_in));
			strncat(line_out,hb,(72-strlen(line_in))/2+odd);
			strcat(line_out,rea);
			fputs(line_out,outfile);

			/******************************************
			 create centered IBM char line with borders
			 ******************************************/
			strcpy(line_outg,le);
			strncat(line_outg,hb,(72-strlen(line_in))/2);
			strncat(line_outg,line_in,strlen(line_in));
			strncat(line_outg,hb,(72-strlen(line_in))/2+odd);
			strcat(line_outg,re);
			fputs(line_outg,outfileg);
			printf("%s",line_outg);

			/*************************************************
			 create centered ansi color text line with borders
			 *************************************************/
			strcpy(line_outc,border);
			strcat(line_outc,le);
			strcat(line_outc,text);
			strncat(line_outc,hb,(72-strlen(line_in))/2);
			strncat(line_outc,line_in,strlen(line_in));
			strncat(line_outc,hb,(72-strlen(line_in))/2+odd);
			strcat(line_outc,border);
			strcat(line_outc,re);
			fputs(line_outc,outfilec);
			}

	/***********************************
	 make bottom border, plain & colored
	 ***********************************/
	strcpy(line_out,bla);
	strncat(line_out,hla,72);
	strcat(line_out,bra);
	fputs(line_out,outfile);
	fputs("{PB\n",outfile);

	strcpy(line_outg,bl);
	strncat(line_outg,hl,72);
	strcat(line_outg,br);
	fputs(line_outg,outfileg);
	fputs("{PB\n",outfileg);

	fputs(line_outg,outfilec);
	fputs(normal,outfilec);
	fputs("{PB\n",outfilec);
	printf("%s",line_outg);
	fclose(infile);
	}
}
/****************************
 close main.nws and mainc.nws
 all done.
 ****************************/

fcloseall();
printf("--> All done! Thank you for using NEWZ.");
return(0);
}

void no_news(void){

printf("    No applicable files found!\n");
printf("--> Generating NO NEWS message for:\n");
printf("    %s\n",main_path);
printf("    %s\n",mainc_path);
printf("    %s\n",maing_path);
if((outfile=fopen(main_path,"wt"))==NULL){
	printf("FAILURE TRYING TO OPEN MAIN.NWS!\n");
	exit(1);
	}

if((outfilec=fopen(mainc_path,"wt"))==NULL){
	printf("FAILURE TRYING TO OPEN MAINC.NWS!\n");
	exit(1);
	}

if((outfileg=fopen(maing_path,"wt"))==NULL){
	printf("FAILURE TRYING TO OPEN MAING.NWS!\n");
	exit(1);
	}

fputs(title,outfilec);
fputs("No news items today.\n",outfile);
fputs("No news items today.\n",outfilec);
fputs("No news items today.\n",outfileg);
fputs(normal,outfilec);

fcloseall();
printf("--> All done, Thank You for using NEWZ!\n");
exit(0);
}

