/****************************************************

 Compiled under TURBO C (2nd Ed). Small memory model.
 Copyright (c) 1991 by James P. Storch
 all right reserved

 Electric Harbor BBS (703) 730-0542
 ****************************************************/

#include <dos.h>
#include <stdio.h>
#include <dir.h>
#include <string.h>
#define FALSE 0
#define TRUE !FALSE

FILE *infile,*outfile;

struct date date;     		/* date structure, from DOS.H                  */
char line[150];
int x, next;

char quote_path[100];      	/* holds path for quote file to create */
char last_quote[100];

int main(void){

/***************
 Get todays date
 ***************/
getdate(&date); 	/* date.da_day date.da_mon date.da_year */

/************************************
 Open config file and get config info
 ************************************/
printf("\n\n\n--> Reading QUOTE.CFG\n");
if ((infile=fopen("quote.cfg","rt"))==NULL){
	printf("FAILURE TRYING TO OPEN QUOTE.CFG!\n");
	exit(1);
	}

/**************************************
 Read the path for quote file to create
 **************************************/
fgets(line,81,infile);
strncpy(quote_path,line,strlen(line)-1);

/*************************************
 Get the number of the last quote used
 *************************************/
fscanf(infile,"%d",&next);
printf("--> Next quote is %d.\n",next);
fclose(infile);

/*******************************
 Open the quote file for writing
 and quote.dat for reading
 *******************************/
printf("--> Opening quote file %s.\n",quote_path);
if((outfile=fopen(quote_path,"wt"))==NULL){
	printf("FAILURE TRYING TO CREATE %s!\n",quote_path);
	exit(1);
	}

printf("--> Opening quote.dat and getting next quote.\n");
if ((infile=fopen("QUOTE.DAT","rt"))==NULL){
	printf("FAILURE TRYING TO OPEN QUOTE.DAT!\n");
	exit(1);
	}

/******************************************
 Now, read past the last quote if quote.dat
 if EOF, reset to start
 ******************************************/
while(x<next){
if (fgets(line,81,infile)==NULL) {
	printf("    EOF encountered, reseting to first quote.\n");
	rewind(infile);
	next=0;
	break;
        }
if (strncmp(";",line,1)==0) x++;
}

/********************************
 Write to the quote file for NEWZ
 ********************************/
printf("--> This is todays quote:\n\n");

fprintf(outfile,"%d/%d/%d\n",date.da_mon,date.da_day,date.da_year);
fprintf(outfile,"%d/%d/%d\n",date.da_mon,date.da_day,date.da_year);
fprintf(outfile,"Quote of the Day\n");

for(;;){
fgets(line,81,infile);
if (!strncmp(";",line,1)) break;
if (!strncmp("-EOF-",line,5)) break;
fprintf(outfile,"%s",line);
printf("%s",line);
}
printf("\n");

/******************************
 close quote file and quote.dat
 all done.
 ******************************/

fclose(outfile);
fclose(infile);

/*************************************************
 Re-open config file and update next quote pointer
 *************************************************/
printf("--> Updating next quote pointer.\n");
printf("    Writing to QUOTE.CFG\n");
if ((outfile=fopen("quote.cfg","wt"))==NULL){
	printf("FAILURE TRYING TO RE-OPEN QUOTE.CFG!\n");
	exit(1);
	}

fprintf(outfile,"%s\n",quote_path);

/*************************************
 Get the number of the last quote used
 *************************************/
next++;
fprintf(outfile,"%d\n",next);
fclose(outfile);

printf("--> All done! Thank you for using QUOTE.");
return(0);
}


