/*
    CONVERT.PRG
    Author:   Eric J. Givler
    Language: Clipper 5.01, IDL v2.0 LIBRARY (BIT_AND, BIT_NOT, BIT_OR)
    Date:     02-22-91
    Mods:     01-08-92 (CVS.PRG, REAL2IEE.PRG)
    Mods:     05-30-92 (Rewrite for Clipper 5.01 and IDL Library)

    Previous version:
    Link:   CV_READ (Basic number reading by John Wright (in CV_READ.LIB)
            DECIMAL.C and SETBIT (C routines to do bit setting etc.)
            2BYTEDAT.C (converts the 2 Byte subscription date)
            MBF2NUM.C (converts the Microsoft Binary Format Numbers)
*/

#include "fileio.ch"
#include "user.ch"

FUNCTION Convert( UserFile )
LOCAL handle, length         // file handle, length of file
LOCAL recs, n                // records, pointer
LOCAL User_[U_LENGTH]        // the user data broken down
LOCAL UserBuffer             // Buffer to hold complete record
LOCAL numread                // number of records read
LOCAL bytesread              // number of bytes read (should = 128)
LOCAL optionstr              // options as a binary string

    UserFile := if( UserFile == NIL, 'USERS', UserFile )

    handle := fopen( UserFile, FO_READ )
    if (handle == F_ERROR)
        errorlevel(2)
        quit
    endif

    length := fseek(handle, 0, FS_END)
    recs   := length/128
    fseek( handle, 0 , FS_SET )

    if ! file('convert.dbf')
        MakeDBF()
    endif

    USE CONVERT NEW
    ZAP

    UserBuffer := space(128)
    numread    := 0

    do while ( bytesread := FREAD(handle, @UserBuffer, 128) ) == 128

        numread++
        //setpos(24, 0)
        //dispout( trans(numread,'99999')+':'+trans(recs,'99999') )

        FillRecord( User_, UserBuffer )

        if substr( User_[ U_NAME ], 1, 7) <> 'NEWUSER' .AND. ;
           asc(left( User_[ U_NAME ], 1)) <> 0         .AND. ;
           len(trim(substr( User_[ U_NAME ], 1, 31))) > 0

            dbappend()
            n := at(' ', User_[ U_NAME ])
            replace CONVERT->Firstname  with left( User_[ U_NAME ], n - 1), ;
                    CONVERT->Lastname   with substr( User_[ U_NAME ], n + 1), ;
                    CONVERT->Password   with User_[ U_PASSWORD ], ;
                    CONVERT->Seclevel   with User_[ U_SECURITY ], ;
                    CONVERT->CityState  with User_[ U_CITYSTATE ], ;
                    CONVERT->DateTime   with User_[ U_DATETIME ], ;
                    CONVERT->Ul         with User_[ U_ULS ], ;
                    CONVERT->Dl         with User_[ U_DLS ], ;
                    CONVERT->Elapsetime with User_[ U_ELAPTIME ], ;
                    CONVERT->ReadMsg    with User_[ U_LASTMSG ], ;
                    CONVERT->TimesOn    with User_[ U_TIMESON ], ;
                    CONVERT->RightMarg  with User_[ U_RMARGIN ], ;
                    CONVERT->PageLength with User_[ U_PAGELEN ], ;
                    CONVERT->Graphics   with User_[ U_GRAPHICS ]

            replace CONVERT->Protocol   with ;
                      if(User_[ U_PROTOCOL ]==' ', 'N', User_[ U_PROTOCOL ]), ;
                    CONVERT->EchoedBy   with ;
                      if(User_[ U_ECHOER ]==' ','R', User_[ U_ECHOER ]), ;
                    CONVERT->LastList   with ;
                      LastListed( User_[ U_LASTDIR ] ), ;
                    CONVERT->FDL_Today  with Cvs( User_[ U_DLTODAY ] ), ;
                    CONVERT->BDL_Today  with Cvs( User_[ U_BYTESDL ] ), ;
                    CONVERT->BDL_Ever   with Cvs( User_[ U_DLBYTES ] ), ;
                    CONVERT->BUL_Ever   with Cvs( User_[ U_ULBYTES ] )

            optionstr := Dec2Bin( User_[ U_OPTIONS ], 16 )
            replace CONVERT->Promptbell with BitSet(optionstr,1), ;
                    CONVERT->Expert     with BitSet(optionstr,2), ;
                    CONVERT->NullsOn    with BitSet(optionstr,3), ;
                    CONVERT->Uppercase  with BitSet(optionstr,4), ;
                    CONVERT->Linefeeds  with BitSet(optionstr,5), ;
                    CONVERT->Checkbull  with BitSet(optionstr,6), ;
                    CONVERT->Skipfiles  with BitSet(optionstr,7), ;
                    CONVERT->Autodl     with BitSet(optionstr,8), ;
                    CONVERT->Answerques with BitSet(optionstr,9), ;
                    CONVERT->Mailwait   with BitSet(optionstr,10), ;
                    CONVERT->Highliting with BitSet(optionstr,11), ;
                    CONVERT->Turbokey   with BitSet(optionstr,12)

            // TwoByte() makes the IDL calls.
            REPLACE CONVERT->Sub_Date   with TwoByte( User_[ U_SUBDATE ] )

        endif

    enddo

    fclose( handle )
    USE

RETURN NIL


/* ==========================================================================
    PadLc()
    SYNTAX: PadLc( string, length, Padchar )
    PURPOSE: Pad string to left with PadChar to total of (Length) chars
---------------------------------------------------------------------------*/
FUNCTION PadLc(String, Length, PadChar)
RETURN right(replicate(PadChar,Length)+String,Length)


/* ==========================================================================
    Num2Strg()
    SYNTAX: Num2Strg(Number, StringLen)
    PURPOSE: Convert number to string, length StringLen, padded to left
             with zeros.
---------------------------------------------------------------------------*/
FUNCTION Num2Strg(Number, StrgLen)
RETURN PadLc(ltrim(rtrim(str(Number,StrgLen))),StrgLen,"0")


/* ==========================================================================
    FillRecord()
    SYNTAX: FillRecord( UserArray[], UserBuffer )
    PURPOSE: Fills array with data from current buffer via USER.CH constants.
---------------------------------------------------------------------------*/
STATIC FUNCTION FillRecord( User_, UserBuffer )

    User_[ U_NAME ]     := SUBSTR(UserBuffer,1,31)
    User_[ U_PASSWORD ] := SUBSTR(UserBuffer,32,15)
    User_[ U_SECURITY ] := BIN2I(SUBSTR(UserBuffer,47,2))
    User_[ U_TIMESON ]  := BIN2I(SUBSTR(UserBuffer,49,2))
    User_[ U_LASTMSG ]  := BIN2I(SUBSTR(UserBuffer,51,2))
    User_[ U_PROTOCOL ] := SUBSTR(UserBuffer,53,1)
    User_[ U_GRAPHICS ] := ASC(SUBSTR(UserBuffer,54,1))
    User_[ U_RMARGIN ]  := BIN2I(SUBSTR(UserBuffer,55,2))
    User_[ U_OPTIONS ]  := BIN2I(SUBSTR(UserBuffer,57,2))
    User_[ U_SUBDATE ]  := SUBSTR(UserBuffer,59,2)
    User_[ U_PAGELEN ]  := ASC(SUBSTR(UserBuffer,61,1))
    User_[ U_ECHOER ]   := SUBSTR(UserBuffer,62,1)
    User_[ U_CITYSTATE ]:= SUBSTR(UserBuffer,63,24)
    User_[ U_MACHINE ]  := SUBSTR(UserBuffer,87,3)
    User_[ U_DLTODAY ]  := SUBSTR(UserBuffer,90,4)
    User_[ U_BYTESDL ]  := SUBSTR(UserBuffer,94,4)
    User_[ U_DLBYTES ]  := SUBSTR(UserBuffer,98,4)
    User_[ U_ULBYTES ]  := SUBSTR(UserBuffer,102,4)
    User_[ U_DATETIME ] := SUBSTR(UserBuffer,106,14)
    User_[ U_LASTDIR ]  := SUBSTR(UserBuffer,120,3)
    User_[ U_DLS ]      := BIN2I(SUBSTR(UserBuffer,123,2))
    User_[ U_ULS ]      := BIN2I(SUBSTR(UserBuffer,125,2))
    User_[ U_ELAPTIME ] := BIN2I(SUBSTR(UserBuffer,127,2))

RETURN NIL


/* ==========================================================================
    MakeDBF()
    SYNTAX: MakeDBF()
    PURPOSE: Creates the Convert.dbf file.
---------------------------------------------------------------------------*/
STATIC FUNCTION MAKEDBF()
LOCAL dbf_

    dbf_ := {}
    aadd( dbf_, { "FIRSTNAME", "C", 15, 0 } )
    aadd( dbf_, { "LASTNAME",  "C", 20, 0 } )
    aadd( dbf_, { "PASSWORD",  "C", 15, 0 } )
    aadd( dbf_, { "SECLEVEL",  "N",  5, 0 } )
    aadd( dbf_, { "CITYSTATE", "C", 24, 0 } )
    aadd( dbf_, { "DATETIME",  "C", 14, 0 } )
    aadd( dbf_, { "LASTLIST",  "D",  8, 0 } )
    aadd( dbf_, { "UL",        "N",  5, 0 } )
    aadd( dbf_, { "DL",        "N",  5, 0 } )
    aadd( dbf_, { "ELAPSETIME","N",  5, 0 } )
    aadd( dbf_, { "READMSG",   "N",  5, 0 } )
    aadd( dbf_, { "TIMESON",   "N",  5, 0 } )
    aadd( dbf_, { "FDL_TODAY", "N",  8, 0 } )
    aadd( dbf_, { "BDL_TODAY", "N",  8, 0 } )
    aadd( dbf_, { "BDL_EVER",  "N",  8, 0 } )
    aadd( dbf_, { "BUL_EVER",  "N",  8, 0 } )
    aadd( dbf_, { "ECHOEDBY",  "C",  1, 0 } )
    aadd( dbf_, { "PROMPTBELL","L",  1, 0 } )
    aadd( dbf_, { "EXPERT",    "L",  1, 0 } )
    aadd( dbf_, { "NULLSON",   "L",  1, 0 } )
    aadd( dbf_, { "UPPERCASE", "L",  1, 0 } )
    aadd( dbf_, { "LINEFEEDS", "L",  1, 0 } )
    aadd( dbf_, { "CHECKBULL", "L",  1, 0 } )
    aadd( dbf_, { "SKIPFILES", "L",  1, 0 } )
    aadd( dbf_, { "AUTODL",    "L",  1, 0 } )
    aadd( dbf_, { "ANSWERQUES","L",  1, 0 } )
    aadd( dbf_, { "MAILWAIT",  "L",  1, 0 } )
    aadd( dbf_, { "HIGHLITING","L",  1, 0 } )
    aadd( dbf_, { "TURBOKEY",  "L",  1, 0 } )
    aadd( dbf_, { "RIGHTMARG", "N",  5, 0 } )
    aadd( dbf_, { "PAGELENGTH","N",  2, 0 } )
    aadd( dbf_, { "SUB_DATE",  "D",  8, 0 } )
    aadd( dbf_, { "GRAPHICS",  "N",  2, 0 } )
    aadd( dbf_, { "PROTOCOL",  "C",  1, 0 } )
    dbcreate( "CONVERT.DBF", dbf_ )

RETURN NIL


/* ==========================================================================
    Cvs()
    SYNTAX: Cvs( Four_Bytes )
    PURPOSE: Returns the actual number from the BASIC MBF MKS() four bytes.
---------------------------------------------------------------------------*/
STATIC FUNCTION CVS(_mbf)
local retval := 0, x1 := "", k, sign, exponent, fraction

    if asc(substr(_mbf,4,1)) != 0
        for k := len(_mbf) to 1 step -1
            x1 += Dec2bin(asc(substr(_mbf,k,1)),8)
        next k
        sign     := (substr(x1,9,1) == "1")
        exponent := Bin2dec(substr(x1,1,8)) - 128
        fraction := Bin2dec("1"+substr(x1,10)) / (2**24 )
        retval   := if(sign,-1,1) * (fraction * (2**exponent))
    endif

RETURN retval


/* ==========================================================================
    Bin2Dec()
    SYNTAX: Bin2Dec( string )
    PURPOSE: Returns numeric based on binary string, ie. "00010001"
---------------------------------------------------------------------------*/
STATIC FUNCTION BIN2DEC(_string)
local l, t, n := 0

    l := len(_string)
    for t := 1 to l
        n += if(substr(_string,t,1)=="1",2^(l-t),0)
    next t

RETURN (n)


/* ==========================================================================
    Dec2Bin()
    SYNTAX: Dec2Bin( number, n )
    PURPOSE: Return a binary string "n" characters in length.
---------------------------------------------------------------------------*/
STATIC FUNCTION DEC2BIN(_number, n)
local tmp := _number, retval := "", remd, quot

    do while .t.
        quot  := int(tmp/2)
        remd  := abs(tmp) - 2*abs(quot)
        retval:= substr("01",remd+1,1)+retval
        if quot==0
            exit
        endif
        tmp   := quot
    enddo

    * Pad to n "digits"
    do while len(retval) < n
        retval := "0" + retval
    enddo

RETURN retval


// ==========================[ BitSet ]======================================
STATIC FUNCTION BITSET( string, n )
LOCAL l := len( string )
RETURN (substr( string, (l+1)-n, 1) == "1")


/* ==========================================================================
    LastListed()
    SYNTAX: LastListed( Three_Bytes )
    PURPOSE: Returns dBASE date from RBBS-PC 3 byte Last Listed Format
---------------------------------------------------------------------------*/
STATIC FUNCTION LASTLISTED( LastDir )
LOCAL Ye, Mo, Da, TempStr

    Ye := Num2Strg( asc(substr(LastDir,1,1)),2)
    Mo := Num2Strg( asc(substr(LastDir,2,1)),2)
    Da := Num2Strg( asc(substr(LastDir,3,1)),2)
    Tempstr := ctod(Mo + "/" + Da + "/" + Ye)

RETURN if(empty(TempStr), ctod('01/01/80'), TempStr)


/* ==========================================================================
    TwoByte()
    SYNTAX: TwoByte( RBBS_twobytes )
    PURPOSE: Return a dBASE date from RBBS-PC 2 byte "crunched" date.
---------------------------------------------------------------------------*/
STATIC FUNCTION TWOBYTE( two_bytes )
LOCAL b1 := substr( two_bytes, 1, 1 ), ;
      b2 := substr( two_bytes, 2, 1 )
LOCAL nYear, nMonth, nDay

    nYear  := BIT_AND(asc( b1 ), BIT_NOT( 1)) / 2 + 1980
    nMonth := BIT_OR( asc( b2 ) / 32, (BIT_AND( asc( b1 ), 1 ) * 8) )
    nDay   := BIT_AND( asc( b2 ), BIT_NOT( 224 ) )

RETURN ctod( trans(nMonth, '99') + '/' + trans( nDay, '99' ) + '/' + ;
             trans(nYear, '9999') )
