Program Convert2;
{ AUTHOR: (c)1989-1992, Eric J. Givler, All Rights Reserved }

Uses Crt,
     Dos,
     TPDB,
     TPDBStr;

{ The RBBS-PC USERS file contains information unique for each
  RBBS-PC user who logs on.  It is a random file with 128-byte
  records.  The layout of each users record within the USERS
  file is as follows:

Position      Length  Description
  1 - 31	  31  Users first and last name (separated by a blank).
 32 - 46	  15  Users password for logon.
 47 - 48	   2  Users security level (permanent).
 49 - 62	  14  Users logon options (see detail breakdown below).
 63 - 86	  24  City and state from which the user is calling.
 87 -105	  19  ---- RESERVED FOR FUTURE USE ----
106 -119	  14  Date and time the user was last on (MM-DD-YY HH:MM).
120 -122	   3  Date the user last listed a directory.
123 -124	   2  Number of downloads done by the user.
125 -126	   2  Number of uploads done by the user.
127 -128	   2  Elapsed time the user was on for day of last access. }

TYPE
    FourByteArray = Array[1..4] of byte;
    hexstr = string[4];

   UserRec = RECORD
      Name       : ARRAY[1..31] OF CHAR;
      PassWord   : ARRAY[1..15] OF CHAR;
      SecLevel   : INTEGER;

      (* Options : ARRAY[1..14] OF CHAR; *)
      TimesOn    : INTEGER;
      LastMsg    : INTEGER;
      Protocol   : CHAR;
      Ug         : CHAR;
      RMargin    : INTEGER;
      Options    : INTEGER;
      SubDate    : ARRAY[1..2] OF CHAR;    {?}
      PageLength : CHAR;
      Echoer     : CHAR;                     { I, C, R }

      CityState  : ARRAY[1..24] OF CHAR;
      Machine    : ARRAY[1..3] OF BYTE;     (* Actually RESERVED   *)
      DLToday    : FourByteArray;           (* number of downloads *)
      BytesDL    : FourByteArray;           (* BYTES DL TODAY      *)
      DLBytes    : FourByteArray;           (* total bytes DL EVER *)
      ULBytes    : FourByteArray;           (* BYTES UL EVER       *)
      DateTime   : ARRAY[1..14] OF CHAR;
      LastDir    : ARRAY[1..3] OF BYTE;
      DLS        : INTEGER;
      ULS        : INTEGER;
      ElapsedTime: INTEGER;
   END;

VAR
    User     : UserRec;
    UserFile : File of UserRec;
    IntStr   : String[2];
    IntStr4  : String[4];
    IntStr5  : String[5];
    IntStr7  : String[7];
    Ye,Mo,Da : Byte;
    StrYe,
    StrMo,
    StrDa    : String[2];
    TempStr  : String[8];
    i        : integer;
    Graphics : integer;
    BigBool  : Boolean;
    RBBS     : ^DBF;

{ Basic2TP returns a longint of a QuickBASIC numeric stored as
  a 4byte string.  QuickBASIC displays this via CVS() }
FUNCTION Basic2TP(b4 : fourbytearray) : longint;
var r :real;
   b6 :array[0..5] of byte absolute r;
begin
    b6[0] := b4[4];
    b6[1] := 0;
    b6[2] := 0;
    b6[3] := b4[1];
    b6[4] := b4[2];
    b6[5] := b4[3];
    basic2TP := trunc(r);
end;  {basic2TP}


BEGIN
   Writeln('CONVERT v1.21b, (c)1989-1992, E. Givler, All Rights Reserved.');
   IF ParamCount <> 2 THEN Begin
      Writeln('Syntax: CONVERT <UserFile> <File.DBF>');
      Halt;
   End;

   Assign(UserFile,ParamStr(1));
   Reset(UserFile);
   New(RBBS,Init(ParamStr(2)));
   RBBS^.Zap;

   While NOT Eof(UserFile) Do Begin
     Read(UserFile,User);
     IF (Copy(User.Name,1,7) <> 'NEWUSER') AND (User.Name[1] <> #0) AND
        (LENGTH(RTRIM(User.Name)) > 0) THEN Begin
        RBBS^.NewDBRec;
        RBBS^.Repl(1,COPY(User.Name, 1, POS(' ',User.Name) -1));
        i := LENGTH(User.Name);  (* 31 *)
        WHILE COPY(User.Name, i, 1) = ' ' DO i := i - 1;
        RBBS^.Repl(2,COPY(User.Name, POS(' ',User.Name) + 1, i));
        RBBS^.Repl(3,User.PassWord);
        Str(User.SecLevel : 5 ,IntStr5);
        RBBS^.Repl(4,IntStr5);
        RBBS^.Repl(5,User.CityState);
        RBBS^.Repl(6,User.DateTime);

        if User.LastDir[1] <> 32 then
        begin
            Ye := User.LastDir[1];
            Mo := User.LastDir[2];
            Da := User.LastDir[3];
            Str(Ye : 2,StrYe);
            Str(Mo : 2,StrMo);
            Str(Da : 2,StrDa);
            IF Ye < 10 THEN StrYe := '0'+LTRIM(StrYe);
            IF Mo < 10 THEN StrMo := '0'+LTRIM(StrMo);
            IF Da < 10 THEN StrDa := '0'+LTRIM(StrDa);
            IF StrYe = '00' THEN StrYe := ' ';
            IF StrMo = '00' THEN StrMo := ' ';
            IF StrDa = '00' THEN StrDa := ' ';
            TempStr := '19'+StrYe+StrMo+StrDa;
        end
        else
            TempStr := '19800101';
        IF (RTRIM(TempStr) = '19') THEN RBBS^.Repl(7,'19800101')
           ELSE RBBS^.Repl(7,TempStr);

        Str(User.ULS : 5,IntStr5);
        RBBS^.Repl(8,IntStr5);
        Str(User.DLS : 5,IntStr5);
        RBBS^.Repl(9,IntStr5);
        Str(User.ElapsedTime : 5,IntStr5);
        RBBS^.Repl(10,IntStr5);
        Str(User.LastMsg : 5, IntStr5);
        RBBS^.Repl(11, IntStr5);
        Str(User.TimesOn : 5, IntStr5);
        RBBS^.Repl(12, IntStr5);

        STR(Basic2TP(User.DLToday) : 2, IntStr);
        RBBS^.Repl(13, IntStr);
        STR(Basic2TP(User.BytesDL) : 7, IntStr7);
        RBBS^.Repl(14, IntStr7);
        STR(Basic2TP(User.DLBytes) : 8, TempStr);
        RBBS^.Repl(15, TempStr);
        STR(Basic2TP(User.ULBytes) : 8, TempStr);
        RBBS^.Repl(16, TempStr);

        IF User.Echoer = ' ' THEN RBBS^.Repl(17, 'R')
           ELSE RBBS^.Repl(17, User.Echoer);
        BigBool := (User.Options AND 1) > 0;
        IF BigBool THEN RBBS^.Repl(18, 'T') ELSE RBBS^.Repl(18, 'F');
        BigBool := (User.Options AND 2) > 0;
        IF BigBool THEN RBBS^.Repl(19, 'T') ELSE RBBS^.Repl(19, 'F');
        BigBool := (User.Options AND 4) > 0;
        IF BigBool THEN RBBS^.Repl(20, 'T') ELSE RBBS^.Repl(20, 'F');
        BigBool := (User.Options AND 8) > 0;
        IF BigBool THEN RBBS^.Repl(21, 'T') ELSE RBBS^.Repl(21, 'F');
        BigBool := (User.Options AND 16) > 0;
        IF BigBool THEN RBBS^.Repl(22, 'T') ELSE RBBS^.Repl(22, 'F');
        BigBool := (User.Options AND 32) > 0;
        IF BigBool THEN RBBS^.Repl(23, 'T') ELSE RBBS^.Repl(23, 'F');
        BigBool := (User.Options AND 64) > 0;
        IF BigBool THEN RBBS^.Repl(24, 'T') ELSE RBBS^.Repl(24, 'F');
        BigBool := (User.Options AND 128) > 0;
        IF BigBool THEN RBBS^.Repl(25, 'T') ELSE RBBS^.Repl(25, 'F');
        BigBool := (User.Options AND 256) > 0;
        IF BigBool THEN RBBS^.Repl(26, 'T') ELSE RBBS^.Repl(26, 'F');
        BigBool := (User.Options AND 512) > 0;
        IF BigBool THEN RBBS^.Repl(27, 'T') ELSE RBBS^.Repl(27, 'F');
        BigBool := (User.Options AND 1024) > 0;
        IF BigBool THEN RBBS^.Repl(28, 'T') ELSE RBBS^.Repl(28, 'F');
        BigBool := (User.Options AND 2048) > 0;
        IF BigBool THEN RBBS^.Repl(29, 'T') ELSE RBBS^.Repl(29, 'F');

        Str(User.RMargin : 5, IntStr5);
        RBBS^.Repl(30, IntStr5);
        Str(ORD(User.PageLength) : 2, IntStr);
        RBBS^.Repl(31, IntStr);

        i := (ORD(User.SubDate[1]) AND NOT 1) div 2 + 1980;
        Mo := (ord(user.subdate[2]) div 32) or
              ((ord(user.subdate[1]) and 1) * 8);
        Da := ord(user.subdate[2]) and not 224;
        Str(i : 4, IntStr4);
        Str(Mo : 2, StrMo);
        Str(Da : 2, StrDa);
        IF Mo < 10 Then StrMo := '0'+LTRIM(StrMo);
        IF Da < 10 THEN StrDa := '0'+LTRIM(StrDa);
        TempStr := IntStr4+StrMo+StrDa;
        RBBS^.Repl(32,TempStr);

        Graphics := ORD(User.Ug);
        Str(Graphics : 2, IntStr);
        RBBS^.Repl(33, IntStr);
        IF User.Protocol = ' ' THEN RBBS^.Repl(34, 'N')
           ELSE RBBS^.Repl(34,User.Protocol);
        RBBS^.AddDBRec;
     End;
   End;
   Close(UserFile);
   DISPOSE(RBBS,Done);
END. { Convert2.pas }
