/*  VARMOD.C
 *--------------------------------------------------------------------------
 *
 *  Converts RBBS-VAR.BAS to RBBS-VAR.MOD
 *
 */
#include <stdio.h>
#include <string.h>
void main(int argc ,char *argv[] )
{
	FILE *fpvar, *fpmod, *fptmp;
	char s[256];
	int  zfs_written = 0;

	if (argc != 2 )
		{
		printf("Usage: VARMOD Merge File Name\n" );
		return;
		}
	fpvar = fopen("RBBS-VAR.BAS" ,"rt" );
	if (fpvar == NULL )
		{
		printf("Can't Find RBBS-VAR.BAS... Aborted.\n" );
		return;
		}
	fpmod = fopen("RBBS-VAR.MOD" ,"wt" );
	if (fpmod == NULL )
		{
		printf("Can't Write RBBS-VAR.MOD... Aborted.\n" );
		return;
		}
	fptmp = fopen("RBBS-VAR.TMP" ,"wt" );
	if (fptmp == NULL )
		{
		printf("Can't Write RBBS-VAR.TMP... Aborted.\n" );
		return;
		}
	strupr(argv[1] );
	while (1 )
		{
		if (fgets(s ,256 ,fpvar ) == NULL )
			break;
		if (strncmp(s ,"DEF FN" ,6 ) == 0 )
			{
			fprintf(fpmod ,"' %s" ,s );
			}
		else if (strstr(s ,"ZFullScreenEditor" ) != NULL )
			{
			continue;
			}
		else
			{
			if (strstr(argv[1] ,"TOG" ) != 0 && !zfs_written )
				{
				int i = 0;
				while (s[i] != '\0' )
					{
					if (s[i] != ' ' && s[i] != '\t' )
						{
						if (strcmp(&s[i] ,"ZFullScreenEditor" ) > 0 )
							{
							while (i > 0 )
								{
								fputc(' ' ,fpmod );
								fputc(' ' ,fptmp );
								i--;
								}
							fputs("ZFullScreenEditor, _\n" ,fpmod );
							fputs("ZFullScreenEditor, _\n" ,fptmp );
							zfs_written = 1;
							}
						break;
						}
					i++;
					}
				}
			fputs(s ,fpmod );
			}
		fputs(s ,fptmp );
		}
	fclose(fpvar );
	fclose(fpmod );
	fclose(fptmp );

	unlink("RBBS-VAR.BAS" );
	rename("RBBS-VAR.TMP" ,"RBBS-VAR.BAS" );
}
