@Echo off
Rem  Doors Batch File for The Abacus - Node 1
Rem  Nodes 2 and 3 have similar batch files with changes for the bbs
Rem  directory, comport and irq where applicable.

Rem  Doors marked with an asterisk don't work when Use Serial Ports
Rem  is set to "No" in Desqview. (Saying "Yes" will slow the system down.)
Rem  Most of these are Pcboard games and others that won't work on Com3
Rem  using irq5 (non-standard irq), so I have them disabled, since my 4-port
Rem  serial card won't allow the system to share irq's.
Rem  If anyone knows how I can get these games working, I'd appreciate
Rem  your advice.

Echo %5 %6 entered %1 on %_date at %_time. >>e:\bu\dsz1.log
Echo %5 %6 entered %1 at %_time on node %node. >> c:\bbs\s\bullet18.msg

Rem Online Games
if (%1)==() goto error
if (%1)==(arena) goto arena
if (%1)==(bgame) goto bgame*
if (%1)==(barons) goto barons
if (%1)==(bsb) goto bsb*
if (%1)==(bjack) goto bjack*
if (%1)==(chess) goto chess*
if (%1)==(crash) goto crash*
if (%1)==(dnd) goto dnd
if (%1)==(drawpoke) goto drawpoke
if (%1)==(decoder) goto decoder*
if (%1)==(double) goto double
if (%1)==(empire) goto empire
if (%1)==(fifi) goto fifi*
if (%1)==(fishing) goto fishing
if (%1)==(galwar) goto galwar
if (%1)==(geop) goto geop
if (%1)==(globewar) goto globewar
if (%1)==(golf) goto golf
if (%1)==(gupsup) goto gupsup*
if (%1)==(hangman) goto hangman
if (%1)==(indy) goto indy
if (%1)==(keno) goto keno*
if (%1)==(life) goto life*
if (%1)==(match) goto match
if (%1)==(melee) goto melee
if (%1)==(murder) goto murder*
if (%1)==(othello) goto othello*
if (%1)==(overkill) goto overkill
if (%1)==(phant) goto phant
if (%1)==(pimp) goto pimp
if (%1)==(pit) goto pit
if (%1)==(planet) goto planet
if (%1)==(realms) goto realms
if (%1)==(robot) goto robot
if (%1)==(scrabble) goto scrabble
if (%1)==(sharx) goto sharx*
if (%1)==(solitree) goto solitree
if (%1)==(solpoker) goto solpoker*
if (%1)==(sslot) goto sslot
if (%1)==(triyat) goto triyat
if (%1)==(twars) goto twars*
if (%1)==(wheel) goto wheel*
if (%1)==(yat) goto yat
if (%1)==(yt) goto yt*
if (%1)==(zag) goto zag
if (%1)==(zodiac) goto zodiac*

Rem Doorway Menu
if (%1)==(educ) goto educ
if (%1)==(fin) goto fin
if (%1)==(games) goto games

Rem Main Menu
if (%1)==(ansi) goto ansi 
if (%1)==(doordos) goto doordos
if (%1)==(refund) goto refund
if (%1)==(silver) goto silver

Rem Trivia Menu
if (%1)==(alaska) goto alaska*
if (%1)==(computer) goto computer*
if (%1)==(disney) goto disney*
if (%1)==(emerg) goto emerg*
if (%1)==(hobbit) goto hobbit*
if (%1)==(movie) goto movie*
if (%1)==(potpourr) goto potpourr*
if (%1)==(rockroll) goto rockroll*
if (%1)==(sex) goto sex*
if (%1)==(sports) goto sports*
if (%1)==(startrek) goto startrek*
if (%1)==(televis) goto televis*

Rem Download Tag
if (%1)==(tagg) goto tagg
if (%1)==(tagy) goto tagy
if (%1)==(tagz) goto tagz


:Error
Echo An error has occurred.  Please try again, or please inform > com2
Echo Deb that the batch file is messed up.  Thank you.   > com2
goto end

:Arena
cd \bbs\games\arena
if exist in.use goto inuse
copy c:\bin\in.use
copy \bbs\dorinfo1.def
arena1
del in.use
del dorinfo1.def
goto end

:Barons
cd \bbs\games\barons
if exist in.use goto inuse
copy c:\bin\in.use
barons 1 c:\bbs QBBS
del in.use
goto end

:Bgame
goto end
dm 1 pcb14 * c:\bbs\games\bgame\
cd \bbs\games\bgame
if exist in.use goto inuse
copy c:\bin\in.use
bgame bgame.cfg
del in.use
del pcboard.*
goto end

:Bjack
cd \bbs\games\black
if exist in.use goto inuse
copy c:\bin\in.use
copy 21_1.cfg 21.cfg
21 21.cfg
copy 21.dat c:\bbs\s
del in.use
goto end

:Bsb
dm 1 pcb12 * *
cd \bbs\games\bsb
if exist in.use goto inuse
copy c:\bin\in.use
baybull2 bsb1.cfg
bsbscore
del in.use
goto end

:Chess
cd \bbs\games\chessmst
if exist in.use goto inuse
copy c:\bin\in.use
cmagic c:\bbs\dorinfo1.def
del in.use
goto end

:Crash
dm 1 pcb14 * *
cd \bbs\games\crash
if exist in.use goto inuse
copy c:\bin\in.use
copy crash1.cfg crash.cfg
crash crash.cfg
del in.use
goto end

:Decoder
dm 1 pcb14 * *
cd \bbs\games\decoder
if exist in.use goto inuse
copy c:\bin\in.use
decode6 decode1.cfg
copy decode.dat c:\bbs\s\decode.msg
del in.use
goto end

:Dnd
dm 1 pcb14 * *
cd\bbs\games\dnd
Set dndbbs=c:\bbs\games\dnd\
set dnddat=c:\bbs\games\dnd\
set dnddoc=c:\bbs\games\dnd\
set dndtemp=c:\bbs\games\dnd\
set dnddoor=c:\bbs\
cd\bbs\games\dnd
dndbbs 1
unset dndbbs
unset dnddat
unset dnddoc
unset dndtemp
unset dnddoor
goto end

:Double
cd\bbs\games\double
if exist in.use goto inuse
copy c:\bin\in.use
copy double1.cfg doublest.cfg
doublest doublest.cfg
del in.use
goto end

:Drawpoke
cd\bbs\games\poker
if exist in.use goto inuse
copy c:\bin\in.use
copy draw1.cfg drawpoke.cfg
drawpoke drawpoke.cfg
del in.use
goto end

:Empire
cd \bbs\games\empire
copy c:\bbs\dorinfo1.def
empire c:\bbs 2 -fdorinfo1.def
copy scores.txt c:\bbs\s\empire.msg
del dorinfo1.def
goto end

:Fifi
dm 1 pcb12 * *
cd \bbs\games\fifi
if exist in.use goto inuse
copy c:\bin\in.use
copy fifi1.cfg fifi.cfg
fifi fifi.cfg
del in.use
goto end

:Fishing
rem dm 1 pcb14 * *
cd\bbs\games\fish
if exist in.use goto inuse
copy c:\bin\in.use
rem fishing 5 c:\bbs /b19200
fishing 1 c:\bbs 1 /b19200
fishtext c:\bbs\s\fish.msg c:\bbs\s\fish.clr
del in.use
goto end

:Galwar
qdoor 1 c:\bbs\games\galwar
cd \bbs\games\galwar
if exist in.use goto inuse
copy c:\bin\in.use
copy galwar1.ctl galwar.ctl
twars
copy rankings.gw c:\bbs\s
copy log.gw c:\bbs\s
del in.use
del pcboard.*
goto end

:Geop
dm 1 pcb12 * c:\bbs\games\geo\
cd \bbs\games\geo
if exist in.use goto inuse
copy c:\bin\in.use
copy cfg1.dor config.dor
rem geop c:\bbs\games\geo\pcboard.sys
geop c:\bbs\games\geo
del pcboard.*
del in.use
goto end

:Globewar
cd\bbs\games\globewar
if exist in.use goto inuse
copy c:\bin\in.use
war /r c:\bbs\dorinfo1.def
del *.lok
del in.use
goto end

:Golf
cd\bbs\games\golf
if exist in.use goto inuse
copy c:\bin\in.use
copy golf-st1.cfg golf-st.cfg
golf-st golf-st.cfg
del in.use
goto end

:Gupsup
dm 1 pcb14 * *
cd \bbs\games\guppies
if exist in.use goto inuse
copy c:\bin\in.use
gupsup4 gup1.cfg
copy guppies.dat c:\bbs\s\guppies.msg
del in.use
goto end

:Hangman
cd \bbs\games\hangman
if exist in.use goto inuse
copy c:\bin\in.use
copy hang1.cfg hang.cfg
hang hang.cfg /s
del in.use
goto end

:Indy
cd\bbs\games\indy
if exist in.use goto inuse
copy c:\bin\in.use
indiana c:\bbs\dorinfo1.def
del in.use
goto end

:Keno
dm 1 pcb12 * *
cd \bbs\games\keno
if exist in.use goto inuse
copy c:\bin\in.use
keno 1
del in.use
goto end

:Life
cd \bbs\games\life
if exist in.use goto inuse
copy c:\bin\in.use
lifespan 2 19200 1 %2 %4 %5 1
del in.use
goto end

:Match
cd\bbs\games\match
if exist in.use goto inuse
copy c:\bin\in.use
copy drmatch1.dr drmatch.dr
drmatch
del in.use
goto end

:Melee
cd\bbs\games\melee
if exist in.use goto inuse
copy c:\bin\in.use
copy melee1.cfg melee.cfg
melee
del in.use
goto end

:Murder
dm 1 pcb14 * *
cd \bbs\games\mm
if exist in.use goto inuse
copy c:\bin\in.use
copy mm1.cfg murder.cfg
murder murder.cfg
del in.use
goto end

:Othello
qdoor 2 c:\bbs
cd \bbs\games\othello
if exist in.use goto inuse
copy c:\bin\in.use
copy tfl1.cfg tfl.cfg
tflip tfl.cfg
del in.use
goto end

:Overkill
cd\bbs\games\oo
if exist in.use goto inuse
copy c:\bin\in.use
ooinfo 5 c:\bbs\ 1
maintoo
ooii
topten
del in.use
goto end

:Pimp
rem qdoor 0 c:\bbs
cd\bbs\games\pimp
if exist in.use goto inuse
copy c:\bin\in.use
lockbaud 2 19200 N 8 1
pimpwars /R /2 /c:\bbs
del in.use
goto end

:Pit
cd \bbs\games\pit
rem copy \bbs\dorinfo1.def
rem if exist in.use goto inuse
rem copy c:\bin\in.use
rem copy pit1.cfg pit01.cfg
pit /NODE01
rem del in.use
rem del dorinfo1.def
goto end

:Phant
cd \bbs\games\phant
rem phant c:\bbs\dorinfo1.def port:02f8:3 port:f:2
phant c:\bbs\dorinfo1.def
goto end

:Planet
dm 1 mgw * c:\bbs\games\planet\
cd \bbs\games\planet
if exist in.use goto inuse
copy c:\bin\in.use
copy pbust1.cfg pbustprm.txt
pbexec pbustprm.txt
pbplay pbustprm.txt
del in.use
del userinfo.txt
goto end

:Realms
cd \bbs\games\realms
if exist in.use goto inuse
copy c:\bin\in.use
copy setup1.sr setup.sr
copy setup1.dat srsetup.dat
srdoor 2
srlock 19200
sre
del in.use
goto end

:Robot
cd \bbs\games\rob
if exist in.use goto inuse
copy c:\bin\in.use
robo 1 c:\bbs qbbs
del in.use
goto end

:Scrabble
cd\bbs\games\scrab
if exist in.use goto inuse
copy c:\bin\in.use
copy scrab1.cfg scrabble.cfg
scrabdor scrabble.cfg
del in.use
goto end

:Sharx
dm 1 mgw * c:\bbs\games\card\
cd \bbs\games\card
if exist in.use goto inuse
copy c:\bin\in.use
copy sharx1.cfg sharxprm.txt
sharx
del in.use
del userinfo.txt
goto end

:Solitree
qdoor 2 c:\bbs
cd \bbs\games\solitree
if exist in.use goto inuse
copy c:\bin\in.use
copy soli-1.cfg solitree.cfg
solitree solitree.cfg
del in.use
goto end

:Solpoker
dm 1 pcb14 * *
cd \bbs\games\sol
if exist in.use goto inuse
copy c:\bin\in.use
sol4 sol1.cfg
copy sol.dat c:\bbs\s
del in.use
goto end

:Sslot
cd \bbs\games\suprslot
if exist in.use goto inuse
copy c:\bin\in.use
copy \bbs\dorinfo1.def
suprslot suprslot.cfg c:\bbs\games\suprslot\dorinfo1.def
del in.use
del dorinfo*.def
goto end

:Triyat
cd\bbs\games\triyaht
if exist in.use goto inuse
copy c:\bin\in.use
copy triyat1.cfg yahtzee.cfg
yahtzee yahtzee.cfg
del in.use
goto end

:Twars
cd\bbs\games\twars
if exist in.use goto inuse
copy c:\bin\in.use
copy \bbs\dorinfo1.def
tw2002.exe -rbbs
copy c:\bbs\s\twtrader.txt c:\bbs\s\tw2002.msg
copy c:\bbs\s\twtrader.ans c:\bbs\s\tw2002.clr
copy c:\bbs\s\twcorp.txt c:\bbs\s\twcorp.msg
copy c:\bbs\s\twcorp.ans c:\bbs\s\twcorp.clr
del in.use
del dorinfo*.def
goto end

:Wheel
copy dorinfo1.def c:\bbs\games\wheel
cd\bbs\games\wheel
if exist in.use goto inuse
copy c:\bin\in.use
wheel-4
del in.use
del dorinfo*.def
goto end

:Yat
cd \bbs\games\yat
yacht yacht1.cfg
goto end

:Yt
cd \bbs\games\yt
if exist in.use goto inuse
copy c:\bin\in.use
yt.exe c:\bbs\dorinfo1.def 19200
copy ytmesg.dat c:\bbs\s
del in.use
goto end

:Zag
dm 1 pcb14C * *
copy pcb14.dat pcboard.dat
cd\bbs\games\zwords
if exist in.use goto inuse
copy c:\bin\in.use
copy zwords1.cfg zagwords.cfg
zagwords zagwords.cfg
del in.use
goto end

:Zodiac
dm 1 pcb14 * *
cd \bbs\games\zodiac
if exist in.use goto inuse
copy c:\bin\in.use
copy zodiac1.cfg zodiac.cfg
zodiac zodiac.cfg
del in.use
goto end

:Alaska
dm 1 spitfire * *
cd \bbs\games\alaska
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfaktrv /p c:\bbs\s\aktriv
copy c:\bbs\s\aktriv.bbs c:\bbs\s\aktriv.msg
del c:\bbs\s\aktriv.bbs
del sfdoors.dat
del in.use
goto end

:Computer
dm 1 spitfire * *
cd \bbs\games\computer
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfcomtrv /p c:\bbs\s\comtriv
copy c:\bbs\s\comtriv.bbs c:\bbs\s\comtriv.msg
del c:\bbs\s\comtriv.bbs
del sfdoors.dat
del in.use
goto end

:Disney
dm 1 spitfire * *
cd \bbs\games\disney
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfdistrv /p c:\bbs\s\distriv
copy c:\bbs\s\distriv.bbs c:\bbs\s\distriv.msg
del sfdoors.dat
del in.use
goto end

:Emerg
dm 1 spitfire * *
cd \bbs\games\emerg
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfemstrv /p c:\bbs\s\emerg
del sfdoors.dat
copy c:\bbs\s\emerg.bbs c:\bbs\s\emerg.msg
del c:\bbs\s\emerg.bbs
del in.use
goto end

:Hobbit
dm 1 spitfire * *
cd \bbs\games\hobbit
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfhobtrv /p c:\bbs\s\hobtriv
copy c:\bbs\s\hobtriv.bbs c:\bbs\s\hobtriv.msg
del c:\bbs\s\hobtriv.bbs
del sfdoors.dat
del in.use
goto end

:Movie
dm 1 spitfire * *
cd \bbs\games\movie
if exist in.use goto inuse
copy c:\bin\in.use
Copy c:\bbs\sfdoors.dat
sfmovtrv /p c:\bbs\s\movtriv
copy c:\bbs\s\movtriv.bbs c:\bbs\s\movtriv.msg
del c:\bbs\s\movtriv.bbs
del sfdoors.dat
del in.use
goto end

:Potpourr
dm 1 spitfire * *
cd \bbs\games\potpourr
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfpottrv /p c:\bbs\s\pottriv
copy c:\bbs\s\pottriv.bbs c:\bbs\s\pottriv.msg
del c:\bbs\s\pottriv.bbs
del sfdoors.dat
del in.use
goto end

:Rockroll
dm 1 spitfire * *
cd \bbs\games\rockroll
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfroctrv
del sfdoors.dat
del in.use
goto end

:Sex
dm 1 spitfire * *
cd \bbs\games\sextriv
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfsextrv /p c:\bbs\s\sextriv
copy c:\bbs\s\sextriv.bbs c:\bbs\s\sextriv.msg
del c:\bbs\s\sextriv.bbs
del sfdoors.dat
del in.use
goto end

:Sports
dm 1 spitfire * *
cd \bbs\games\sports
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfsprtrv /p c:\bbs\s\sprtriv
copy c:\bbs\s\sprtriv.bbs c:\bbs\s\sprtriv.msg
del c:\bbs\s\sprtriv.bbs
del sfdoors.dat
del in.use
goto end

:Startrek
f:\dm 1 spitfire * *
cd \bbs\games\startrek
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sfsttrv /p c:\bbs\s\sttriv
copy c:\bbs\s\sttriv.bbs c:\bbs\s\sttriv.msg
del c:\bbs\s\sttriv.bbs
del sfdoors.dat
del in.use
goto end

:Televis
f:\dm 1 spitfire * *
cd \bbs\games\tv
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\sfdoors.dat
sftvtrv /p c:\bbs\s\tvtriv
copy c:\bbs\s\tvtriv.bbs c:\bbs\s\tvtriv.msg
del c:\bbs\s\tvtriv.bbs
del sfdoors.dat
del in.use
goto end

:Educ
cd\bbs\games\doorway
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\door.sys
doorway sys /o:t /i:emenu
del door.sys
del in.use
goto end

:Fin
cd\bbs\games\doorway
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\door.sys
doorway sys /o:t /i:fmenu
del door.sys
del in.use
goto end

:Games
cd\bbs\games\doorway
if exist in.use goto inuse
copy c:\bin\in.use
copy c:\bbs\door.sys
doorway sys /o:t /i:gmenu
del door.sys
del in.use
goto end

:Ansi
dm lock 1 19200 default * c:\bbs\games\ansi\
cd\bbs\games\ansi
if exist in.use goto inuse
copy c:\bin\in.use
copy \bbs\dorinfo1.def
ansisee2
del in.use
del dorinfo1.def
goto end

:Doordos
doorway com2 /m:240 /s:* /g:on /o:t /v:d /c:dos
goto end

:Refund
cd\bbs\games\refund
if exist in.use goto inuse
copy c:\bin\in.use
refunds 2 y
copy refunds.txt c:\bbs\s\user1.msg
del in.use
goto end

:Silver
cd \bbs\silver
if exist in.use goto inuse
copy \bin\in.use
copy \bbs\dorinfo1.def
copy xpmail1.ctl xpmail.ctl
copy xpmail1.prm xpmail.prm
xpmail -p2 -f -b19200 -fcts -tsys -lrf -g -ml -mt1 %1 %2 %3 %4 %5 %6 %7
del dorinfo1.def
del in.use
goto end

:Tagg
dsz port 2 sb -g d:\tag\tagd25g.zip d:\tag\tagm25g.zip d:\tag\tags25g.zip d:\tag\patch25g.zip
goto end

:Tagy
dsz port 2 sb d:\tag\tagd25g.zip d:\tag\tagm25g.zip d:\tag\tags25g.zip d:\tag\patch25g.zip
goto end

:Tagz
dsz port 2 sz d:\tag\tagd25g.zip d:\tag\tagm25g.zip d:\tag\tags25g.zip d:\tag\patch25g.zip
goto end

:Inuse
Echo Sorry, this door is already in use. > com2
Echo Please try again in a few minutes.  > com2

:End
echo %5 %6 returned from %1 on %_date at %_time. >> e:\bu\dsz1.log
Echo %5 %6 returned from %1 at %_time on node %node. >> c:\bbs\s\bullet18.msg
cd\bbs
exit
