{
T.A.G. (C) Copyrighted 1986-1990 by Robert Numerick and Victor Capton
All rights reserved.

                   -----------------------------------
                   T.A.G. Version 2.5g Data Structures
                   -----------------------------------

All we ask if you use these records is to give credit where credit is due.

Additional structure information may be given out on an individual basis
depending on the situation.

Program: TAGR25G.PAS
}

type

  arflagtype='@'..'Z'; {AR flags}

  arflagset=set of arflagtype; {Set of AR flags}

  flagrec=(      {Special flags}
    autoprivdel, {A=Force user to delete private mail}
    nopostcall,  {B=No post call ratio}
    ForceULScan, {C=Force this user to automatically scan when uploading}
    ranon,       {D=Restrict from posting anonymous}
    rbbslist,    {E=Restrict from adding to other BBS list}
    rchat,       {F=Restrict from chatting}
    nodllimit,   {G=No download ratio limit}
    rpubmsg,     {H=Restrict from posting public mail}
    rprivmsg,    {I=Restrict from sending private mail}
    rvoting,     {J=Restrict from voting}
    onecall,     {K=One call per day allowed}
    pubnotval,   {L=Public posts are not validated}
    protdel,     {M=Protect from deletion}
    nofilepts,   {N=No file point checks}
    rfileval,    {O=Word wrap in messages enabled}
    pause,       {P=[PAUSE] active}
    ansi,        {Q=ANSI graphics active}
    color,       {R=Color active if ANSI present}
    onekey,      {S=Onekey input used instead of line input}
    alert,       {T=Alert active from user's next call}
    usermale,    {U=User is of the male gender}
    mboxclosed,  {V=Mail box closed to all but SysOp's}
    tabs,        {W=VT100 tabs are used to optimize display}
    clschar      {X=Clear screen characters used}
    );           {3 bytes used for 24 flags in set}

  flagset=set of flagrec; {Set of special flags}

  ConfigFlagRec=(
    UseCustomMenus,  {Allow custom ANSI menus}
    uuflag1,
    uuflag2,
    uuflag3,
    uuflag4,
    uuflag5,
    uuflag6,
    uuflag7,
    uuflag8,
    uuflag9,
    uuflag10,
    uuflag11,
    uuflag12,
    uuflag13,
    uuflag14,
    uuflag15,
    uuflag16,
    uuflag17,
    uuflag18,
    uuflag19,
    uuflag20,
    uuflag21,
    uuflag22,
    uuflag23
    );

  ConfigFlagSet=set of ConfigFlagRec;

  filerec=(           {File flags}
    notvalidated,     {File is not validated}
    ownerrestricted,  {Uploader did not receive credit on upload}
    uuf1,             {Reserved}
    uuf2,             {Reserved}
    uuf3,             {Reserved}
    uuf4,             {Reserved}
    uuf5,             {Reserved}
    uuf6              {Reserved}
    );                {1 byte used for 8 flags in set}

  flagrecset=set of filerec; {Set of file flags}

  msgscanrec=set of 0..55; {Set of flags for message section scanning}

  filescanrec=set of 0..174; {Set of flags for file section scanning}

  colorrec=
    array[false..true,0..9] of byte; {Array of B&W/Color Colors}
                                     {  false=Black and white colors}
                                     {  true =Color colors}

  umsgsrec=record    {User last read message point for each section}
    ltr:char;        {Message letter - e.g. "A" of A-28432}
    number:integer;  {Message number - e.g. -28432 of A-28432}
  end;

  smalrec=record     {User name index - NAMES.LST}
    name:string[36]; {User name}
    number:integer;  {User number}
  end;

  userrec=record                    {User log - USER.LST}
    uname,                          {User name}
      rname:string[36];             {Real name}
    addr,                           {Address}
      comtype,                      {Computer type}
      citystate,                    {City/State}
      snote:string[30];             {SysOp note}
    lastdate,                       {Last date on - MS-DOS format}
      lasttime:integer;             {Last time on - MS-DOS format}
    pw:string[16];                  {Password}
    phone:string[12];               {Phone number}
    zcode:string[10];               {Zip code}
    qscan:array[0..55] of umsgsrec; {Array of last read pointers}
                                    {for each message section   }
    vote:array[1..20] of byte;      {Array of voting answers for each question}
    callspr:array[1..15] of byte;   {Call spread for last 15 calls - Number}
                                    {of days between each call:            }
                                    {    0     =Called the same day        }
                                    {    1..253=X number of days between   }
                                    {    254   =254 or more days between   }
                                    {    255   =Element not used yet       }
    ttimeon,                        {Total time on system in minutes}
      ulk,                          {UL K-Bytes}
      dlk:real;                     {DL K-Bytes}
    usernum,                        {User number                }
                                    {  0            =Deleted    }
                                    {  Same as rec  =Normal user}
                                    {  Diff from rec=Locked out }
      privpost,                     {Private posts}
      pubpost,                      {Public posts}
      feedback,                     {Feedback sent to SysOp}
      numcalls,                     {Total number of calls to system}
      numul,                        {Number of uploads}
      numdl,                        {Number of downloads}
      fmail,                        {Forward mail to which user number}
                                    {  0=Forwarding inactive          }
      hbaud,                        {Highest baud rate user supports}
      timetoday,                    {Minutes on system date of last call}
      credit,                       {Credit for mail in cents}
      debit,                        {Debit for mail in cents}
      points,                       {File points}
      timebank,                     {Minutes in time bank}
      bday,                         {Birthdate of user - MS-DOS format}
      lastchange:integer;           {Reserved}
    strtmenu,                       {Reserved}
      sl,                           {Security level - SL}
      dsl,                          {Download security level - DSL}
      hlvl,                         {Help level}
      colms,                        {Number of screen columns}
      lines,                        {Number of screen lines}
      callstoday,                   {Number of calls to system today}
      illegal,                      {Illegal logon attempts}
      waiting,                      {Number of private messages waiting}
      lmsgbase,                     {Last message base}
      ldlbase,                      {Last file section}
      cls,                          {Reserved}
      fulledit:byte;                {Full screen editor status}
                                    {  0=Ask user each time   }
                                    {  1=Never use it         }
                                    {  2=Always use it        }
    ar:arflagset;                   {AR flag set}
    flags:flagset;                  {Special flag set}
    msgsysop:array[1..4] of byte;   {Array of SubOp message boards (255=None)}
    msgscan:msgscanrec;             {Message area scan set}
    dlscan:filescanrec;             {File section scan set}
    colors:colorrec;                {User colors}
    tbdeposit,                      {Time deposited in bank date of last call}
      tbwithdraw:byte;              {Time withdraw from bank date of last call}
    adjtime:integer;                {Adjusted time date of last call}
    ConfigFlags:ConfigFlagSet;
    unused:array[1..9] of byte;    {Reserved}
  end;

  messages=record    {Message filename}
    ltr:char;        {Message letter    - e.g. A      of A-28432.1}
    number:integer;  {Message number    - e.g. -28432 of A-28432.1}
    ext:byte;        {Message extension - e.g. 1      of A-28432.1}
  end;

  anontyp=(   {Message section anonymous type}
    no,       {Anonymous messages not allowed}
    yes,      {Anonymous messages allowed}
    forced,   {Messages forced anonymous}
    atunused  {Reserved}
    );

  boardrec=record         {Public message section - BOARDS.DAT}
    name:string[45];      {Base name                          }
                          {30 max real length - Rest for color}
    filename:string[12];  {Header filename (does NOT include ".BRD"}
    sl:byte;              {SL required}
    maxmsgs:byte;         {Maximum messages}
    pw:string[16];        {Password required - Null if none}
    anonymous:anontyp;    {Anonymous type}
    ar:arflagtype;        {AR flag required}
    noansi:boolean;       {ANSI graphics disabled}
    postsl:byte;          {SL required to post}
  end;

  msgstat=(       {Message status type}
    validated,    {Normal validated message}
    unvalidated,  {Unvalidated message}
    deleted       {Deleted message - Ready for purge}
    );

  messagerec=record       {Public message header - *.BRD}
    title:string[30];     {Subject}
    messagestat:msgstat;  {Message status}
    message:messages;     {Message name}
    owner:integer;        {User number of poster}
    date:integer;         {Date posted - Days since Jan 1, 1985}
    unused:byte;          {Reserved}
  end;

  mailrec=record       {Private message header - EMAIL.DAT}
    title:string[30];  {Subject}
    from,              {User number of who message from}
      destin:integer;  {User number of who message to}
    msg:messages;      {Message name}
    date:integer;      {Date posted - Days since Jan 1, 1985}
    unused:byte;       {Reserved}
  end;

  smallmessagerec=record  {Short messages - SHORTMSG.DAT}
    msg:string[160];      {Message text}
    destin:integer;       {User number of who message to}
  end;

  vdatar=record                 {Voting questions - VOTING.DAT}
    question:string[74];        {Question}
    numa:integer;               {Number of answers in below array}
    answ:array[0..9] of record  {Array of answer data}
      ans:string[40];           {Answer}
      numres:integer;           {Number of users who choose this response}
    end;
  end;

  ulrec=record              {File section - FBOARDS.DAT}
    name:string[39];        {Section name                       }
                            {26 max real length - Rest for color}
    filename:string[8];     {Listing filename (does not include ".DIR")}
                            {If UL and DL paths are different,         }
                            {filename for upload section is "FILES"    }
                            {If first character is "@" then *.DIR file }
                            {is found in main data files directory     }
    dlpathname:string[30];  {Download pathname}
    ulpathname:string[30];  {Upload pathname}
    password:string[16];    {Password required}
    dsl,                    {DSL required}
      seenames:byte;        {DSL required to see uploader names}
    arlvl:arflagtype;       {AR flag required}
    noratio:boolean;        {Ratio disabled}
  end;

  ulfrec=record              {File listing - *.DIR}
    filename:string[12];     {File name}
    description:string[78];  {Description}
    nacc:integer;            {Number of times file downloaded}
    unused:byte;             {Reserved}
    blocks:word;             {Number of 128 byte blocks in file}
    owner:string[36];        {Uploader of file}
    date:string[8];          {Date file uploaded}
    daten:integer;           {Date file uploaded in days since Jan 1, 1985}
    flag:flagrecset;         {File status}
    points:byte;             {File points}
  end;

  range=array[0..255] of integer; {Range of values for all security levels}
                                  {for use in system configuration        }

  systatrec=record                    {System status - STATUS.DAT}
    altpath,                          {Alternate file path}
      msgspath:string[40];            {Message text path}
    uusr:array[1..15] of byte;        {Reserved}
    ShowFilesOpen,                    {Show Files Open on Top Screen}
    localsysopwindow,                 {SysOp window when on locally}
      allowsuperfast,                 {Allow SHIFT password override}
      waitsend,                       {FOSSIL buffer inactive}
      overlayems,                     {Attempt EMS of overlays}
      lockbaud,                       {Locked baud rate}
      directscreen,                   {Direct screen writes}
      useems,                         {Use EMS memory for swap shell}
      useswap,                        {Use swap shell}
      usefossil,                      {Use FOSSIL driver}
      snowcheck:boolean;              {Snow checking active}
    modemresultnocarrier:string[14];  {Modem NO CARRIER result}
    modemanswer:string[20];           {Modem answer phone string}
    modemresultring:string[14];       {Modem RING result}
    minkpost,                         {Minimum K-Bytes to post}
      minkul:integer;                 {Minimum K-Bytes to upload}
    autochatbufopen:boolean;          {Auto chat buffer open}
    modemoffhook:string[20];          {Modem off-hook string}
    modemresultok:string[14];         {Modem OK result}
    logonpassword,                    {SL when SysOp PW #1 needed to logon}
      readtextmsg:byte;               {SL when allowed to use /READ command}
    alertchatonly,                    {Alert active only when chat on}
      genericinfo,                    {Generic mode active}
      logonphone:boolean;             {Logon requires phone number}
    modeminit:string[54];             {Modem initialization string}
    lastcaller:string[42];            {Name and number of last caller}
    modemhangup:string[20];           {Modem disconnect string}
    boardpw:string[16];               {New user password (Null=None)}
    boardphone:string[12];            {Board phone number}
    sysopcolor,                       {Chat SysOp color}
      usercolor:byte;                 {Chat user color}
    postcallflag:arflagtype;          {Post call ratio AR flag}
    nopostcallchk,                    {SL when post call ratio ignored}
      reinittime,                     {Minutes to re-init modem when no calls}
      startmenu:byte;                 {Starting menu for users}
    useautomsg,                       {Display auto-message during logon}
      logonoffhook:boolean;           {Take phone off-hook on local logon}
    nopointchk:byte;                  {DSL when file points ignored}
    lastdate:string[8];               {Date last user logged on}
    unused_event:
      array[1..390] of byte;          {Old events-Moved to EVENTS.DAT}
{$IFDEF Multi_user}
    multiuserpath:string[40];         {Multi-user path}
{$ELSE}
    unused_multiuserpath:string[40];  {Unused}
{$ENDIF}
    junk:array[1..11] of byte;        {Reserved}
    gfilespath:string[40];            {Main data files path}
    storebadlogon:boolean;            {Store bad logon info in SysOp log}
    maxbdnum,                         {Maximum number of batch DL files}
      maxbunum:byte;                  {Maximum number of batch UL files}
    boardname:string[48];             {Board name}
    sysopmenusl:byte;                 {SL required for SysOp Control-Q menu}
    sysopmenuar:arflagtype;           {AR flag required from Control-Q menu}
    sysopname:string[36];             {SysOp name}
    swappath:string[40];              {Swap shell path}
    chatpw:string[16];                {Chat password}
    modemafterhangup:string[20];      {Modem after hang up string}
    uubytes:array[1..45] of byte;     {Reserved}
    ksm:array[1..9] of string[255];   {Internal use}
    sysoppw:
      array[1..3] of string[16];      {Array of SysOp passwords}
    modemresult:
      array[1..8] of string[14];      {Array of modem result strings}
                                      {  1,2=300 baud               }
                                      {  3,4=1200 baud              }
                                      {  5,6=2400 baud              }
                                      {  7,8=9600 baud              }
    callernum,                        {Total number of calls to system}
      ulktoday,                       {K-Bytes uploaded today}
      dlktoday,                       {K-Bytes downloaded today}
      uur1,                           {Reserved}
      uur2,                           {Reserved}
      uur3:real;                      {Reserved}
    users,                            {Number of active users}
      activetoday,                    {Minutes active today}
      callstoday,                     {Calls today}
      msgposttoday,                   {Public messages posted today}
      emailtoday,                     {Private messages posted today}
      fbacktoday,                     {Feedback sent to SysOp today}
      ultoday:integer;                {Number of uploads today}
    waitbaud:word;                    {Baud rate for modem initialization}
    lowtime,                          {Minutes into day for start chat hours}
      hitime,                         {Minutes into day for end chat hours}
      maxusers,                       {Maximum users allowed to be active}
      errorstoday,                    {Number of errors today}
      nuserstoday,                    {Number of new users today}
      dltoday,                        {Number of downloads today}
      newusermsgto,                   {User number new user message sent to}
      uui1,                           {Reserved}
      sysopmailto,                    {User number mail to "SYSOP" is sent to}
      guestuser,                      {Guest user number (0=None)}
      low300time,                     {Minutes into day 300 baud hours start}
      uui2,                           {Reserved}
      usagelogdays,                   {Number of days to keep USAGE.LOG}
      hi300time:integer;              {Minutes into day 300 baud hours end}
      UEditJumpSL:byte;               {SL required for SysOp Control-U menu}
    UEditJumpAR:arflagtype;           {AR flag required from Control-U menu}
    novicedisplay,                    {Number of calls to display novice msg}
{$IFDEF Multi_user}
      nodenumber:byte;                {Multi-user node number}
{$ELSE}
      unused_nodenumber:byte;         {Unused}
{$ENDIF}
    UEditJumpPassword:boolean;        {Use System pswd for Quick User Edit}
    ScanOnUploads:boolean;            {System permits forced scan on uploads}
      maxtimeinbank:word;             {Maximum minutes in time bank}
      showgifres,                     {Show GIF resolution}
      checkuploadspace,               {Show upload drive space}
      systemsecur:boolean;            {Full keyboard security active}
{$IFDEF Multi_user}
    multiuser:boolean;                {Board in multi-user mode      }
                                      {Assuming you have that version}
{$ELSE}
    unused_multiuser:boolean;         {Unused}
{$ENDIF}
    tbmaxdeposit,                     {Maximum daily time bank deposit}
      tbmaxwithdraw,                  {Maximum daily time bank withdraw}
      sysoplvl,                       {SL for SysOp}
      cosysoplvl,                     {SL for CoSysOp}
      suboplvl,                       {Exact SL for full SubOp}
      addbbslvl,                      {SL for adding boards to bbs listing}
      emaillvl,                       {SL for sending normal private mail}
      unused_3,                       {Reserved}
      unused_4,                       {Reserved}
      seeunvallvl,                    {DSL for seeing unvalidated files}
      dlcosysoplvl,                   {DSL for Download CoSysOp}
      noratiochk,                     {DSL for no ratio}
      readanon,                       {SL to know who send anonymous mail}
      replyanon,                      {SL to reply to anonymous private mail}
      publicanonany,                  {SL to post anonymous on any public base}
      privateanonany,                 {SL to send private anonymous mail}
      maxpubliccall,                  {Maximum public posts per call}
      maxprivcall,                    {Maximum private messages per call}
      maxfbackcall,                   {Maximum feedback to SysOp per call}
      maxwaitso,                      {Maximum messages waiting SysOp}
      seepasswords,                   {SL to see user passwords remotely}
      maxwaitcs,                      {Maximum messages waiting CoSysOp}
      maxwaitnorm,                    {Maximum messages waiting normal user}
      comport,                        {Communications port}
      timeout,                        {Minutes for inactivity time-out}
      timeoutbell,                    {Minutes for inactivity bell}
      backlogdays,                    {Number of days to keep SYSOP.LOG's}
      privilagesl,                    {Privilege SL}
      privilagedsl,                   {Privilege DSL}
      cdmask,                         {Carrier detect mask}
      maxlogontries,                  {Maximum logon attempts per call}
      numlines,                       {Maximum lines per msg for normal user}
      csnumlines,                     {Maximum lines per msg for CoSysOp}
      ultimepercent,                  {UL time percent refund}
      maxchats,                       {Maximum chat pages per call}
      readmsgview,                    {SL for read message view user command}
      readmsgval:byte;                {SL for read message user validated}
    closedsystem,                     {System closed}
      titlepause,                     {Allow [PAUSE] on welcome screen}
      logonbulletin,                  {Logon to the bulletin section}
      blankwait,                      {Blank the wait screen if no activity}
      handles,                        {Allow handles}
      unused_1,                       {Reserved}
      securesystem,                   {Keyboard security active}
      timeperday,                     {Time limits represent time per day}
      mailer,                         {External mailer active}
      sysopfemale,                    {SysOp is female}
      scantosysoplog:boolean;         {File scans are saved in SysOp log}
    timeallowed,                      {SL array of time per call/per day}
      uldlnumratio,                   {DSL array of number of file UL ratios}
      uldlkratio,                     {DSL array of K-Byte UL ratios}
      callsallowed,                   {SL array of calls allowed per day}
      postcall:range;                 {SL array of posts per 1/10 call}
    hmsg:messages;                    {The very important high message pointer}
    unused_2:arflagset;               {Reserved}
  end;

  menuflagtype=( {Menu flag type}
    sls,         {SL security check - When off DSL security check}
    orcheck,     {SL or AR - When off SL and AR}
    flag1,       {Time/Help display (menu) or Hidden status (command)}
    flag2,       {Board display override (menu) or unused (command)}
    flag3        {Menu name prompt (menu) or unused (command)}
    ); {1 byte}

  menuflagset=set of menuflagtype; {Set of menu flags}

  menurec=record
    longd:string[60];             {Menu desc (menu) or Long command desc (cmd)}
    gsl:byte;                     {General security level - Use depends}
                                  {on the "sls" flag                   }
    arlvl:arflagtype;             {AR flag}
    flags:menuflagset;            {Menu flags}
    case menu:boolean of          {Menu or command - Variant section}
      true :(menunum:byte;        {Menu number}
             mprompt:string[20];  {Menu prompt unless "flag3" active}
             password:string[15]; {Menu password}
             fallback:byte;       {Fallback menu number}
             helpfile:string[7];  {Help file ID name}
             starthelp:byte;      {Starting help level}
             location:byte);      {Menu location (0=Main, 1=File)}
      false:(pkey:byte;           {Command PKey}
             pdata:string[20];    {Command PData}
             shortd:string[15];   {Command short description}
             cmdkey:string[12]);  {Command execution key}
  end; {case/record}

  macrorec=record                   {Macro list - MACROS.LST}
    usern:integer;                  {User number of macro owner}
    key:array[1..4] of string[160]; {Text for each of the macros}
  end;

  sprotocolrec=record              {Single protocols - SPROT.DAT}
    key:string[12];                {Execution key}
    desc:string[60];               {Description}
    minbaud,                       {Minimum baud rate to use}
      maxbaud:word;                {Maximum baud rate to use}
    dsl:byte;                      {DSL required}
    templog,                       {Temp log path and name}
      ullog,                       {UL log path and name}
      dllog:string[52];            {DL log path and name}
    ulstring,                      {UL string for DOS call}
      dlstring:string[70];         {DL string for DOS call}
    goodcode:boolean;              {Result codes mean good transfer}
    dlcode,                        {DL error level result codes}
      ulcode:array[1..6] of byte;  {DL error level result codes}
  end;

  bprotocolrec=record                    {Batch protocols - BPROT.DAT}
    key:string[12];                      {Execution key}
    desc:string[60];                     {Description}
    minbaud,                             {Minimum baud rate to use}
      maxbaud:word;                      {Maximum baud rate to use}
    dsl:byte;                            {DSL required}
    ulstring,                            {UL string for DOS call}
      dlstring:string[70];               {DL string for DOS call}
    ullist,                              {UL file list file path and name}
      dllist,                            {DL file list file path and name}
      templog,                           {Temp log path and name}
      ullog,                             {UL log path and name}
      dllog:string[52];                  {DL log path and name}
    maxcmdlen,                           {Maximum command line length}
      posfn,                             {Position of filename in log}
      posstatus:byte;                    {Position of status in log}
    goodcode:boolean;                    {Result codes mean good transfer}
    dlcode,                              {DL status result codes}
      ulcode:array[1..6] of string[10];  {UL status result codes}
  end;

  validationrec=record   {Validation information - VALIDATE.DAT}
    key:char;            {Execution key}
    desc:string[160];    {Description sent to user after validation}
                         {76 max real length - Rest for color}
    sl,                  {SL to set on validation}
      dsl:byte;          {DSL to set on validation}
    credit,              {Credit in cents to set on validation}
      points,            {File points to set on validation}
      timebank:integer;  {Time bank minutes to set on validation}
    ar:arflagset;        {AR flags to set on validation}
    flags:flagset;       {Special flags to set on validation}
    unusedint:integer;   {Reserved}
  end;

  EventType  =
    (UnknownEvent,          {* 1-1. Unknown                *}
     EventIsExternal,       {* 1-2. External/Internal      *}
     EventIsActive,         {* 1-3. Active/InActive        *}
     EventIsShell,          {* 1-4. Shell/Error            *}
     EventIsMonthly,        {* 1-5. Monthly/Daily          *}
     EventIsPermission,     {* 1-6. Permission/Restriction *}
     EventIsChat,           {* 1-7. Chat Event             *}
     EventIsSoft,           {* 1-8. Soft/Hard              *}

     BaudIsActive,          {* 2-1. Baud Rate Flag         *}
     SLisActive,            {* 2-2. SL Flag                *}
     DSLisActive,           {* 2-3. DSL Flag               *}
     ARisActive,            {* 2-4. ARflag required        *}
     InRatioIsActive,       {* 2-5. InRatioFlag            *}
     TimeIsActive,          {* 2-6. Time Flag              *}
     SetARisActive,         {* 2-7. Set AR flag            *}
     ClearARisActive,       {* 2-8. Clear AR Flag          *}

     uuEvent31,uuEvent32,   {* Byte 3 ...                  *}
     uuEvent33,uuEvent34,
     uuEvent35,uuEvent36,
     uuEvent37,uuEvent38,

     uuEvent41,uuEvent42,   {* Byte 4 ...                  *}
     uuEvent43,uuEvent44,
     uuEvent45,uuEvent46,
     uuEvent47,uuEvent48,

     uuEvent51,uuEvent52,   {* Byte 5 ...                  *}
     uuEvent53,uuEvent54,
     uuEvent55,uuEvent56,
     uuEvent57,uuEvent58
    );

  EventDaysType       = Set of 0..6;

{*************************************************************************}
{* The Record Structure of the EventFile                                 *}
{*************************************************************************}
  EventRecordType = Record               {* ---------------------------- *}
    EventFlags     : Set of EventType;   {* Kinds of Events Supported    *}
    EventDayOfMonth: Byte;               {* If monthly, the Day of Month *}
    EventDays      : EventDaysType;      {* If Daily, the Days Active    *}
    EventStartTime : Word;               {* Start Time in Min from Mid.  *}
    EventFinishTime: Word;               {* Finish Time                  *}
    EventDesc      : Str32;              {* Description of the Event     *}
    EventQualMsg   : Str64;              {* Msg/Path if he qualifies     *}
    EventNotQualMsg: Str64;              {* Msg/Path if he doesn't       *}
    EventPreTime   : Byte;               {* Min. B4 event to rest. Call  *}
    EventOffHook   : Boolean;            {* Take phone Offhook ?         *}
    EventLastDate  : Str8;               {* Last Date Executed           *}
                                         {* ---------------------------- *}
    EventErrorLevel: Byte;               {* For Ext Event ErrorLevel     *}
    EventShellPath : String[8];          {* File for Ext Event Shell     *}
                                         {* ---------------------------- *}
    LoBaud,HiBaud  : Word;               {* Limits On Baud Rates         *}
    LoSL,HiSL      : Byte;               {* Limits On SL's               *}
    LoDSL,HiDSL    : Byte;               {* Limits on  DSL's             *}
    ARflagRequired : Char;               {* AR flag required             *}
                                         {* ---------------------------- *}
    MaxTimeAllowed : Word;               {* Max Time per user this event *}
    SetARflag      : Char;               {* AR Flag to Set               *}
    ClearARflag    : Char;               {* AR Flag to Clear             *}
    EventUnused    :                     {* ---------------------------- *}
      Array[1..128] of Byte;             {* Reserved                     *}
  End; {Record}                          {* ---------------------------- *}
