ECHO OFF

:RESET
rem When messages are entered in TagMail,  TagMail will create files so that
rem this batch file can process the outbound mail.  Here's a table of the
rem files created:

rem Type of message     File name    contents
rem Matrix Message      MATRIX.TAG   Nothing
rem Echo Message        ECHO.LST     List of areas messages entered in
rem Group Message       GROUP.ENT    Nothing
rem Echo message        ECHO.TAG     Nothing, Only created if the message
rem                                  area isnot found in the areas found.

rem we then use the IF EXIST function of MSDOS to decide if we need to 
rem process outbound mail


IF EXIST C:\TAG\TAGMAIL\GROUP.ENT GOTO GRPPACK
IF EXIST C:\TAG\TAGMAIL\ECHO.LST GOTO PACK
IF EXIST C:\TAG\TAGMAIL\MATRIX.TAG GOTO PACK

C:
CD\TAG\BINKLEY
rem I run timer to make sure my date and time are correct (Since DOS 3.2 had
rem a bug with the date/time rollover at midnight)
TIMER /S
CLS

rem we run BinkleyTerm here

BT

Rem now we look at the errorlevels returned to see what we are supposed to do.
rem Errorlevels of 1,3,12,20,24, and 96 should return directly to the bbs (GO
rem to the end of the batch file).  Other errorlevels as defined in 
Rem BINKLEY.EVT will do other functions.

IF ERRORLEVEL 163 GOTO MAINT2
IF ERRORLEVEL 160 GOTO MIDNIGHT
IF ERRORLEVEL 154 GOTO GRPASK
IF ERRORLEVEL 153 GOTO MAINT
IF ERRORLEVEL 150 GOTO MAILIN
IF ERRORLEVEL 100 GOTO CLEARCOUNT
IF ERRORLEVEL 97 GOTO RESET
IF ERRORLEVEL 96 GOTO TAG
IF ERRORLEVEL 80 GOTO TAGMAIL
IF ERRORLEVEL 50 GOTO MAILIN
IF ERRORLEVEL 30 GOTO TAG
IF ERRORLEVEL 25 GOTO RESET
IF ERRORLEVEL 24 GOTO TAG
IF ERRORLEVEL 20 GOTO TAG
IF ERRORLEVEL 13 GOTO RESET
IF ERRORLEVEL 12 GOTO TAG
IF ERRORLEVEL 10 EXIT
IF ERRORLEVEL 3 EXIT
EXIT

:TAGMAIL
ECHO ATH1 > COM1
Rem This is used to run TagMail in the local mode without logging on through
Rem TAG.  in this example,  pressing F8 while Binkley is in it's unattended
Rem mode will  bring you here (BT Errorlevel 80)

C:
CD \TAG\TAGMAIL
TAGMAIL -L
GOTO RESET

:MIDNIGHT
Rem You may or may not need this event,  This will occur only if a user is
Rem not on the system at the midnight rollover.  This is used in conjunction
Rem with the Timer program above to ensure the Date Rolls over at midnight.

ECHO ATH1 > COM1
WAIT 1:10
GOTO RESET

:MAILIN
ECHO ATH1 > COM1

Rem When mail is recieved from another system, it needs to be processed.  This
Rem example uses Qmail by Greg Dawson and Group (GroupMail) by System
Rem Enhancement Associates (SEA).

C:
CD \TAG\BINKLEY
CLS
ECHO PROCESSING RECIEVED MAIL

Rem first we do a GROUP IN to process any Group Mail we may have recieved.
Rem If you are not using Group Mail, just place a Rem statement in front of 
Rem the GROUP lines in this batch file.

GROUP IN 

Rem Then we have Qmail do it's stuff.  

QM TOSS SCAN PACK 

Rem if Qmail processed any mail,  it will exit with an errorlevel of 1 or
Rem higher,  We check for this to figure out if we need to continue processing
Rem for other recieved mail. 

IF ERRORLEVEL 1 GOTO CONTINUE

Rem And lastly,  we check to see if we have recieved the latest NODEDIFF file
Rem used to update the nodelist file.  If we have then we jump to our 
Rem nodelist processing area of this batch file.  If you don't want to
Rem process the nodelist as it comes in,  place a Rem statement in front of
Rem these lines except in the MAINT area.  This check is located here, In 
Rem CONTINUE, and MAINT areas of this Batch file

IF EXIST C:\FILE\NET\NODEDIFF.A?? goto LISTPROC
GOTO RESET

:CONTINUE
C:
CD \TAG\TAGMAIL

Rem if you are using the Mailwait program, remove the Rem statement in front
Rem of the Mailwait - U command below,  This will tell Mailwait to update the
Rem indexes of the messages in each area. 

REM MAILWAIT -U

Rem Check for NODEDIFF file as described above

IF EXIST C:\FILE\NET\NODEDIFF.A?? goto LISTPROC
GOTO RESET

:GRPPACK

Rem This area of the Batch file is only called if somes one enters a Group
Rem mail message on your system.

C:
CD \TAG\BINKLEY
CLS
ECHO PROCESSING OUTBOUND GROUP MAIL
GROUP OUT

:PACK
ECHO ATH1 > COM1

Rem This area is called if a user enters an Echo mail or matrix mail message.
Rem Since Qmail will ignore the area list parameter if the file doesn't exist,
Rem and it packs Matrix Mail on the same run, we can make the call for both 
Rem at the same time.

C:
CD \TAG\BINKLEY
CLS
ECHO PROCESSING ALL OUTBOUND MAIL
QM PACK SCAN -FC:\TAG\TAGMAIL\ECHO.LST
C:
CD \TAG\TAGMAIL

Rem again, If you are using Mailwait,  uncomment the next line.

REM MAILWAIT -U

Rem Now we delete the files that were used to deturmine if processing is
Rem required.  If we don't do this,  we will go into a endless loop of mail
Rem processing.
 
IF EXIST C:\TAG\TAGMAIL\GROUP.ENT   DEL C:\TAG\TAGMAIL\GROUP.ENT
IF EXIST C:\TAG\TAGMAIL\MATRIX.TAG  DEL C:\TAG\TAGMAIL\MATRIX.TAG
IF EXIST C:\TAG\TAGMAIL\ECHO.LST    DEL C:\TAG\TAGMAIL\ECHO.LST
GOTO RESET

:GRPASK

Rem Group mail is based on the file Update request function of most mailers.
Rem to get new messages for these conferences,  you must generate an update
Rem request.  This area will do this processing.

C:
CD \TAG\BINKLEY
CLS
ECHO DOING GROUP MAIL UPDATE REQUESTS
GROUP OUT ASK
QM PACK
GOTO RESET

:MAINT
ECHO ATH1 > COM1

Rem This area of the batch file runs once per day (Just after ZMH in this 
Rem example).  Any processing that needs to be done only once a day can be
Rem done here.

C:
CD \TAG\TAGMAIL

Rem First we Renumber or TagMail Message Bases
RENUMBER

Rem If you are using Mailwait, we then need to compile the mailwait indexes
Rem by uncommenting the following:

REM MAILWAIT -C

C:
CD \TAG\BINKLEY

Rem if you use the FILELIST program to build text file listings of your
Rem downloadable files.  Uncomment the following lines.  This program will
Rem also create the files needed to allow File requests from your system
Rem Remember to change the MYFILES to something that would be unique to your
Rem System to avoid sysops getting multiple MYFILES.LST file from different
Rem Systems.

REM FILELIST -C -D50 -FC:\TAG\GFILES -O MYFILES.LST -K -U
REM PKZIP -A MYFILES MYFILES.LST

Rem We scan ALL echo areas during this event to make sure we haven't missed
Rem an area for one reason or another...  

QM SCAN PACK
GOTO RESET

:MAINT2
REM This happens once a week...
ECHO ATH1 > COM1
C:
CD \TAG\BINKLEY

Rem I use Qmail to make a file request for the latest NODEDIFF file

QM PACK -SGET_DIFF
GOTO RESET

:LISTPROC
ECHO ATH1 > COM1

Rem When a new NODEDIFF file comes in,  It must be processed to build the
Rem new updated nodelist.  This area of the Batch file does this processing:

Rem (the directory C:\FILE\NET is my Inbound Directory, C:\NODELIST is my
Rem Nodelist directory)

C:
CD \NODELIST

Rem Copy the nodediff.a?? file to the nodelist directory and delete it from
Rem the inbound directory.

COPY C:\FILE\NET\NODEDIFF.A??
DEL C:\FILE\NET\NODEDIFF.A??

Rem Un-arc the NODELIST.A?? and NODEDIFF.A?? files.  I use the -R option
Rem of PKXARC to overwrite the files if they exist, and add the two file names
Rem at the end so that nothing other than NODEDIFF.* and NODELIST.* files will
Rem be extracted for security.

PKXARC -R NODE*.A* NODELIST.* NODEDIFF.*

Rem Run PARSELST to combine the Nodelist and Nodediff files and build the
Rem NODELIST.IDX and NODELIST.DAT files used by Binkley, and the TAGMAIL.IDX
Rem file used by TAGMail.
 
PARSELST

Rem Now update the TagMail nodelist index (TAGMAIL.IDX)

TAGIDX

Rem delete the old nodelist archives.

DEL NODELIST.A??

Rem OLDLIST is a program that will remove all old nodelists from the directory
Rem and then optionally archive the nodelist with the correct A?? file name.

OLDLIST -A PKARC A

Rem Delete the nodediff file as we don't need it anymore.

DEL NODEDIFF.*
GOTO RESET

:CLEARCOUNT

Rem this area is used at the start of each mail event.  It will remove the
Rem call counter files from the outbound directory.  In this example, only
Rem the net 120 counter files will be deleted.

DEL C:\TAG\OUTBOUND\0078*.$$?
GOTO RESET

:TAG
Rem this area returns control to TAG from this batch file.  DO NOT run any
Rem programs in this area as it will change the Errorlevel returned to TAG.

C:
CD\TAG
:END
                                                                                            