{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R+,S+,V-}
{$IFDEF VER60}
  {$G-,X-}
{$ENDIF}
{$M 1024,0,0}

program GUS_WriteConfig;    { Append or update configuration }
                            { information to or in GUS.EXE   }
uses DOS;

type
    FNameStr = string[12];

    ArcType = (Unknown,ARC,ARJ,ARp,DWC,HYP,LZH,PAK,ZIP,ZOO);
    ArcCmds = (Extract,Replace,Display,Test);

    ArcData = record
               Ext : string[3];
               Prog: FNameStr;
               Cmd : array [ArcCmds] of string[10];
               Pwd : string[5];
              end;

    ArcCfg  = record
                Marker  : longint;
                ArcTable: array [ArcType] of ArcData;
              end;

const
    GUSname     = 'GUS.EXE';
    CfgMarker   = $775A6F4A;  {'JoZw'}
    Unsupported = '**********';
    ArcInfo     : ArcCfg
    = (Marker   : CfgMarker;
       ArcTable :                         {     Extract      Replace      Display Test }
       ((Ext: '???'; Prog: ''            ; Cmd:(''         , ''         , ''          , ''          ); Pwd: ''          ),
        (Ext: 'ARC'; Prog: 'PKUNPAK .EXE'; Cmd:('-n       ', '-r       ', '-c        ', '-t        '); Pwd: '-g   '     ),
        (Ext: 'ARJ'; Prog: 'ARJ     .EXE'; Cmd:('e -n     ', 'e -y     ', 'p         ', 't         '); Pwd: '-g   '     ),
        (Ext: 'A7+'; Prog: 'XARC    .EXE'; Cmd:('         ', '/o       ', Unsupported , Unsupported ); Pwd: '/g   '     ),
        (Ext: 'DWC'; Prog: 'DWC     .EXE'; Cmd:('xowr     ', 'xwr      ', 'p         ', 't         '); Pwd: 'g    '     ),
        (Ext: 'HYP'; Prog: 'HYPER   .EXE'; Cmd:('-xp      ', '-xop     ', Unsupported , Unsupported ); Pwd: Unsupported ),
        (Ext: 'LZH'; Prog: 'LHA     .EXE'; Cmd:('e /x+m+  ', 'e /x+m+c+', 'p         ', 't         '); Pwd: Unsupported ),
        (Ext: 'PAK'; Prog: 'PAK     .EXE'; Cmd:('e/WN/PATH', 'e/WA/PATH', 'p         ', 't         '); Pwd: '/g   '     ),
        (Ext: 'ZIP'; Prog: 'PKUNZIP .EXE'; Cmd:('-n -d    ', '-o -d    ', '-c        ', '-t        '); Pwd: '-s   '     ),
        (Ext: 'ZOO'; Prog: 'ZOO     .EXE'; Cmd:('e//      ', 'e//SO    ', 'ep        ', 'eN        '); Pwd: Unsupported )
       )
      );

var
    CfgData : ArcCfg;
    Present : boolean;
    GUSfile : file;


procedure ReadData (var F   : file;
                    var Data: ArcCfg);
 begin
  {$I-}
  reset(F,1);
  {$I+}
  if IOresult<>0
   then begin
         writeln('Can''t find ',GUSname);
         Halt(1);
        end;
  {$I-} seek(F,filesize(F)-sizeof(ArcCfg)); {$I+}
  if IOresult<>0
   then begin
         writeln('Problem: cannot seek to byte location ',filesize(F),' - ',sizeof(ArcCfg));
         Halt(1);
        end;
  {$I-} BlockRead(F,Data,sizeof(ArcCfg)); {$I+}
  if IOresult<>0
   then begin
         writeln('Problem: cannot read ',sizeof(ArcCfg),' bytes in ',GUSname,' at offset ',filepos(F));
         Halt(1);
        end;
  close(F);
  writeln('Reading configuration information from ',GUSname)
 end; {ReadData}


procedure AppendData (var F   : file;
                      var Data: ArcCfg);
 begin
  Data.Marker:=CfgMarker;
  reset(F,1);
  seek(F,filesize(F));
  BlockWrite(F,Data,sizeof(ArcCfg));
  close(F);
  writeln('Appending configuration information to ',GUSname)
 end; {AppendData}


procedure UpdateData (var F   : file;
                      var Data: ArcCfg);
 begin
  Data.Marker:=CfgMarker;
  reset(F,1);
  seek(F,filesize(F)-sizeof(ArcCfg));
  BlockWrite(F,Data,sizeof(ArcCfg));
  close(F);
  writeln('Updating configuration information in ',GUSname)
 end; {UpdateData}

begin {=MAIN=}
 assign(GUSfile,GUSname);
 ReadData(GUSfile,CfgData);
 Present:=(CfgData.Marker=CfgMarker);
 if Present
  then UpdateData(GUSfile,ArcInfo)
  else AppendData(GUSfile,ArcInfo)
end.
