#--------------------------------------------------------------------------#
#                                                                          #
#                                                                          #
#      ------------         Bit-Bucket Software, Co.                       #
#      \ 10001101 /         Writers and Distributors of                    #
#       \ 011110 /          Freely Available<tm> Software.                 #
#        \ 1011 /                                                          #
#         ------                                                           #
#                                                                          #
#  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. #
#                                                                          #
#                                                                          #
#            Makefile for BinkleyTerm (Microsoft NMAKE version)            #
#                                                                          #
#                                                                          #
#                       BinkleyTerm Licensing Terms                        #
#                                                                          #
#                                                                          #
# (C) Copyright 1987-91 Bit Bucket Software Co., a Delaware Corporation.   #
# ALL RIGHTS RESERVED. COMMERCIAL DISTRIBUTION AND/OR USE PROHIBITED       #
# WITHOUT WRITTEN PERMISSION FROM BIT BUCKET SOFTWARE CO.                  #
#                                                                          #
# Non-Commercial distribution and/or use is permitted under the following  #
# terms:                                                                   #
#                                                                          #
#                                                                          #
# 1. You may copy and distribute verbatim copies of BinkleyTerm source,    #
# documentation, and executable code as you receive it, in any medium,     #
# provided that you conspicuously and appropriately publish on each copy a #
# valid copyright notice "(C) Copyright 1987-91, Bit Bucket Software Co."; #
# keep intact the notices on all files that refer to this License          #
# Agreement and to the absence of any warranty;  PROVIDE UNMODIFIED COPIES #
# OF THE DOCUMENTATION AS PROVIDED WITH THE PROGRAM; and give any other    #
# recipients of the BinkleyTerm program a copy of this License Agreement   #
# along with the program.  You may charge a distribution fee for the       #
# physical act of transferring a copy, but no more than is necessary to    #
# recover your actual costs incurred in the transfer. Under no             #
# circumstances is BinkleyTerm to be distributed in such a way as to be    #
# construed as "value added" in a sales transaction, such as, but not      #
# limited to, software bundled with a modem or CD-ROM software             #
# collections.                                                             #
#                                                                          #
# 2. You may modify your copy or copies of BinkleyTerm or any portion of   #
# it, and copy and distribute such modifications under the terms of        #
# Paragraph 1 above, provided that you also do the following:              #
#                                                                          #
#     a) cause the modified files to carry prominent notices stating       #
#     that you changed the files and the date of any change;               #
#                                                                          #
#     b) cause the executable code of such modified version to clearly     #
#     identify itself as such in the course of its normal operation;       #
#                                                                          #
#     c) if the modified version is not a "port", but operates in the      #
#     same hardware and/or software environment as the original            #
#     distribution, make the original version equally available,           #
#     clearly identifying same as the original, unmodified version;        #
#                                                                          #
#     d) cause the whole of any work that you distribute or publish,       #
#     that in whole or in part contains or is a derivative of              #
#     BinkleyTerm or any part thereof, to be licensed at no charge to      #
#     all third parties on terms identical to those contained in this      #
#     License Agreement (except that you may choose to grant more          #
#     extensive warranty protection to some or all third parties, at       #
#     your option); and                                                    #
#                                                                          #
#     e) send the complete source code modifications to Bit Bucket         #
#     Software Co. at one of the addresses listed below,  for the          #
#     purpose of evaluation for inclusion in future releases of            #
#     BinkleyTerm.  Should your source code be included in BinkleyTerm,    #
#     Bit Bucket Software Co. retains all rights for redistribution of     #
#     the code as part of BinkleyTerm and all derivative works, with       #
#     appropriate credit given to the author of the modification.          #
#                                                                          #
#     f) You may charge a distribution fee for the physical act of         #
#     transferring a copy, but no more than is necessary to recover        #
#     your actual costs incurred in the transfer, and you may at your      #
#     option offer warranty protection in exchange for a fee.              #
#                                                                          #
# 3. Mere aggregation of another unrelated program with this program and   #
# documentation (or derivative works) on a volume of a storage or          #
# distribution medium does not bring the other program under the scope of  #
# these terms.                                                             #
#                                                                          #
# 4. You may copy and distribute BinkleyTerm and its associated            #
# documentation (or a portion or derivative of it, under Paragraph 2) in   #
# object code or executable form under the terms of Paragraphs 1 and 2     #
# above provided that you also do one of the following:                    #
#                                                                          #
#     a) accompany it with the complete corresponding machine-readable     #
#     source code, which must be distributed under the terms of            #
#     Paragraphs 1 and 2 above; or,                                        #
#                                                                          #
#     b) accompany it with a written offer, valid for at least three       #
#     years, to give any third party free (except for a nominal            #
#     shipping charge) a complete machine-readable copy of the             #
#     corresponding source code, to be distributed under the terms of      #
#     Paragraphs 1 and 2 above; or,                                        #
#                                                                          #
#     c) accompany it with the information you received as to where        #
#     the corresponding source code may be obtained.  (This                #
#     alternative is allowed only for noncommercial distribution and       #
#     only if you received the program in object code or executable        #
#     form alone.)                                                         #
#                                                                          #
# For an executable file, complete source code means all the source code   #
# for all modules it contains; but, as a special exception, it need not    #
# include source code for modules which are standard libraries that        #
# accompany the operating system on which the executable file runs.        #
#                                                                          #
# 5. You may not copy, sublicense, distribute or transfer BinkleyTerm and  #
# its associated documentation  except as expressly provided under this    #
# License Agreement.  Any attempt otherwise to copy, sublicense,           #
# distribute or transfer BinkleyTerm is void and your rights to use the    #
# program under this License agreement shall be automatically terminated.  #
# However, parties who have received computer software programs from you   #
# with this License Agreement will not have their licenses terminated so   #
# long as such parties remain in full compliance, and notify Bit Bucket    #
# Software Co. of their intention to comply with this Agreement.           #
#                                                                          #
# 6. If you wish to incorporate parts of BinkleyTerm into other free       #
# programs whose distribution conditions are different, please contact     #
# Bit Bucket Software Co. at one of the addresses listed below.  We have   #
# not yet worked out a simple rule that can be stated here, but we will    #
# usually permit this.  We will be guided by the two goals of preserving   #
# the free status of all derivatives of our free software (as it pertains  #
# to Non-Commercial use as provided by this Agreement) and of promoting    #
# the sharing and reuse of software.                                       #
#                                                                          #
# 7. For the purposes of this document, "COMMERCIAL USE" is defined as     #
# operation of the software on four or more computers or data lines owned  #
# by the same for-profit organization. Any organization may operate this   #
# software under the terms of this Non-Commercial Agreement if operation   #
# is limited to three or less computers or data lines.                     #
#                                                                          #
#                                                                          #
#                                NO WARRANTY                               #
#                                                                          #
# BECAUSE BINKLEYTERM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY NO #
# WARRANTY.  EXCEPT WHEN OTHERWISE STATED IN WRITING, BIT BUCKET SOFTWARE  #
# CO. AND/OR OTHER PARTIES PROVIDE BINKLEYTERM "AS IS" WITHOUT WARRANTY OF #
# ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,    #
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR   #
# PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF           #
# BINKLEYTERM, AND THE ACCURACY OF ITS ASSOCIATED DOCUMENTATION, IS WITH   #
# YOU.  SHOULD BINKLEYTERM OR ITS ASSOCIATED DOCUMENTATION PROVE           #
# DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR     #
# CORRECTION.                                                              #
#                                                                          #
# IN NO EVENT WILL BIT BUCKET SOFTWARE CO. BE RESPONSIBLE IN ANY WAY FOR   #
# THE BEHAVIOR OF MODIFIED VERSIONS OF BINKLEYTERM. IN NO EVENT WILL       #
# BIT BUCKET SOFTWARE CO. AND/OR ANY OTHER PARTY WHO MAY MODIFY AND        #
# REDISTRIBUTE BINKLEYTERM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR        #
# DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,      #
# INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY  #
# TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED #
# INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE      #
# PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) BINKLEYTERM, EVEN IF YOU     #
# HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM   #
# BY ANY OTHER PARTY.                                                      #
#                                                                          #
#                                                                          #
# You can contact Bit Bucket Software Co. at any one of the following      #
# addresses:                                                               #
#                                                                          #
# Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             #
# P.O. Box 460398                AlterNet 7:491/0                          #
# Aurora, CO 80046               BBS-Net  86:2030/1                        #
#                                Internet f491.n343.z1.fidonet.org         #
#                                                                          #
#                                                                          #
# Please feel free to contact us at any time to share your comments about  #
# our software and/or licensing policies.                                  #
#                                                                          #
# Our thanks to Richard Stallman and the Free Software Foundation, Inc.,   #
# for most of the wording of this License.                                 #
#                                                                          #
#--------------------------------------------------------------------------#

#
# Definitions
#

PROJ = BINKLEY
PROJFILE = BINKLEY.MAK

SRC_DIR  = ..\src
INCL_DIR = ..\include

CC  = cl
ASM = masm

LINKER = link
LRF  = echo > NUL

#
# Default C Compiler flags: 
# Compile only, Medium Model,
# Optimize for speed, only one return per function, No stack checking,
# Pack structures, Include CodeView symbols, Maximum Warning Level
#
# Important point: for MSC 4.0, instead of -Oslern, use -Ot
#                  for MSC 5.0,                     use -Os 
#                  for MSC 5.1,                     use -Oxrn
#                  for MSC 6.0a,                    use -Olerg
#
# The following is for MSC 6.0a
CFLAGS = -c -Lr -EM -AL -Olerg -Gs -Zp -Zi -W4 -I $(INCL_DIR)

#
# Object files that MSC (4.0, 5.0 or 5.1) is responsible for generating:
#

# First those for the main BinkleyTerm module
#
COBJS = bt.obj       btconfig.obj langload.obj timer.obj    misc.obj     \
        b_help.obj   file_dos.obj dosfuncs.obj keymap.obj   b_today.obj  \
        mdm_proc.obj b_script.obj b_fuser.obj  nodeproc.obj version7.obj \
	b_proto.obj  b_bbs.obj    b_search.obj b_sessio.obj recvbark.obj \
	yoohoo.obj   b_wazoo.obj  b_wzsend.obj ftsc.obj     mailer.obj   \
	sendbark.obj sched.obj    fossil.obj   b_passwo.obj b_frproc.obj \
	zreceive.obj zsend.obj    zmisc.obj    sendsync.obj recvsync.obj \
        data.obj     vfossil.obj  b_termov.obj b_banner.obj b_initva.obj \
        b_sbinit.obj b_flofil.obj mailovly.obj evtparse.obj b_whack.obj  \
	sb_box.obj   sb_fill.obj  sb_init.obj  sb_move.obj  sb_new.obj   \
	sb_put.obj   sb_read.obj  sb_scrl.obj  sb_show.obj  sb_write.obj \
	sb_popup.obj sb_save.obj  b_spawn.obj  b_rspfil.obj b_term.obj   \
	xmsend.obj   m7send.obj   bsend.obj    brec.obj     xmrec.obj    \
	m7rec.obj    janus.obj    statetbl.obj outbound.obj overlay.obj  \
        mailroot.obj upload.obj   download.obj

# Next those for BTCTL, the program that makes a dummy OMMM CTL file
#
COBJ1 = btctl.obj

# Then those for BTLNG, Bink's language compiler
COBJ2 = btlng.obj get_lang.obj put_lang.obj

#
# Object files that MASM (4.0, 5.0 or 5.1) is responsible for generating
#
MOBJS = spawn.obj bink_asm.obj

#
# Dependency list for regular and debug version, and LINK
# command lines
#

all:	english.bxt bt.exe btctl.exe btlng.exe

bt.exe: $(COBJS) $(MOBJS)
	$(LRF) @<<$(PROJ).lrf
/EXEPACK bt.obj+b_term.obj+
timer.obj+misc.obj+file_dos.obj+keymap.obj+
mdm_proc.obj+nodeproc.obj+version7.obj+b_wzsend.obj+
b_sessio.obj+b_wazoo.obj+b_spawn.obj+spawn.obj+
ftsc.obj+mailer.obj+mailroot.obj+b_today.obj+
fossil.obj+b_frproc.obj+b_flofil.obj+
sb_fill.obj+sb_move.obj+sb_popup.obj+
sb_put.obj+sb_scrl.obj+sb_show.obj+sb_write.obj+
bink_asm.obj+
dosfuncs.obj+data+vfossil.obj+statetbl.obj+overlay.obj+
(xmsend.obj+m7send.obj+bsend.obj+recvbark.obj)+
(xmrec.obj+m7rec.obj+brec.obj+sendbark.obj)+
(sched.obj+b_bbs.obj+b_banner.obj+b_help.obj+
mailovly.obj+b_rspfil.obj)+
(langload.obj+btconfig.obj+evtparse.obj)+
(b_termov.obj+b_script.obj+b_proto.obj+upload.obj+download.obj)+
(yoohoo.obj+b_whack.obj+
b_passwo.obj+sendsync.obj+recvsync.obj)+
(zreceive.obj+zsend.obj+zmisc.obj)+
(janus.obj)+
(b_initva.obj+b_sbinit.obj+sb_box.obj+sb_init.obj+sb_new.obj+
b_search.obj+b_fuser.obj+outbound.obj+sb_read.obj+sb_save.obj),
$*/STACK:4000,$*/MAP/LI;
<<
	$(LINKER) @$(PROJ).lrf

btbig.exe: $(COBJS) $(MOBJS)
	$(LRF) @<<$(PROJ).lrf
/EXEPACK $(COBJS: = +^
) +
$(MOBJS: = +^
)
$*/STACK:4000
$*/MAP/LI;
<<
	$(LINKER) @$(PROJ).lrf

english.bxt : btlng.exe $(SRC_DIR)\english.txt
	btlng $(SRC_DIR)\english.txt english.bxt

bt-dbg.exe: $(COBJS) $(MOBJS)
	$(LRF) @<<$(PROJ).lrf
/CODEVIEW $(COBJS: = +^
) +
$(MOBJS: = +^
)
$*/STACK:4000
$*/MAP/LI;
<<
	$(LINKER) @$(PROJ).lrf

btctl.exe: $(COBJ1)
	link /EXEPACK $(COBJ1), $*/stack:3000,$*/map/li;

btlng.exe: $(COBJ2)
	link /EXEPACK $(COBJ2), $*/stack:3000,$*/map/li;

#
# Dependencies for .C files and compiler line to generate 'em.
#
$(COBJS): $(SRC_DIR)\$*.c $(INCL_DIR)\com.h $(INCL_DIR)\xfer.h $(INCL_DIR)\bink.h
	$(CC) $(CFLAGS) $(SRC_DIR)\$*.c

$(COBJ1): $(SRC_DIR)\$*.c $(INCL_DIR)\com.h $(INCL_DIR)\xfer.h $(INCL_DIR)\bink.h
	$(CC) $(CFLAGS) $(SRC_DIR)\$*.c

$(COBJ2): $(SRC_DIR)\$*.c $(INCL_DIR)\language.h
	$(CC) $(CFLAGS) $(SRC_DIR)\$*.c
#
# Modules with special includes here
#
langload.obj: $(INCL_DIR)\msgs.h

#
# Dependencies for .ASM files and compiler line to generate 'em.
#
# Important point: for MASM 4.0, leave out the -Zi switch.
#
# For MASM 4.0, leave out the -Zi switch.
# For TASM 1.0, use /zi instead of -Zi
#

$(MOBJS): $(SRC_DIR)\$*.asm
	$(ASM) -Zi -DMODL=LARGE $(SRC_DIR)\$*;
