/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*                                                                          */
/*                BinkleyTerm BBS / UUCP Session Initiator                  */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifdef Snoop
#include "snserver.h"
extern HSNOOP hsnoop;
#endif /* Snoop */

void BBSexit ()
{
   int retval;
   int xit = 0;
   unsigned int baudrate;
   char command[80];
   FILE *bbsbatch;
   long t1, t2;

   if (BBSnote != NULL)
      {
      (void) SendBanner ((char far *)"\r\n");    /* Start with newline    */
      (void) SendBanner ((char far *)BBSnote);   /* Tell user we're going */
      (void) SendBanner ((char far *)"\r\n");    /* End it with a newline */
      }

   t1 = timerset (100);
   t2 = timerset (400);

   /* Wait for output complete, 4 seconds, or carrier loss */

   while (!OUT_EMPTY () && !timeup (t2) && CARRIER)
      ;

   /* Make sure we waited at least 1 second */
   while (CARRIER && !timeup (t1))
      ;

   /* Now if there is no carrier bag it */
   if (!CARRIER)
      {
      status_line (MSG_TXT(M_NO_CARRIER));
      return;
      }

   ++hist.bbs_calls;
   if (un_attended && fullscreen)
      {
      (void) sprintf (junk, "%d/%d", hist.bbs_calls, hist.mail_calls);
      sb_move (history_hWnd, HIST_BBS_ROW, HIST_COL);
      sb_puts( history_BBS, junk );
      }

   if ((lock_baud && (btypes[baud].rate_value >= (unsigned)lock_baud))
   || (ARQ_lock != 0))
      baudrate = max_baud.rate_value;
   else baudrate = cur_baud.rate_value;

   if (strnicmp (BBSopt, "batch", 5) == 0)       /* if BBS flag is "batch" */
      {
      (void) strcpy (command, COMFILE_PREFIX);          /* Start of batch filename*/
      (void) strcat (command, "BBSBATCH");              /* Meat of Batch filename */
      (void) strcat (command, COMFILE_SUFFIX);          /* End of batch filename  */

      (void) unlink (command);                          /* Delete old copies      */
      if ((bbsbatch = fopen (command, "wt")) == NULL)   /* Try to open it  */
         {
         (void) got_error (MSG_TXT(M_OPEN_MSG), command);
         return;
         }
      errno = 0;

      (void) fprintf (bbsbatch, "SPAWNBBS %u %u %d %d %s\n",
               baudrate, cur_baud.rate_value,
                  hfComHandle, time_to_next (1), mdm_reliable);

      (void) fclose (bbsbatch);
      xit = 1;
      }

   if ((strnicmp (BBSopt, "exit", 4) == 0) || (xit))    /* "exit" or "batch" ??   */
      {
      retval = (int) (baudrate / 100);
      status_line (MSG_TXT(M_BBS_EXIT), retval);
      if (vfossil_installed)
         vfossil_close ();

      if (!share)                                /* Turn off FOSSIL,       */
         MDM_DISABLE ();                         /* if need be             */
      write_sched ();
      exit (retval);                             /* and exit with error    */
      }

   if (strnicmp (BBSopt, "spawn", 5) == 0)       /* if BBS flag is "spawn" */
      {
      status_line (MSG_TXT(M_BBS_SPAWN));
      gotoxy (0, SB_ROWS);
      (void) sprintf (command, "SPAWNBBS %u %u %d %d %s",
               baudrate, cur_baud.rate_value,
                  hfComHandle, time_to_next (1), mdm_reliable);
      close_up ();

      /* Run the BBS */
      b_spawn (command);

      come_back ();
      status_line (MSG_TXT(M_BBS_RETURN));
      }
}

void close_up ()
{
   if (!share)
       MDM_DISABLE ();

   vfossil_close ();

   /* Close the log file */
   if (status_log != NULL)
      (void) fclose (status_log);
#ifdef Snoop
   if (hsnoop != (HSNOOP)NULL)
      snoop_close();
#endif /* Snoop */
}

void come_back ()
{
#ifdef Snoop
   if (pipename[0] != '\0')
      {
      if (hsnoop == (HSNOOP)NULL)
         snoop_open(pipename);
      else
         snoop_open(NULL);
      }
#endif /* Snoop */

   /* Re-enable ourselves */
   if (Cominit (port_ptr, buftmo) != 0x1954)
      {
      (void) printf ("\n%s\n", MSG_TXT(M_FOSSIL_GONE));
      exit (1);
      }

   if (status_log != NULL)
      {
      if ((status_log = share_fopen (log_name, "at", DENY_WRITE)) == NULL)
         {
         (void) printf ("\n%s\n", MSG_TXT(M_NO_LOGFILE));
         }
      }

   program_baud ();
   vfossil_init ();
   if (fullscreen && un_attended)
      {
      screen_clear ();
      sb_dirty ();
      opening_banner ();
      mailer_banner ();
      sb_show ();
      }
}


void UUCPexit (int n)
{
   unsigned int baudrate;
   char command[80];
   FILE *mailbatch;
   long t1, t2;

   if (MAILnote != NULL)
      {
      (void) SendBanner ((char far *)"\r\n");    /* Start with newline */
      (void) SendBanner ((char far *)MAILnote);  /* Say it's mail time */
      (void) SendBanner ((char far *)"\r\n");    /* End with a newline */
      }

   t1 = timerset (100);
   t2 = timerset (400);

   /* Wait for output complete, 4 seconds, or carrier loss */

   while (!OUT_EMPTY () && !timeup (t2) && CARRIER)
      ;

   /* Make sure we waited at least 1 second */
   while (CARRIER && !timeup (t1))
      ;

   /* Now if there is no carrier bag it */
   if (!CARRIER)
      {
      status_line (MSG_TXT(M_NO_CARRIER));
      return;
      }

   if ((lock_baud && (btypes[baud].rate_value >= (unsigned)lock_baud))
   || (ARQ_lock != 0))
      baudrate = max_baud.rate_value;
   else baudrate = cur_baud.rate_value;

   (void) strcpy (command, COMFILE_PREFIX);            /* Start of batch filename*/
   (void) strcat (command, "MAILBAT");                 /* Meat of Batch filename */
   (void) strcat (command, COMFILE_SUFFIX);            /* End of batch filename  */

   (void) unlink (command);                             /* Delete old copies */
   if ((mailbatch = fopen (command, "at")) == NULL) /* Try to open it */
      {
      (void) got_error (MSG_TXT(M_OPEN_MSG), command);
      return;
      }

   (void) fprintf (mailbatch, "EXTMAIL %u %u %d %d %d %s\n",
               baudrate, cur_baud.rate_value,
                  hfComHandle, time_to_next (1), n, mdm_reliable);
   (void) fclose (mailbatch);

   status_line (MSG_TXT(M_EXT_MAIL), n);

   if (vfossil_installed)
      vfossil_close ();

   if (!share)                                   /* Turn off FOSSIL,          */
      MDM_DISABLE ();                            /* if need be                */

   write_sched ();                               /* Save scheduler info       */
   exit (n);                                     /* and exit with UUCP error  */
}

