/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*          This module was originally written by Vince Perriello           */
/*                                                                          */
/*                                                                          */
/*                   BinkleyTerm Variable Initialization                    */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

void compile_externs (void);
void fillin_defaults (struct secure *, struct secure *);

/**
 ** b_initvars -- called before parse_config. Sets defaults that we want
 ** to have set FIRST.
 **/


void b_initvars ()
{
    int k;
    char *envp;
    BINK_EVENT far *p;
    BINK_EVENT foo;

    if ((envp = getenv ("TZ")) != NULL)
        {
        if ((saved_TZ = calloc( 1, 4 + strlen (envp))) != NULL)
            {
            (void) strcpy (saved_TZ, "TZ=");
            (void) strcat (saved_TZ, envp);
            }
        }

    (void) putenv ("TZ=GMT0");
    tzset ();


    p = (BINK_EVENT far *) _fmalloc( 256 * sizeof (BINK_EVENT));
    if (p == (BINK_EVENT far *) NULLGLOBALPTR)
        {
        (void) printf (MSG_TXT(M_BAD_EVENT_ALLOC));
        exit (252);
        }

    (void) memset ((char *)&foo, 0 , sizeof (foo));

    e_ptrs = p;

    for (k = 0; k < 256; k++)
        {
        *p++ = foo;
        }

    (void) memset ((char *)&DEFAULT, 0 , sizeof (DEFAULT));

    KNOWN = DEFAULT;                            /* Does some of the work      */
    KNOWN.rq_Limit = -1;
    KNOWN.byte_Limit = -1L;
    KNOWN.time_Limit = -1;
    KNOWN.rq_Cum_Limit = -1;
    KNOWN.byte_Cum_Limit = -1L;
    KNOWN.time_Cum_Limit = -1L;

    PROT = KNOWN;                               /* Initially the same default */

    for (k = 0; k < 10; k++)                    /* Zero the phone scan list   */
        {
        scan_list[k] = NULL;
        }

    for (k = 0; k < MAX_EXTERN; k++)            /* And the external protocols */
        {
        protocols[k] = NULL;
        }

    for (k = 1; k < ALIAS_CNT; k++)             /* And the alias list         */
        {
        alias[k].Zone = alias[k].Net = alias[k].Node = alias[k].Point = 0;
        alias[k].Domain = NULL;
        }

    alias[0].Zone = 1;                          /* Make sure we have a zone   */
    alias[0].Net = alias[0].Node = (unsigned) -1;  /* Default Fidonet address */
    alias[0].Point = 0;
    alias[0].Domain = NULL;

#ifdef Snoop
    pipename[0] = '\0';                         /* Make sure we have no name  */
    if (getenv("SNOOPPIPE") != NULL)
       {
       strcpy (pipename, getenv("SNOOPPIPE"));
       snoop_open(pipename);
       }
#endif

    b_init ();

    baud = 2;
    cur_baud = btypes[baud];
    command_line_un = 0;

    (void) memset (&dta_str, 0, sizeof (dta_str));

}

/**
 ** b_defaultvars -- called after all parse_config passes complete.
 ** sets anything not handled by parse_config to default if we know it.
 **/


void b_defaultvars ()
{
    int i;
    char *p;

    if (!fullscreen)
        do_screen_blank = 0;

    if (version7)
        nodelist_name = "NODEX";
    else
        nodelist_name = "NODELIST";

    if (modem_init == NULL)
        modem_init = ctl_string ("|AT|");
    if (modem_busy == NULL)
        modem_busy = ctl_string ("|AT|");

    if (net_info == NULL)
        net_info = ctl_string (".\\");


    /* Set up "boss" and "point" addresses correctly if we can */

    if (boss_addr.Zone == 0)
        boss_addr.Zone = alias[0].Zone;

    if (boss_addr.Net == 0)
        {
        boss_addr = alias[0];
        boss_addr.Point = 0;
        }

    if ((pvtnet >= 0) && (alias[0].Point != 0))
        {
        my_addr = boss_addr;
        my_addr.Point  = alias[0].Point;
        alias[0].Net   = (unsigned) pvtnet;
        alias[0].Node  = alias[0].Point;
        alias[0].Point = 0;
        }
    else
        my_addr = alias[0];

    /* If we have the minimum information to do netmail, set the flag */

    if ((alias[0].Zone      != 0)
    &&  (alias[0].Net       != 0)
    &&  (system_name        != NULL)
    &&  (sysop              != NULL)
    &&  (hold_area          != NULL)
    &&  (DEFAULT.sc_Inbound != NULL))
        {
        net_params = 1;
        (void) flag_file (INITIALIZE, &alias[0], 0);
        }

    if (system_name == NULL)
        system_name = "";

    if (hold_area == NULL)
        hold_area = ctl_string (".\\");

    if (DEFAULT.sc_Inbound == NULL)
        DEFAULT.sc_Inbound = ctl_string (".\\");

    /* Make the "higher class" requests at least as well off as the
        "lowest class"... */

    fillin_defaults (&KNOWN, &DEFAULT);
    fillin_defaults (&PROT, &KNOWN);

    if (extern_index)
        compile_externs ();                     /* generate extern_protocols  */

    if (!colors.calling && colors.hold)
        colors.calling = (unsigned char)(((colors.hold & 0x70) >> 4) | ((colors.hold & 0x7) << 4) | (colors.hold & 0x8));

    if ((!colors.popup) && colors.call)
        colors.popup = colors.call;

    first_block = 0;

    /* Make our domain first in the list */
    if (my_addr.Domain != NULL)
        {
        for (i = 0; domain_name[i] != NULL; i++)
            {
            if (domain_name[i] == my_addr.Domain)
                break;
            }

        if ((i > 0) && (domain_name[i] == my_addr.Domain))
            {
            p = domain_name[0];
            domain_name[0] = domain_name[i];
            domain_name[i] = p;
            p = domain_nodelist[0];
            domain_nodelist[0] = domain_nodelist[i];
            domain_nodelist[i] = p;
            p = domain_abbrev[0];
            domain_abbrev[0] = domain_abbrev[i];
            domain_abbrev[i] = p;
            }
        }

    set_prior(4);                                           /* Always High    */

    if (Cominit (port_ptr, buftmo) != 0x1954)
        {
        (void) printf (MSG_TXT(M_DRIVER_DEAD_1));
        (void) printf (MSG_TXT(M_DRIVER_DEAD_2));
        (void) printf (MSG_TXT(M_DRIVER_DEAD_3));
        set_prior(2);                                       /* Regular        */
        exit (1);
        }

    i = un_attended;
    un_attended = 0;

    (void) set_baud (max_baud.rate_value, 0);
    un_attended = i;

    MDM_ENABLE (lock_baud && (btypes[baud].rate_value >= (unsigned)lock_baud) ? max_baud.rate_mask : btypes[baud].rate_mask);
    RAISE_DTR ();
    XON_ENABLE ();

    set_prior(2);                                           /* Regular        */

    Txbuf = Secbuf = (byte *) calloc( 1, WAZOOMAX + 16);
    if (!Txbuf)
        {
        status_line (MSG_TXT(M_MEM_ERROR));
        exit (2);
        }

/*
 * Pointing it to the middle of the buffer allows us to pop up
 * file transfer windows if we choose to do so.
 */

    popbuf = Secbuf + 1500;

/*
 * Do a couple of system-related things.
 * Maybe they shouldn't be here -- but better here than in BT.C.
 *
 * Because of some config verbs that affect its behavior, mtask_find
 * MUST follow parse_config!
 */

    fossil_ver ();
    mtask_find ();
}

void compile_externs ()
{
    register char *c;
    register i;
    char junk[100];
    int j, k, l;
    char *p;
    char x;

    i = l = 0;                                      /* start at beginning     */
    junk [0] = '\0';

    for (k = 0; protocols[k] != NULL; k++)          /* Total no. of protos    */
        {
        c = protocols[k];                           /* Point at filename      */
        if (!dexists (c))                           /* Is it there?           */
            {
            (void) printf ("%s %s\n", MSG_TXT(M_NO_PROTOCOL), c);
            continue;
            }
        p = NULL;
        while (*c)                                  /* Until end of string    */
            {
            if ((*c == '\\') || (*c == ':'))        /* Look for last path     */
                p = c;                              /* Delimiter              */
            c++;
            }
        if (strlen (p) < 3)                         /* If no name,            */
            continue;                               /* No protocol...        */

        p++;                                        /* Point to the          */
        x = (char) toupper (*p);                    /* First character      */
        if (strchr (junk, x) != NULL)
            {
            (void) printf ("%s %s\n", MSG_TXT(M_DUP_PROTOCOL), c);
            continue;
            }

        protos[l].first_char = x;                   /* Makes lookup fast      */
        protos[l++].entry = k;                      /* Now we know where      */

        junk[i++] = x;                              /* Store first char       */
        junk[i++] = ')';                            /* Then a ')'             */
        c = ++p;                                    /* Point to 2nd char      */
        for (j = 0; j < 9; j++)                     /* Up to 9 chars more     */
            {
            if (*c != '.')                          /* If no comma yet,       */
                {
                junk[i++] = (char) tolower (*c);    /* store the char and     */
                ++c;                                /* bump the pointer       */
                }
            else junk[i++] = ' ';                   /* otherwise pad it       */
            }
        junk[i++] = ' ';                            /* And one more space     */
        junk[i] = '\0';                             /* Need for testing       */
        }

    if (!i)                                         /* If we got none,        */
        return;                                     /* Return now.            */

    i += 2;                                         /* Total for malloc       */
    if ((extern_protocols = calloc( 1, (unsigned) i)) == NULL) /* Allocate string*/
        return;                                     /* Return on failure      */
    (void) strcpy (extern_protocols, junk);         /* Copy the string        */
    return;                                         /* Back to caller         */
}

void fillin_defaults (struct secure *higher, struct secure *lower)
{
    if (higher->time_Limit == -1)
        higher->time_Limit = lower->time_Limit;
    if (higher->byte_Limit == -1L)
        higher->byte_Limit = lower->byte_Limit;
    if (higher->rq_Limit == -1)
        higher->rq_Limit = lower->rq_Limit;

    if (higher->time_Cum_Limit == -1)
        higher->time_Cum_Limit = lower->time_Cum_Limit;
    if (higher->byte_Cum_Limit == -1L)
        higher->byte_Cum_Limit = lower->byte_Cum_Limit;
    if (higher->rq_Cum_Limit == -1)
        higher->rq_Cum_Limit = lower->rq_Cum_Limit;

    if (higher->rq_FILES == NULL)
        higher->rq_FILES = lower->rq_FILES;
    if (higher->rq_OKFile == NULL)
        higher->rq_OKFile = lower->rq_OKFile;
    if (higher->rq_About == NULL)
        higher->rq_About = lower->rq_About;
    if (higher->rq_Template == NULL)
        higher->rq_Template = lower->rq_Template;
    if (higher->sc_Inbound == NULL)
        higher->sc_Inbound = lower->sc_Inbound;
}


/**
 ** b_exitproc -- called by mainline to do exit processing.
 **/

void b_exitproc ()
{
    if (command_line_un)
        {
        mdm_init (modem_busy);
        exit_DTR ();
        }

    vfossil_cursor (1);

    while (KEYPRESS ())
        {
        (void) FOSSIL_CHAR ();
        }

#ifdef MILQ
    SB_ROWS = 24;
#endif

    gotoxy (0, SB_ROWS);
    clear_eol ();
    (void) printf (MSG_TXT(M_THANKS), ANNOUNCE);
    clear_eol ();
    (void) printf (MSG_TXT(M_ANOTHER_FINE_PRODUCT));

    if (vfossil_installed)
        vfossil_close ();

    if (!share) {
        set_prior(4);                                                /* Always High */
        MDM_DISABLE ();
        set_prior(2);                                                /* Regular */
    }
}


