/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*           Communications (FOSSIL) definitions for BinkleyTerm            */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* MACROS that call the routines in COM_ASM                                 */
/*--------------------------------------------------------------------------*/
extern  unsigned Com_           (char, byte);
extern  unsigned Cominit        (int, int);
extern  int      READBYTE();
/*#define M_INSTALL(b)       {Cominit(com_port);Com_(0x0f,0);Com_(0x0f,handshake_mask);new_baud(0,b);}*/


                           /*-----------------------------------------------*/
                           /* Service 0: SET BAUD(etc)                      */
                           /*-----------------------------------------------*/
/*#define MDM_ENABLE(b)      (Com_(0x00,b|NO_PARITY|STOP_1|BITS_8))*/

                           /*-----------------------------------------------*/
                           /* Service 1: SEND CHAR (wait)                   */
                           /*-----------------------------------------------*/
/*#define SENDBYTE(x)    (Com_(0x01,x))*/
                           /*-----------------------------------------------*/
                           /* Service 2: GET CHAR (wait)                    */
                           /*-----------------------------------------------*/
/*#define MODEM_IN()         (Com_(0x02)&0x00ff)*/

                           /*-----------------------------------------------*/
                           /* Service 3: GET STATUS                         */
                           /*-----------------------------------------------*/
/*#define MODEM_STATUS()     (Com_(0x03))*/
#define CARRIER            (Com_(0x03,0)&carrier_mask)
#define CHAR_AVAIL()       (MODEM_STATUS()&DATA_READY)
#define OUT_EMPTY()        (Com_(0x03,0)&TX_SHIFT_EMPTY)
#define OUT_FULL()         (!(Com_(0x03,0)&TX_HOLD_EMPTY))

                           /*-----------------------------------------------*/
                           /* Service 4: INIT/INSTALL                       */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 5: UNINSTALL                          */
                           /*-----------------------------------------------*/
/*#define MDM_DISABLE()      (Com_(0x05,BAUD_2400|NO_PARITY|STOP_1|BITS_8))*/

                           /*-----------------------------------------------*/
                           /* Service 6: SET DTR                            */
                           /*-----------------------------------------------*/
#define LOWER_DTR()        ((void) Com_(0x06,0))
#define RAISE_DTR()        ((void) Com_(0x06,1))

                           /*-----------------------------------------------*/
                           /* Service 7: GET TIMER TICK PARMS               */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 8: FLUSH OUTBOUND RING-BUFFER         */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 9: NUKE OUTBOUND RING-BUFFER          */
                           /*-----------------------------------------------*/
/*#define CLEAR_OUTBOUND()   (Com_(0x09,0))*/

                           /*-----------------------------------------------*/
                           /* Service a: NUKE INBOUND RING-BUFFER           */
                           /*-----------------------------------------------*/
/*#define CLEAR_INBOUND()    (Com_(0x0a,0))*/

                           /*-----------------------------------------------*/
                           /* Service b: SEND CHAR (no wait)                */
                           /*-----------------------------------------------*/
#define Com_Tx_NW(c)       (Com_(0x0b,c))

                           /*-----------------------------------------------*/
                           /* Service c: GET CHAR (no wait)                 */
                           /*-----------------------------------------------*/
/*#define PEEKBYTE()         (Com_(0x0c,0))*/

                           /*-----------------------------------------------*/
                           /* Service d: GET KEYBOARD STATUS                */
                           /*-----------------------------------------------*/
#ifndef MILQ
#define KEYPRESS()         (Com_(0x0d,0)!=(0xffff))
#define FOSSIL_PEEKKB()    (Com_(0x0d,0))
#endif
                           /*-----------------------------------------------*/
                           /* Service e: GET KEYBOARD CHARACTER (wait)      */
                           /*-----------------------------------------------*/
#ifndef MILQ
#define READKB()           (Com_(0x0e,0)&0xff)
#define READSCAN()         (Com_(0x0e,0))
#endif
#define FOSSIL_CHAR()      READSCAN()

                           /*-----------------------------------------------*/
                           /* Service f: SET/GET FLOW CONTROL STATUS        */
                           /*-----------------------------------------------*/
#define XON_ENABLE()       ((void) Com_(0x0f,(byte)handshake_mask))
#define XON_DISABLE()      ((void) Com_(0x0f,(byte)(handshake_mask&(~USE_XON))))
#define IN_XON_ENABLE()    ((void) Com_(0x0f,(byte)(handshake_mask|OTHER_XON)))
#define IN_XON_DISABLE()   ((void) Com_(0x0f,(byte)(handshake_mask&(~OTHER_XON))))

                           /*-----------------------------------------------*/
                           /* Service 10: SET/GET CTL-BREAK CONTROLS        */
                           /*             Note that the "break" here refers */
                           /*             to ^C and ^K rather than the      */
                           /*             tradition modem BREAK.            */
                           /*-----------------------------------------------*/
#define _BRK_ENABLE()      (Com_(0x10,BRK))
#define _BRK_DISABLE()     (Com_(0x10,0))
#define RECVD_BREAK()      (Com_(0x10,BRK)&BRK)

                           /*-----------------------------------------------*/
                           /* Service 11: SET LOCAL VIDEO CURSOR POSITION   */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 12: GET LOCAL VIDEO CURSOR POSITION   */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 13: WRITE LOCAL ANSI CHARACTER        */
                           /*-----------------------------------------------*/
#ifndef MILQ
#define WRITE_ANSI(c)    ((void) Com_(0x13,(byte)(c)))
#endif
                           /*-----------------------------------------------*/
                           /* Service 14: WATCHDOG on/off                   */
                           /*-----------------------------------------------*/
#define FOSSIL_WATCHDOG(x) (Com_(0x14,x))
                           /*-----------------------------------------------*/
                           /* Service 15: BIOS write to screen              */
                           /*-----------------------------------------------*/
#ifndef MILQ
#define WRITE_BIOS(c) (Com_(0x15,(byte)c))
#endif

/*--------------------------------------------------------------------------*/
/*                                                                          */
/* A no-stall ReadByte routine might look like this:                        */
/*                                                                          */
/*    int READBYTE()                                                        */
/*       {                                                                  */
/*       return( CHAR_AVAIL() ? MODEM_IN() : (-1) );                        */
/*       }                                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* END OF FILE: com.h */

