/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                  Common Include Files for BinkleyTerm                    */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/*
 * This file drives all the defines and includes in BinkleyTerm. In
 * here we handle cross-compiler portability issues. It was originally
 * born to make compiled headers (a neat feature of Borland C) work,
 * but the other role quickly caught on as well.
 *
 * Some of the portability stuff will no doubt wind up in other Bink
 * include files -- but the system-level stuff such as utime, etc
 * is all dealt with here.
 *
 * All main Bink modules should include this file before any specific
 * local includes.
 *
 */


/* System include files */

#include <stdio.h>
#include <signal.h>
#include <ctype.h>

#ifdef MEWEL
#include <Window.H>
#include <WinDecls.H>
#include <GSDfn.H>     /* ?????? */
#endif

#if ( !defined(MEWEL) & defined(MILQ) )
#define MILQ
#include <Windows.H>
#include <GSDfn.H>     /* ?????? */
#endif

#ifndef MILQ
#include <conio.h>
#endif

#include <string.h>
#include <process.h>
#include <stdlib.h>
#include <stdarg.h>
#include <io.h>
#include <dos.h>
#include <errno.h>
#include <time.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <share.h>


/*
 * Compiler-specific stuff. The baseline in this sucker is
 * Microsoft C 6.00a. Below what you see are the includes and
 * macros we need to differentiate individual compilers from
 * the baseline.
 *
 * The easiest way to add a new compiler is to replicate the
 * _MSC_VER section using whatever manifest constant your
 * compiler uses to identify itself, then do the fixups in
 * that section.
 *
 * Be sure to put your section before that last define for
 * COMPILER_NAME!
 *
 */


#ifdef __TURBOC__       /* Borland C++ 2.0                */
/*
 * Borland.
 *
 * No sharing stream open. (s)open/fdopen works, though.
 * Signal call is non-generic and incompatible
 * Read/Write to far memory in near model not implemented
 * Console output non-generic
 * No utime call
 *
 */

#ifdef __BORLANDC__
#define COMPILER_NAME   "-Borland"
#else
#define COMPILER_NAME   "-Turbo"
#endif
#define MUST_FDOPEN     /* Share streams: sopen+fdopen    */
#define NO_SIGNALS      /* Don't install a signal handler */
#define NEED_DOSREAD    /* Need our own _dos_(read/write) */
#define NEED_CPUTS      /* Need our own cputs             */
#define NEED_PUTCH      /* Need our own putch             */
#define NEED_CPRINTF    /* Need our own cprintf           */
struct utimbuf {
    time_t actime;      /* access time */
    time_t modtime;     /* modification time */
};
typedef struct utimbuf UTIMBUF;
int cdecl utime(char *, struct utimbuf *);
#define UT_ACTIME actime
typedef long off_t;
#include <mem.h>
#include <dir.h>
#include <alloc.h>
#define _fmalloc(n) farmalloc (n)
#define _ffree(n) farfree (n)
#undef sopen /* we don't want to use all the args */
#define sopen(a,b,c) open (a, b|c)
#endif


#ifdef _MSC_VER         /* Microsoft C 5.1 or 6.0a        */
/*
 * Microsoft.
 *
 * By and large, it's Microsoft compatible <grin>
 *
 * MSC 5.10 and below has no way to open a stream in
 * sharing mode. sopen/fdopen doesn't work.
 *
 */

#if _MSC_VER == 510
#define COMPILER_NAME   "-uSoft5.1"
#endif
#if _MSC_VER == 600
#define COMPILER_NAME   "-uSoft6.0"
#endif
#if _MSC_VER < 600
#define CANT_FSOPEN
#endif
#include <sys/utime.h>
typedef struct utimbuf UTIMBUF;
#define UT_ACTIME actime
#include <memory.h>
#include <direct.h>
#include <malloc.h>
#endif


#ifdef __WATCOMC__      /* WATCOM C 8.0                   */
/*
 * WATCOM.
 *
 * No sharing stream open. sopen/fdopen doesn't work.
 * No mktemp call
 * utime structure member naming different
 *
 */

#define COMPILER_NAME   "-WATCOM"
#define CANT_FSOPEN     /* No way to share streams        */
#define NEED_MKTEMP     /* Need our own mktemp            */
#include <sys/utime.h>
typedef struct utimbuf UTIMBUF;
#define UT_ACTIME acctime /* WCC acctime = actime         */
#include <direct.h>
#include <malloc.h>
#endif


#ifdef __ZTC__          /* Zortech C++ 3.0 */
/*
 * Zortech.
 *
 * No sharing stream open. sopen/fdopen doesn't work.
 * Signal handler stuff incompatible
 * Read/Write to far memory in near model not implemented
 * No console I/O functions
 * No mktemp call
 * utime doesn't use a structure
 * no ultoa, we use more limited ltoa
 * tzset not there or needed
 *
 */

#define COMPILER_NAME   "-Zortech"
#define CANT_FSOPEN     /* No way to share streams        */
#define NO_SIGNALS      /* Don't install a signal handler */
#define NEED_DOSREAD    /* Need our own _dos_(read/write) */
#define NEED_CPUTS      /* Need our own cputs             */
#define NEED_PUTCH      /* Need our own putch             */
#define NEED_MKTEMP     /* Need our own mktemp            */
struct utimbuf {
    time_t actime;      /* access time */
    time_t modtime;     /* modification time */
};
typedef time_t UTIMBUF; /* ZTC utime uses a time_t array  */
#define UT_ACTIME actime
#ifdef __VCM__
#define __LARGE__       /* VCM model same as large, really*/
#endif
typedef long off_t;
#include <direct.h>
#define _fmalloc(n) farmalloc (n)
#define _ffree(n) farfree (n)
#define ultoa(x,y,z) ltoa((long)x,y,z)
#define stricmp(x,y) strcmpl(x,y)
#define _dos_setdrive(x,y) dos_setdrive(x,y)
#define tzset()
#endif


/*
 * Make sure there's at least a zero-length string for
 * the compiler name.
 *
 * THIS LINE SHOULD ALWAYS BE LAST!
 *
 */

#ifndef COMPILER_NAME
#define COMPILER_NAME   ""
#endif

#ifndef OS_2

#ifndef MILQ
typedef unsigned int USHORT;
#endif

typedef int HFILE;
typedef unsigned char far *PCH;
typedef unsigned short HVIO;
#define hfComHandle (port_ptr + 1)
#define COMFILE_PREFIX ""
#define COMFILE_SUFFIX ".BAT"
#endif

/* Local include files */

#include "bink.h"
#include "defines.h"
#include "com.h"
#include "xfer.h"
#include "msgs.h"
#include "zmodem.h"
#include "keybd.h"
#include "keyfncs.h"
#include "sbuf.h"
#include "sched.h"
#include "timer.h"
#include "vfossil.h"
#include "externs.h"
#include "prototyp.h"

#ifdef OS_2 /* This MUST follow our includes, I don't know why */
#define INCL_DOSPROCESS
#include <os2.h>
#define _dos_read DosRead
#define _dos_write DosWrite
#define COMFILE_PREFIX ""
#define COMFILE_SUFFIX ".CMD"
#endif

#define isBITBRAIN 0x1b

