/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*            This module was originally written by Bob Hartman             */
/*                                                                          */
/*                                                                          */
/*                         Outbound Manipulating                            */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

int add_request (char *, char *, char *, char *);
int add_send (char *, char *, char *);
int kill_node (char *);

int Overlay_Do_Get (BINK_SAVEP p, int x)
{
#ifndef MILQ
    REGIONP r;
    char node[51];
    char file[13];
    char password[9];
    char flavor[2];
    char sure[2];
#endif

#ifndef MILQ
    if (p != NULL)
        {
        r = p->region;

        /* First fill it all with blanks */
        sb_fill (r, ' ', colors.popup);

        /* Now draw the box */
        sb_box (r, boxtype, colors.popup);

        sb_move (r, 0, 1);
        sb_puts (r, MSG_TXT(M_GET_FILE));

        /* Now do the fields */
        sb_move (r, 1,2);
        sb_puts (r, MSG_TXT(M_ADDRESS_TO_GET_FROM));
        if (!sb_input_chars (r, 1, 23, node, 36))
            {
            sb_move (r, 2, 2);
            sb_puts (r, MSG_TXT(M_FILE_TO_RECEIVE));
            if (!sb_input_chars (r, 2, 23, file, 12))
                {
                sb_move (r, 3, 2);
                sb_puts (r, MSG_TXT(M_PASSWORD_TO_USE));
                (void) sb_input_chars (r, 3, 23, password, 8);
                sb_move (r, 4, 2);
                sb_puts (r, "Crash, Hold, Direct, Normal (C/H/D/N)?");
                (void) sb_input_chars (r, 4, 41, flavor, 1);
                sb_move (r, 5, 2);
                sb_puts (r, MSG_TXT(M_ARE_YOU_SURE));
                (void) sb_input_chars (r, 5, 23, sure, 1);
                if (sure[0] == (char)toupper (MSG_TXT(M_YES)[0]))
                    x = add_request (node, file, password, flavor);
                }
            }
        }
#else
    DialogBox( MilqueRsrc, (LPSTR)"Get", MilqueMailerWnd, GetDlgPrc );
#endif
    /* Return value is never checked, just use x so lint and -W3 don't get mad */
    return (x);
}

int Overlay_Do_Send (BINK_SAVEP p, int x)
{
#ifndef MILQ
    REGIONP r;
    char node[51];
    char file[51];
    char flavor[2];
    char sure[2];
#endif

#ifndef MILQ
    if (p != NULL)
        {
        r = p->region;

        /* First fill it all with blanks */
        sb_fill (r, ' ', colors.popup);

        /* Now draw the box */
        sb_box (r, boxtype, colors.popup);

        sb_move (r, 0, 1);
        sb_puts (r, MSG_TXT(M_SEND_FILE));

        /* Now do the fields */
        sb_move (r, 1,2);
        sb_puts (r, MSG_TXT(M_ADDRESS_TO_SEND_TO));
        if (!sb_input_chars (r, 1, 22, node, 47))
            {
            sb_move (r, 2, 2);
            sb_puts (r, MSG_TXT(M_FILE_TO_SEND));
            if (!sb_input_chars (r, 2, 22, file, 47))
                {
                sb_move (r, 3, 2);
                sb_puts (r, "Crash, Hold, Direct, Normal (C/H/D/N)?");
                (void) sb_input_chars (r, 3, 41, flavor, 1);
                sb_move (r, 4, 2);
                sb_puts (r, MSG_TXT(M_ARE_YOU_SURE));
                (void) sb_input_chars (r, 4, 22, sure, 1);
                if (sure[0] == (char)toupper (MSG_TXT(M_YES)[0]))
                    x = add_send (node, file, flavor);
                }
            }
        }
#else
    DialogBox( MilqueRsrc, "Send", MilqueMailerWnd, SendDlgPrc );
#endif

    /* Return value is never checked, just use x so lint and -W3 don't get mad */
    return (x);
}

int Overlay_Do_Kill (BINK_SAVEP p, int x)
{
#ifndef MILQ
    REGIONP r;
    char node[51];
    char sure[2];
#endif

#ifndef MILQ
    if (p != NULL)
        {
        r = p->region;

        /* First fill it all with blanks */
        sb_fill (r, ' ', colors.popup);

        /* Now draw the box */
        sb_box (r, boxtype, colors.popup);

        sb_move (r, 0, 1);
        sb_puts (r, MSG_TXT(M_KILL_MAIL));

        /* Now do the fields */
        sb_move (r, 1,2);
        sb_puts (r, MSG_TXT(M_ADDRESS_TO_KILL));
        if (!sb_input_chars (r, 1, 19, node, 50))
            {
            sb_move (r, 2, 2);
            sb_puts (r, MSG_TXT(M_KILL_ALL_MAIL));
            sb_puts (r, MSG_TXT(M_ARE_YOU_SURE));
            (void) sb_input_chars (r, 2, 38, sure, 1);
            if (sure[0] == (char)toupper (MSG_TXT(M_YES)[0]))
                x = kill_node (node);
            }
        }

    /* Return value is never checked, just use x so lint and -W3 don't get mad */
    return (x);
#else
    DialogBox( MilqueRsrc, (LPSTR)"Kill", MilqueMailerWnd, KillDlgPrc );
#endif
}

int Overlay_Do_Poll (BINK_SAVEP p, int x)
{
#ifndef MILQ
    char node[51];
    REGIONP r;
#else
    HDLG                hDlg;
    HANDLE              Instance;
    int                 Rslt;
#endif

    happy_compiler = x;            /* Makes the compiler happy! */
#ifndef MILQ
    if (p != NULL)
        {
        r = p->region;

        /* First fill it all with blanks */
        sb_fill (r, ' ', colors.popup);

        /* Now draw the box */
        sb_box (r, boxtype, colors.popup);

        sb_move (r, 0, 1);
        sb_puts (r, MSG_TXT (M_NODE_TO_POLL));

        /* Now do the fields */
        sb_move (r, 1,2);
        sb_puts (r, MSG_TXT (M_POLL_WHOM));
        if (!sb_input_chars (r, 1, 14, node, 40))
            {
            return ( find_address (node, &next_addr));
            }
        }
    return (FALSE);
#else
    return DialogBox( MilqueRsrc, (LPSTR)"Poll", MilqueMailerWnd, PollDlgPrc );
#endif
                                       /* The return is indeed checked in */
                                       /* this case.  FALSE means I got no */
                                       /* stinkin' address in next_addr. */
}

int kill_node (char *node)
{
    ADDR addr;
    char *HoldName;
    char *p;
    char fname[160];
    struct FILEINFO fileinfo;

    if (find_address (node, &addr))
        {
        if (flag_file (TEST_AND_SET, &addr, 0))
           {
           return (-1);
           }

        HoldName = HoldAreaNameMunge(&addr);

        (void) sprintf (fname, "%s%s.*", HoldName, Hex_Addr_Str (&addr));
        if (!dfind (&fileinfo, fname, 0))
            {
            do
                {
             /* Don't delete the .bsy flags yet */
                if ((p = strchr (fileinfo.name, '.')) != NULL)
                    {
                    if (strcmp (p, ".BSY") == 0)
                       continue;
                    }
                if (addr.Point != 0)
                   {
                   (void) sprintf (fname, "%s%04x%04x.PNT\\%s",
                             HoldName, addr.Net, addr.Node, fileinfo.name);
                   }
                else
                   (void) sprintf (fname, "%s%s", HoldName, fileinfo.name);

                (void) unlink (fname);
                } while (!dfind (&fileinfo, fname, 1));
            }

        (void) flag_file (CLEAR_FLAG, &addr, 0);
        return (0);
        }
/* else */
   return (-1);
}

int add_request (char *node, char *file, char *password, char *flavor)
{
    ADDR addr;
    char *HoldName;
    char fname[100];
    FILE *f;

    if (find_address (node, &addr))
        {
        HoldName = HoldAreaNameMunge(&addr);

     /* Now see if we should send anything back to him */
        (void) sprintf (fname, "%s%s.REQ", HoldName, Hex_Addr_Str (&addr));
        if ((f = fopen (fname, "ab")) == NULL)
            {
            return (-2);
            }

        (void) sprintf (fname, "%s", Full_Addr_Str (&(alias[0])));
        (void) sprintf (junk, ";GET generated by node %s using %s", fname, ANNOUNCE);
                                 /* A brutal Greylock Hack */
        junk[75] = '\0';
        (void) fprintf (f, "%s\r\n", junk);
        (void) fprintf (f, "%s", file);
        if (password[0] != '\0')
            {
            (void) fprintf (f, " !%s", password);
            }
        (void) fprintf (f, "\r\n");

        (void) fclose (f);

        (void) add_send (node, "", flavor);
        return (0);
        }
 /* else */
    return (-1);
}

int add_send (char *node, char *file, char *flavor)
{
   ADDR addr;
   char *HoldName;
   char fname[100];
   FILE *f;

   if ((flavor[0] != 'C') && (flavor[0] != 'H') && (flavor[0] != 'N') && (flavor[0] != 'D'))
      return (-3);

   if (flavor[0] == 'N')
      flavor[0] = 'F';

   flavor[1] = '\0';
   if (find_address (node, &addr))
      {
      HoldName = HoldAreaNameMunge(&addr);
      (void) sprintf (fname, "%s%s.%sLO", HoldName, Hex_Addr_Str (&addr), flavor);

      if ((f = fopen (fname, "ab")) == NULL)
          {
          return (-2);
          }
      else
          {
          if (file[0] != '\0')
              {
              (void) sprintf (fname, "%s", Full_Addr_Str (&(alias[0])));
              (void) sprintf (junk, ";SEND generated by node %s using %s", fname, ANNOUNCE);
                                       /* A brutal Greylock Hack */
              junk[75] = '\0';
              (void) fprintf (f, "%s\r\n", junk);
              (void) fprintf (f, "%s\r\n", file);
              }
          (void) fclose (f);
          }
      return (0);
      }
/* else */
   return (-1);
}


