Unit Compress;
{========================================================================}
Interface
  Uses
    Dos;
  Procedure DisplayPageHeader;
  Procedure DirOfArj(InFileName : PathStr);
  Procedure DirOfZip(InFileName : PathStr);
  Procedure DirOfArchive(InFileName : PathStr);
{========================================================================}
Implementation
  Uses
    Display, General, MfmDefs, MfmStr, Screen;
{========================================================================}
Procedure DisplayPageHeader;
  Begin
    AnsiClearScreen;
    WriteLn('Directory for file '+CurrentEntry^.FileName);
  End;
{========================================================================}
Procedure DirOfArj(InFileName : PathStr);
  Const
    HeaderSignature = $EA60;
  Type
    ArjHeaderType = Record
      FirstHdrSize : Byte;
      ArchiverVersionNumber : Byte;
      MinArchiverVersion2Extract : Byte;
      HostOS : Byte;
      ArjFlags : Byte;
      Method : Byte;
      FileType : Byte;
      Reserved : Byte;
      DateTime : LongInt;
      CompressedSize : LongInt;
      OriginalSize : LongInt;
      OriginalCrc : LongInt;
      FilespecPos : Word;
      FileAccessMode : Word;
      HostData : Word;
    End;
    FileNameType = Array[1..255] Of Char;
  Var
    ArjFile : File;
    SigOk : Boolean;
    NewPos : LongInt;
    Signature, HeaderSize, ExtHeaderSize : Word;
    HeaderBuffer : Pointer;
    HeaderBufferPtr : ^ArjHeaderType;
    FileNameStr : String;
    FileNamePtr : ^FileNameType;
    LineCounter : Byte;
  {==============================}
  Procedure DisplayArjHeader;
    Var
      Dahb : Byte;
    Begin
      BlockRead(ArjFile,Signature,SizeOf(Signature));
      If Signature = HeaderSignature Then
      Begin
        BlockRead(ArjFile,HeaderSize,SizeOf(HeaderSize));
        If HeaderSize > 0 Then
        Begin
          SigOk := True;
          GetMem(HeaderBuffer,HeaderSize);
          BlockRead(ArjFile,HeaderBuffer^,HeaderSize);
          HeaderBufferPtr := HeaderBuffer;
          FileNamePtr := HeaderBuffer;
          Dahb := 1;
          While FileNamePtr^[Dahb+SizeOf(ArjHeaderType)] <> #0 Do
          Begin
            FileNameStr[Dahb] := FileNamePtr^[Dahb+SizeOf(ArjHeaderType)];
            Inc(Dahb);
          End;
          FileNameStr[0] := Char(Dahb-1);
          If Length(FileNameStr) > 12 Then
          Begin
            WriteLn(FileNameStr);
            Write('            ');
            Inc(LineCounter);
          End
          Else
          Begin
            Write(Copy(FileNameStr+'          ',1,12));
          End;
          Write(MyStr(HeaderBufferPtr^.OriginalSize,8)+' ');
          Write(GetDateString(HeaderBufferPtr^.DateTime)+' ');
          Write(GetTimeString(HeaderBufferPtr^.DateTime)+' ');
          Write(HexDw(HeaderBufferPtr^.OriginalCrc));
          WriteLn;
          Seek(ArjFile,FilePos(ArjFile)+4);
          BlockRead(ArjFile,ExtHeaderSize,SizeOf(ExtHeaderSize));
          If ExtHeaderSize > 0 Then Seek(ArjFile,FilePos(ArjFile)+ExtHeaderSize);
          Seek(ArjFile,FilePos(ArjFile)+HeaderBufferPtr^.CompressedSize);
          FreeMem(HeaderBuffer,HeaderSize);
        End
        Else
        Begin
          SigOk := False;
        End;
      End
      Else
      Begin
        SigOk := False;
      End;
    End;
  {==============================}
  Begin
    DisplayPageHeader;
    LineCounter := 0;
    SigOk := True;
    Assign(ArjFile,InFileName);
    Reset(ArjFile,1);
    BlockRead(ArjFile,Signature,SizeOf(Signature));
    BlockRead(ArjFile,HeaderSize,SizeOf(HeaderSize));
    Seek(ArjFile,FilePos(ArjFile)+HeaderSize+4);
    BlockRead(ArjFile,ExtHeaderSize,SizeOf(ExtHeaderSize));
    If ExtHeaderSize > 0 Then Seek(ArjFile,FilePos(ArjFile)+ExtHeaderSize);
    While SigOk Do
    Begin
      DisplayArjHeader;
      Inc(LineCounter);
      If LineCounter >= 23 Then
      Begin
        If UpCase(Char(AnyKey)) = 'Q' Then SigOk := False;
        DisplayPageHeader;
        LineCounter := 0;
      End;
    End;
    If LineCounter > 0 Then AnyKey;
    Close(ArjFile);
    DisplayScreen;
  End;
{========================================================================}
Procedure DirOfZip(InFileName : PathStr);
  Var
    ZipFile : File;
    SigOk : Boolean;
    NewPos : LongInt;
    LineCounter : Byte;
  {==============================}
  Procedure DisplayZipHeader;
    Const
      HeaderSignature = $04034b50;
    Type
      ZipHeaderType = Record
        Version, Flag, Method, Time, Date : Word;
        Crc32, CompressedSize, UncompressedSize : LongInt;
        FileNameLength, ExtraFieldLength : Word;
      End;
      FileNameType = Array[1..255] Of Char;
    Var
      Dzhb : Byte;
      Signature, PosInFile : LongInt;
      ZipHeader : ZipHeaderType;
      HeaderBuffer, FileNameBuffer : Pointer;
      HeaderBufferPtr : ^ZipHeaderType;
      FileNameStr : String;
      FileNamePtr : ^FileNameType;
    Begin
      BlockRead(ZipFile,Signature,SizeOf(Signature));
      If Signature = HeaderSignature Then
      Begin
        SigOk := True;
        GetMem(HeaderBuffer,SizeOf(ZipHeader));
        BlockRead(ZipFile,HeaderBuffer^,SizeOf(ZipHeader));
        HeaderBufferPtr := HeaderBuffer;
        GetMem(FileNameBuffer,HeaderBufferPtr^.FileNameLength);
        BlockRead(ZipFile,FileNameBuffer^,HeaderBufferPtr^.FileNameLength);
        FileNamePtr := FileNameBuffer;
        For Dzhb := 1 To HeaderBufferPtr^.FileNameLength Do FileNameStr[Dzhb] := FileNamePtr^[Dzhb];
        FileNameStr[0] := Chr(Lo(HeaderBufferPtr^.FileNameLength));
        AnsiClearToEol;
        WriteLn(Copy(FileNameStr+'          ',1,12)+' '+MyStr(HeaderBufferPtr^.UncompressedSize,8)+' '+
          FormatDate(HeaderBufferPtr^.Date)+' '+FormatTime(HeaderBufferPtr^.Time)+' '+
          HexDw(HeaderBufferPtr^.Crc32));
        PosInFile := FilePos(ZipFile);
        NewPos := PosInFile+HeaderBufferPtr^.CompressedSize+HeaderBufferPtr^.ExtraFieldLength;
        FreeMem(FileNameBuffer,HeaderBufferPtr^.FileNameLength);
        FreeMem(HeaderBuffer,SizeOf(ZipHeader));
      End
      Else
      Begin
        SigOk := False;
      End;
    End;
  {==============================}
  Begin
    DisplayPageHeader;
    LineCounter := 0;
    SigOk := True;
    Assign(ZipFile,InFileName);
    Reset(ZipFile,1);
    While SigOk Do
    Begin
      DisplayZipHeader;
      Seek(ZipFile,NewPos);
      Inc(LineCounter);
      If LineCounter >= 23 Then
      Begin
        If UpCase(Char(AnyKey)) = 'Q' Then SigOk := False;
        DisplayPageHeader;
        LineCounter := 0;
      End;
    End;
    If LineCounter > 0 Then AnyKey;
    Close(ZipFile);
    DisplayScreen;
  End;
{========================================================================}
Procedure DirOfArchive(InFileName : PathStr);
  Begin
    If FileExt(InFileName) = '.ARJ' Then DirOfArj(InFileName);
    If FileExt(InFileName) = '.ZIP' Then DirOfZip(InFileName);
  End;
{========================================================================}
Begin
End.
{========================================================================}
