Unit Debit;
{========================================================================}
Interface
  Procedure RemoveUpLdCredit;
{========================================================================}
Implementation
  Uses
    Dos, General, MaxAreas, MfmDefs, MfmStr, Screen, Strings;
{========================================================================}
Procedure RemoveUpLdCredit;
  Const
    Max_Alen = 10;
  Type
    UserRecordType = Record
      Name, City : Array[0..35] Of Char;
      Alias : Array[0..20] Of Char;
      Phone : Array[0..14] Of Char;
      LastReadPtr, TimeRemaining : Word;
      Pwd : Array[0..15] Of Char;
      Times : Word;
      Help : Byte;
      Rsvd1 : Array[1..2] Of Byte;
      Video, Nulls, Bits1 : Byte;
      Rsvd2, Bits2 : Word;
      Priv : Integer;
      Rsvd3 : Array[1..19] Of Byte;
      StructLen : Byte;
      Time, DelFlag : Word;
      Rsvd4 : Array[1..8] Of Byte;
      Width, Len : Byte;
      Credit, Debit : Word;
      XpPriv : Integer;
      XpDate, XpMins : LongInt;
      XpFlag, XpRsvd : Byte;
      LuDate, Xkeys : LongInt;
      Lang : Byte;
      DefProto : ShortInt;
      Up, Down : LongInt;
      DownToday : LongInt;
      Msg : Array[1..Max_Alen] Of Byte;
      Files : Array[1..Max_Alen] Of Byte;
      Compress, Rsvd5 : Byte;
      Extra : LongInt;
    End;
  Var
    RcD : DirStr;
    RcN : NameStr;
    RcE : ExtStr;
    UpLdLog : Text;
    UpLdStr : String;
    UserRecPtr : ^UserRecordType;
    UserBbs : File;
    StructLen : Byte;
    Buffer : Pointer;
    UserNo, NumberOfUsers : LongInt;
    UserName : String[36];
    AmountUpLd : LongInt;
    FileFound : Boolean;
    Rcc : Char;
  Begin
    FSplit(AreaPath,Rcd,RcN,RcE);
    If FileExist(Rcd+'UL.LOG') Then
    Begin
      Assign(UpLdLog,Rcd+'UL.LOG');
      Reset(UpLdLog);
      AnsiGotoXY(1,1);
      FileFound := False;
      While Not Eof(UpLdLog) Do
      Begin
        ReadLn(UpLdLog,UpLdStr);
        UpLdStr := UpperString(UpLdStr);
        If Pos(UpperString(FileAreaPath+CurrentEntry^.FileName),UpLdStr) > 0 Then
        Begin
          FileFound := True;
          If FileExist(Rcd+'USER.BBS') Then
          Begin
            UserName := Copy(UpLdStr,1,Pos('UL',UpLdStr)-2);
            Val(Copy(UpLdStr,Pos('(',UpLdStr)+1,(Pos(')',UpLdStr)-Pos('(',UpLdStr))-2),AmountUpLd,Result);
            Assign(UserBbs,Rcd+'USER.BBS');
            FileMode := 2;
            Reset(UserBbs,1);
            Seek(UserBbs,161);
            BlockRead(UserBbs,StructLen,1);
            GetMem(Buffer,StructLen*20);
            UserRecPtr := Buffer;
            NumberOfUsers := DirInfo.Size Div (StructLen*20);
            For UserNo := 0 To NumberOfUsers-1 Do
            Begin
              Seek(UserBbs,UserNo*StructLen*20);
              BlockRead(UserBbs,Buffer^,StructLen*20);
              If UserName = StrPas(StrUpper(UserRecPtr^.Name)) Then
              Begin
                AnsiGotoXY(25,1); AnsiClearToEol;
                Write(CurrentEntry^.FileName+' was uploaded by '+
                  StrPas(UserRecPtr^.Name)+', (+ or -) credit or (Q)uit: ');
                Repeat
                  Rcc := UpCase(Char(GetInput));
                Until Pos(Rcc,'+-Q') > 0;
                If Rcc In ['+','-'] Then
                Begin
                  Seek(UserBbs,UserNo*StructLen*20);
                  Case Rcc Of
                    '+' : UserRecPtr^.Up := UserRecPtr^.Up+(AmountUpLd Div 1024);
                    '-' : UserRecPtr^.Up := UserRecPtr^.Up-(AmountUpLd Div 1024);
                  End;
                  BlockWrite(UserBbs,Buffer^,StructLen*20);
                  AnsiGotoXY(25,1); AnsiClearToEol;
                  Write(StrPas(UserRecPtr^.Name)+' was ');
                  Case Rcc Of
                    '+' : Write('credited with ');
                    '-' : Write('debited by ');
                  End;
                  Write(MyStr(AmountUpLd Div 1024,0)+'Kb.  ');
                  AnyKey;
                End;
              End;
            End;
            Close(UserBbs);
            FreeMem(Buffer,StructLen*20);
          End
          Else
          Begin
            AnsiGotoXY(25,1); AnsiClearToEol;
            Write('USER.BBS not found!   ');
            AnyKey;
          End;
        End;
      End;
      If Not FileFound Then
      Begin
        AnsiGotoXY(25,1); AnsiClearToEol;
        Write('File not found in UL.LOG.  ');
        AnyKey;
      End;
      Close(UpLdLog);
    End
    Else
    Begin
      AnsiGotoXY(25,1); AnsiClearToEol;
      Write('UL.LOG not found!   ');
      AnyKey;
    End;
  End;
{========================================================================}
Begin
End.
{========================================================================}
