Unit SaveKill;
{========================================================================}
Interface
  Uses
    Dos, MfmDefs;
  Function SizeOfFilesBbs(FileArea : String) : LongInt;
  Function InMainList(TempEntry : ListPtr) : Boolean;
  Procedure EraseKillList;
  Procedure Mfm2Bbs2Bak(InString : PathStr);
  Procedure SaveList;
{========================================================================}
Implementation
  Uses
    MfmStr, Screen;
{========================================================================}
Function SizeOfFilesBbs(FileArea : String) : LongInt;
  Var
    FilesBbs : File Of Byte;
    SizeOfFile : LongInt;
  Begin
    Assign(FilesBbs,FileArea+'FILES.BBS');
    {$I-} Reset(FilesBbs); {$I+}
    If IOresult = 0 Then
    Begin
      SizeOfFilesBbs := FileSize(FilesBbs);
      Close(FilesBbs);
    End
    Else
    Begin
      SizeOfFilesBbs := 0;
    End;
  End;
{========================================================================}
Function InMainList(TempEntry : ListPtr) : Boolean;
  Begin
    NextPrintEntry := FirstEntry; InMainList := False;
    While NextPrintEntry^.NextEntry <> NIL Do
    Begin
      If NextPrintEntry^.FileName = TempEntry^.FileName Then InMainList := True;
      NextPrintEntry := NextPrintEntry^.NextEntry;
    End;
  End;
{========================================================================}
Procedure EraseKillList;
  Var
    FileToErase : File;
  Begin
    While KillEntry <> NIL Do
    Begin
      FindFirst(FileAreaPath+KillEntry^.FileName,Archive,DirInfo);
      If DosError = 0 Then
      Begin
        If (Not InMainList(KillEntry)) Then
        Begin
          If UpperString(KillEntry^.FileName) <> 'FILES.BBS' Then
          Begin
            Assign(FileToErase,FileAreaPath+KillEntry^.FileName);
            Erase(FileToErase);
          End;
        End;
      End;
      OldEntry := KillEntry;
      If KillEntry^.PrevEntry = KillEntry Then
      Begin
        Dispose(KillEntry);
        KillEntry := NIL;
      End
      Else
      Begin
        KillEntry^.PrevEntry^.NextEntry := KillEntry^.NextEntry;
        KillEntry^.NextEntry^.PrevEntry := KillEntry^.PrevEntry;
        KillEntry := KillEntry^.NextEntry;
      End;
      If KillEntry <> NIL Then Dispose(OldEntry);
    End;
  End;
{========================================================================}
Procedure Mfm2Bbs2Bak(InString : PathStr);
  Var
    TmpFilVar : Text;
  Begin
    FindFirst(InString+'FILES.BAK',AnyFile,DirInfo);
    If DosError = 0 Then
    Begin
      Assign(TmpFilVar,InString+'FILES.BAK');
      Erase(TmpFilVar);
    End;
    FindFirst(InString+'FILES.BBS',AnyFile,DirInfo);
    If DosError = 0 Then
    Begin
      Assign(TmpFilVar,InString+'FILES.BBS');
      Rename(TmpFilVar,InString+'FILES.BAK');
    End;
    Assign(TmpFilVar,InString+'FILES.MFM');
    Rename(TmpFilVar,InString+'FILES.BBS');
  End;
{========================================================================}
Procedure SaveList;
  Var
    Slc : Char;
  Begin
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write('This will DELETE killed files and update FILES.BBS, Are you sure? ');
    Repeat
      Gbx := GetInput;
      Slc := Upcase(Chr(Gbx));
    Until Slc In ['N','Y'];
    Write(Slc);
    If Slc = 'Y' Then
    Begin
      Assign(FileList,FileAreaPath+'FILES.MFM');
      {$I-} ReWrite(FileList); {$I+}
      If IOresult = 0 Then
      Begin
        NextPrintEntry := FirstEntry;
        While NextPrintEntry^.NextEntry <> NIL Do
        Begin
          If NextPrintEntry^.TypeOfRecord <> Orphan Then
          Begin
            If NextPrintEntry^.TypeOfRecord <> Comment Then
            Begin
              Write(FileList,NextPrintEntry^.FileName);
              Write(FileList,Copy('         ',1,13-Length(NextPrintEntry^.FileName))+' ');
            End;
            WriteLn(FileList,NextPrintEntry^.Description);
          End;
          NextPrintEntry := NextPrintEntry^.NextEntry;
        End;
        If NextPrintEntry^.TypeOfRecord <> Orphan Then
        Begin
          Write(FileList,NextPrintEntry^.FileName);
          Write(FileList,' ');
          WriteLn(FileList,NextPrintEntry^.Description);
        End;
        Close(FileList);
        Mfm2Bbs2Bak(FileAreaPath);
        EraseKillList;
        AnsiGotoXY(25,1); AnsiClearToEOL;
      End;
      AreaChanged := True;
      Altered := False;
    End
    Else Write('N');
    AnsiGotoXY(24,80);
  End;
{========================================================================}
Begin
End.
{========================================================================}
