
#define     MEMERROR       10
#define     FILEERROR      11

/*------------------------------------------------------------*/

#define     SOFTCR         0x8D
#define     SEENBYSTR      "SEEN-BY"
#define     QMAILSTR       "QM"
#define     SQUISHSTR      "Squish"

/*------------------------------------------------------------*/

struct _attributes {
   unsigned int private:1;    /* private message flag     */
   unsigned int crash:1;      /* crash mail               */
   unsigned int recvd:1;      /* received by addressee    */
   unsigned int sent:1;       /* message sent             */
   unsigned int attached:1;   /* file attached            */
   unsigned int forward:1;    /* message in transit       */
   unsigned int orphan:1;     /* unknown destination      */
   unsigned int killsent:1;   /* kill after sending       */
   unsigned int local:1;      /* local message            */
   unsigned int hold:1;       /* hold for pickup          */
   unsigned int direct:1;     /* do no gating on this msg */
   unsigned int freq:1;       /* file request             */
   unsigned int rreq:1;       /* return receipt requested */
   unsigned int rcpt:1;       /* return receipt           */
   unsigned int areq:1;       /* audit trail request      */
   unsigned int ureq:1;       /* update file request      */
};

typedef struct _dosdate {
   unsigned int day:5;
   unsigned int mon:4;
   unsigned int year:7;
   unsigned int sec:5;
   unsigned int min:6;
   unsigned int hour:5;
} DOSDATE;

typedef struct _fidoheader {
   char from[36];                 /* who from,               */
   char to[36];                   /* who to,                 */
   char subj[72];                 /* message subject,        */
   char date[20];                 /* creation date,          */
   int times;                     /* number of times read,   */
   int dest;                      /* destination node,       */
   int orig;                      /* originating node        */
   int cost;                      /* actual cost this msg    */
   int orig_net;                  /* originating net         */
   int dest_net;                  /* destination net         */
   DOSDATE written     ;          /* when it was written     */
   DOSDATE arrived;               /* when it arrived         */
   unsigned int reply;            /* thread to previous msg  */
   struct _attributes attrib;     /* message attributes      */
   int up;                        /* thread to next msg      */
} FIDOHEADER;


typedef struct  _addrzap {
    unsigned int zone;
    unsigned int net;
    unsigned int node;
    unsigned int point;
} ADDRTYPE;


/*----------------------------------------------------------------*/
/*              function prototypes                               */

int ftsc_addrset(FIDOHEADER *hdr, char *mbuf, ADDRTYPE *t_addr);
int ftsc_read(int n, char *mp, FIDOHEADER *hdr, char *mtext);
int ftsc_write(int n, char *mp, FIDOHEADER *hdr, char *mtext);
int ftsc_delete(int n, char *mp);
int ftsc_append(char *mp, FIDOHEADER *hdr, char *mtext);
int get_ftsc_high(char *mp);
int prn_ftsc_hdr(FIDOHEADER *fhdr);

/*------------------------------------------------------------*/


