{
NNRNEWS.PAS ver. 1.00 - May 23, 1994. Programmed in Turbo Pascal 6.0 by

  Henrik Rosen  (*)
--
| Henrik Rosen, MSc.         |    Tel: + 45 35 36 52 76    | East or West, |
| Nrrebrogade 49C, 1.tv.     |    FAX: + 45 35 26 25 93    | Cyberspace is |
| 2200 Copenhagen N - DENMARK | e-mail: hero@login.dkuug.dk | best   - HeRo |

NNRNEWS.PAS Copyright (c) 1994 Henrik Rosen.

License conditions:
This program is freeware and distributed as a TP 6.0 source file.
I do not take any responsibility for the consequences of compiling or
running the program. Alteration and redistribution is allowed, as long
as the file is only altered below the following line.
--------------------------------------------------------------------------

  NNRNEWS convertes files saved by nn into rnews-batches (according
  to RFC-1036 section 4.3), by inserting the '#! rnews <x>'-line before
  the headers of all the postings in the file. When saved by nn, the
  messages are simply separated by an empty line. It has been tested,
  that Yarn v0.65 can import these rnews-batches.

  The program requires access to FLIP.EXE, to work!
  (FTP or download FLIP from somewhere, for instance as
   textutil/flip1exe.zip at SimTel mirrors.)

  The nnrnews command:

      nnrnews [searchstring [directory]]

        searchstring  The files to be processed ex. *.doc.
                      Default is *.*
                      (At least on DR DOS 6.0 *.* does not work!)

        directory     The directory to be searched for files to convert.
                      Default is current directory on default drive.

When compiled in TP 6.0, this program cuts down lines to 255 characters.
Some header lines (especially Path: and Xref:, but also Newsgroups:) are
longer than 255 characters, and are damaged.
Lines that where cut, are copied to the file 'cutlines.uvy', for manual
evaluation of the damage.
Anybody with TP 7.0 are encouraged to compile a version of the program,
that does not cut any lines.

  All <space>-characters in the end of any line is removed in the process.
  This feature is an integrated part of the whole algorithm.
  The program allows the file to start with whatever before the first
  news-message, and moves that to 'crapfile.uvy'.

  The program detects the starting of a new message by the following
  criteria:
  After an empty line, all the required headers (according to RFC-1036)
  are found among the headers before the next empty line (or max. 50 lines).
  The required headers are:
  "From:", "Date:", "Newsgroups:", "Subject:", "Message-ID:" and "Path:".

  This algorithm is nearly 100% sure of detecting the start of a message,
  but:
  1. If a message contains a forwarded message, the forwarded message will
     be regarded as a new message, if the 6 required headers are unchanged
     and there is an empty line just before these headers.
  2. If the first header is very wierd and therefore unknown (see the
     is_header-function), the program will not regard it as the start of
     a new message.
  3. If the block of headers contains an empty line before the 6 required
     headers have been found, the program will not regard it as the start
     of a new message.

  The program can _probably_ handle up to 8000 messages in one file,
  depending only on allocated heap. The size of files only depend on the
  diskspace for the temporary copy.
  The program uses 2 passes:
  1. It finds the starting points of messages, places '#! rnews' and
     counts the size of the messages in bytes. These numbers are placed
     in a list chained with pointers.
  2. The numbers in the list are placed in the '#! rnews'-lines.
  Well, there are actually 2 more passes (calling FLIP.EXE):
  Before, all the files are converted to DOS-ASCII, by inserting <Carriage
  Return> at newline (for Turbo Pascal to be able to handle them as text
  files), and in the end they are converted (back) to UNIX-text-format,
  by removing the <Carriage Return>s at all newlines, to create a real
  rnews-batch.

(*) (The reason why Danish letters can be used in Turbo Pascal source code,
     is that from the begining as COMPAS Pascal in 1982 (or earlier?), and
     until now, TP has been developed by a Dane, Anders Hejlsberg.
     He programmed the Pascal-compiler in Z80-assembler in his spare time
     while studying Bachelor in Computer Science. I believe that he invented
     the idea of an integrated, interactive program-development environment,
     know called IDE, thereby making the big, clumsy, and time-consuming
     error-recovery procedures obsulete in the compiler.)
}

program nnrnews;
{$I-}
{$M 16000,0,65000 }
uses    dos,crt;
type
  int_point = ^longint_rec;
  longint_rec = record
                  count: longint;
                  next: int_point;
                end;
var
  first_pointer, last_pointer, temp_pointer
                              : int_point;
  empty_line, empty_oldline, is_from, is_date, is_newsg, is_subj, is_mess,
    is_path, all_headers, is_a_header, is_newsfile
                              : boolean;
  infil, udfil, crapfile, cutlinefile
                              : text;
  l, i, str_count             : integer;
  message_counter             : longint;
  streng, streng2, streng3    : string;
  str_arr                     : array[1..50] of string;
  dirinfo                     : searchrec;

procedure required_heads(streng:string);
begin
  { The required headers:  "From:", "Date:", "Newsgroups:", "Subject:",
                           "Message-ID:" and "Path:" }
  if copy(streng,1,5)='Path:'        then is_path:=true else
    if copy(streng,1,11)='Newsgroups:' then is_newsg:=true else
      if copy(streng,1,5)='From:'        then is_from:=true else
        if copy(streng,1,5)='Date:'        then is_date:=true else
          if copy(streng,1,8)='Subject:'     then is_subj:=true else
            if copy(streng,1,10)='Message-ID'  then is_mess:=true else
              if copy(streng,1,10)='Message-id'  then is_mess:=true;
end;

function is_header(streng:string): boolean;
var is_head : boolean;
{ I believe this function is quite time-optimal! }
begin
  if streng='' then  is_head:=false  else
    if copy(streng,1,1)='-' then  is_head:=false  else
      if copy(streng,1,1)=' ' then  is_head:=false  else
        { The required headers:  "From:", "Date:", "Newsgroups:",
          "Subject:", "Message-ID:" and "Path:" }
        if copy(streng,1,5)='Path:' then
          begin is_head:=true; is_path:=true end else
          if copy(streng,1,11)='Newsgroups:' then
            begin is_head:=true; is_newsg:=true end else
            begin
            is_head:=false;
            if copy(streng,1,5)  = 'From:'       then
              begin is_head:=true; is_from:=true end;
            if copy(streng,1,5)  = 'Date:'       then
              begin is_head:=true; is_date:=true end;
            if copy(streng,1,8)  = 'Subject:'    then
              begin is_head:=true; is_subj:=true end;
            if copy(streng,1,10) = 'Message-ID'  then
              begin is_head:=true; is_mess:=true end;
            if copy(streng,1,10) = 'Message-id'  then
              begin is_head:=true; is_mess:=true end;
            if copy(streng,1,5)  = 'Xref:'          then is_head:=true;
            if copy(streng,1,8)  = 'Expires:'       then is_head:=true;
            if copy(streng,1,8)  = 'Control:'       then is_head:=true;
            if copy(streng,1,13) = 'Distribution:'  then is_head:=true;
            if copy(streng,1,9)  = 'Keywords:'      then is_head:=true;
            if copy(streng,1,8)  = 'Summary:'       then is_head:=true;
            if copy(streng,1,9)  = 'Approved:'      then is_head:=true;
            if copy(streng,1,9)  = 'Comments:'      then is_head:=true;
            if copy(streng,1,6)  = 'Lines:'         then is_head:=true;
            if copy(streng,1,13) = 'MIME-Version:'  then is_head:=true;
            if copy(streng,1,13) = 'MIME-version:'  then is_head:=true;
            if copy(streng,1,13) = 'Mime-Version:'  then is_head:=true;
            if copy(streng,1,13) = 'Mime-version:'  then is_head:=true;
            if copy(streng,1,5)  = 'NNTP-'          then is_head:=true;
            if copy(streng,1,5)  = 'Nntp-'          then is_head:=true;
            if copy(streng,1,8)  = 'Content-'       then is_head:=true;
            if copy(streng,1,2)  = 'X-'             then is_head:=true;
            if copy(streng,1,12) = 'In-reply-to:'   then is_head:=true;
            if copy(streng,1,12) = 'In-Reply-To:'   then is_head:=true;
            if copy(streng,1,13) = 'Organization:'  then is_head:=true;
            if copy(streng,1,11) = 'References:'    then is_head:=true;
            if copy(streng,1,9)  = 'Followup-'      then is_head:=true;
            if copy(streng,1,6)  = 'Reply-'         then is_head:=true;
            if copy(streng,1,7)  = 'Return-'        then is_head:=true;
            if copy(streng,1,7)  = 'Errors-'        then is_head:=true;
            if copy(streng,1,7)  = 'Sender:'        then is_head:=true;
            end;
  is_header:=is_head
end;

{ main program }
begin
  writeln;
  writeln('The program can be terminated by Ctrl-Break.');
  writeln;
  if paramcount=2 then
    begin
      chdir(paramstr(2));
      getdir(0,streng);
      streng3:=paramstr(1)
    end
  else
    if paramcount=1 then
      begin
        streng3:=paramstr(1);
        getdir(0,streng)
      end
    else
      begin
        getdir(0,streng);
        streng3:='*.*'
      end;

  writeln('The file(s) ',streng3,' in directory ',streng,' will be converted into rnews-batches.');
  write('Is this okay ? (y/n) ');
  readln(streng2);
  if (copy(streng2,1,1)<>'y') and (copy(streng2,1,1)<>'Y') then halt;
  FindFirst(streng3, $3F, DirInfo);
  if (Doserror=0) and (dirinfo.name<>'.') then
    begin
      WriteLn('Temporary insertion of <Carriage Return>s at newline in all file(s).');
      streng := Fexpand(Fsearch('FLIP.EXE',getenv('PATH')));
      streng2:=' -mb '+streng3;
      swapvectors;
      exec(streng,streng2);
      swapvectors;
      if doserror<>0 then begin
        writeln('FLIP.EXE could not be executed, program terminated.');
        halt
      end;
    end
  else
    begin
      writeln('The directory does not contain any files matching ',streng3);
      halt
    end;
  assign(crapfile,'crapfile.uvy');
  rewrite(crapfile);
  assign(cutlinefile,'cutlines.uvy');
  rewrite(cutlinefile);
  FindFirst(streng3, $3F, DirInfo);
  { Processing one file at a time: }
  while (Doserror=0) and (dirinfo.name<>'.') do begin
    WriteLn('Processing ',DirInfo.Name);
    if dirinfo.size+6000>diskfree(0) then
      writeln('There is probably not enough diskspace. The file will not be processed.')
    else begin
      assign(infil,dirinfo.name);
      reset(infil);
      readln(infil,streng);
      if copy(streng,1,9)='#! rnews ' then
        writeln('The file is probably allready an rnews-batch. It will not be processed.')
      else
        begin
        assign(udfil,'temp.fil');
        rewrite(udfil);
        new(first_pointer);
        last_pointer:=first_pointer;
        first_pointer^.count:=0;
        first_pointer^.next:=nil;
        writeln(crapfile,'');
        writeln(crapfile,'------------------- start of crap from ',dirinfo.name,' ------------------');
        writeln(crapfile,'');
        writeln(cutlinefile,'');
        writeln(cutlinefile,'----------- start of lines cut to 255 characters from ',dirinfo.name,' ----------');
        writeln(cutlinefile,'');
        while not eof(infil) and not is_header(streng) do
          begin writeln(crapfile,streng); readln(infil,streng) end;
        message_counter:=0;
        if eof(infil) then
          begin
            writeln(crapfile,streng);
            writeln('The file does not seem to contain any USENET-news messages.')
          end
        else
        begin
          is_newsfile:=false;
          while not eof(infil) do begin
            { The possible start of a new message has been detected: }
            is_from:=false; is_date:=false; is_newsg:=false;
            is_subj:=false; is_mess:=false; is_path:=false;
            all_headers:=false;
            l:=length(streng);
            while (streng[l]=' ') and (l>0) do begin
              delete(streng,l,1);
              dec(l); { l:=l-1; }
            end;
            str_count:=1; str_arr[1]:=streng;
            required_heads(streng);
            while not eof(infil) and (str_count<50) and not all_headers
              and (streng<>'') do
            begin
              readln(infil,streng);
              l:=length(streng);
              if l=255 then writeln(cutlinefile,streng);
              while (streng[l]=' ') and (l>0) do begin
                delete(streng,l,1);
                dec(l); { l:=l-1; }
              end;
              inc(str_count);
              str_arr[str_count]:=streng;
              required_heads(streng);
              all_headers:=(is_from and is_date and is_newsg and
                            is_subj and is_mess and is_path)
            end;
            if streng='' then empty_line:=true else empty_line:=false;
            if all_headers then begin
              is_newsfile:=true;
              writeln(udfil,'#! rnews');
              if message_counter>0 then begin
                last_pointer^.count:=message_counter;
                new(last_pointer^.next);
                last_pointer:=last_pointer^.next;
                last_pointer^.next:=nil;
                message_counter:=0;
              end;
            end;
            for i:=1 to str_count do begin
              writeln(udfil,str_arr[i]);
              message_counter:=message_counter+length(str_arr[i])+1;
            end;
            { No matter whether a new message started or not, we can now copy
              from infil to udfil, counting bytes, until detecting an empty
              line followed by a header line. }
            empty_oldline:=false; is_a_header:=false;
            while not eof(infil) and not (empty_oldline and is_a_header) do
            begin
              readln(infil,streng);
              l:=length(streng);
              if l=255 then writeln(cutlinefile,streng);
              while (streng[l]=' ') and (l>0) do begin
                delete(streng,l,1);
                dec(l); { l:=l-1; }
              end;
              empty_oldline:=empty_line;
              if streng='' then empty_line:=true else empty_line:=false;
              { There is no reason for searching for headers inside a
                paragraph, neither when we are still in the header-block
                of current message: }
              if empty_oldline<>empty_line then
                is_a_header:=is_header(streng)
              else
                is_a_header:=false;
              if not is_a_header then begin
                writeln(udfil,streng);
                message_counter:=message_counter+length(streng)+1
              end;
            end;
          end; { end-while not eof(infil) }
          close(infil);
          close(udfil);
          if is_newsfile then
          begin
            last_pointer^.count:=message_counter;
            reset(udfil);
            rewrite(infil);
            while not eof(udfil) do begin
              readln(udfil,streng);
              if streng='#! rnews' then begin
                if first_pointer=nil then begin
                  writeln('Program error: Unexpected end of integer pointer-list!');
                  exit
                end;
                str(first_pointer^.count,streng2);
                streng:=streng+' '+streng2;
                temp_pointer:=first_pointer^.next;
                dispose(first_pointer);
                first_pointer:=temp_pointer;
              end;
              writeln(infil,streng);
            end;
            if first_pointer<>nil then
            begin
              writeln('Program error: Too many integers in pointer-list!');
              exit
            end;
          end; { end_if: testing is_newsfile }
        end; { end-if: testing of any messages at all }
        close(udfil)
      end; { end-if: testing if first line in file is '#! rnews ' }
      close(infil);
      { I can't see what else should be needed here...? }
    end; { end-if: testing necessary free disk space }
    findnext(dirinfo);
  end; { end-while: doserror = 0 }
  close(crapfile);
  close(cutlinefile);
  WriteLn('Deleting <Carriage Return>s at newline in all file(s).');
  streng := Fexpand(Fsearch('FLIP.EXE',getenv('PATH')));
  streng2:=' -ub '+streng3;
  swapvectors;
  exec(streng,streng2);
  swapvectors;
  streng2:='/C del temp.fil';
  SwapVectors;
  Exec(GetEnv('COMSPEC'), streng2);
  SwapVectors;
  if DosError <> 0 then
    WriteLn('Could not execute COMMAND.COM - temp.fil not deleted.');
end.
