' ANSISTRP.BAS by Duane Paulson  Version 2.00
' Simple utility to strip ansi escape sequences from a text file.

' For Microsoft BASIC Professional Developer's System, version 7.1.
' Sorry, some functions are not compatible with QuickBASIC.

' BASIC Professional Developer's System and QuickBASIC are trademarks of Microsoft Corporation.

' Compiler instructions:
'     8088 version:
'        BC /E /O /Ot /Fpa /C:1 ansistrp.bas, astr.obj,;
'     80286 version:
'        BC /E /O /Ot /Fpa /C:1 /G2 ansistrp.bas, astr286.obj,;

' Linker instructions:
'     LINK /NOE astr[286].obj+tscnionr.obj+smallerr.obj+nolpt.obj+nocom.obj+noedit.obj,astr[286].exe,,BCL71ANR.LIB,;

DEFINT A-Z

CONST Title$ = "ANSISTRP Version 2.01 ANSI Strip Utility by Duane Paulson 02/26/91"
CONST CString$ = "Portions (C) 1982-1990 Microsoft Corporation. All rights reserved."

CONST AnsiEsc$ = "["            ' This is the ANSI escape to be looked for

CONST InAnsi$ = "0123456789;"    ' Any of these characters following an ANSI
                                 ' escape indicate that we are still in the
                                 ' ANSI control code.

OPEN "CONS:" FOR OUTPUT AS #3             ' Print to STDOUT so nobody's
PRINT #3,                                 ' custom screen setup gets wrecked

Cl$ = COMMAND$
IF Cl$ = "" THEN PRINT #3, CHR$(7); : GOTO Help  'Need 2 Command line parameters

ParamEnd = INSTR(Cl$, " ")          ' Find the space between the two params
IF ParamEnd = 0 THEN GOTO Help
InFile$ = LEFT$(Cl$, ParamEnd - 1)  ' Parse the Command parameters
OutFile$ = MID$(Cl$, ParamEnd + 1)

IF DIR$(InFile$) = "" THEN GOTO NotFound     ' The parameters should be
ON ERROR GOTO ErrTrp                         ' valid filenames

OPEN OutFile$ FOR OUTPUT AS #2 LEN = 20480   ' Check and see

ON ERROR GOTO 0                              ' Turn it back off


OPEN InFile$ FOR INPUT AS #1 LEN = 20480     ' Open the source

PRINT #3, "Working";

DO WHILE NOT EOF(1)                          ' Main loop

   LINE INPUT #1, a$                         ' Grab a line

   StartAnsi = INSTR(a$, AnsiEsc$)           ' Any ANSI?
   StrLen = LEN(a$)

   DO WHILE StartAnsi                 ' If ANSI found, this is the strip loop

      ' Compare the characters in CONST InAnsi$ to the current line on a
      ' character by character basis. A soon as we hit on a character that
      ' is not an the middle of ANSI, we jump out, with k set on the ANSI
      ' terminator.

      FOR k = StartAnsi + 2 TO StrLen
         IF INSTR(InAnsi$, MID$(a$, k, 1)) = 0 THEN EXIT FOR
      NEXT k

      left = StartAnsi - 1     ' Now we need to know if the ANSI escape is
                               ' at the start of the line or not

      IF left THEN             ' ... and process accordingly.
         a$ = MID$(a$, 1, left) + MID$(a$, k + 1)
      ELSE
         a$ = MID$(a$, k + 1)
      END IF

      StartAnsi = INSTR(a$, AnsiEsc$)   ' Find out if there's any more ANSI
      StrLen = LEN(a$)                  ' and adjust the length

   LOOP                                 ' End of the strip loop

   PRINT #2, a$                         ' Print stripped material to file
   PRINT #3, ".";                       ' Let user know it's working

LOOP                                    ' And grab the next line.

CLOSE #1, #2                            ' All done!
PRINT #3,
GOTO Ender

ErrTrp:
   PRINT #3, CHR$(7); "Unable to open "; OutFile$; " as Output File. Reason:"
   SELECT CASE ERR
      CASE 25
         e$ = "Device Fault"
      CASE 61
         e$ = "Disk Full"
      CASE 64
         e$ = "Bad Filename"
      CASE 68
         e$ = "Device Unavailable"
      CASE 70
         e$ = "Permission Denied (Read Only or Write Protect)"
      CASE 71
         e$ = "Disk Not Ready (Check Drive Door)"
      CASE 72
         e$ = "Disk Media Error"
      CASE 75
         e$ = "Path/File Access Error"
      CASE 76
         e$ = "Path Not Found"
      CASE ELSE
         e$ = "Unknown Type Error"
   END SELECT
   PRINT #3, e$
   PRINT #3,
   El = 2
   GOTO Help

NotFound:
   PRINT #3, CHR$(7); "Input file "; InFile$; " Not Found"
   PRINT #3,
   El = 1
Help:
   PRINT #3, "Syntax: astr[286] input_filename output_filename"
   PRINT #3, "  Both parameters are required."
   PRINT #3, "  A space must seperate each parameter."
   PRINT #3,

Ender:
   PRINT #3, Title
   PRINT #3, CString
   PRINT #3,

   CLOSE

END El

