: PC Pursuit script for use with ZCOMM communication software.
: Updated 1/18/88 to version 1.0
: From now on this file will be named ZC1_0PCP.T, where the 1_0
: denotes the version number.

:		 Created and placed in the public domain by:

:	   RCT Design, PO Box 1726, Novato, CA 94948 (415) 892-2713

:				 producers of

:		  JOBS - Job Organization and Backup System
:		   The consumate disk manager and DOS shell
:		 (Shareware version available - Get a copy!)

: Author: Robert C Tellefson  (408) 749-9826
:  UUCP: tellefson@cup.portal.com
: Genie: R.TELLEFSON
:   Cis: 73417,545

: Created 1/12/88 for use with the new PCP format.  This script file
: is not complete in the sense that not all of the cities have been
: plugged in.  However, the operational aspects are complete and seem
: to work excellently, a reflection of the power provided by ZCOMM.

: This script was created to solve a problem we PCP users all have.
: Namely, overnight obsolesence (as of JAN 5 '88) of our PC Pursuit
: scripts.  In addition, I wanted to create something that was simple
: to use and in particualr, robust.  It was also important that it be
: easy to come and go from the script while on line.  There are no
: fancy moves here; it just does the job.

: I have limited the commands used to those that are provided with
: the unregistered version of ZCOMM for two reasons:
: 1.  I wrote this script to evaluate ZCOMM for myself.
:     Result:  ZCOMM is clearly a superior product to the other
:     half dozen comm programs that I have used.  It takes a bit
:     longer to get familiar with (as with any powerful tool) but
:     the effort is definitely worth it.
: 2.  I hope that it will encourage others to try ZCOMM.

: IMPORTANT: Before you customize this script for your own use, make
: a copy of it and rename the copy to 'ZPCP.T'.  Use the copy, save
: the original.  This script will not run under any other name.  Also
: you will not want to be giving it to friends after you have installed
: your password and ID.

: There are three lines which require customization for your individual
: use.  They are marked with a comment that begins with ####.  Plug in
: your personal info at these three places and the script is ready to go.

: There are four other places that require changes or additions if you
: add more city menus to this file.  These four places are marked with
: comments that begin with $$$$.  Adding more city menus is very simple.
: 1. Copy one of the existing menus.
: 2. Each menu has two branch labels aXXX: and aXXXa: where XXX is the
:    area code of the city.  Change these two labels (and the two 
     references to them) to match the new city's area code.
: 3. Replace the numbered menu selections with the selections you want
:    included for this city.  Example:
:                lput " 4  = PCUG dt pub. (445-8072)\n"
: 4. Change the phone numbers in the corresponding lines that test and
:    supply the phone #. Example:
:                if is1,1 set s2 "281-7586"; goto dit
: 5. You may comment out or erase unneeded entries or add new ones as
:    needed.
: 6. Change the menu's title line.
: 7. Add an entry at 'xlarea:' to translate city abbreviation to area
:    code.
: 8. Add and entry at 'leap:' that causes a jump to the new city's menu.

: For those occasions when Telenet gets confused or you enter a node
: that was left in an undetermined mode, I have included a SYNCRONIZE
: command at every menu.  Syncronizing takes place automatically if
: the script doesn't see what it expects, but you may also force a
: syc to be done just for your own peace of mind.  So far the snyc
: routines have worked excellently in every situation I ran into or
: could create (it may take some time, but we must be patient with 
: Telenet).  If you run into something I didn't, feel free to bring
: it to my attention so we both benefit from the knowledge.

: The sync routines listen to the keyboard and quit trying if a
: keystroke is detected (it may take a few to get its attention).
: This is useful for those situations where sync can't be found
: and you want out.

: Using this script is easy.  There are only four commands.
: 1.  call 2pcp  This command is used to begin a PC pusuit session.
:                It calls your local telenet 1200 baud access number,
:                sets the SET? commands (suitable for uploads/downloads
:                with bbs's) and displays the city list.  Select a city
:                from the menu and it will be dialed continuously until
:                it connects or you stop it by pressing any key when
:                the highlighted message is first displayed.
:                Once conected to a city, that city's menu is displayed.
:                Select the number to dial and dialing will begin.
:                Dialing will repeat until a connection is made or
:                you stop it.  At any menu you may elect to stop the
:                script and return to terminal mode.
: 2. call 4pcp   Same as 'call 2pcp' except that it uses the 2400 baud
:                access number.  This script supports 2400 baud for
:                those cities that are included in this script, although
:                as of this time only Boston is actually functioning.
:                The rest should be operational within Jan 88.
: 3. call pcp    If you cancel the script while at the cities menu,
:                use this command to restart the script.
: 4. call city   If you cancel the script while at a city menu, use
:                this command to restart the script.  You will be
:                prompted for the Area Code to resume at, so be sure
:                to make note of what city you're in before canceling
:                the script at a city menu.

: With the addition of the new cities, there is some duplication of
: Area Codes.  Where prompted for a city, this script will accept
: either an Area Code or the telenet city abbreviation.  Where the
: Area Code would be ambiguous you must use the city abbreviation.
: Example: San Francisco and Palo Alto are both 415

: Here's the commands for attaching these commands to your function
: keys:
:	set f5 "@call 2pcp.zpcp.t"
:	set f6 "@call 4pcp.zpcp.t"
:	set f7 "@call pcp.zpcp.t"
:	set f8 "@call city.zpcp.t"

: A word about re-dialing.  You may leave the system unattended and
: when a connection is made the bell will ring once.  I dislike the
: bell going off any more than necessary so I disable the bell at
: all other times and enable it only for this one purpose.  You may
: wish to do otherwise.  The command that rings the bell is called
: 'ring', oddly enough.

: Autodial is automatic, to stop it press any key when the highlighted
: message reminding you to do so is first displayed and before the next
: redial.  Hitting a key while the number is being dialed has no effect.

: By the way, the BBS's in the city menus that are known to have a
: copy of our JOBS disk manager are marked with a (*JOBS31xx*) after
: their names.  JOBS (version 3.1) comes as two arc'd files:

:		     JOBS31x1.ARC  and  JOBS31x2.ARC

: where the x denotes the sub version.  In addition there is usually
: a file named JOBS31x0.ARC which describes JOBS and its capabilities
: for those of you that would like to read about it before downloading.
: If you use ZCOMM, you know the value of a powerful and versatile
: tool.  JOBS is one of those kind of tools.

: That's about all there is to it.  For better performance you should
: remove this text from the script file when you use it.  This is not
: essential but it will speed up the commands a little bit.  Please
: keep a copy of the original file to give to your friends.

: note: I have not connected to all of the bbs's listed in these menus.

:......................... begin script .............................

commnu  lput " -------------------------------------------\n"
	lput " D  = Dial number not in menu\n"
	lput " E  = Exit this city\n"
	lput " T  = Cancel script, return to terminal mode\n"
	lput " S  = Syncronize\n\n"
	display nonlmode
	acceptl s1 "      Choice? "
	return

tcon	echo "\rconnected to telenet\r"; return

setcmds	put "SET? 1:0,4:2,5:0,7:8,12:0\r"; return

clrkey	while k acceptl1 fc1 ""

redmsg	echo "Hit any key to stop redial\n"; sleep 15; return

badsync:	echo "Returning to terminal mode."; return

nocar:	echo "Not currently on line, use 'call 2pcp' or 'call 4pcp' to begin"; return

byepcp:	pat; pat 1 "NO CARRIER"; put "HANGUP\r";
	while "!1&&c&&L<3" wait -f1
	if c bye
	return
	
city:	if !c goto nocar
	echo "Return to city, checking sync...."
	gosub syncity.zpcp.t
	if %s1 goto badsync
	acceptl s4 "Area code (or city abbrev.) of city to return to? "
	if !%s4 return
	gosub clrkey.zpcp.t
	gosub xlarea.zpcp.t
	goto leap

ring	display nobell; lput "\007"; display bell=visual; return

getnum:	accept s2 "      Number to dial? "
	if !%s2 goto leap

dit:	lput "\n\r"
rdit:	if k gosub clrkey.zpcp.t; goto leap
	put "ATDT"; put %s2; put "\r"
	pat 1 "BUSY"; pat 2 "CONNECT"
	wait -f90
	if 1 set s3 BUSY; gosub redmsg.zpcp.t; goto rdit
	if 2 gosub ring.zpcp.t; t -8g; return
	set s3 ERROR; goto leap

dcity:	put "\100\r"; pat;
	pat 1 "\n@";
	wait -f4
	if 1 put "D\r";
	pat 1 "DISCON"
	wait -f15
	if 1 goto pcp
	gosub syncity.zpcp.t
	if %s1 goto badsync
	goto dcity

synctel	gosub clrkey.zpcp.t
	pat; pat 1 @
	while "!k&&!1&&L<5" put "\r" wait -f1
	if k gosub clrkey.zpcp.t; goto stel2
	if 1 goto stel2
	pat 2 "TELENET"
	put "\100\r"
	wait -f5
	if !2 echo "Couldn't syncronize"; goto stel2
	echo "You appear to be still connected to a city."
	acceptl1 s1 "Press <C> to go to a city menu, any other key to return to main menu"
	if is1,c goto city
stel2:	pat; return

syncity:
	gosub clrkey.zpcp.t
	set s1 ""; set s5 "ATZ\r"
syn2:	if k gosub clrkey.zpcp.t; return
	pat; pat 1 "MANUAL ANSWER"; pat 2 OK;
	pat 3 "INVALID COMMAND"; pat 4 *;
	pat 5 @; pat 6 "NOT CONNECTED"; pat 7 "IDLE"
	put %s5
	if !is5,"ATZ\r" set s5 "ATZ\r"
	wait -f5
syn3:	if 6 pat; echo "not in city, use 'call pcp' to restart\n"; goto syn4
	if 7 goto syn2
	if "1||3||4" set s5 "I\r"; goto syn2
	if 5 set s5 "CONT\r"; goto syn2
	if 2 pat; return
	put "\100\r"
	wait -f5
	if 5 put "CONT\r"
	wait -f5
	put "ATZ\r"
	if "1||3||4" set s5 "I\r"; goto syn2
	if 6 goto syn3
	if 2 pat; return
syn4:	echo "Couldn't syncronize at city"
	set s1 "no sync"
	return

	: $$$$ ADD CITIES HERE
	: just dup a line and change cite abbrev. and equiv. area code
	: translate city abbrev. to area code
xlarea:	if is4,atl set s4 404
	if is4,bos set s4 617
	if is4,chi set s4 312
	if is4,det set s4 313
	if is4,gle set s4 818
	if is4,lan set s4 213
	if is4,mil set s4 414
	if is4,nyo set s4 212
	if is4,por set s4 503
	if is4,sac set s4 916
	if is4,sfa set s4 415
	if is4,was set s4 202
	return

	: $$$$ ADD CITIES HERE
	: just dup a line and change the area code numbers
leap:	pat;
	if is4,202 goto a202
	if is4,212 goto a212
	if is4,213 goto a213
	if is4,312 goto a312
	if is4,313 goto a313
	if is4,404 goto a404
	if is4,414 goto a414
	if is4,415 goto a415
	if is4,503 goto a503
	if is4,617 goto a617
	if is4,818 goto a818
	if is4,916 goto a916
	return

4pcp	cls; echo "Calling PC Pursuit - 2400"
	speed 2400
	goto dpcp
2pcp	cls; echo "Calling PC Pursuit - 1200"
	speed 1200
dpcp:	if S>1200 286-6340	: #### TELENET 2400 BAUD ACCESS NUMBER
	else 294-9119		: #### TELENET 1200 BAUD ACCESS NUMBER
	gosub tcon.zpcp.t
	set s1 ""; set s2 ""; set s3 ""
	ena -t
	if S>1200 put "\100"; sleep 3; put "D\r"
	else put "\rD\r"
	pat 1 "\nTERMINAL="
	wait -f10
	if !1 echo "failed connect to telenet"; return
	put "D1\r"
	pat 1$ "\n\r\n@"
	wait
	gosub setcmds.zpcp.t
	pat 1$ "\n\r\n@"
	wait
	dis -t
pcp:	pat;
	if !c goto nocar
	goto pcpm
gocity: set s3 ""; lput "\n\r"
rdial:	if k gosub clrkey.zpcp.t; goto pcp
	pat; pat 1 "BUSY"; pat 2 "CONNECTED"; pat 3 "NOT REACH"
	pat 4 "STILL CONNECT"; pat 5 "UNAVAIL"; pat 6 "NOT OPER"
	put "C %s2,ID,PASSWORD\r" : #### add your telenet ID,PASSWORD
	wait -f15
	if !4 goto rd1
	pat;
	echo "You appear to be still connected to a city."
	acceptl1 s1 "Press <C> to go to a city menu, any other key to return to main menu"
	if is1,c goto city
	goto pcp
rd1:	if 1 set s3 BUSY; gosub redmsg.zpcp.t; goto rdial
	if !2 gosub synctel.zpcp.t; set s3 "Couldn't connect"; goto pcp
	set s3 ""
	if is2,PURSUIT gosub ring; t -8g; return
	if is2,PORTAL gosub ring; t -8g; return
	gosub syncity.zpcp.t
	if %s1 goto badsync
	gosub ring.zpcp.t
	goto leap

pcpm:	cls
	if %s3 echo %s3; set s3 ""
pcagn:	if !c goto nocar
	display nlmode nooverstrike;
	: note: '&' is used where more than one area code is accessed from
	:       one city.  Those that are in () require that the numbers
	:       be prepended to the phone number when dialing from that city.
 lput " PC Pursuit city list  '_' denotes 2400 baud cities ͻ\n"
 lput " ATL = 404 _Atlanta                PAL * 415  Palo Alto    & (408) \n"
 lput " BOS = 617 _Boston                 POR = 503  Portland             \n"
 lput " CHI = 312 _Chicago    & (1-815)   RTP * 919  Res. Tri. Park       \n"
 lput " CLV * 216  Cleveland              RIV * 714  Riverside            \n"
 lput " DAL * 214  Dallas                 SLC * 801  Salt Lake City       \n"
 lput " DEN * 303  Denver                 SAN * 714  Santa Ana            \n"
 lput " DET = 313 _Detroit                SAC = 916  Sacramento           \n"
 lput " GLE = 818  Glendale               SAD * 619  San Diego            \n"
 lput " HAR * 203  Hartford               SLO * 314  St. Louis    & (618) \n"
 lput " HOU * 713  Houston                SFA = 415 _San Francisco        \n"
 lput " KAN * 816  Kansas City  & (913)   SJO * 408  San Jose     & (415) \n"
 lput " LAN = 213 _Los Angeles            SEA * 206  Seattle              \n"
 lput " MIA * 305  Miami                  TAM * 813  Tampa                \n"
 lput " MIL = 414  Milwaukee              WAS = 202 _Washington & 703,301 \n"
 lput " MIN * 612  Minneapolis              H = HANGUP                    \n"
 lput " NEW * 201  Newark                   N = Net Exchange BBS          \n"
 lput " NYO = 212 _New York    & (1-718)    P = Portal                    \n"
 lput " PHI * 215  Philadelphia             S = Syncronize                \n"
 lput " PHO * 602  Phoenix                  T = Terminal mode             \n"
 lput " '*' denotes not currently installed in this script ͼ\n\n"
	set s2 ""
	acceptl s4 "  Enter city abbreviation, Area Code, or other command: "
	: $$$$ ADD 1200 BAUD CITIES HERE
	: just dup a line, change the area code and
	: the xxxxx in "D/xxxxx/12"
	gosub xlarea.zpcp.t
	if S>1200 goto b2400
	if is4,202 set s2 "D/DCWAS/12"; goto gocity
	if is4,212 set s2 "D/NYNYO/12"; goto gocity
	if is4,213 set s2 "D/CALAN/12"; goto gocity
	if is4,312 set s2 "D/ILCHI/12"; goto gocity
	if is4,313 set s2 "D/MIDET/12"; goto gocity
	if is4,404 set s2 "D/GAATL/12"; goto gocity
	if is4,414 set s2 "D/WIMIL/12"; goto gocity
	if is4,415 set s2 "D/CASFA/12"; goto gocity
	if is4,503 set s2 "D/ORPOR/12"; goto gocity
	if is4,617 set s2 "D/MABOS/12"; goto gocity
	if is4,818 set s2 "D/CAGLE/12"; goto gocity
	if is4,916 set s2 "D/CASAC/12"; goto gocity
	goto bboth
	: $$$$ ADD 2400 BAUD CITIES HERE
	: just dup a line, change the area code and
	: the xxxxx in "D/xxxxx/24"
b2400:	if is4,202 set s2 "D/DCWAS/24"; goto gocity
	if is4,212 set s2 "D/NYNYO/24"; goto gocity
	if is4,213 set s2 "D/CALAN/24"; goto gocity
	if is4,312 set s2 "D/ILCHI/24"; goto gocity
	if is4,313 set s2 "D/MIDET/24"; goto gocity
	if is4,404 set s2 "D/GAATL/24"; goto gocity
	if is4,415 set s2 "D/CASFA/24"; goto gocity
	if is4,617 set s2 "D/MABOS/24"; goto gocity
bboth:	if is4,n set s2 "PURSUIT"; goto gocity
	if is4,p set s2 "PORTAL"; goto gocity
	if is4,t return
	if is4,h goto byepcp
	if is4,s gosub synctel.zpcp.t; lput "\n\r"; goto pcagn
	cls; echo "Try again."; goto pcagn

:........................ begin city menus .............................

a202:	cls;					:________WASHINGTON DC
	if s3 echo "%s3\ %s2"; set s3 ""
a202a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(202) Wash DC numbers:\n"
	lput " 1  = Govt Computer Net (537-1045)  (*JOBS31A*)\n"
	lput " 2  = TeleComm BBS (478-9850)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "537-1045\r"; goto dit
	if is1,2 set s2 "478-9850\r"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,s gosub syncity.zpcp.t; goto a202a
	if is1,e goto dcity
	cls; echo "Try again."; goto a202a

a212:	cls;						:________NEW YORK
	if s3 echo "%s3\ %s2"; set s3 ""
a212a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(212) New York numbers:\n"
	lput " 1  = Deversified Tech (415-2697)\n"
	lput " 2  = Supersystem (683-2332)\n"
	lput " 3  = PC Mag IRS,2-7 lines (696-0360)\n"
	lput " 4  = Hi Tech (769-4799)  (*JOBS31A*)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "415-2697"; goto dit
	if is1,2 set s2 "683-2332"; goto dit
	if is1,3 set s2 "696-0360"; goto dit
	if is1,4 set s2 "769-4799"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,s gosub syncity.zpcp.t; goto a212a
	if is1,e goto dcity
	cls; echo "Try again."; goto a212a

a213:	cls;						:________LOS ANGELES
	if s3 echo "%s3\ %s2"; set s3 ""
a213a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(213) Los Angeles numbers:\n"
	lput " 1  = Long beach BBS (438-6783)  $5 reg fee\n"
	lput " 2  = Intelligent solutions (494-1243)\n"
	lput " 3  = PC Store (559-6954)\n"
	lput " 4  = Network Adv'ge,30M  (822-1804)\n"
	lput " 5  = INFO-IBMPC (827-2635) 827-2515\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "438-6783"; goto dit
	if is1,2 set s2 "494-1243"; goto dit
	if is1,3 set s2 "559-6954"; goto dit
	if is1,4 set s2 "822-1804"; goto dit
	if is1,5 set s2 "827-2635"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,s gosub syncity.zpcp.t; goto a213a
	if is1,e goto dcity
	cls; echo "Try again."; goto a213a

a312:	cls;						:________CHICAGO
	if s3 echo "%s3\ %s2"; set s3 ""
a312a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(312) Chicago numbers:\n"
	lput " 1  = RBBS of Chicago,160M  (312-352-1035)\n"
	lput " 2  = Turner Tech,72M  (312-593-6478)  (*JOBS31A*)\n"
	lput " 3  = Lakes Region,95M  (312-872-8086)\n"
	lput " 4  = Rick's BB, 60M  (312-588-1003)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "352-1035"; goto dit
	if is1,2 set s2 "593-6478"; goto dit
	if is1,3 set s2 "872-8086"; goto dit
	if is1,4 set s2 "588-1003"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,s gosub syncity.zpcp.t; goto a312a
	if is1,e goto dcity
	cls; echo "Try again."; goto a312a

a313:	cls;					:________DETROIT
	if s3 echo "%s3\ %s2"; set s3 ""
a313a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(313) Detroit numbers:\n"
	lput " 1  = Home of FansiConsole  (994-3946)\n"
	lput " 2  = PCUTIL, Utilities  (393-0527)\n"
	lput " 3  = Data Exchange  (254-5514)\n"
	: lput " 4  = \n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "994-3946"; goto dit
	if is1,2 set s2 "393-0527"; goto dit
	if is1,3 set s2 "254-5514"; goto dit
	: if is1,4 set s2 ""; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,s gosub syncity.zpcp.t; goto a313a
	if is1,e goto dcity
	cls; echo "Try again."; goto a313a

a404:	cls;					:________ATLANTA
	if s3 echo "%s3\ %s2"; set s3 ""
a404a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(404) Atlanta numbers:\n"
	lput " 1  = Automenu bbs (446-6650)\n"
	lput " 2  = Atlanta PCUG (433-0062)\n"
	lput " 3  = PC World  (565-7775)\n"
	lput " 4  = T.J.'s,60M  (392-1756)\n"
	lput " 5  = AESC,100M  (381-1947)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "446-6650"; goto dit
	if is1,2 set s2 "433-0062"; goto dit
	if is1,3 set s2 "565-7775"; goto dit
	if is1,4 set s2 "392-1756"; goto dit
	if is1,5 set s2 "381-1947"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a404a
	cls; echo "Try again."; goto a404a

a414:	cls;					:________MILWAUKEE
	if s3 echo "%s3\ %s2"; set s3 ""
a414a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(414) Milwaukee numbers:\n"
	lput " 1  = PKARC bbs (352-7176)\n"
	lput " 2  = F.R.E.D.  (784-1417)\n"
	: lput " 3  = )\n"
	: lput " 4  = )\n"
	: lput " 5  = )\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "352-7176"; goto dit
	if is1,2 set s2 "784-1417"; goto dit
	: if is1,3 set s2 ""; goto dit
	: if is1,4 set s2 ""; goto dit
	: if is1,5 set s2 ""; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a414a
	cls; echo "Try again."; goto a414a

a415:	cls;                                    :________SAN FRAN
	if s3 echo "%s3\ %s2"; set s3 ""
a415a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(415) San Francisco:\n"
	lput " 1  = Charisma (349-6576)  (*JOBS31A*)\n"
	lput " 2  = R-Entrepreneurs (552-9070)\n"
	lput " 3  = X-LogOn, 8 lines (571-6911)\n"
	lput " 4  = R-PC Shop-Talk (621-6520)\n"
	lput " 5  = R-Marin Sonoma PCUG (927-1216)\n"
	lput " 6  = R-CLM source codes (957-9370)\n"
	lput " 7  = VOR RBBS -Vern Buerg (994-2944)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "349-6576"; goto dit
	if is1,2 set s2 "552-9070"; goto dit
	if is1,3 set s2 "571-6911"; goto dit
	if is1,4 set s2 "621-6520"; goto dit
	if is1,5 set s2 "927-1216"; goto dit
	if is1,6 set s2 "957-9370"; goto dit
	if is1,7 set s2 "994-2944"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a415a
	cls; echo "Try again."; goto a415a

a503:	cls;						:________PORTLAND
	if s3 echo "%s3\ %s2"; set s3 ""
a503a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(503) Portland numbers:\n"
	lput " 1  = Zcomm's bbs (1-503-621-3746)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "621-3746"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a503a
	cls; echo "Try again."; goto a503a

a617:	cls;						:________BOSTON
	if s3 echo "%s3\ %s2"; set s3 ""
a617a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(617) Boston numbers:\n"
	lput " 1  = Boston Computer Soc.  (332-5584)\n"
	lput " 2  = Channel One,400M  (354-8873)\n"
	lput " 3  = Future Tech Xchg  (720-3600)\n"
	lput " 4  = RBBS IBM PC Computer Society  (353-29312)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "332-5584"; goto dit
	if is1,2 set s2 "354-8873"; goto dit
	if is1,3 set s2 "720-3600"; goto dit
	if is1,4 set s2 "353-9312"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a617a
	cls; echo "Try again."; goto a617a

a818:	cls;					:________GLENDALE
	if s3 echo "%s3\ %s2"; set s3 ""
a818a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(818) Glendale numbers:\n"
	lput " 1  = PrgrmrXchange (281-7586)\n"
	lput " 2  = The Ledge PCBoard (352-3620)\n"
	lput " 3  = Mogur's EMS (366-1238)\n"
	lput " 4  = PCUG dt pub. (445-8072)\n"
	lput " 5  = Lynzie's motherboard (508-6482)\n"
	lput " 6  = Lunacy Board-2000+-f (894-1248)\n"
	lput " 7  = Underground RBBS (954-0800)\n"
	lput " 8  = Sysops only (990-6842)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "281-7586"; goto dit
	if is1,2 set s2 "352-3620"; goto dit
	if is1,3 set s2 "366-1238"; goto dit
	if is1,4 set s2 "445-8072"; goto dit
	if is1,5 set s2 "508-6482"; goto dit
	if is1,6 set s2 "894-1248"; goto dit
	if is1,7 set s2 "954-0800"; goto dit
	if is1,8 set s2 "990-6842"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a818a
	cls; echo "Try again."; goto a818a

a916:	cls;					:________SACRAMENTO
	if s3 echo "%s3\ %s2"; set s3 ""
a916a:	if !c goto nocar
	display nlmode nooverstrike
	echo "(916) Sacramento numbers:\n"
	lput " 1  = IBM Archives,64M  (682-6755)\n"
	lput " 2  = Generic, ASM,121M  (726-4272)\n"
	gosub commnu.zpcp.t
	if is1,1 set s2 "682-6755"; goto dit
	if is1,2 set s2 "726-4272"; goto dit
	if is1,d goto getnum
	if is1,t return
	if is1,e goto dcity
	if is1,s gosub syncity.zpcp.t; goto a916a
	cls; echo "Try again."; goto a916a

