/*
**	formatch() proto/data types header file (for use with MicroS*t C7.00)
**
**	Otto Makela, Jyvaskyla, Finland, 1992
**	Distributed under the GNU General Public Licence:
**	see file COPYING for details
*/

int formatch(char *, unsigned int, int (*)(struct file_match *));

#ifndef	_A_RDONLY
#include	<dos.h>
#endif

#include	<time.h>
#include	<stdlib.h>

struct file_match	{
	unsigned char attribute;	/* Found DOS attribute */
	time_t filetime;		/* time() format time file last modified */
	struct tm file_tm;		/* Same in struct tm form */
	unsigned long filesize;		/* Length of file */
	char filename[65];		/* Full filename, shortname ->here */
	char *shortname;		/* Pointer to filename tail part */
	char *extension;		/* Pointer to filename extension */
};

/*
**	These masks are identical to DOS file attribute bits
*/
#define	READONLY	_A_RDONLY	/* DOS attribute 0x01 */
#define	HIDDEN		_A_HIDDEN	/* DOS attribute 0x02 */
#define	SYSTEM		_A_SYSTEM	/* DOS attribute 0x04 */
#define	VOLABEL		_A_VOLID	/* DOS attribute 0x08 */
#define	DIRECTORY	_A_SUBDIR	/* DOS attribute 0x10 */
#define	ARCHIVE		_A_ARCH		/* DOS attribute 0x20 */

#define	ALLREALONES	(_A_NORMAL|_A_RDONLY|_A_HIDDEN|_A_SYSTEM\
			|_A_VOLID|_A_SUBDIR|_A_ARCH)

/*
**	These masks modify the functioning of formatch()
*/
#define	DOTHIDDEN	0x0100		/* Treat . and .. as hidden files */
#define	MATCHNONWILD	0x0200		/* Force match on nonwild files */
#define	RECURSIVE	0x0400		/* Recurse subdirectories */
#define	DIRFIRST	0x0800		/* Recursive: return directory first */

extern char switchar,dirsepar,othersepar;

/*
**	The environment variable SWITCHAR is the switch character
**	which this program uses.  If it is set to a slash, we will
**	emulate the standard MS-DOS command line conventions,
**	otherwise we try to be somewhat unix-like
*/
#define	init_match()	\
		do	{\
			if(!switchar)	{\
				char *p;\
				if((p=getenv("SWITCHAR")) && (switchar=*p)=='/')	{\
					dirsepar='\\';\
					othersepar='/';\
				} else\
					switchar='-';\
			}\
		} while(0)
