/*
   A program to add the Lines: header to Waffle messages..
   --- needs to be run before the Waffle BATCH.EXE program.

   Syntax: LINES <batch queue directories>

   If feeds file reads:
      tornado /batch=compress rec.* comp.* soc.*
      halcyon /batch clari

   then command line will be something like:
        LINES d:\spool\compress d:\spool\batch
     or Lines d:\spool\comp16


   Returns ERRORLEVEL 0 if okay, 1 if an error.

   Will only add Lines: header to message if it isn't already there.

   Written in a hurry under Borland TC v2.0.
   by Pat Cain, cain_p@kosmos.wcc.govt.nz

   Refer to lines.doc for more info.

*/

#include <stdio.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LINE_LEN 1023
#define READ_ONLY    "r"
#define WRITE        "w"
#define LINES        "Lines: "
#define TEMP_FILE    "/temp.msg"


main(int argc, char *argv[]) {
  char cwd[MAX_LINE_LEN];
  int converted=0, argument=1;

  printf("Waffle \"Lines:\" Adder\n\n");

  if (argc<2) {
    printf("syntax: lines batch-directories\n"
           "    eg. lines d:/spool/compress\n"
           "    or  lines d:/spool/batch d:/spool/compress d:/spool/comp16\n");
    exit(1);
  }

  getcwd(cwd, MAX_LINE_LEN); /* save current dir */

  while (argument!=argc) {
    printf("Directory: %s\n",argv[argument]);
    if (chdir(argv[argument]))
      printf("error: can't open directory '%s'\n",argv[argument]);
    else
      converted+=do_current();
    argument++;
  }
  chdir(cwd);  /* return to original dir */
  printf("%d messages converted\n", converted);

  exit(0);
}

int do_message(char *filename) {
  /* Counts lines in a message then inserts Lines: header */

  int x, found_lines=0, lines=0;
  int lines_length=strlen(LINES);
  int name_length=strlen(filename);
  char line[MAX_LINE_LEN];
  FILE *message, *tempfile;

  if (name_length && filename[name_length-1]=='\n')
    filename[name_length-1]=0;  /* cut off LF at end.. */

  printf("  %s ",filename);
  /* Print some dots after filename */
  for(x=name_length;x<30;x++) putchar('.');
  putchar(' ');

  if ((message=fopen(filename,READ_ONLY))==NULL) {
    printf("couldn't open message file '%s'\n",filename);
    return 0;
  }

  /* Scan through headers for Lines: header.. */
  while(fgets(line, MAX_LINE_LEN, message) && line[0]!='\n' && !found_lines)
    if (!strncmp(line, LINES, lines_length)) found_lines=1;
  if (found_lines) {
    /* Message already has the Lines: header in it */
    printf("done\n");
    return 0;
  }

  /* Now know message doesn't have "Lines:" header.. */
  while(fgets(line, MAX_LINE_LEN, message)) lines++;
  printf("%d lines",lines);

  if ((tempfile=fopen(TEMP_FILE, WRITE))==NULL) {
    printf("ERROR: Can't open temporary file '%s' for writing\n",TEMP_FILE);
    return 0;
  }

  /* Jump back to start of message file */
  fseek(message, 0L, SEEK_SET);
  printf(", copying");
  while(fgets(line, MAX_LINE_LEN, message) && line[0]!='\n')
    fputs(line, tempfile);

  /* put Lines: header in temporary file.. */
  fprintf(tempfile, "%s%d\n", LINES, lines);

  if (lines) {
    /* copy message over .. */
    /* put blank line between headers/message */
    fprintf(tempfile, "\n");
    /* copy rest of message into temp file */
    while(fgets(line, MAX_LINE_LEN, message)) fputs(line, tempfile);
  }

  fclose(tempfile); /* Close temporary file */
  fclose(message);  /* Close message file */
  remove(filename); /* Remove message without Lines: header */
  rename(TEMP_FILE, filename);  /* Rename to correct filename */
  printf(", done\n");

  return(1);
}


int do_current() {
  /* Read queue files in current directory.. process them.. */

  char line[MAX_LINE_LEN];   /* Line of text */
  int done;
  int converted=0;
  struct ffblk ffblk;
  FILE *handle;

  done=findfirst("*.*",&ffblk,255);  /* Find first file */
  if (done) return 0;  /* Nothing found .. */

  while (!done) {
    if (ffblk.ff_name[0]!='.')
      /* if not ".<blah>" then ... */
      if ((handle=fopen(ffblk.ff_name,"r"))==NULL)
        printf("Couldn't open queue file '%s'\n",ffblk.ff_name);
      else {
        /* Read in a line from batch file.. */
        while(fgets(line,MAX_LINE_LEN,handle)) converted+=do_message(line);
        fclose(handle);  /* Close queue file */
      }
    done=findnext(&ffblk);
  }
  return converted;
}
