unit rusnproc;

{

rusnproc.pas - rusnews procedures

}

{$I rusn-def.pas}

interface

uses dos,rusnglob,rusnfunc,rusnio,genericf,rusnmous;

procedure warn(warning: string);
procedure warn3(w1,w2,w3: string);
procedure warnerr(prg: string; doserr: integer);
procedure execp(cmd,cmdline: string);
procedure shellout;
procedure unfoldergroup(var group: string);
procedure pickagroup(var possgroup: string);
procedure updatejoin(highestnum: word);
procedure updatejoinunsubscribe;
procedure addnewmailgroup(newgroup: string);
procedure execviacomspec(cmdline: string);

implementation

procedure warn;

var
  wastec: char;

begin
  xclreolxy(1,lpp);
  xwritess(warning,' - press any key ');
  wastec := xreadkey;
  xclreolxy(1,lpp);
end;

procedure warn3;

begin
  xwriteln;
  xwriteln;
  xclreolxy(1,lpp-2);
  xwrites(w1);
  xclreolxy(1,lpp-1);
  xwrites(w2);
  warn(w3);
  xclreolxy(1,lpp-2);
  xclreolxy(1,lpp-1);
end;

procedure warnerr;

var
  errstr: string;

begin
  errstr := itoa(doserr); 
  if doserr=2 then errstr := '2 (file not found)'
  else if doserr=3 then errstr := '3 (path not found)'
  else if doserr=5 then errstr := '5 (access denied)'
  else if doserr=6 then errstr := '6 (invalid handle)'
  else if doserr=8 then errstr := '8 (not enough memory)'
  else if doserr=10 then errstr := '10 (invalid environment)'
  else if doserr=11 then errstr := '11 (invalid format)'
  else if doserr=18 then errstr := '18 (no more files)';

  warn('warning: '+prg+' failed (error '+errstr+')');
end;

procedure execp;

var
  path: string;
  success: boolean;
  ncmd: string;
  nbase: string;
  npath: string;
  el: string;
  at: integer;

function indir(cmd,dir: string): boolean;

var
  fileinfo: searchrec;

begin
  findfirst(dir+'\'+cmd,archive,fileinfo);
  indir := (doserror=0);
end;

begin
  success := false;

  ncmd := crepl(cmd,'/','\');
  nbase := ncmd;

{strip path from nbase}

  repeat
    at := pos(':',nbase);
    if at<>0 then
      nbase := copy(nbase,at+1,255);
  until at=0;

  repeat
    at := pos('\',nbase);
    if at<>0 then
      nbase := copy(nbase,at+1,255);
  until at=0;

{chop off path.  if trailing \, chop, unless root or drive:root (then add .)}

  npath := '';
  if nbase<>ncmd then
    begin
      success := true;  {so as to not look further than given path}
      npath := copy(ncmd,1,length(ncmd)-length(nbase));
      if npath='\' then
        npath := npath+'.';
      if pos(':\',npath)<>0 then
        if copy(npath,length(npath)-1,2)=':\' then
          npath := npath+'.';
      if copy(npath,length(npath),1)='\' then
        npath := copy(npath,1,length(npath)-1);
    end;

{if an explicit path, use it -- otherwise, just try '.'}

  if npath='' then
    npath := '.';

{if no extension, try com then exe}

  if pos('.',nbase)=0 then
    begin
      if indir(nbase+'.com',npath) then
        begin
          success := true;
          exec(npath+'\'+nbase+'.com',cmdline);
        end
      else if indir(nbase+'.exe',npath) then
        begin
          success := true;
          exec(npath+'\'+nbase+'.exe',cmdline);
        end
    end
  else if indir(nbase,npath) then
    begin
      success := true;
      exec(npath+'\'+nbase,cmdline);
    end;

  if not success then
    begin

{not found in explicit path (or ., if no explicit path).  try $PATH}

      path := getenv('PATH');
      while not success and (path<>'') do
        begin
          if copy(path,length(path),255)<>';' then
            path := path+';';
          at := pos(';',path);
          el := copy(path,1,at-1);
          path := copy(path,at+1,255);
          if pos('.',nbase)=0 then
            begin
              if indir(nbase+'.com',el) then
                begin
                  success := true;
                  exec(el+'\'+nbase+'.com',cmdline);
                end
              else if indir(nbase+'.exe',el) then
                begin
                  success := true;
                  exec(el+'\'+nbase+'.exe',cmdline);
                end;
            end
          else
            begin
              if indir(nbase,el) then
                begin
                  success := true;
                  exec(el+'\'+nbase,cmdline);
                end;
            end;
        end;
    end;
end;

procedure shellout;

var
  doserr: integer;
  wastec: char;

begin
  if console and trusted then
    begin
      xgotoxy(1,lpp);
      xwriteln;
      xwriteln;
      xwriteln;
      xwritelns('use `EXIT'' to return to rusnews');
      xwritelns('be careful - you probably don''t have a lot of memory left');
      xwriteln;
      if comspec='' then
        begin
          warn('could not find what shell to run - no COMSPEC variable');
        end
      else
        begin
          mousehide;
          execp(comspec,'');
          mouseshow;
          doserr := doserror;
          xgotoxy(1,lpp);
          xwriteln;
          xwriteln;
          xwriteln;
          if doserr<>0 then
            xwrites('(error) press any key to return to rusnews ')
          else
            xwrites('press any key to return to rusnews ');
          wastec := xreadkey;
          xwrites(^M);
          xclreol;
          if doserr<>0 then
            warnerr('shell',doserr);
        end
    end;
end;

procedure unfoldergroup;

begin
  if length(group)>0 then
    if group[1]='=' then
      begin
        if length(group)=1 then
          group := mailprefix
        else
          group := mailprefix+'.'+copy(group,2,255);

{ prevent possible security hole }

        if (numoccur('\',unslash(group))<>0) or
         (numoccur(':',group)<>0) or (pos('..',group)<>0) then
          group := mailprefix;
      end;
end;

procedure pickagroup;

var
  howto: char;

begin
  xclreolxy(1,lpp);
  if possgroup='' then
    begin
      xwrites('Goto group (or initials): ');
      possgroup := currgroup;

{ changed true to false - it was a pain having to hit ^U to cancel this }

      xreadlnsp(possgroup,cols-30,false);

{mail folder support}

      unfoldergroup(possgroup);

    end;

  if (possgroup='') then
    xclreolxy(1,lpp)
  else
    if joinedtogroup(possgroup) then
      begin
        xclreolxy(1,lpp-1);
        xwritelnss('found group: ',possgroup);
        howto := onekey(
    '<j>ump, <a>ll, <A>ll, last <1>-<9> pages <h>eader <b>ody <e>ither (j) ',
         'jaA123456789hbe '+#13);
        if (howto=' ') or (howto=#13) then
          howto := 'j';
        if howto='h' then
          begin
            searchinheaders := true;
            howto := 'A';
          end;
        if howto='b' then
          begin
            searchinbody := true;
            howto := 'A';
          end;
        if howto='e' then
          begin
            searchinheaders := true;
            searchinbody := true;
            howto := 'A';
          end;
        if searchinheaders or searchinbody then
          begin
            xclreolxy(1,lpp);
            xwrites('Search for: ');
            xreadlns(searchtext,cols-30,true);
            if searchtext='' then
              searchtext := newsreadername;
          end;
        if howto='A' then
          begin
            readabsolutelyallarts := true;
            howto := 'a';
          end;
        if howto='a' then
          readallarts := true;
        if (howto>='1') and (howto<='9') then
          readpagesback := ord(howto)-ord('0');
        xclreolxy(1,lpp);
      end
    else
      begin
        warn('could not find a group to match');
        possgroup := '';
      end;
end;

procedure updatejoin;

var
  s: string;
  tempf: text;

begin
  if highestnum>alreadyread then
    begin
      xwritelns('Updating join file...');
      assign(tempf,temporarydir+'\'+userid);
      reset(joinf);
      rewrite(tempf);
      while not eof(joinf) do
        begin
          readln(joinf,s);
          if getfirstw(s)=currgroup then
            writeln(tempf,currgroup,' ',highestnum)
          else
            writeln(tempf,s);
        end;
      close(joinf);
      close(tempf);

      reset(tempf);
      rewrite(joinf);
      while not eof(tempf) do
        begin
          readln(tempf,s);
          writeln(joinf,s);
        end;
      close(tempf);
      close(joinf);

      erase(tempf);

      reset(joinf);
    end;
end;

procedure updatejoinunsubscribe;

var
  s: string;
  firstw: string;
  tempf: text;

begin
  xwritelns('Updating join file...');
  assign(tempf,temporarydir+'\'+userid);
  reset(joinf);
  rewrite(tempf);
  numjoined := 0;
  while not eof(joinf) do
    begin
      readln(joinf,s);
      firstw := getfirstw(s);
      if firstw<>currgroup then
        begin
          if numjoined<maxjoined then
            begin
              inc(numjoined);
              joinedgroups[numjoined] := firstw;
            end;
          writeln(tempf,s);
        end;
    end;
  close(joinf);
  close(tempf);

  reset(tempf);
  rewrite(joinf);
  while not eof(tempf) do
    begin
      readln(tempf,s);
      writeln(joinf,s);
    end;
  close(tempf);
  close(joinf);

  erase(tempf);

  reset(joinf);
end;

procedure addnewmailgroup;

var
  seenmailbutnotnew: boolean;
  s: string;
  firstw: string;
  tempf: text;

begin
  seenmailbutnotnew := false;
  xwritelns('Updating join file...');
  assign(tempf,temporarydir+'\'+userid);
  reset(joinf);
  rewrite(tempf);
  numjoined := 0;
  while not eof(joinf) do
    begin
      readln(joinf,s);
      firstw := getfirstw(s);

      if firstw=mailprefix then
        seenmailbutnotnew := true;

{insert the new group alphabetically in the mail groups, or after}
{the last one if it's the biggest alphabetically of them all}

      if (seenmailbutnotnew and not ismailgroup(firstw)) or
       (ismailgroup(firstw) and (firstw>newgroup)) then
        begin
          if numjoined<maxjoined then
            begin
              inc(numjoined);
              joinedgroups[numjoined] := newgroup;
            end;
          writeln(tempf,newgroup,' 0');
          seenmailbutnotnew := false;
        end;

      if numjoined<maxjoined then
        begin
          inc(numjoined);
          joinedgroups[numjoined] := firstw;
        end;
      writeln(tempf,s);
    end;

  if seenmailbutnotnew then
    begin
      if numjoined<maxjoined then
        begin
          inc(numjoined);
          joinedgroups[numjoined] := newgroup;
        end;
      writeln(tempf,newgroup,' 0');
    end;

  close(joinf);
  close(tempf);

  reset(tempf);
  rewrite(joinf);
  while not eof(tempf) do
    begin
      readln(tempf,s);
      writeln(joinf,s);
    end;
  close(tempf);
  close(joinf);

  erase(tempf);

  reset(joinf);
end;

procedure execviacomspec;

begin
  execp(comspec,'/c '+cmdline);
end;

end.
