@echo off

rem make sure the query program is present in the current directory
if exist query.com goto :all_ok
cls
echo.
echo Required files for ZSetup are missing.  Please UnZip ALL files from
echo the distribution archive and try again.  ZSetup should be run from the
echo directory where you UnZipped ZNReader to.
echo.
goto :abort

:all_ok
rem check for 4DOS and/or NDOS, and turn off NOCLOBBER if they are loaded
if not "%_4VER%" == "" setdos /N0
if not "%_NVER%" == "" setdos /N0

rem make a backup of any existing znreader.cfg
if exist .\znreader.cfg copy .\znreader.cfg .\znrcfg.bak > NUL

rem start a new file
echo. > znreader.cfg
echo # Zipnews Reader/Mailer Configuration File >> znreader.cfg
echo. >> znreader.cfg
echo # (Optional)  If specified, this is the directory which the reader will >> znreader.cfg
echo #   make the current directory for the session.  If this not specified  >> znreader.cfg
echo #   (commented out) the current directory when the reader is started will >> znreader.cfg
echo #   remain the current directory during the session. >> znreader.cfg

rem Get the home directory
cls
echo ZNReader uses a HOME directory for storing index files, message pointers,
echo and other files.  This is usually the same directory where the znr.exe
echo program is stored, but it does not have to be.  If you specify nothing here,
echo then the current directory when you start ZNReader will be the home directory.
echo Use of a HOME directory is encouraged.
echo.
echo Specify the full drive and path to this directory, omitting any trailing
echo backslash (e.g. C:\ZNR).
query Home directory: > home.bat
call .\home.bat
if not "%ask%" == "" goto :makehome
echo # home       : >> znreader.cfg
goto :nohome
:makehome
echo home       : %ask% >> znreader.cfg
:nohome
del home.bat > NUL
set homedir=%ask%
if not exist %homedir%\NUL query This directory does not exist.  Create it now? > makedir.bat
if exist .\makedir.bat call .\makedir.bat
if "%ask%" == "y" mkdir %homedir% > NUL
if "%ask%" == "Y" mkdir %homedir% > NUL
set homedir=
if exist makedir.bat del makedir.bat > NUL

echo. >> znreader.cfg
echo # The full pathname to your download directory (in which new ZipNews >> znreader.cfg
echo #   packets arrive) >> znreader.cfg

rem get the incoming directory
cls
echo.
echo ZNReader needs to know where to find INCOMING .ZNS packets.  This is usually
echo the directory where your communications program has downloaded the .ZNS
echo packet to.
echo.
echo Specify the full drive and path to this directory, omitting any trailing
echo backslash (e.g. C:\DOWNLOAD).
query Incoming directory: > incoming.bat
call .\incoming.bat
echo incoming   : %ask% >> znreader.cfg
del incoming.bat > NUL
set indir=%ask%
if not exist %indir%\NUL query This directory does not exist.  Create it now? > makedir.bat
if exist .\makedir.bat call .\makedir.bat
if "%ask%" == "y" mkdir %indir% > NUL
if "%ask%" == "Y" mkdir %indir% > NUL
set indir=
if exist makedir.bat del makedir.bat > NUL

echo. >> znreader.cfg
echo # The full pathname of a directory in which you will keep various >> znreader.cfg
echo #  packets (.ZNS files) for later reference. >> znreader.cfg

rem get the storage directory
cls
echo.
echo ZNReader can store old .ZNS packets if you wish, in a directory you specify
echo here.  Usually, this is a subdirectory of the HOME directory.  This
echo directory cannot be the same as the INCOMING or OUTGOING directories.
echo.
echo Specify the full drive and path to this directory, omitting any trailing
echo backslash (e.g. C:\ZNR\STORAGE).
query Storage directory: > storage.bat
call .\storage.bat
echo storage  : %ask% >> znreader.cfg
del storage.bat > NUL
set stordir=%ask%
if not exist %stordir%\NUL query This directory does not exist.  Create it now? > .\makedir.bat
if exist .\makedir.bat call .\makedir.bat
if "%ask%" == "y" mkdir %stordir% > NUL
if "%ask%" == "Y" mkdir %stordir% > NUL
set stordir=
if exist makedir.bat del makedir.bat > NUL

echo. >> znreader.cfg
echo # The full pathname of the directory in which follow-up and new newsgroup >> znreader.cfg
echo #   postings and outgoing mail items are stored until uploaded to the >> znreader.cfg
echo #   ZipNews Door.  This must be different directory from your "home" directory. >> znreader.cfg

rem get the outgoing directory
cls
echo.
echo When you post an article or send e-mail, ZNReader stores these new messages
echo in the OUTGOING directory until you tell it to export them to a PST packet
echo for upload to ZipNews.  This directory cannot be the same as the HOME
echo directory, or the STORAGE directory.  It is usually a subdirectory of
echo the HOME directory.
echo.
echo Specify the full drive and path to this directory, omitting any trailing
echo backslash (e.g. C:\ZNR\OUT).
query Outgoing directory: > outgoing.bat
call .\outgoing.bat
echo outgoing  : %ask% >> znreader.cfg
del outgoing.bat > NUL
set outdir=%ask%
if not exist %outdir%\NUL query This directory does not exist.  Create it now? > makedir.bat
if exist .\makedir.bat call .\makedir.bat
if "%ask%" == "y" mkdir %outdir% > NUL
if "%ask%" == "Y" mkdir %outdir% > NUL
set outdir=
if exist makedir.bat del makedir.bat > NUL

echo. >> znreader.cfg
echo # The full pathname to your upload directory (in which compressed packets >> znreader.cfg
echo #   of your news postings and sent mail, *.PST files, are stored until >> znreader.cfg
echo #   sent.  (This could be the same as your download directory.) >> znreader.cfg

rem get the upload directory
cls
echo.
echo When you export waiting articles or e-mail to a .PST packet, ZNReader will
echo create it in the UPLOAD directory.  Usually, this is the same as the
echo DOWNLOAD directory, or wherever your communucations program expects to
echo find files for uploading.
echo.
echo Specify the full drive and path to this directory, omitting any trailing
echo backslash (e.g. C:\DOWNLOAD).
query Outgoing directory: > upload.bat
call .\upload.bat
echo upload    : %ask% >> znreader.cfg
del upload.bat > NUL
set updir=%ask%
if not exist %updir%\NUL query This directory does not exist.  Create it now? > makedir.bat
if exist .\makedir.bat call .\makedir.bat
if "%ask%" == "y" mkdir %updir% > NUL
if "%ask%" == "Y" mkdir %updir% > NUL
set updir=
if exist makedir.bat del makedir.bat > NUL

echo. >> znreader.cfg
echo # The full pathname to the file name of your archival newsbase and >> znreader.cfg
echo #   associated indices are maintained.  This is where articles are sent >> znreader.cfg
echo #   when you hit the w key (Write to archive). >> znreader.cfg

rem get the newsbase directory
cls
echo.
echo ZNReader lets you keep an archival NEWSBASE of saved messages.  When you
echo use the W)rite to archive command, this directory is where the messages
echo and indices are placed.  This directory cannot be the same as the HOME,
echo STORAGE, or OUTGOING directories.  Usually it is a subdirectory of the
echo HOME directory.
echo.
echo Specify the full drive and path to this directory, omitting any trailing
echo backslash (e.g. C:\ZNR\ARCHIVE).
query Newsbase directory: > newsbase.bat
call .\newsbase.bat
echo newsbase  : %ask% >> znreader.cfg
del newsbase.bat > NUL
set arcdir=%ask%
if not exist %arcdir%\NUL query This directory does not exist.  Create it now? > makedir.bat
if exist .\makedir.bat call .\makedir.bat
if "%ask%" == "y" mkdir %arcdir% > NUL
if "%ask%" == "Y" mkdir %arcdir% > NUL
set arcdir=
if exist makedir.bat del makedir.bat > NUL

echo. >> znreader.cfg
echo # The command for invoking your file compression/archiving utility.  Use full >> znreader.cfg
echo #   pathname if the executable is NOT in your PATH OR for speed in locating. >> znreader.cfg

rem get the compress program
cls
echo.
echo ZNReader will use any of the common compression programs to pack your
echo posted messages for upload.  Enter the COMPRESS command to use here.
echo You may need to specify a full pathname to the COMPRESS program if it
echo is not on your path.  Make sure this program matches the one you have
echo selected in the ZipNews door!
query Compress program (e.g. C:\BIN\PKZIP.EXE): > compbin.bat
call .\compbin.bat
echo compress   : %ask% >> znreader.cfg
del compbin.bat > NUL

echo. >> znreader.cfg
echo # The command for your file decompression/unarchiving utility.  Use full >> znreader.cfg
echo #   pathname if the executable is NOT in your PATH OR for speed in locating. >> znreader.cfg

rem get the UNcompress program
cls
echo.
echo You also must tell ZNReader what program to use for uncompressing new
echo .ZNS packets.  Naturally, this must match the selection you made in the
echo ZipNews door.
query UNCOMPRESS program (e.g. C:\BIN\PKUNZIP.EXE): > uncompbi.bat
call .\uncompbi.bat
echo uncompress   : %ask% >> znreader.cfg
del uncompbi.bat > NUL

echo. >> znreader.cfg
echo # The full pathname of your signature file (appended to your new postings) >> znreader.cfg
echo newssig: c:\znr\newssig >> znreader.cfg
echo. >> znreader.cfg
echo # The full pathname of your mail signature file (appended to mail you write) >> znreader.cfg
echo mailsig: c:\znr\mailsig >> znreader.cfg
echo. >> znreader.cfg
echo # The command for your ASCII text editor.  Use full pathname if the executable >> znreader.cfg
echo #   is NOT in your PATH OR for speed in locating. >> znreader.cfg

rem get the editor program
cls
echo.
echo You probably want to be able to write new articles, or respond via e-mail.
echo Editors are handy for this.  Specify the editor program ZNReader is to use
echo for creating and replying to messages.
query EDITOR (e.g. C:\DOS\EDIT.COM): > znredit.bat
call .\znredit.bat
echo editor   : %ask% >> znreader.cfg
del znredit.bat > NUL

echo. >> znreader.cfg
echo # The command for your spell checker.  If enabled, this will be invoked on >> znreader.cfg
echo #  your prepared text should you hit the C (as in Checker) after leaving your >> znreader.cfg
echo #  editor.  The excellent ShareSpell (SPELL23D.ZIP) is recommended. >> znreader.cfg
echo checker  : c:\bin\spell.exe >> znreader.cfg
echo. >> znreader.cfg
echo # ReplyTo header specification.  RFC-822 compliant mailers will reference >> znreader.cfg
echo #  this header line if present, rather than the return path of your original. >> znreader.cfg
echo #  Use only if you want replies to your mail to be addressed to a site >> znreader.cfg
echo #  different from that from which you send your mail. >> znreader.cfg
echo #replyto  : other@somewhere.else.com >> znreader.cfg

echo. >> znreader.cfg
echo # Your login ID on the ZipNews Door >> znreader.cfg

rem get the user ID
cls
echo.
echo You must now tell ZNReader what your Waffle user ID is.  This MUST
echo match both the ID you login to Waffle with, and the ID that ZNReader is
echo registered to.  If you want to use more than one ID, create a new HOME
echo directory, copy your registration key file, and the query.com program to
echo the new HOME directory, and run ZSetup again.  Make sure you place the
echo directory where znr.exe is located in your PATH statement in autoexec.bat.
echo Experienced users may simply copy znreader.cfg to the new HOME directory
echo and edit it accordingly.
query USER ID (all lower case): > userid.bat
call .\userid.bat
echo username : %ask% >> znreader.cfg
del userid.bat > NUL

echo. >> znreader.cfg
echo # Name of aliases file -- a file in which you can store your nicknames for >> znreader.cfg
echo #  frequently contacted people and their full Internet addresses.  A handy >> znreader.cfg
echo #  tool to help you "remember" those long Internet addresses. >> znreader.cfg
echo aliases  : c:\znr\aliases >> znreader.cfg
echo. >> znreader.cfg
echo # Site abbreviated name, used as filename for the .ZNS and .ZUP files. >> znreader.cfg

rem get the sitename abbrev
cls
echo.
echo Finally, ZNReader needs to know the sitename (UUCP name) of the Waffle
echo system you get .ZNS packets from.  This is the same as the root filename
echo of the .ZNS packet.  For example, a packet from nlbbs.com would be named
echo NLBBS.ZNS, and the appropriate sitename would be nlbbs.
echo Again, if you want to get packets from more than one site, create a new
echo HOME directory, copy your registration key file and the query.com program
echo to the new HOME directory and run ZSetup again.
query Sitename (all lower case): > abbrev.bat
call .\abbrev.bat
echo abbrev   : %ask% >> znreader.cfg
del abbrev.bat > NUL

cls
echo.
echo ZNReader has many other customization options you can set in znreader.cfg.
echo ZSetup only configures those that are essential to correct operation.
echo You should edit znreader.cfg later and customize it with signature files,
echo color choices, spell checker, etc.
echo.
echo But for now, you should be up and running, ready to read and reply (if
echo registered) to news and e-mail.  Type "znr" in your HOME directory to
echo start.  Enjoy!
echo.

echo. >> znreader.cfg
echo # Optional color spec for the message/article screen >> znreader.cfg
echo # >> znreader.cfg
echo # Valid values for Foreground colors: >> znreader.cfg
echo # BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, GREY >> znreader.cfg
echo #   plus the following "bright" (high intensity) colors: >> znreader.cfg
echo # WHITE, YELLOW, LBLUE, LGREEN, LCYAN, LRED, LMAGENTA >> znreader.cfg
echo article_fg : lcyan >> znreader.cfg
echo. >> znreader.cfg
echo # Valid values for Background colors: >> znreader.cfg
echo # BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LGREY >> znreader.cfg
echo article_bg : blue >> znreader.cfg
echo. >> znreader.cfg
echo # Quoted article text colors >> znreader.cfg
echo article_quote_fg: yellow >> znreader.cfg
echo article_quote_bg: blue >> znreader.cfg
echo. >> znreader.cfg
echo # News directories to be scanned (Required ONLY when used in LOCAL mode >> znreader.cfg
echo #  by Waffle system operators).  All other users should delete these lines >> znreader.cfg
echo #    Note: If multiple directories, list all. Separate by space. >> znreader.cfg
echo # news : d:\news d:\waffle\local >> znreader.cfg

:abort
