Program Today_Change;

{$M 8192,0,0}

Uses Dos;

Const
  Months : Array [1..12] of String[3] =
             ('JAN','FEB','MAR','APR','MAY','JUN',
              'JUL','AUG','SEP','OCT','NOV','DEC');

Var
  Year,
  Month,
  Last_Month,
  Day,
  Day_of_Week : Word;
  Mon_S,
  L_Mon_S     : String[3];
  Path_to_ZIP : String;

Procedure Usage;

Begin

  Writeln ('USAGE : Todaychg <path to TODAY???.ZIP files>');
  Writeln;
  Halt (1);

End;

Procedure Get_Month;

Begin

  GetDate(Year,Month,Day,Day_of_Week);
  If Month=1 Then Last_Month := 12 Else Last_Month := Month - 1;
  Mon_S := Months[Month];
  L_Mon_S := Months[Last_Month];

End;

Procedure Unzip_this_Month;

Begin

  SwapVectors;
  Exec(GetEnv('COMSPEC'),'/C'+'PKUNZIP '+Path_to_ZIP+'TODAY'+Mon_S+' TODAY.'+Mon_S);
  SwapVectors;

End;

Procedure Delete_last_Month;

Begin

  SwapVectors;
  Exec(GetEnv('COMSPEC'),'/C'+'Del TODAY.'+L_Mon_S);
  SwapVectors;

End;

{ *** Main Program *** }

Begin

  If ParamCount <> 1 Then Usage;
  Path_to_ZIP := ParamStr(1);
  Get_Month;
  If Day=1 Then Begin
    Unzip_this_Month;
    Delete_last_Month;
  End;

End.