;
; ZSET.CMD by Prof. Timo Salmi, ts@chyde.uwasa.fi, Sun 18-Feb-90
; A script to set MsKermit to use z-modem file transfers
;
; It also makes easy calling the kermit transfer scripts defined
; in getbin.cmd, gettext.cmd, getvtext.cmd, putbin.cmd, puttext.cmd,
; and putvtext.cmd
;
; First run this script using "take zset.cmd" at the MsKermit prompt
; Then you have at your disposal the new commands defined below
;
; Adapt the paths and ports as appropriate
; To utilize this script fully you need DSZ.COM by Omen Technology Inc.
; And you must have a basic understanding of z-modem file transfer
; I recommend that you get version dsz1019.zip for z-modem transfers

; Invoking z-modem for a fixed connection
; Remember to adapt the paths and ports as appropriate for your configuration

define releasez define \%1,define \%2,define \%3, define \%4, define \%5
define beep3 echo \7\7\7

define zdnd run c:\telec\pcplus\dsz CON port 2 d rz f:,beep3
define zupd run c:\telec\pcplus\dsz CON port 2 d sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

; Invoking z-modem for a modem connection
define zdn run dsz CON port 1 rz f:,beep3
define zup run dsz CON port 1 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

; Define synonyms for Kermit uploads and downloads
define getbin   take getbin.cmd
define gettext  take gettext.cmd
define getvtext take getvtext.cmd
define putbin   take putbin.cmd
define puttext  take puttext.cmd
define putvtext take putvtext.cmd

; For invoking an editor, SemWare's QEdit in this case
; You may have a different editor, adapt accordingly
define edit run qed \%1,define \%1

; For invoking MsKermit autodialing from own.cll. You have to build
; own.cll (or whatever) yourself. See sample.cll for the format.
define phone take own.cll

echo \13zset.cmd file transfer command abbreviations ready\13
echo New commands include:\13
echo \13  getbin, gettext, getvtext, putbin, puttext, putvtext\13
echo \13  zdn, zup, zdnd, zupd, edit, phone\13
