// MSGOBJAD.CPP: module to handle fidonet addresses

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "msgobj.h"

int address_class::parse_uucp(char *buff,char*id,char*in)
{
  char *z,*z2;
  z=strstr(buff,in);
  if(z)
    {
      z+=strlen(in); z2=uucp;
      while(*z>32)
        *(z2++)=*(z++);
      *z2=0; z2=id;
      while(*z && *z!=10 && *z!=13 && *z!='(')
        z++;
      if(*z=='(')
        {
          z++;
          while(*z && *z!=10 && *z!=13 && *z!=')')
            *(z2++)=*(z++);
          *z2=0;
        }
      return 0;
    }
  return 1;
}

int address_class::parse(char*s)
{
  char *z,*z2;
  zone=net=node=point=*domain=0;
  *uucp=0;
  if(*s)
    {
      if(isdigit(*s))
        {
          if((z2=strchr(s,':'))!=NULL)
            {
              zone=atoi(s);
              z2++;
            }
          if((z=strchr(z2,'/'))!=NULL)
            {
              net=atoi(z2);
              z2=z+1;
            }
          else
            return -1;
          if(isdigit(*z2))
            node=atoi(z2);
          else
            return -1;
          if((z=strchr(z2,'.'))!=NULL)
            point=atoi(z+1);
          else
            point=0;
          if((z=strchr(z,'@'))!=NULL)
            {
              z2=z+1;
              z=domain;
              while(*z2 && *z2!=')' && *z2!=13 && *z2!=10 && *(unsigned char*)z2!=141)
                *z++=*z2++;
              *z=0;
            }
        }
      else
        strcpy(uucp,s);
      return 0;
    }
  return 1;
}

int address_class::pack(char*s)
{
  char t[30];
  if(*uucp)
    sprintf(s,"%s",uucp);
  else
    {
      if(!zone && !net && !node)
        return -1;
      if(zone)
        sprintf(s,"%d:",zone);
      else
        *s=0;
      sprintf(t,"%d/%d.%d",net,node,point);
      strcat(s,t);
      if(*domain)
        {
          strcat(s,"@");
          strcat(s,domain);
        }
    }
  return 0;
}

address_class::address_class(void)
{
  zone=net=node=point=*domain=*uucp=0;
}

address_class::~address_class(void)
{
}
