// MSGOBJDT.CPP: module to handle date and time in fidonet format

#include <ctype.h>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "msgobj.h"

#ifndef PIPVARS
  static char *mname[12]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
#endif

int date_time_class::parse(char*s)
{
  int i;
  char smonth[6];
  #ifdef DEBUG
    cout << "Parsing date " << s << "\n";
  #endif
  sscanf(s,"%d %s %d %d:%d:%d",&day,smonth,&year,&hour,&minutes,&seconds);
  month=0;
  for (i=0; i!=12; i++) if (!stricmp(smonth,mname[i])) month=i+1;
  return (month!=0);
}

int date_time_class::pack(char*s)
{
  if(month==0) return -1;
  sprintf(s,"%02d %3s %02d  %02d:%02d:%02d",day,mname[month-1],year%100,hour,minutes,seconds);
  return 0;
}

date_time_class::date_time_class(void)
{
  day=month=year=hour=minutes=seconds=0;
}

date_time_class::~date_time_class(void)
{
}
