// MsgObjPi.CPP procedures to handle PIP compressed strings (type 10 messages)

#include <fcntl.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "msgobj.h"

char *pip[128]={ // decompression table
"PREFIX","SEEN-BY: ","MSGID: ","PATH: ",": ",
"zion","ment","---","che","chi","ghe","ghi","str","","il","al","ed",
"pr","st","..","  ",", ",". ","; ","++",
"a'","e'","i'","o'","u'","a ","e ",
"i ","o ","u ","nt","hi",
"bb","ba","be","bi","bo","bu",
"cc","ca","ce","ci","co","cu",
"dd","da","de","di","do","du",
"ff","fa","fe","fi","fo","fu",
"gg","ga","ge","gi","go","gu",
"ll","la","le","li","lo","lu",
"mm","ma","me","mi","mo","mu",
"nn","na","ne","ni","no","nu",
"pp","pa","pe","pi","po","pu",
"rr","ra","re","ri","ro","ru",
"ss","sa","se","si","so","su",
"tt","ta","te","ti","to","tu",
"vv","va","ve","vi","vo","vu",
"zz","za","ze","zi","zo","zu",
"==",":-","' ","ha","ho","qu","#"};



// compression table for Pip compressor

// >0: best; len=2
// 0: no compression
// -1: special handling

char piptable[26][26]=
// a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z 
{{ 0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  38, 37,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 42,  0,  0,  0,  0,  0},
{  44,  0, 43,  0, 45,  0,  0, -1, 46,  0,  0,  0,  0,  0, 47,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0},
{  50,  0,  0, 49, 51,  0,  0,  0, 52,  0,  0,  0,  0,  0, 53,  0,  0,  0,  0,  0, 54,  0,  0,  0,  0,  0},
{  0 ,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  56,  0,  0,  0, 57, 55,  0,  0, 58,  0,  0,  0,  0,  0, 59,  0,  0,  0,  0,  0, 60,  0,  0,  0,  0,  0},
{  62,  0,  0,  0, 63,  0, 61, -1, 64,  0,  0,  0,  0,  0, 65,  0,  0,  0,  0,  0, 66,  0,  0,  0,  0,  0},
{ 124,  0,  0,  0,  0,  0,  0,  0, 36,  0,  0,  0,  0,  0,125,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  68,  0,  0,  0, 69,  0,  0,  0, 70,  0,  0, 67,  0,  0, 71,  0,  0,  0,  0,  0, 72,  0,  0,  0,  0,  0},
{  74,  0,  0,  0, -1,  0,  0,  0, 76,  0,  0,  0, 73,  0, 77,  0,  0,  0,  0,  0, 78,  0,  0,  0,  0,  0},
{  80,  0,  0,  0, 81,  0,  0,  0, 82,  0,  0,  0,  0, 79, 83,  0,  0,  0,  0, 35, 84,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,  0,  0, 89, 85,  0,  0,  0,  0, 90,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,126,  0,  0,  0,  0,  0},
{  92,  0,  0,  0, 93,  0,  0,  0, 94,  0,  0,  0,  0,  0, 95,  0,  0, 91,  0,  0, 96,  0,  0,  0,  0,  0},
{  98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,  0,  0,101,  0,  0,  0, 97, -1,102,  0,  0,  0,  0,  0},
{ 104,  0,  0,  0,105,  0,  0,  0,106,  0,  0,  0,  0,  0,107,  0,  0,  0,  0,103,108,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{ 110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,  0,  0,113,  0,  0,  0,  0,  0,114,109,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{  0 ,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
{ 116,  0,  0,  0,117,  0,  0,  0, -1,  0,  0,  0,  0,  0,119,  0,  0,  0,  0,  0,120,  0,  0,  0,  0,115}};


void message_frame::pipstring(unsigned char huge*s,int f)
{
  register int best;
  char l,k;
  unsigned char b[2],z;
  *b=128;
  while (*s)
    {
      if (*s==10)
        s++;
      else
        {
          best=127; l=1;
          if(*s>96 && *s<123)
            {
              if(*(s+1)>96 && *(s+1)<123)
                {
                  if((k=piptable[*s-'a'][*(s+1)-'a'])!=0)
                    {
                      if (k==-1) // special multi-letter compression
                        {
                          switch(*s)
                            {
                              case 'c': switch(*(s+1)) {
                                          case 'h': if (*(s+2)=='i') {best=9; l=3;} else if (*(s+2)=='e') {best=8; l=3;}; break;
                                        } break;
                              case 'g': switch(*(s+1)) {
                                          case 'h': if (*(s+2)=='i') {best=11; l=3;} else if (*(s+2)=='e') {best=10; l=3;}; break;
                                        } break;
                              case 'm': switch(*(s+1)) {
                                          case 'e': if((*(s+2)=='n') && (*(s+3)=='t')) {best=6; l=4;} else {best=75; l=2;} break;
                                        } break;
                              case 's': switch(*(s+1)) {
                                          case 't': best=18; l=2; if (*(s+2)=='r') {best=12; l=3;} break;
                                        } break;
                              case 'z': switch(*(s+1)) {
                                          case 'i': best=118; l=2; if ((*(s+2)=='o') && (*(s+3)=='n')) {best=5; l=4;} break;
                                        } break;
                            }
                        }
                      else
                        { // normal multiletter compression
                          best=k; l=2;
                        }
                    }
                }
              else
                { // special letter+symbol compression
                  switch(*s)
                    {
                      case 'a': switch(*(s+1)) {
                                  case ' ': best=30; l=2; break;
                                  case '\'': best=25; l=2; break;} break;
                      case 'e': switch(*(s+1)) {
                                  case ' ': best=31; l=2; break;
                                  case 'd': best=16; l=2; break;
                                  case '\'': best=26; l=2; break;} break;
                      case 'i': switch(*(s+1)) {
                                  case ' ': best=32; l=2; break;
                                  case 'l': best=14; l=2; break;
                                  case '\'': best=27; l=2; break;} break;
                      case 'o': switch(*(s+1)) {
                                  case ' ': best=33; l=2; break;
                                  case '\'': best=28; l=2; break;} break;
                      case 'u': switch(*(s+1)) {
                                  case ' ': best=34; l=2; break;
                                  case '\'': best=29; l=2; break;} break;
                    }
                }
            }
          else
            switch(*s)
              {
                case ' ': if (*(s+1)==' ') {best=20; l=2;} break;
                case '-':if ((*(s+1)=='-') && (*(s+2)=='-')) {best=7; l=3;} break;
                case '\'': if (*(s+1)==' ') {best=123; l=2;} break;
                case '+': if (*(s+1)=='+') {best=24; l=2;} break;
                case ';': if (*(s+1)==' ') {best=23; l=2;} break;
                case ',': if (*(s+1)==' ') {best=21; l=2;} break;
                case '=': if (*(s+1)=='=') {best=121; l=2;} break;
                case ':': switch(*(s+1)) {
                            case '-': best=122; l=2; break;
                            case ' ': best=4; l=2; break;} break;
                case '.': switch(*(s+1)) {
                            case '.': best=19; l=2; break;
                            case ' ': best=22; l=2; break;} break;
                case 'M':if ((*(s+1)=='S') &&
                             (*(s+2)=='G') &&
                             (*(s+3)=='I') &&
                             (*(s+4)=='D') &&
                             (*(s+5)==':') &&
                             (*(s+6)==' ')) {best=2; l=7;} break;
                case 'P':if ((*(s+1)=='A') &&
                             (*(s+2)=='T') &&
                             (*(s+3)=='H') &&
                             (*(s+4)==':') &&
                             (*(s+5)==' ')) {best=3; l=6;} break;
                case 'S':if ((*(s+1)=='E') &&
                             (*(s+2)=='E') &&
                             (*(s+3)=='N') &&
                             (*(s+4)=='-') &&
                             (*(s+5)=='B') &&
                             (*(s+6)=='Y') &&
                             (*(s+7)==':') &&
                             (*(s+8)==' ')) {best=1; l=9;} break;
              }
          if (best==127)
            {if ((*s<128) || (*s==141)) write(f,s,1); else {b[1]=*s-127; write(f,b,2);} s++;}
          else
            {z=128+best; write(f,&z,1); s+=l;}
        }
    }
  write(f,"",1);
}


void message_frame::unpipstring(char cr,unsigned char huge*s,int f)
{
  unsigned char t;
  char *p;
  while (*s)
    {
      if (*s!=10)
        {
          if ((*s==141) || (*s==13)) *s=cr;
          if (*s<128)
            write(f,s,1);
          else
            {
              if (*s==128)
                {s++; t=(*s)+127; write(f,&t,1);}
              else
                write(f,p=pip[*s-128],strlen(p));
            }
        }
      s++;
    }
}


void message_frame::unpipfile(unsigned char huge*s,int f)
{
  char *t;
  while(::read(f,s,1),*s!=0)
    {
      if (*s>128)
        {
          t=pip[*s-128];
          while (*t) {*s=*t; s++; t++;}
          *s=0; s--;
        }
      else
        if (*s==128)
          {
            ::read(f,s,1);
            *s+=127;
          }
      s++;
    }
}


int message_frame::read0(unsigned char huge*s, int f,unsigned int mxlen,char truncate)
{
  while (mxlen && (::read(f,s,1),*s) && !eof(f)) {s++; mxlen--;}
  if(*s==0) return 0;
  *s=0;
  if(truncate)
    while ((::read(f,s,1),*s) && !eof(f));
  return -1;
}


int message_frame::readfile(unsigned char huge*s,char *fn)
{
  int f;
  #ifdef __WINDOWS__
    if ((f=OpenFile(fn,O_RDONLY|O_BINARY|O_DENYWRITE))==-1) return -1;
  #else
    if ((f=open(fn,O_RDONLY|O_BINARY|O_DENYWRITE))==-1) return -1;
  #endif
  while (!eof(f)) {::read(f,s,1); if (*s!=10) s++;}
  s--; /* to skip last *s, that is a EOF */
  if (*(s-1)==26)
    {*(s-1)=13; *s=0;}
  else
    {*s=13; *(s+1)=0;}
  return(close(f));
}


void message_frame::write0(unsigned char huge*s,int f)
{
  write(f,s,strlen((char huge*)s)+1);
}


void message_frame::writemex(unsigned char huge*s,int f,char ctrl_a)
{
  unsigned char b;
  while (*s) 
    {
      b=((*s&127)==13)?'\n':((*s==1)?ctrl_a:*s);
      write(f,&b,1);
      s++;
    }
}


char huge*message_frame::find_origin(char huge*msg)
{
  char huge*s1=msg,huge*s2=NULL,huge*s3;
  while((s3=strstr(s1," * Origin:"))!=NULL)
    {
      s1=s3+1;
      if((*(s3-1)==13) || (*(s3-1)==10) || ((unsigned char)(*(s3-1))==141))
        s2=s3;
    }
  return s2;
}

