
code    segment

        assume cs:code;ds:code
        org     100h

begin:  jmp     start

comx    equ     03f9h                   ;IER register for COM1:
                                        ;   Use 02f9h for COM2:

file    db      'C:\COMMAND.COM',0      ;Drive & path to COMMAND.COM

env_str dw      ?
        dw      80h                     ;PSP parameters
pt1     dw      ?
        dw      5ch
pt2     dw      ?
        dw      6ch
pt3     dw      ?

start:

        mov al,00h                      ; Zap modem IER register with 00h
        mov dx,comx                     ; to disable UART interrupts
        out dx,al                       ; before calling COMMAND.COM

        push    cs
        pop     es
        call    find_endfile            ; Find end of code
        mov     cl,4
        sar     bx,cl
        inc     bx
        mov     ah,4ah                  ; Shrink memory to minimum needed
        int     21h
        jc      error

;------build param block the way DOS EXEC (4Bh) call wants it

        mov     si,2ch
        mov     ax,word ptr si
        mov     env_str,ax
        push    cs
        pop     ax
        mov     pt1,ax                  ; Pass parameters, if any
        mov     pt2,ax
        mov     pt3,ax
        mov     bx,offset env_str
        mov     dx,offset file

        mov     ax,4b00h                ; Call COMMAND.COM
        int     21h
        pushf

        mov al,01h                      ; Zap modem IER register with 01h
        mov dx,comx                     ; to enable UART interrupts
        out dx,al                       ; before returnning to PROCOMM

        popf
        jc      error                   ;In case something goes wrong
        mov     ax,4c00h                ;No problem, reset carry & return
        int     21h

error:
        mov     ax,4cffh                ;Return with carry set
        int     21h

FIND_ENDFILE:
        CALL    HERE
HERE:   POP     BX
        ADD     BX,6
        RET

code    ends
        end     begin
