;*************************************************************************
;* FASTCOMM.ASP (C) 1987 DATASTORM TECHNOLOGIES, INC.                    *
;*                                                                       *
;* An ASPECT script file for initializing the FastComm 2496/Turbo modem  *
;* for proper use with PROCOMM PLUS.                                     *
;*                                                                       *
;*************************************************************************

CLEAR
LOCATE 0 0
SOUND 440 50
SOUND 880 50
BOX 0 0 4 46 14
ATSAY 2 2 14 "FastComm 2496/Turbo modem initialization..."
LOCATE 6 0

SET BAUDRATE 1200                         ;Set up comm line
SET PARITY NONE
SET DATABITS 8
SET STOPBITS 1

TRANSMIT "AT^M"                           ;Get modem's attention
PAUSE 2

TRANSMIT "ATZ^M"                          ;Resets non-volatile mem
PAUSE 1
TRANSMIT "AT#F^M"                         ;Get factory defaults
TRANSMIT "AT#E^M"                         ;Erase non-volatile mem
TRANSMIT "ATE0^M"                         ;Set modem ECHO off for now
TRANSMIT "AT#CL2^M"                       ;2400 baud FASTSNAP(tm)
TRANSMIT "AT#CH1^M"                       ;9600 baud FASTSNAP(tm)
TRANSMIT "AT#CW^M"                        ;Write FASTSNAP(tm) mem
TRANSMIT "AT#LCN^M"                       ;Normal CD (not forced on)
TRANSMIT "AT#LDN^M"                       ;Normal DTR (not forced on)
TRANSMIT "ATS0=0^M"                       ;Set auto answer off
TRANSMIT "ATS2=43^M"                      ;ESCAPE char = '+'
TRANSMIT "ATS6=1^M"                       ;Wait 1 second for dial tone
TRANSMIT "ATS7=255^M"                     ;Wait for connect time
TRANSMIT "ATS10=10^M"                     ;Lost CARRIER delay
TRANSMIT "ATS11=6^M"                      ;Dialing speed
TRANSMIT "ATS22=54^M"                     ;Set DTR,CD,RTS,Xon/Xoff
TRANSMIT "ATS49=6^M"                      ;Burst Timeout for L/D
TRANSMIT "ATS57=0^M"                      ;Normal hangup with DTR drop
TRANSMIT "ATS58=0^M"                      ;Enable TURBO (19.2)
TRANSMIT "ATS16=128^M"                    ;Set High Reg for access...
TRANSMIT "ATS177=224^M"                   ;Set X/off to 256
TRANSMIT "ATS178=192^M"                   ;Set X/on to 128
TRANSMIT "ATS16=0^M"                      ;Set High Reg Normal
TRANSMIT "ATB3^M"                         ;Enable binary transfers
TRANSMIT "ATM1^M"                         ;Speaker on during dial
TRANSMIT "ATQ0^M"                         ;Disable 'quiet' mode
TRANSMIT "ATX2^M"                         ;Full return codes
TRANSMIT "ATV1^M"                         ;Enable 'word' results
TRANSMIT "ATE1^M"                         ;Set modem ECHO on
TRANSMIT "AT#W^M"                         ;Save to non-volatile mem
PAUSE 2
TRANSMIT "ATZ^M"                          ;Reset to new settings
PAUSE 2

SET BAUDRATE 9600                         ;Reset comm line

TRANSMIT "AT^M"                           ;Get modem's attention
PAUSE 2
TRANSMIT "AT^M"                           ;Get modem's attention

CLEAR
LOCATE 0 0
SOUND 440 50
SOUND 880 50
BOX 0 0 10 56 14
ATSAY 2 2 14 "FastComm 2496/Turbo modem initialization - COMPLETED!"
ATSAY 4 2 14 "Your FastComm modem will now power up with the proper"
ATSAY 5 2 14 "defaults for PROCOMM PLUS.  You should now use the"
ATSAY 6 2 14 "Setup Facility (Alt-S) MODEM OPTIONS to clear out the"
ATSAY 7 2 14 "INITIALIZATION COMMAND and to change the DIALING"
ATSAY 8 2 14 "COMMAND to `"AT^M~~~~ATDT`" (do not include the qoutes)."
LOCATE 12 0

