;*************************************************************************
;* TEF.ASP  (C) 1987 DATASTORM TECHNOLOGIES, INC.                        *
;*                                                                       *
;* A sample ASPECT script file for PROCOMM PLUS to demonstrate simple    *
;* time and string handling functions, as well as general ASPECT         *
;* commands and structure                                                *
;*                                                                       *
;*************************************************************************
;
; Clear the screen and paint the initial window. (A color monitor is
; assumed.)
;
   CLEAR 30                                     ; clear the screen
   CUROFF                                       ; turn off cursor
   BOX 0 0 23 79 30                             ; draw a box
   ATSAY 1 32 30 ">>> TEF.ASP <<<"
   ATSAY 2 20 31 "A sample command file for timed execution"
   ATSAY 22 15 30 "Copyright (C) 1987 DATASTORM TECHNOLOGIES, INC."
   ATSAY 6 5 31 ".ASP file to execute:"
   ATSAY 8 10 31 "Time to execute:       (HH:MM in 24 hour format) "

;
; prompt for filename to execute
;
GETCMD:
   ATGET 6 27 113 12 S0                         ; get the filename
   ISFILE S0                                    ; does it exist ?
   IF FAILURE                                   ; if not, add extension
      STRCAT S0 ".ASP"                          ; and look some more
      ISFILE S0
      IF FAILURE                                ; if still not found
         SOUND 200 50                           ; beep, error msg and
         ATSAY 6 40 32 "** File not found **"   ; try again
         PAUSE 2
         SCROLL 0 6 40 6 59 31                  ; clear error message
         GOTO GETCMD
      ENDIF
   ENDIF

;
; prompt for time to execute
;
GETTIME:                                        ; got the file, get the time
   ATGET 8 27 113 5 S1
   FIND S1 ":"                                  ; check for a colon
   IF NOT FOUND                                 ; it's a cludgey error check
      SOUND 200 50                              ; but what the heck
      ATSAY 8 59 32 "** Invalid time **"
      PAUSE 2
      SCROLL 0 8 59 8 76 31                     ; clear error message
      GOTO GETTIME
   ENDIF

;
; Display the waiting prompts
;
   CLEAR 30
   ATSAY 0 0 31 ">>> TEF.ASP <<<            (C) 1987 DATASTORM TECHNOLOGIES, INC."
   ASSIGN S8 "File: "
   STRCAT S8 S0
   STRCAT S8 " will execute at "
   STRCAT S8 S1
   ATSAY 2 0 31 S8
   STRCAT S1 ":"
   ATSAY 3 0 31 "The current time is:"

;
; Wait until specified time
;
SITITOUT:
   TIME S9 1                                    ; get the time
   ATSAY 3 22 31 S9                             ; display it
   FIND S9 S1                                   ; compare for match
   IF NOT FOUND                                 ; not found ?
      GOTO SITITOUT                             ; wait some more
   ENDIF

;
; Call and execute named ASPECT file
;
   CLEAR 30                                     ; clear the screen
   EXECUTE S0                                   ; call the specified file
