;  Get CIS STOCK STATISTICS, version 0.4
;     by Jim Robeson
;     2-24-92
;
;  - Modify all lines containing "<==="
;  - Requires a file named STOCKS.CFG containing stock names
;    (1 per line)
;
PROC MAIN
;                         **** INITIALIZE LOG FILE ****
LOG CLOSE                       ; Close any open log file
LOG OPEN "C:\AI\STOCKS.DLY"     ; <=== the named log file
LOG SUSPEND                     ; Immediatly idle it til we need it
;
;                         **** START UP STOCKS.CFG FILE ****
STRING STOCK
SET FGETS_CRLF OFF
FOPEN 0 "STOCKS.CFG" "RT"        ; Enable stock file
IF NOT SUCCESS
  ASSIGN S1 "(1) CAN'T OPEN THE STOCKS.CFG FILE"
  GOTO PROBLEM
  ENDIF
FGETS 0 STOCK                   ; Read in first STOCK var
IF NOT SUCCESS
  ASSIGN S1 "(2) ERROR READING STOCKS.CFG FILE "
  GOTO PROBLEM
  ENDIF
IF EOF 0
  ASSIGN S1 "(3) FOUND AN EMPTY STOCKS.CFG FILE"
  GOTO PROBLEM
  ENDIF
;
;                         **** DIAL CIS AND LOG ON ****
TRYAGAIN:
  IF NOT FROMDDIR               ; Handle coming in from BATch call
    DIAL "100"                  ; <=== dialing directory entry number
    ENDIF
PAUSE 1
TRANSMIT "^M"
WAITFOR "Host Name:" 5          ; wait 5 seconds, else try again
  IF NOT WAITFOR
    HANGUP
    GOTO TRYAGAIN
    ENDIF
PAUSE 1
TRANSMIT "cis^M"
WAITFOR "User ID:" 5
  IF NOT WAITFOR
    HANGUP
    GOTO TRYAGAIN
    ENDIF
PAUSE 1
TRANSMIT "xxxxxxxxxx^M"         ; <=== your User ID
WAITFOR "Password:"
PAUSE 1
TRANSMIT "xxxxxxxxxx^M"         ; <=== your password
WAITFOR " !"                    ; "Enter choice !" or "Enter choice number !"
PAUSE 1
TRANSMIT "go basicquotes^M"
;                         **** DO AT LEAST ONE TIME ****
WAITFOR "Issue:"
PAUSE 1
TRANSMIT STOCK                  ; send FIRST stock name
TRANSMIT "^M"
  WAITFOR "------^M^J"          ; 1st time must have CR & LF
  LOG RESUME                    ; or will have a leading blank line
  WAITFOR "^M"                  ; in the output file
  LOG SUSPEND
  WAITFOR "Issue:"
;                         **** LOOP THROUGH THE REST ****
CYCLE:
FGETS 0 STOCK                   ; Read in next STOCK var
IF NOT SUCCESS
  ASSIGN S1 "(4) ERROR READING STOCKS.CFG FILE "
  ERRORMSG S1
  GOTO DONE
  ENDIF
IF EOF 0                        ; quit CIS when file empty
  GOTO DONE
  ENDIF
PAUSE 1
TRANSMIT STOCK                  ; send next stock name
TRANSMIT "^M"
  WAITFOR "------^M"
  LOG RESUME
  WAITFOR "^M"
  LOG SUSPEND
  WAITFOR "Issue:"
GOTO CYCLE
;                         **** ALL DONE, SHUT HER DOWN ****
DONE:
LOG CLOSE                       ; Close the log entirely for today
   PAUSE 1
   TRANSMIT "/exit^M"
   WAITFOR "Enter choice !"
   PAUSE 1
   TRANSMIT "off^M"
   WAITFOR "Host Name:"
IF NOT NULL S1
  GOTO PROBLEM
  ENDIF
USERMSG "FINIS"
QUIT                            ; Hang up telephone & exit ProComm
;                         **** ABORTING, TELL BATCH FILE ABOUT IT ****
PROBLEM:
LOG CLOSE
ERRORMSG S1
FOPEN 1 "C:\AI\STOCKS.ERR" "WT"        ; Enable error file
FWRITE 1 S1 34
FPUTC 1 10
FCLOSE 1
QUIT
ENDPROC
