/*  PPSTOCK v1.1  by Jim Robeson    copyright (c) 1992
 *  Read the file found in (arg-1),
 *     insert comma-delimited values into the data,
 *  then copy whatever to the file in (arg-2).
 */

#include <stdio.h>
#include <string.h>
#define TRUE 1
#define FALSE 0
#define FLDCNT 7

  FILE *infile;                    /* the IN file */
  FILE *outfile;                   /* the OUT file */
  char inbuf[BUFSIZ];              /* line buffer for reading from file */
  char outbuf[BUFSIZ];             /* line buffer for output            */
                                   /* BUFSIZ = 512 in stdio.h */
static char vartab[2][FLDCNT] = {
   {25,  8, 10, 10,  9,  8,  7},                        /* length    */
   {2,   1,  1,  1,  1,  1,  2},                        /* char/numr */
                                                        /*  2    1   */
 };
/* ------------------------------------------------------------------ */
main(int argc, char *argv[])              /* main reads command args  */
{
  char *progname;
  char *filein;
  char *fileout;
  int linecnt;
  int ipt,opt;            /* index pointers */
  int fldi, len, frm;
  int first_time;
  int i;

/* ------------------------------------------------------------------ */
/*  Display a little how-to "help" if arguments are null or improper  */

  if (argc != 3)                /*  should be 2 args */
    {
    printf("\nPPSTOCK v1.1:  A File Copy Program,");
    printf("  by Jim Robeson,  compiled 2-24-92.\n\n");
    printf("This program copies one file to another, inserting\n");
    printf("comma-delimited controls between selected fields.\n");
    printf("File names must be entered on the command line:\n\n");
    printf("PPSTOCK drv:\path\in-file-name drv:\path\out-file-name \n\n");
    exit (1);                              /* exit with errorlevel=1 */
    }

  progname = argv[0];
  filein   = argv[1];
  fileout  = argv[2];

/* ------------------------------------------------------------------ */
  infile = fopen(filein,"r");          /* open the input file */
  if (infile == NULL)
    {
    fprintf(stderr,"\n\007%s can't open the INPUT file: %s.\n",progname,filein);
    exit (1);
    }

  outfile = fopen(fileout,"w");          /* open the output file */
  if (outfile == NULL)
    {
    fprintf(stderr,"\n\007%s can't open the OUTPUT file: %s.\n",progname,fileout);
    exit (1);
    }

/* ------------------------------------------------------------------ */
linecnt = 0;
printf ("%4d records processed.\r",linecnt);
while ( fgets(inbuf,BUFSIZ,infile) != NULL )  /* read it */
 { /* READ PROCESSING */

   first_time = 0;
   ipt=0;
   opt=0;

   for (fldi = 1; fldi <= FLDCNT; fldi++)
    { /* FIELD PROCESSING */
      len = vartab[0][fldi-1];
      frm = vartab[1][fldi-1];

      /* FOR THE OUTPUT SIDE: */
      if (first_time == 1)           /* 1 = all but the first */
          { outbuf[opt] = ',';       /* put trailer ',' first */
            opt++;
            if (frm == 2) { outbuf[opt] = '"';
                            opt++;
                          }
          }
      else
          { first_time = 1;        /* only one time, the first. */
            if (frm == 2) { outbuf[opt] = '"';
                            opt++;
                          }
          }

      for (i=0;   (i < len) && !( (inbuf[ipt] == '\0') || (inbuf[ipt] == '\n') )  ; i++)
         { outbuf[opt] = inbuf[ipt];
           opt++;
           ipt++;
         }
      if (frm == 2) { outbuf[opt] = '"';
                      opt++;
                    }
      if ( inbuf[ipt] == '\0' ) ipt = ipt - 1;

    } /* FIELD PROCESSING loop */

 here:

    outbuf[opt] = '\n';
    opt++;
    outbuf[opt] = '\0';

    linecnt++;
    fprintf(outfile,"%s",outbuf);
    printf ("%4d\r",linecnt);


 } /* READ PROCESSING loop */

/* ------------------------------------------------------------------ */

  fclose(infile);
  fclose(outfile);

  printf ("%4d\n",linecnt);

  exit (0);                      /* job done, get out, errorvalue = 0 */
}

/*------------- End of PPSTOCK.C ------------------------------------*/
