;
; OPUS.ASP
; A script file by Timo Salmi to call Finnish Opus bulletin boards
;
; Chapters 4 and 8 of Procomm Plus User's Manual contain more information
; about the script command language for automating communications
;

IF NOT LINKED             ;if the call is not made through dialiang directory
  CLEAR                   ;clear the screen
  EMULATE ANSI
  MESSAGE "Dialing Opus"  ;put the relevant bulletin board name here
  MDIAL "999999"          ;put the relevant number here to dial it
ENDIF

ASSIGN S0 "Failed to encounter "  ;first part of the error message string

ASSIGN S1 "Node 515/xx"   ;put the relevant Node number in xx
WAITFOR S1                ;have we connected to the correct bulletin board
PAUSE 1
IF NOT WAITFOR            ;if failed to entounter "Node 515/xx" then
  GOTO VIRHE              ;  goto the error routine
ENDIF

SET TRANSLATE ON          ;set the (Scandinavian) translation table on
SET BACKSPACE DEST        ;set the backspace to delete text

ASSIGN S1 "your FIRST name:"   ;you may have to replace this with "etunimesi"
WAITFOR S1 45             ;wait for 45 seconds to encounter "your FIRST name"
PAUSE 1
IF NOT WAITFOR            ;if failed to encounter "your FIRST name" then
  GOTO VIRHE              ;  goto the error routine
ENDIF
TRANSMIT "Matti^M"        ;put your first name here

ASSIGN S1 "your LAST name:"   ;you may have to replace this with "sukunimesi"
WAITFOR S1                ;wait for 30 seconds to encounter "your LAST name"
PAUSE 1
IF NOT WAITFOR            ;if failed to encounter "your LAST name" then
  GOTO VIRHE              ;  goto the error routine
ENDIF
TRANSMIT "Meikalainen^M"  ;put your last name here

ASSIGN S1 "^JMatti Meikalainen"  ;use ^J to ensure that your name was
WAITFOR S1                       ;received correctly
PAUSE 1
IF NOT WAITFOR            ;if failed to encounter "^JMatti Meikalainen" then
  SUBSTR S1 S1 2 10       ;  omit linefeed ^J from the error message
  GOTO VIRHE              ;  goto the error routine
ENDIF
TRANSMIT "^M"             ;transmit carriage return

ASSIGN S1 "Password: "    ;you may have to replace this with the relevant
WAITFOR S1                ;Finnish word
PAUSE 1
IF NOT WAITFOR            ;if failed to encounter "Password: " then
  GOTO VIRHE              ;  goto the error routine
ENDIF
TRANSMIT "salainen^M"     ;put your password here

ALARM 3                   ;sound the alarm for three seconds
EXIT                      ;exit the script file

VIRHE:                    ;the error routine
STRCAT S0 S1              ;build up the error message
MESSAGE S0                ;write the error message to the screen
SOUND 440 100             ;sound a different alarm
SOUND 350 100
SOUND 440 100
SOUND 350 100