echo off
rem ZMOD-U.BAT
rem
rem                  Osborne 06AT harddisk version
rem                       by Prof. Timo Salmi
rem                          9-May-1989
rem
rem      P.O. BOX 297, University of Vaasa, SF-65101 Vaasa, Finland
rem                       ts@chyde.uwasa.fi
rem
rem  The purpose of this batch is to upload files with Procomm Plus using
rem  the ZMODEM protocol.
rem
rem  1) Put this batch file in your Procomm Plus directory.
rem
rem  2) Set an External Protocol Upload Filename as ZMOD-U in
rem     Procomm Plus Protocol Options in the Setup Facility.
rem     Procomm Plus setup facility is invoked by Alt-S.
rem
rem  3) Put DSZ.COM in your Procomm Plus directory (here C:\TELEC\PCPLUS).
rem     DSZ.COM is a marketed by Omen Technology Inc.
rem
rem  4) At the remote end tell the system that you are going to upload.
rem     In an Opus bulletin board simply write uz
rem
rem  5) In Procomm Plus by press the PageUp key and select the
rem     relevant external upload protocol.
rem     A ZMOD-U parameters prompt appears. Give the name(s) of
rem     your file(s).
rem
rem  6) If all goes well, the file(s) will be uploaded.
rem
rem  For more information see DSZ.DOC e.g. in DSZ1019.ARC, or later.
rem  Also many public domain files contain useful advice. See e.g.
rem  PRCM-DSZ.ARC, DSZOP3.ARC, Z4PCPL.ARC, DSZHOWTO.ARC, PCPZMOD.ARC, etc.

if "%1"=="" goto _error0
if not exist %1 goto _error1
if "%2"=="" goto _do
if not exist %2 goto _error2
if "%3"=="" goto _do
if not exist %3 goto _error3
if "%4"=="" goto _do
if not exist %4 goto _error4
if "%5"=="" goto _do
if not exist %5 goto _error5
if not "%6"=="" goto _error6

rem
rem  Below, change the modem port number (3) if necessary.
rem  Omit portx 3e8,2 which is an uncommon resetting of the IRQs

:_do
c:\telec\pcplus\dsz CON port 3 portx 3e8,2 sz %1 %2 %3 %4 %5
goto _out1

:_error0
echo No filename(s)
goto _error
:_error1
echo File %1 not found
goto _error
:_error2
echo File %2 not found
goto _error
:_error3
echo File %3 not found
goto _error
:_error4
echo File %4 not found
goto _error
:_error5
echo File %5 not found
goto _error
:_error6
echo The maximum number of file names is five
goto _error

:_error
echo To try again
echo  1) First exit by pressing any key
echo  2) If the host still is receptive, invoke the upload anew by pressing
echo     PgUp in Procomm, else start the whole upload process from beginning
pause
goto _out2

:_out1
echo 
echo 
echo 
if errorlevel 1 pause
:_out2
echo on
