/****************************************************************************
 *   FILE CKITDEMO.H                                                        *
 *   Created 11-FEB-1990            Rickie W. Belitz                        *
 *                                  820 Brentwood Drive                     *
 *                                  Maryville, Tennessee  37801             *
 *                                  BBS (615) 982-6512                      *
 *                                      (615) 982-6537                      *
 *                                      (615) 982-8723                      *
 *                                                                          *
 *                  Parameters that are specific to CKITDEMO                *
 *                                                                          *
 ****************************************************************************/


/****************************************************************************
 *                   CKITDEMO macros                                        *
 ****************************************************************************/
#define     BELL   0x07
#define     BUFFER_SIZE   2048  /* File Read Buffer */

/****************************************************************************
 *      IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF         *
 ****************************************************************************/
#if COMPILER == MICROSOFT
    #define RAND( seed) (seed = ((( seed * 12) + 6) % (Modulo + 1)))
    int     irandom(short);             /* Generate random number       */
    #define dosopen _dos_open           /* MSC     */
    #define dosread _dos_read
    #define dosclose _dos_close
#else
    #define dosopen _open               /* Turbo C */
    #define dosread _read
    #define dosclose _close
#endif

/****************************************************************************
 *     ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF    *
 ****************************************************************************/

/****************************************************************************
 *                   CKITDEMO function prototypes                           *
 ****************************************************************************/
void    shut_down(void);      /* Shuts door down if normal or error occurs. */
void    ansi_demo(void);            /* ANSI graphic demo            */
void    display_info(void);         /* Display CKIT information     */
void    take_chance(void);          /* Take a change game           */
void    menu(void);                 /* Main menu for demo           */
void    test_pattern(void);         /* Test pattern                 */
void    filexfer(void);             /* Zmodem file xfer             */
void    zipfile(void);              /* PKZIP shell                  */
void    read_scancode(void);        /* Read key code                */
void    print_msg(short, char **);  /* Print open_door errors       */
void    send_byte(BYTE);            /* Send single byte out remote  */
void    display_time(void);         /* Display XXXX used, XXXX left */
char *  create_buffer(size_t);
short   open_file(char *);
size_t  ck_read_record(short, BYTE *, size_t);
short   parse_to_C(char *, size_t, char **, short);
void    copy_buffer(char *, char **, char *);
short   read_WWIV(void);

/****************************************************************************
 *     Set this array equal to your door program name desired               *
 ****************************************************************************/
char    progname[21] = "Ckit - Demo";   /* Program name for status line     */

/****************************************************************************
 *     Used in filexfer() in ckitdemo.c                                     *
 ****************************************************************************/
char    doc_filename[9] ="CKIT.DOC";    /* Name for Zmodem xfer             */
char    zip_filename[9] ="CK";          /* Name for PKZIP file              */
char    zmodem_cmds[256];               /* Buffer to build Zmodem command   */
char    dszcmds[128];
char    pkzcmds[128];
char    dos_cmd[] = "COMSPEC";

/*****************************************************************************
 *  Create array of pointers to our error messages                           *
 *****************************************************************************/
static  char    *ckit_errors[9] = {
"Error opening system file -> ",
"Error reading system file -> ",
"Unknown BBS file type -> ",
"Error opening users file -> ",
"Invalid User Record in ->",
"Error reading user record -> ",
"Port syntax error: USAGE: PORT:AAAA:X AAAA=COMBASE X=IRQ",
"Fossil driver / DigiBoard driver not installed",
"Unable to allocate memory",
 };

/*****************************************************************************
 *  If desired, optional custom log off messages.                            *
 *  If not used, the library will use it's internal defaults.                *
 *****************************************************************************/
char    option0[] = "Normal Quit to BBS msg\n";
char    option1[] = "CARRIER DROPPED! msg\n";
char    option2[] = "Keyboard Timeout msg\n";
char    option3[] = "Sysop return request msg\n";
char    option4[] = "System time expired msg\n";
char    option5[] = "Goobye, hangup msg\n";

/*****************************************************************************
 *  If desired, optional general message used.                               *
 *  If not used, the library will use it's internal defaults.                *
 *****************************************************************************/
char    ckmsg0[] = "Screen Display on Message";
char    ckmsg1[] = "Time Adjusted due to event message";
char    ckmsg2[] = "< Press ENTER to Continue > message";
char    ckmsg3[] = "Sysop Chat Active Message";
char    ckmsg4[] = "Sysop Chat End Message";
char    ckmsg5[] = "Sysop Exited to DOS Message";
char    ckmsg6[] = "Sysop Returned from DOS Message";
char    ckmsg7[] = "(Enter=none)?) ";
char    ckmsg8[] = "(Enter=yes) ";
char    ckmsg9[] = "(Enter=no) ";
char    ckmsg10[] = " (Enter) or (Y)es, (N)o, (NS)nonstop? ";
char    ckmsg11[] = "More: ";

/*****************************************************************************
 *  Create array of pointers to our custom log off messages                  *
 *****************************************************************************/
static  char    *logoffs[6] = {
    option0,
    option1,
    option2,
    option3,
    option4,
    option5,
};

/*****************************************************************************
 *  Create array of pointers to our custom general messages                  *
 *****************************************************************************/
static  char    *ckit_msgs[12] = {
    ckmsg0,
    ckmsg1,
    ckmsg2,
    ckmsg3,
    ckmsg4,
    ckmsg5,
    ckmsg6,
    ckmsg7,
    ckmsg8,
    ckmsg9,
    ckmsg10,
    ckmsg11
};

/****************************************************************************
 ************************ E N D  OF  M O D U L E ****************************/

