/*
   Copyright (C) 1988-1992 The GAP Development Company

   All Rights Reserved
   
   This source code is considered to be confidential information proprietary
   to The GAP Development Company.  It is prohibited and punishable by law
   to use or duplicate any part of this information.
 

   GAPCDR.H

   Header file for GAPCDR modules

   Defines external declarations and includes gastruc.h which defines
   global structures and function prototypes.

*/

#include "gapstruc.h"

   /*********************************************************************/
   /*  Variables initialized by reading DOOR.SYS                        */
   /*********************************************************************/

   extern short multi;                    // 1 = system is multi-user
   extern short local;                    // 0 = remote user, 1 = local user  
   extern short port;                     // com port being used              
   extern short parity;                   // actually data bits, not used     
   extern short node;                     // node number in use, 0 = single   
   extern short screen;                   // 0 = screen off, 1 = screen on    
   extern short printer;                  // 0 = printer off, 1 = printer on  
   extern short bell;                     // 0 = page bell off, 1 = bell on   
   extern short alarm;                    // 0 = caller alarm off, 1 = on     
   extern short level;                    // user's security level            
   extern short minsleft;                 // minutes left at door start       
   extern short color;                    // 0 = no color, 1 = color          
   extern short page;                     // page length                      
   extern short expert;                   // 0 = novice, 1 = expert           
   extern short realcredit;               // real time credits
   extern short dflt_color;               // BBS default color
   extern short maxfiles;                 // Max files available
   extern short curfiles;                 // Current files downloaded

   extern unsigned short userbaud;        // remote user's bps rate           
   extern unsigned short baud;            // DTE bps rate                     

   extern long timeson;                   // # of times on                    
   extern long recnum;                    // user's record number             
   extern long uploads;                   // total number of uploads          
   extern long downloads;                 // total number of downloads        
   extern long curbytes;                  // current download bytes             
   extern long maxbytes;                  // max bytes can download           
   extern long doors_open;                // Total doors opened
   extern long mesleft;                   // Total messages left
   extern long upbytes;                   // total upload bytes               
   extern long downbytes;                 // total download bytes             

   extern char username   [];             // user's full name                 
   extern char fname      [];             // user's first name                
   extern char lname      [];             // user's last name                 
   extern char city       [];             // user's home town                 
   extern char hphone     [];             // user's home phone number         
   extern char bphone     [];             // user's business phone number     
   extern char password   [];             // user's password                  
   extern char lastdate   [];             // last date user was on            
   extern char subscrip   [];             // date user's subscription expires 
   extern char handle     [];             // caller's Handle
   extern char event_time [];             // event run time
   extern char last_new   [];             // last new files scan


   /********************************************************************/
   /*  global variables                                                */
   /********************************************************************/

   extern char noup;                      // if 1, dont uppercase characters     
   extern char redisplay;                 // true if wants to start over         
   extern char usemore1;                  // true if showing a file              
   extern char view;                      // true if want a more prompt          
   extern char endview;                   // true if dont want to see any more   
   extern char NS;                        // true if in Non Stop mode            
   extern char instatus;                  // if doing status line,bypas our BIOS 
   extern char chat;                      // true if chatting with user          
   extern char wordwrap;                  // column to wrap at                   
   extern char column;                    // column we are at now                
   extern char flag;                      // flag that a space was pressed       
   extern char clockon;                   // 0 no clock, 1 display clock

   extern short timeleft;                 // time user has left                  
   extern short lines;                    // # of lines currently displayed
   extern short irq;                      // IRQ for port
   extern short base_add;                 // base address for port
   extern short timecredit;               // any time credits user may have
   extern short _near normal;             // current display color
   extern short _near crscur;             // current cursor pos

   extern char anystring   [];            // global garbage collector            
   extern char maindir     [];            // path to the BBS main dir            
   extern char gendir      [];            // path to the BBS gen dir             
   extern char sysname     [];            // sysop's name                        
   extern char strtime     [];            // holds the time string               
   extern char curtime     [];            // holds the current time as a string  
   extern char bbs_dir     [];            // path to BBS default dir             
   extern char board_name  [];            // name of the BBS                     
   extern char birthday    [];            // caller's birth date

   extern long temptime;                  // for calculating time out            
   extern long timenow;                   // long integer for current time       
   extern long starttime;                 // long integer for time door opened   

   // structures

   extern struct GAP_USER user;
   extern struct PCBSYS14 pcbsys;
   extern struct PCBUSER14 pcbuser;


   extern char  BS [];
   extern char  CRLF [];

   extern char  A_BLACK [];               // ANSI color strings                  
   extern char  A_RED [];
   extern char  A_GREEN [];
   extern char  A_BROWN []; 
   extern char  A_BLUE [];
   extern char  A_MAGENTA []; 
   extern char  A_CYAN [];
   extern char  A_WHITE [];
   extern char  A_BBLACK [];
   extern char  A_BRED [];
   extern char  A_BGREEN [];
   extern char  A_YELLOW [];
   extern char  A_BBLUE [];
   extern char  A_BMAGENTA [];
   extern char  A_BCYAN [];
   extern char  A_BWHITE [];

